/**
	SIP Forwarder: Header File

				sip_forwarder.h v1.0  by Fumi.Iseki (C)2009-2010
*/


#ifndef  __SIP_FORWARDER_H_
#define  __SIP_FORWARDER_H_


#ifdef HAVE_CONFIG_H
	#include "config.h"
#endif


#include "xtools.h"
#include "ttree.h"
#include "ssl_tool.h"
#include "ipaddr_tool.h"
#include "protocol.h"




#ifndef  TIME_OUT
#define  TIME_OUT				30
#endif

#define  LOG_FILE				if(LogFile!=NULL)
#define  UDP_DUMP_MODE			if(UDPDumpMode) 



#define  SIP_DEFAULT_PORT		5060
#define  SIP_FRWRDR_PORT		5062


#define  SPKI_MEDIA_TYPE		"spki der base64"
#define  SPKI_MEDIA_KEY			"keyinfo:"




/**
	SIP: UA (u) <---> (s) Controll (i) <---> (t) Proxy (v) <---> (x) SIP Server
*/
struct  _sip_port_info
{
	unsigned short u_port;
	unsigned short s_port;
	unsigned short i_port;
	unsigned short t_port;
	unsigned short v_port;
	unsigned short x_port;
};  

typedef  struct _sip_port_info   SIP_PortInfo;





//////////////////////////////////////////////////////////////////////////

extern int      CryptMode;

extern char*	SIPserverName;
extern unsigned short SIPserverPort;
extern char*	SIPdomainName;

extern char* 	UAgentName;


////////////////////////////////////////////

extern int 		DebugMode;
extern int 		UDPDumpMode;

extern int 		SysLogLevel;
extern int 		LogMode;

extern int 		MaxUdpExPort, MinUdpExPort;
extern int 		MaxUdpInPort, MinUdpInPort;

extern int 		MaxIdleTime;

extern char*	LogFileName;
extern FILE*	LogFile;

extern char* 	Hosts_Allow_File;
extern char* 	Temp_File_Dir;

//extern char* 	MyIPaddr;
//extern char* 	MyIPaddrNum;
extern char* 	MyExtIPaddr;
extern char* 	MyExtIPaddrNum;
extern char* 	MyIntIPaddr;
extern char* 	MyIntIPaddrNum;

extern tList* 	Process_List;
extern tList* 	Trans_Table;
extern tList* 	Allow_IPaddr;

extern pid_t	CrntPID;
extern pid_t	RootPID;


extern Buffer*  CRYPT_SharedKey;




//////////////////////////////////////////////////////////////////////////
// Functions

// sip_forwarder
void   	sip_forwarder(int sock, Buffer buf, SIP_PortInfo sip_port);

Buffer  sip_from_inside (Buffer buf, SIP_PortInfo sip_port, int vsock);
Buffer 	sip_from_outside(Buffer buf, SIP_PortInfo sip_port, int tsock);



// sip_config.c
void   	read_config_file(char* fn);





#endif
