/**
	Second Life Relay Server: Tools Header File

				sl_tools.h v1.0  by Fumi.Iseki (C)2008
*/


#ifndef  __SL_TOOLS_H_
#define  __SL_TOOLS_H_



#include <dirent.h>

#include "tlist.h"
#include "txml.h"

#include "ssl_tool.h"



#define  AUTH_PASSWD_LEN		16
#define  REGION_HANDLE_LEN		8




#define  LOG_FILE			   	if(LogFile!=NULL)
#define  TCP_DUMP_MODE		 	if(TCPDumpMode) 
#define  HTTP_DUMP_MODE		 	if(HTTPDumpMode) 
#define  UDP_DUMP_MODE		  	if(UDPDumpMode) 
#define  UDP_FULL_DUMP_MODE	 	if(UDPFullDumpMode) 



#define  LST_SZ					4096
#define  TIME_OUT   			60





extern  pid_t  CrntPID;
extern  int    SysLogLevel;



//////////////////////////////////////////////////////////////////////////
// Functions

// sl_tools.c
int  	search_relay_list(tList* pl, char* ip, unsigned short port);
int		del_relay_list   (tList* pl, char* ip, unsigned short port);
char*  	del_process_list (tList* pl, int pid,  int* port);

void  	clean_work_file(char* dir, int flen);
tList*  make_text_contents_header(tList* pl);

void  	expire_list(tList* pp, unsigned int expire);
void  	check_list_limitsize(tList* plist, int maxnum, int delnum);
void	get_uint_from_RegionHandle(char* handle, unsigned int* x, unsigned int* y);

Buffer	backup_temp_file(char* ffn, char* tfn, char* ext, int tmon);

Buffer  make_relay_url(char* ip, unsigned short port, char* dir, int use_ssl);
void	set_texture_full_download(tList* pl);



#endif


