/**  
  Second Life Voice Relay Config Program: Configure File Tool Program 	

				sl_vconfig.c v0.9b by Fumi.Iseki
*/


#include "sl_voice_relay.h"



//////////////////////////////////////////////////////////////////////////
// Configuration File
//

void  read_config_file(char* fn)
{
	tList* lt;

	lt = read_index_tList_file(fn, ' ');

	if (lt!=NULL) {
		DEBUG_MODE   print_message("[%d] READ_CONFIG_FILE: readed configuration file [%s]\n", (int)CrntPID, fn);

		MinTcpExPort   = get_intparam_tList(lt, "MinTcpExPort",   MinTcpExPort);
		MaxTcpExPort   = get_intparam_tList(lt, "MaxTcpExPort",   MaxTcpExPort);
		MinTcpImPort   = get_intparam_tList(lt, "MinTcpImPort",   MinTcpImPort);
		MaxTcpImPort   = get_intparam_tList(lt, "MaxTcpImPort",   MaxTcpImPort);
		MaxIdleTime	   = get_intparam_tList(lt, "MaxIdleTime",	  MaxIdleTime);

		if (MinTcpExPort>MaxTcpExPort) int_swap(MinTcpExPort, MaxTcpExPort);
		if (MinTcpImPort>MaxTcpImPort) int_swap(MinTcpImPort, MaxTcpImPort);

		CERT_PEM_File	 = get_strparam_tList(lt, "CERT_PEM_File", CERT_PEM_File);
		SKEY_PEM_File	 = get_strparam_tList(lt, "SKEY_PEM_File", SKEY_PEM_File);
		CA_PEM_File		 = get_strparam_tList(lt, "CA_PEM_File",   CA_PEM_File);

		Temp_File_Dir	 = get_strparam_tList(lt, "Temp_File_Dir",	  Temp_File_Dir);
		Hosts_Allow_File = get_strparam_tList(lt, "Hosts_Allow_File", Hosts_Allow_File);

		del_all_tList(&lt);
	}
	else {
		DEBUG_MODE print_message("[%d] READ_CONFIG_FILE: cannot read configuration file [%s]\n", (int)CrntPID, fn);
	}

	DEBUG_MODE {
		print_message("[%d] READ_CONFIG_FILE: MinTcpExPort     = %d\n", (int)CrntPID, MinTcpExPort);
		print_message("[%d] READ_CONFIG_FILE: MaxTcpExPort     = %d\n", (int)CrntPID, MaxTcpExPort);
		print_message("[%d] READ_CONFIG_FILE: MinTcpImPort     = %d\n", (int)CrntPID, MinTcpImPort);
		print_message("[%d] READ_CONFIG_FILE: MaxTcpImPort     = %d\n", (int)CrntPID, MaxTcpImPort);
		print_message("[%d] READ_CONFIG_FILE: MaxIdleTime      = %d\n", (int)CrntPID, MaxIdleTime);

		print_message("[%d] READ_CONFIG_FILE: Temp File Dir    = %s\n", (int)CrntPID, Temp_File_Dir);
		print_message("[%d] READ_CONFIG_FILE: Hosts Allow File = %s\n", (int)CrntPID, Hosts_Allow_File);

		if (UseServerSSL) {
			print_message("[%d] READ_CONFIG_FILE: CERT PEM File    = %s\n", (int)CrntPID, CERT_PEM_File);
			print_message("[%d] READ_CONFIG_FILE: SKEY PEM File    = %s\n", (int)CrntPID, SKEY_PEM_File);
		}
		if (UseClientCA) {
			print_message("[%d] READ_CONFIG_FILE: CA PEM File      = %s\n", (int)CrntPID, CA_PEM_File);
		}
	}
}




