/** 
	Second Life: Vivox XML Transform Program: 

				sl_vivox_transform.c v1.0  by Fumi.Iseki (C)2009-2010
*/


#include "sl_vivox_transform.h"



///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Transform HTTPS message
//

/**
int  transform_vivox_xml(tXML* xml, char* fn)

	機能：ログインメッセージに対するサーバから応答を処理(Relay server へリダイレクト)する．

	引数：	xml			受信データの格納されたXMLデータ

	戻り値：
		return:
			RELAY_PROCESS	そのまま中継する．ログインエラーメッセージなど．
			TRANS_PROCESS	通信内容を書き換えて中継する．
			FAIL_PROCES		処理に失敗．
*/
int  transform_vivox_xml(tXML* xml)
{
	int   rt=OFF;

	char* tagname = get_first_tag_name(xml);
	if (tagname==NULL) return FAIL_PROCESS;

	// Configration
	if (!strcasecmp(tagname, VIVOX_CONFIG_XML)) {
		rt = ON;
		char  uri[LNAME];
		snprintf(uri, LNAME, "%s:%d", SIPforwarder, SIPfrwrdrPort);

	   	set_xml_content_list_bystr(xml, VIVOX_SIPSERVER_TAG, uri);	// SIP Server
	   	set_xml_content_bystr(xml, VIVOX_USESTUN_TAG, "false"); 	// Use STUN Server
		tXML* xl = get_xml_tag_bystr(xml, VIVOX_STUNSERVER_TAG);
		del_xml(&xl); 												// Delete STUN Server
	   	//replace_xml_content_bystr(xml, VIVOX_RESETPASS_TAG, "www.bhr.vivox.com", "www.nsl.tuis.ac.jp:1010"); // Reset Passwd

		TCP_DUMP_MODE print_xml(stderr, xml, 2);
	}

	if (rt==OFF) return RELAY_PROCESS;
	return TRANS_PROCESS;
}




