/*	
	Second Life Voice Relay Server: Main Program 

				sl_vmain.c v1.0  by Fumi.Iseki (C)2009-2010
*/


#include "password.h"

#include "sl_voice_relay.h"
#include "sl_voice_help.h"

#include "sip_forwarder.h"




char*   VivoxWebServer		= NULL;		// Vivox WEBサーバ FQDN or IP
unsigned short VivoxWebPort	= 0;		// Vivox WEBサーバ ポート番号

char*	SIPforwarder		= NULL;		// SIP中継サーバ FQDN or IP
unsigned short SIPfrwrdrPort= 0;		// SIP中継サーバ ポート番号


int		SIPExtForward		= OFF;
int		TCPDumpMode			= OFF;
int 	UDPDumpMode			= OFF;

int		SysLogLevel 		= LOG_INFO;
//int 	SysLogLevel			= LOG_ERR;
int 	LogMode				= OFF;

int		UseServerSSL 		= OFF;
int		UseClientCA			= OFF;

int		Isock 				= 0;
int		Vsock 				= 0;
int		Nsock 				= 0;
int		Wofd 				= 0;


// サーバへのHTTPS接続ポート
int		MinTcpExPort		= 14000;
int		MaxTcpExPort		= 14999;

// HTTP(S)の待ち受けポート
int		MinTcpImPort		= 15000;
int		MaxTcpImPort		= 15999;

// RTP/RTCPの外部接続ポート
int		MinUdpExPort		= 14000;
int		MaxUdpExPort		= 14999;

// UDP の内部ポート
int		MinUdpInPort		= 15000;
int		MaxUdpInPort		= 15999;


int		MaxIdleTime			= 300;

char*	Temp_File_Dir		= "/var/sl_proxy/";
char*	Hosts_Allow_File 	= "/usr/local/etc/sl_proxy/hosts_relay.allow";

char*	LogFileName			= "sl_voice_relay.log";
FILE* 	LogFile				= NULL;

char*	CERT_PEM_File 		= "/usr/local/etc/sl_proxy/cert.pem";
char*	SKEY_PEM_File 		= "/usr/local/etc/sl_proxy/skey.pem";
char*	CA_PEM_File			= "/usr/local/etc/sl_proxy/CA_lindenlab.pem";

char*	MyIntIPaddr			= NULL;
char*	MyIntIPaddrNum		= NULL;
char*	MyExtIPaddr			= NULL;
char*	MyExtIPaddrNum		= NULL;


tList* 	Process_List 		= NULL;
tList* 	Trans_Table 		= NULL;
tList* 	Allow_IPaddr		= NULL;

pid_t	RootPID 			= 0;




int main(int argc, char** argv)
{
	int	   i, lgtyp=-1;
	unsigned short sport=0;

	struct passwd* pw;
	struct sigaction sa;

	Buffer vvxwebsvr, sipfrwrdr, username, conffile, pidfile, intipaddr, extipaddr, logfile;

	// 引数処理
	vvxwebsvr = make_Buffer(LNAME);
	sipfrwrdr = make_Buffer(LNAME);		// SIP 中継サーバ URI
	username  = make_Buffer(LNAME);
	pidfile	  = make_Buffer(LNAME);
	conffile  = make_Buffer(LNAME);
	intipaddr = make_Buffer(LNAME);
	extipaddr = make_Buffer(LNAME);
	logfile   = make_Buffer(LNAME);

	sport = VOICE_SERVER_CPORT;

	for (i=1; i<argc; i++) {
		if		(!strcmp(argv[i],"-p"))   {if (i!=argc-1) sport = (unsigned short)atoi(argv[i+1]);}	// このプログラムのポート番号
		else if (!strcmp(argv[i],"-r"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &sipfrwrdr); SIPExtForward=ON;}	// 外部 SIP中継サーバの指定

		else if (!strcmp(argv[i],"-f"))	  {if (i!=argc-1) copy_s2Buffer(argv[i+1], &conffile);}
		else if (!strcmp(argv[i],"-u"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &username);}

		else if (!strcmp(argv[i],"-i"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &intipaddr); MyIntIPaddr=(char*)intipaddr.buf;}
		else if (!strcmp(argv[i],"-ii"))  {if (i!=argc-1) copy_s2Buffer(argv[i+1], &intipaddr); MyIntIPaddr=(char*)intipaddr.buf;}
		else if (!strcmp(argv[i],"-ie"))  {if (i!=argc-1) copy_s2Buffer(argv[i+1], &extipaddr); MyExtIPaddr=(char*)extipaddr.buf;}

		else if (!strcmp(argv[i],"-pid")) {if (i!=argc-1) copy_s2Buffer(argv[i+1], &pidfile); }
		else if (!strcmp(argv[i],"-l"))   {if (i!=argc-1 && *(argv[i+1])!='-') copy_s2Buffer(argv[i+1], &logfile); LogMode=ON;}
		else if (!strcmp(argv[i],"-v"))   {if (i!=argc-1) lgtyp = atoi(argv[i+1]);}

		else if (!strcmp(argv[i],"-as"))  UseServerSSL= ON;
		else if (!strcmp(argv[i],"-aca")) UseClientCA = ON;

		else if (!strcmp(argv[i],"-d"))   DebugMode   = ON;
		else if (!strcmp(argv[i],"-x"))   TCPDumpMode = UDPDumpMode = ON;
		else if (!strcmp(argv[i],"-xt"))  TCPDumpMode = ON;
		else if (!strcmp(argv[i],"-xu"))  UDPDumpMode = ON;

		else if (!strcmp(argv[i],"--version")) { fprintf(stdout, SL_VOICE_RELAY_VERSION); fprintf(stdout, "\n"); exit(0); }
		else if (!strcmp(argv[i],"--help")) { sl_voice_help(stdout); exit(0); }
		else if (!strcmp(argv[i],"-h"))     { sl_voice_help(stdout); exit(0); }
	}

	// -i -ii -ie option
	if (MyIntIPaddr==NULL) {
		MyIntIPaddr = get_localip_bydest("192.168.0.1");
		free_Buffer(&intipaddr);
	}
	MyIntIPaddrNum = (char*)to_address_num4(MyIntIPaddr, 0);
	if (MyIntIPaddrNum==NULL) {
		print_message("SL_VMAIN: ERROR: my Internal IP address is incorrect!!!\n");
		exit(1);
	}

	if (MyExtIPaddr==NULL) {
		MyExtIPaddr = get_localip_bydest("198.41.0.4");	 // a.root-servers.net.
		free_Buffer(&extipaddr);
	}
	MyExtIPaddrNum = (char*)to_address_num4(MyExtIPaddr, 0);
	if (MyExtIPaddrNum==NULL) {
		print_message("SL_VMAIN: ERROR: my External IP address is incorrect!!!\n");
		exit(1);
	}

	// SIP Forward Server
	Buffer buf;
	if (sipfrwrdr.buf[0]=='\0') copy_s2Buffer(MyIntIPaddr, &sipfrwrdr);	// SLVoiceから見たアドレス
	decomp_hostport(sipfrwrdr, &buf, &SIPfrwrdrPort);
	SIPforwarder = (char*)buf.buf;
	if (SIPfrwrdrPort==0) SIPfrwrdrPort = SIP_FRWRDR_PORT;
	free_Buffer(&sipfrwrdr);

	//
	Process_List = add_tList_node_bystr(NULL, 0, 0, LIST_ANCHOR, LIST_ANCHOR, NULL, 0);	// アンカー
	if (lgtyp>=0) SysLogLevel = lgtyp;

	init_rand();
	char* passwd = random_str(AUTH_PASSWD_LEN);
	CrntPID = RootPID = getpid();

	///////////////////////////////////////////////////////////
	// syslog のオープン
	openlog("SecondLife_Voice", LOG_PID, LOG_AUTH);

	// 設定ファイルの読み込み
	if (conffile.buf[0]=='\0') copy_s2Buffer(CONFIG_FILE, &conffile);
	read_config_file((char*)conffile.buf);
	free_Buffer(&conffile);

	// PIDファイルの作成
	if (pidfile.buf[0]!='\0') {
		FILE* fp = fopen((char*)pidfile.buf, "w");
		if (fp!=NULL) {
			fprintf(fp, "%d", (int)RootPID);
			fclose(fp);
		}
	}
	free_Buffer(&pidfile);
	DEBUG_MODE print_message("[%d] SL_VMAIN: root PID is [%d]\n", CrntPID, RootPID);

	// 接続許可・禁止ファイルの読み込み
	Allow_IPaddr = read_ipaddr_file(Hosts_Allow_File);
	if (Allow_IPaddr!=NULL) {
		DEBUG_MODE {
			print_message("[%d] SL_VMAIN: readed access control list.\n", RootPID);
  			print_address_in_list(stderr, Allow_IPaddr);
		}
	}
	else {
		DEBUG_MODE print_message("[%d] SL_VMAIN: cannot read access contorol list. no access control.\n", CrntPID);
	}

	// 実効ユーザの変更
	if (username.buf[0]!='\0') {
		int uerr = -1;
		int gerr = -1;
   
		DEBUG_MODE print_message("[%d] SL_VMAIN: change effective user to [%s]．\n", CrntPID, username.buf);
		if (isdigit(username.buf[0])) {
			gerr = 0;
			uerr = seteuid(atoi((char*)username.buf));
		}
		else {
			pw = getpwnam((char*)username.buf);
			if (pw!=NULL) {
				gerr = setegid(pw->pw_gid);
				uerr = seteuid(pw->pw_uid);
			}
		}
		if (gerr==-1) {
			DEBUG_MODE print_message("[%d] SL_VMAIN: WARNING: cannot change effectinve group.\n", CrntPID);
		}
		if (uerr==-1) {
			DEBUG_MODE print_message("[%d] SL_VMAIN: WARNING: cannot change effectinve user [%s].\n", CrntPID, username.buf);
		}
	}
	free_Buffer(&username);

	// シグナルハンドリング
	sa.sa_handler = sl_vmain_term;
	sa.sa_flags   = 0;
	sigemptyset(&sa.sa_mask);
	sigaddset(&sa.sa_mask, SIGCHLD);
	sigaction(SIGINT,  &sa, NULL);
	sigaction(SIGHUP,  &sa, NULL);
	sigaction(SIGTERM, &sa, NULL);

	set_sigterm_child(sl_sigterm_child);	// Childプロセス終了時の処理設定
	DEBUG_MODE set_sigseg_handler(NULL);	// Segmentation Falt check

	// 作業ディレクトリの書き込みチェック
	char* tempfile = temp_filename(Temp_File_Dir, WORK_FILENAME_LEN);
	if (tempfile!=NULL) {
		FILE* fp = fopen(tempfile, "w");
		if (fp==NULL) {
			syslog(SysLogLevel, "sl_vmain: ERROR: sl_voice_relay cannot write working directory [%s]. going down!!  please check permission!!", Temp_File_Dir);
			print_message("SL_VMAIN: ERROR: sl_relay cannot write working directory [%s]. going down!!  please check permission!!\n", Temp_File_Dir);
			sl_vmain_term(1);
		}
		fclose(fp);
		unlink(tempfile);
		free(tempfile);
	}

	// 前回残った作業用ゴミファイルを削除
	//clean_work_file(Temp_File_Dir, WORK_FILENAME_LEN);

	// ログファイルの書き込みチェック
	if (LogMode) {
		if (logfile.vldsz<=0) {
			copy_s2Buffer(Temp_File_Dir, &logfile);
			cat_s2Buffer (LogFileName, &logfile);
		}
		
		LogFile = fopen((char*)logfile.buf, "a");
		if (LogFile==NULL) {
			DEBUG_MODE print_message("SL_VMAIN: WARNING: sl_relay cannot write logfile [%s].\n", logfile.buf);
		}
		free_Buffer(&logfile);
	}

	// 認証局証明書のチェック
	if (UseClientCA) {
		if (!file_exist(CA_PEM_File)) {
			DEBUG_MODE print_message("SL_VMAIN: WARNING: cannot read CA file [%s]. not use CA file.\n", CA_PEM_File);
			UseClientCA = OFF;
		}
	}

	// サーバ証明書と秘密鍵ファイルのチェック
	if (UseServerSSL) {
		if (!file_exist(CERT_PEM_File)) {
			syslog(SysLogLevel, "sl_vmain: ERROR: cannot read cert file [%s].", CERT_PEM_File);
			print_message("SL_VMAIN: ERROR: cannot read cert file [%s].\n", CERT_PEM_File);
			sl_vmain_term(1);
		}
		if (!file_exist(SKEY_PEM_File)) {
			syslog(SysLogLevel, "sl_vmain: ERROR: cannot read secret key file [%s].", SKEY_PEM_File);
			print_message("SL_VMAIN: ERROR: cannot read secret key file [%s].\n", SKEY_PEM_File);
			sl_vmain_term(1);
		}
	}

	// 確認用Log
	DEBUG_MODE {
		print_message("[%d] SL_VMAIN: My Internal IP = %s\n", CrntPID, MyIntIPaddr);
		print_message("[%d] SL_VMAIN: My External IP = %s\n", CrntPID, MyExtIPaddr);
		print_message("[%d] SL_VMAIN: UseServerSSL   = %d\n", CrntPID, UseServerSSL);
		print_message("[%d] SL_VMAIN: UseClientCA    = %d\n", CrntPID, UseClientCA);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// 情報受信用ポート
	unsigned short iport;
	Isock = get_valid_udp_socket(MinUdpInPort, MaxUdpInPort, &iport);
	if (Isock<=0) {
		syslog(SysLogLevel,"sl_vmain: ERROR: Voice infomation server socket open error. [%d]", Isock);
		print_message("[%d] SL_VMAIN: ERROR: Voice infomation server socket open error [%d]\n", CrntPID, Isock);
		sl_vmain_term(1);
	}
	DEBUG_MODE print_message("[%d] SL_VMAIN: Voice infomation server port is %d\n", CrntPID, iport);

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// メインループ
	//
	int  nd, num, execsip=OFF;
	unsigned short vport;
	fd_set mask;
	struct timeval timeout;

	Nsock = tcp_server_socket((int)sport);
	Vsock = get_valid_tcp_server_socket(MinTcpImPort, MaxTcpImPort, &vport);

	DEBUG_MODE {
		print_message("[%d] SL_VMAIN: start SLVoice Relay Main Loop.\n",   CrntPID);
		print_message("[%d] SL_VMAIN: Vivox Web Server relay port = %d\n", CrntPID, vport);
		print_message("[%d] SL_VMAIN: Information Receive port    = %d\n", CrntPID, iport);
	}

	num = Max(Isock, Vsock);
	num = Max(num, Nsock);

	Loop {
		do {
			timeout.tv_sec  = TIME_OUT;
			timeout.tv_usec = 0;
			FD_ZERO(&mask);
			FD_SET(Isock, &mask);
			FD_SET(Vsock, &mask);
			FD_SET(Nsock, &mask);
			nd = select(num+1, &mask, NULL, NULL, &timeout);
		} while (nd<0);


		// Exchange initial information with sl_relay (from sl_relay)
		if (FD_ISSET(Nsock, &mask)) {
			exec_exchange_info_with_relay(Nsock, iport, vport, passwd);
		}

		// Execute Vivox Account Relay Server (from slvoice)
		if (FD_ISSET(Vsock, &mask)) {
			exec_vivox_https_relay(Vsock);
		}

		// Get Vivox web server information from sl_relay (UDP)
		if (FD_ISSET(Isock, &mask)) {
			execsip = exec_sip_forwarder_main(Isock, execsip, passwd);
		}
	}

	// not reachable
	freeNull(MyIntIPaddr); 
	freeNull(MyExtIPaddr); 
	socket_close(Isock);
	socket_close(Vsock);
	socket_close(Nsock);
	free(passwd);
	Isock = Vsock = Nsock = 0;

	sl_vmain_term(0);
}




//////////////////////////////////////////////////////////////////////////
// プログラムの終了
//
void  sl_vmain_term(int sig)
{  
	int ret;
	tList* pl = NULL;
	pid_t pid, cpid;

	pid = getpid();
	DEBUG_MODE print_message("[%d] SL_VMAIN_TERM: going down!!\n", CrntPID);

	//signal(SIGCHLD, SIG_IGN);
	ignore_sigterm_child();

	pl = Process_List;
	while(pl!=NULL) {
		if (pl->ldat.lv>1) {
			//DEBUG_MODE print_message("SL_VMAIN_TERM: down signal to [%d].\n", pl->ldat.lv);
			if (pl->ldat.lv!=0) {
				DEBUG_MODE print_message("[%d] SL_VMAIN_TERM: send SIGINT to [%d]\n", CrntPID, pl->ldat.lv);
				kill((pid_t)pl->ldat.lv, SIGINT);
			}
		}
		pl = pl->next;
	}
	del_all_tList(&Process_List);
	
	do {	 		// チャイルドプロセスの終了を待つ   
		cpid = waitpid(-1, &ret, WNOHANG);
	} while(cpid>0);

	// Socket
	if (Wofd>0) socket_close(Wofd);
	Wofd = 0;

	// Root Process
	if (pid==RootPID) {
		DEBUG_MODE print_message("[%d] SL_VMAIN_TERM: root process is going down.\n", CrntPID);

		LOG_FILE {
			fflush(LogFile);
			fclose(LogFile);
			LogFile = NULL;
		}

		if (Vsock>0) socket_close(Vsock);
		if (Isock>0) socket_close(Isock);
		if (Nsock>0) socket_close(Nsock);
		Vsock = Isock = Nsock = 0;

		closelog();		// close syslog
	}

	exit(sig);
}



/**			   
void  sl_sigterm_child(int signal)
				  
	機能：child プロセス終了時の処理
*/				
void  sl_sigterm_child(int signal)
{				
	pid_t pid = 0;
	int ret;
				  
	DEBUG_MODE print_message("[%d] SL_SIGTERM_CHILD: called. signal = %d\n", (int)getpid(), signal);

	do {	// チャイルドプロセスの終了を待つ   
		pid = waitpid(-1, &ret, WNOHANG);
		if (pid>0 && Process_List!=NULL) {
			del_process_list(Process_List, (int)pid, NULL);
		}
	} while(pid>0);

	DEBUG_MODE {
		print_message("==============================================\n");
		print_message("[%d] Process List ------------------------\n", CrntPID);
		print_tList(stderr, Process_List);
		print_message("==============================================\n");
	}
}



