/*    
    Second Life Voice Relay Server: Help 

				sl_voice_help.c v1.0  by Fumi.Iseki (C)2009-2010
*/


#include "sl_voice_help.h"



void  sl_voice_help(FILE* fp)
{
    fprintf(fp, "\n");
    fprintf(fp, " sl_voice_relay ");
    fprintf(fp, "[-p port] [-r sip_forwarder:port]\n");
    fprintf(fp, "                [-f config_file] [-u user_name] \n");
    fprintf(fp, "                [-i internal_ip_address] [-ii internal_ip_address] [-ie external_ip_address] \n");
    fprintf(fp, "                [-pid pid_file] [-l [logfile]] [-v syslog_level] \n");
    fprintf(fp, "                [-as] [-aca] \n");
    fprintf(fp, "                [-d] [-x] [-xt] [-xu] \n");
    fprintf(fp, "                [--version] [--help] [-h] \n");
    fprintf(fp, "\n");

    fprintf(fp, "        -p   : port number that sl_relay connects. default is 8088.\n");
    fprintf(fp, "        -r   : when external SIP relay server (sip_forwarder) is used, the address and the port number of the sip \n");
    fprintf(fp, "               relay server are specified. if this option is specified, sip_forwarder built in sl_voice_relay stops.\n");
    fprintf(fp, "               specify the address seen from SLVoice (it does not become 127.0.0.1). default is to use internal sip_forwarder.\n");
    fprintf(fp, "\n");

    fprintf(fp, "        -f   : configuration file. default is /usr/local/etc/sl_proxy/sl_voice_relay.conf \n");
    fprintf(fp, "        -u   : specify effective user. \n");
    fprintf(fp, "\n");

    fprintf(fp, "        -i   : if your server has two or more network interfaces, specify IP address of internal network. \n");
    fprintf(fp, "        -ii  : same as -i option. \n");
    fprintf(fp, "        -ie  : if your server has two or more network interfaces, specify IP address of external network. \n");
    fprintf(fp, "               usually, it is detected automatically. \n");
    fprintf(fp, "\n");

    fprintf(fp, "        -pid : specify pid file. \n");
    fprintf(fp, "        -l   : specify log file. default is /var/sl_proxy/sl_voice_relay.log \n");
    fprintf(fp, "        -v   : level of syslog. default is LOG_INFO (7). \n");
    fprintf(fp, "\n");

    fprintf(fp, "        -as  : use HTTPS between sl_voice and Voice Relay Server.\n");
    fprintf(fp, "        -aca : confirms Vivox Server by using C:\\Program Files\\SecondLife\\app_settings\\CA.pem \n");
    fprintf(fp, "\n");

    fprintf(fp, "        -d   : debug mode. display debug information. \n");
    fprintf(fp, "        -x   : TCP packets are printed and saved part at working directory. SIP's UDP packets are printed. \n");
    fprintf(fp, "        -xt  : TCP packets are printed and saved part at working directory. \n");
    fprintf(fp, "        -xu  : SIP's UDP packet are printed. \n");
    fprintf(fp, "\n");
  
    fprintf(fp, "        --version  : display Version information. \n");
    fprintf(fp, "        --help, -h : display this Help messages. \n");
    fprintf(fp, "\n");

    return;
}

