/**  
	Second Life Voice Relay: SL Voice Relay Program

				sl_voice_relay.c v1.0 by Fumi.Iseki (C)2009-2010
*/


#include "sl_voice_relay.h"
#include "sl_vivox_transform.h"
#include "sip_fwdmain.h"
#include "sip_forwarder.h"




//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Reflection between SLVoice and Viewer
//

void    exchange_info_with_relay(int nofd, unsigned short iport, unsigned short vport, char* passwd)
{
	Buffer  buf;
	tcp_com dat;

	DEBUG_MODE print_message("[%d] EXCHANGE_INFO_WITH_RELAY: start exhange information with relay.\n", CrntPID);

	// 情報受信用IP:ポート，Vivox アカウントサーバへの中継サーバの情報を通知する
	dat = recv_tcp_command(nofd, 5, 0);
	if (dat.com[0]==COM_IP_PORT_REQUEST) {
		dat.com[0] = COM_IP_PORT_REPLY;
		memcpy(dat.addr, MyIntIPaddrNum, 4);
		dat.port  = htons(iport);
		dat.prtcl = htons(vport);
		buf = make_relay_url(MyIntIPaddr, vport, NULL, UseServerSSL);
		memcpy(dat.mesg, buf.buf, buf.vldsz+1);
		memcpy(dat.pass, passwd, AUTH_PASSWD_LEN+1);

		tcp_send(nofd, (char*)&dat, sizeof(tcp_com));
	}	
	else {
		//syslog(SysLogLevel,"exchange_info_with_relay: ERROR: request is incorrect!! [%02x]", dat.com[0]);
		print_message("[%d] EXCHANGE_INFO_WITH_RELAY: ERROR: request is incorrect!! [%02x]\n", CrntPID, dat.com[0]);
		return;
	}
}




//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// HTTPS Relay
//

void  vivox_https_relay(char* vhost, unsigned short vport, int sofd)
{
	int    cc, cx, num, nd, state;
	int    cofd = 0;
	unsigned short cport;

	fd_set mask;
	struct timeval timeout;

	char* dumpfn = NULL;
	SSL*  ssl    = NULL;
	tXML* vxml   = NULL;
	tXML* sxml   = NULL;

	del_all_tList(&Process_List);
	DEBUG_MODE print_message("[%d] VIVOX_HTTPS_RELAY: server start.\n", CrntPID);

	////////////////////////////////////////////////////////////////////////////////////////////
	// Connect to Vivox
	cofd = get_valid_tcp_client_socket(MinTcpExPort, MaxTcpExPort, vhost, vport, &cport);
	if (cofd<0) {
		print_message("[%d] VIVOX_HTTPS_RELAY: ERROR: cannot connect to %s:%d\n", CrntPID, vhost, vport);
		return;
	}
	DEBUG_MODE print_message("[%d] VIVOX_HTTPS_RELAY: connected %s:%d\n", CrntPID, vhost, vport);

	ssl_init();
	if (UseClientCA) ssl = ssl_client_connect(cofd, CA_PEM_File, ON);
	else             ssl = ssl_client_connect(cofd, NULL, OFF);
	if (ssl==NULL) {
		socket_close(cofd);
		print_message("[%d] VIVOX_HTTPS_RELAY: ERROR: cannot establish SSL connection with %s:%d\n", CrntPID, vhost, vport);
		return;
	}

	num = Max(sofd, cofd);
 
	DEBUG_MODE print_message("[%d] VIVOX_HTTPS_RELAY: start main Loop.\n", CrntPID);
	Loop {
		do {
			timeout.tv_sec  = TIME_OUT;
			timeout.tv_usec = 0;
			FD_ZERO(&mask); 
			FD_SET(sofd, &mask);
			FD_SET(cofd, &mask);
			nd = select(num+1, &mask, NULL, NULL, &timeout);
		} while (nd<0);

		// SLVoice -> Vivox
		if (FD_ISSET(sofd, &mask)) {
			char*  recvfn;
			tList* pl;

			del_xml(&sxml);
			cc = save_https_xml(sofd, NULL, &pl, &sxml, &recvfn, Temp_File_Dir, TIME_OUT, &state);
			cx = 0;
			if (cc>0 && pl!=NULL) {
				set_http_host_header(pl, vhost, vport); 
				cx = send_https_file(cofd, ssl, pl, recvfn);

				TCP_DUMP_MODE {
					print_message("[%d] VIVOX_HTTPS_RELAY: SLVoice -> Vivox\n", CrntPID);
					print_tList(stderr, pl);
					print_message("\n");
				}
				TCP_DUMP_MODE {
					freeNull(dumpfn);
					dumpfn = temp_filename(Temp_File_Dir, WORK_FILENAME_LEN);
					backup_temp_file(recvfn, dumpfn, S2V_RECV_FILE, ON);
				}
			}

			if (recvfn!=NULL) {
				unlink(recvfn);
				freeNull(recvfn);
			}
			del_all_tList(&pl);

			if (cc<=0 || (cc>0&&cx<=0) || !state) break;
		}

		// Vivox -> SLVoice
		if (FD_ISSET(cofd, &mask)) {
			char*  recvfn;
			tList* pl;

			del_xml(&vxml);
			cc = save_https_xml(cofd, ssl, &pl, &vxml, &recvfn, Temp_File_Dir, RUNAWAY_TIME_OUT, &state);

			cx = 0;
			if (cc>0 && pl!=NULL) {
				if (vxml!=NULL && recvfn!=NULL) {
					TCP_DUMP_MODE {
						print_message("[%d] VIVOX_HTTPS_RELAY: Vivox -> SLVoice: Original\n", CrntPID);
						print_tList(stderr, pl);
						print_message("\n");
					}

					int ret = transform_vivox_xml(vxml);
					if (ret==TRANS_PROCESS && vxml->next!=NULL) {
						Buffer trans_msg = xml_inverse_parse(vxml, 0);
						save_Buffer_file(trans_msg, recvfn);
						free_Buffer(&trans_msg);
					}
					//TCP_DUMP_MODE {
					//	print_message("[%d] VIVOX_HTTPS_RELAY: Vivox -> SLVoice: Transfer\n", CrntPID);
					//	print_xml(stderr, vxml, 2);
					//}
				}
				cx = send_https_file(sofd, NULL, pl, recvfn);

				TCP_DUMP_MODE backup_temp_file(recvfn, dumpfn, V2S_RECV_FILE, ON);
			}

			if (recvfn!=NULL) {
				unlink(recvfn);
				freeNull(recvfn);
			}
			del_all_tList(&pl);

			if (cc<=0 || (cc>0&&cx<=0) || !state) break;
		}
	}
	DEBUG_MODE print_message("[%d] VIVOX_HTTPS_RELAY: exit from main Loop.\n", CrntPID);

	del_xml(&vxml);
	del_xml(&sxml);
	freeNull(dumpfn);

	ssl_close(ssl);
	socket_close(cofd);
	exit(0);
}
 



//////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

void  exec_exchange_info_with_relay(int sock, int iport, int vport, char* passwd)
{
	struct sockaddr_in vv_addr;

	int cdlen = sizeof(vv_addr);
	int nofd = accept_intr(sock, (struct sockaddr*)&vv_addr, (socklen_t*)&cdlen);
	if (nofd<0) {
		//syslog(SysLogLevel,"exec_exchange_info_with_relay: ERROR: accept() error from sl_relay. [%s]", strerror(errno));
		print_message("[%d] EXEC_EXCHANGE_INFO_WITH_RELAY: ERROR: accept() error from sl_relay [%s].\n", CrntPID, strerror(errno));
		sl_vmain_term(1);
	}

	// IP Address check
	char* ipaddr= get_ipaddr(vv_addr.sin_addr);
	char* ipnum = (char*)to_address_num4(ipaddr, 0);

	if (Allow_IPaddr==NULL || is_host_in_list(Allow_IPaddr, (unsigned char*)ipnum, NULL)) {
		pid_t pid = fork();
		if (pid==0) {
			CrntPID = getpid();
			del_all_tList(&Process_List);
			exchange_info_with_relay(nofd, iport, vport, passwd);
			sl_vmain_term(0);
		}
		add_tList_node_int(Process_List, 0, (int)pid);
		Process_List->ldat.id++;
	}
	else {
		DEBUG_MODE print_message("[%d] EXEC_EXCHANGE_INFO_WITH_RELAY: WARNING: not allowed access from [%s].\n", CrntPID, ipaddr);
	}

	freeNull(ipaddr);
	freeNull(ipnum);
	close(nofd);
}



void  exec_vivox_https_relay(int sock)
{
	struct sockaddr_in vv_addr;

	int cdlen = sizeof(vv_addr);
	Wofd = accept_intr(sock, (struct sockaddr*)&vv_addr, (socklen_t*)&cdlen);
	if (Wofd<0) {
		//syslog(SysLogLevel,"exec_vivox_https_relay: ERROR: accept() error from slvoice. [%s]", strerror(errno));
		print_message("[%d] EXEC_VIVOX_HTTPS_RELAY: ERROR: accept() error from slvoice [%s].\n", CrntPID, strerror(errno));
		sl_vmain_term(1);
	}

	// IP Address check
	char* ipaddr= get_ipaddr(vv_addr.sin_addr);
	char* ipnum = (char*)to_address_num4(ipaddr, 0);

	if (Allow_IPaddr==NULL || is_host_in_list(Allow_IPaddr, (unsigned char*)ipnum, NULL)) {
		if (VivoxWebServer!=NULL && VivoxWebPort!=0 && VivoxWebServer[0]!='\0') {
			pid_t pid = fork();
			if (pid==0) {
				CrntPID = getpid();
				vivox_https_relay(VivoxWebServer, VivoxWebPort, Wofd);
				sl_vmain_term(0);
			}
			add_tList_node_int(Process_List, 0, (int)pid);
			Process_List->ldat.id++;
		}
	}
	else {
		DEBUG_MODE print_message("[%d] EXEC_VIVOX_HTTPS_RELAY: WARNING: not allowed access from [%s].\n", CrntPID, ipaddr);
	}

	freeNull(ipaddr);
	freeNull(ipnum);
	close(Wofd);
	Wofd = 0;
}



int   exec_sip_forwarder_main(int sock, int execsip, char* passwd)
{
	struct sockaddr_in vv_addr;

	udp_com rcv = recv_udp_command(sock, &vv_addr, 1, 0);

	if (!strncmp(passwd, rcv.pass, AUTH_PASSWD_LEN)) {
		char* ipaddr= get_ipaddr(vv_addr.sin_addr);
		char* ipnum = (char*)to_address_num4(ipaddr, 0);

		if (Allow_IPaddr==NULL || is_host_in_list(Allow_IPaddr, (unsigned char*)ipnum, NULL)) {
			if (rcv.com[0]==COM_VOICE_SET_ACCNT_SVR) {
				Buffer protocol, srvfqdn;
				Buffer buf = make_Buffer_bystr(rcv.mesg);

				decomp_url(buf, NULL, &protocol, &srvfqdn, &VivoxWebPort, NULL);

				VivoxWebServer = (char*)srvfqdn.buf;
				if      (!strcmp((char*)protocol.buf, "https")) VivoxWebPort = 443;
				else if (!strcmp((char*)protocol.buf, "http"))  VivoxWebPort = 80;
				free_Buffer(&protocol);

				DEBUG_MODE {
					print_message("[%d] SL_VMAIN: Vivox Web Server = %s:%d\n", CrntPID, VivoxWebServer, VivoxWebPort);
				}

				tList* xml = get_vivox_info(VivoxWebServer, VivoxWebPort);
				if (xml!=NULL) {
					Buffer tmp, ipa;
					tmp = get_tag_content(xml, "DefaultRealm", 1);
					if (tmp.buf!=NULL) SIPdomainName = (char*)tmp.buf;

					tmp = get_tag_content(xml, "DefaultSIPProxy", 1);
					if (tmp.buf!=NULL) {
						decomp_hostport(tmp, &ipa, &SIPserverPort);
						if (ipa.buf!=NULL)    SIPserverName = (char*)ipa.buf;
						if (SIPserverPort==0) SIPserverPort = SIP_FRWRDR_PORT;
						free_Buffer(&tmp);
					}
					del_xml(&xml);

					DEBUG_MODE {
						print_message("[%d] SL_VMAIN: Vivox SIP Server = %s:%d\n", CrntPID, SIPserverName, SIPserverPort);
						print_message("[%d] SL_VMAIN: Vivox SIP Domain = %s\n", CrntPID, SIPdomainName);
					}
				}

				if (SIPserverName==NULL || SIPserverPort==0) {
					print_message("[%d] SL_VMAIN: ERROR: can not get vivox server information form %s:%d\n", CrntPID, VivoxWebServer, VivoxWebPort);
					//sl_vmain_term(1);
				}

				if (!execsip && !SIPExtForward && SIPserverName!=NULL) {
					pid_t pid = fork();
					if (pid==0) {
						CrntPID = getpid();
						del_all_tList(&Process_List);
						sip_forwarder_main(SIPfrwrdrPort);
						sl_vmain_term(0);
					}
					add_tList_node_int(Process_List, 0, (int)pid);
					Process_List->ldat.id++;
					execsip = ON;
				}
			}
		}
		else {
			DEBUG_MODE print_message("[%d] SL_VMAIN: WARNING: not allowed access from [%s], during to get information from al_relay.\n", CrntPID, ipaddr);
		}

		freeNull(ipaddr);
		freeNull(ipnum);
	}

	return execsip;
}




//////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

tXML*  get_vivox_info(char* server, unsigned short port)
{
	unsigned short cport;
	int    cofd;
	SSL*   ssl;
	tXML*  xml;
	Buffer buf;
	Buffer ipport = comp_hostport(server, port);
	
	buf = make_Buffer(BUFSZ);
	
	cat_s2Buffer(VIVOX_POST_CGI, &buf);
	cat_s2Buffer("Host: ", &buf);
	cat_Buffer  (&ipport, &buf);
	cat_s2Buffer("\r\nAccept: */*\r\n", &buf);
	cat_s2Buffer("Content-Length: 0\r\n", &buf);
	cat_s2Buffer("Content-Type: application/x-www-form-urlencoded\r\n\r\n", &buf);

	free_Buffer(&ipport);

	////////////////////////////////////////////////////////////////////////////////////////////
	// Connect to Vivox
	cofd = get_valid_tcp_client_socket(MinTcpExPort, MaxTcpExPort, server, port, &cport);
	if (cofd<0) {
		DEBUG_MODE print_message("[%d] GET_VIVOX_INFO: ERROR: cannot connect to %s:%d\n", CrntPID, server, port);
		return NULL;
	}
	DEBUG_MODE print_message("[%d] GET_VIVOX_INFO: connected %s:%d\n", CrntPID, server, port);

	ssl_init();
	if (UseClientCA) ssl = ssl_client_connect(cofd, CA_PEM_File, ON);
	else             ssl = ssl_client_connect(cofd, NULL, OFF);

	if (ssl==NULL) {
		socket_close(cofd);
		DEBUG_MODE print_message("[%d] GET_VIVOX_INFO: ERROR: cannot establish SSL connection with %s:%d\n", CrntPID, server, port);
		return NULL;
	}

	ssl_tcp_send_sBuffer(cofd, ssl, &buf);
	recv_https_Buffer(cofd, ssl, NULL, &buf, 10, NULL, NULL);	// contentsのみ必要

	ssl_close(ssl);
	close(cofd);

	xml = xml_parse((char*)buf.buf);
	free_Buffer(&buf);

	return xml;
}






