/**
	Second Life Voice Relay: Header File

				sl_voice_relay.h v1.0  by Fumi.Iseki (C)2009-2010
*/

#ifndef  __SL_VOICE_RELAY_H_
#define  __SL_VOICE_RELAY_H_


#ifdef HAVE_CONFIG_H
	#include "config.h"
#endif

#include "txml.h"
#include "ssl_tool.h"
#include "ipaddr_tool.h"
#include "http_tool.h"
#include "https_tool.h"

#include "sl_tools.h"
#include "sl_relay_voice_io.h"



#define  SL_VOICE_RELAY_VERSION  "sl_voice_relay v1.0   (C) Fumi.Iseki"

#define  RUNAWAY_TIME_OUT 		300
#define  CONFIG_FILE  			"/usr/local/etc/sl_proxy/sl_voice.conf"

#define  V2S_RECV_FILE			".v2s"
#define  S2V_RECV_FILE			".s2v"


#define  VIVOX_POST_CGI			"POST /api2/viv_get_prelogin.php HTTP/1.1\r\n"




//////////////////////////////////////////////////////////////////////////

extern char*	VivoxWebServer;
extern unsigned short VivoxWebPort;

extern char*	SIPforwarder;
extern unsigned short SIPfrwrdrPort;

extern int		SIPExtForward;

extern int 		DebugMode;
extern int 		TCPDumpMode;

extern int		ExperimentMode;
extern int 		RepVersionMode;

extern int 		SysLogLevel;
extern int 		LogMode;

extern int 		UseServerSSL;
extern int 		UseClientCA;

extern int 		Wofd;

extern int 		MaxTcpExPort, MinTcpExPort;
extern int 		MaxTcpImPort, MinTcpImPort;

extern int 		MaxIdleTime;

extern char*	LogFileName;
extern FILE*	LogFile;

extern char* 	Hosts_Allow_File;
extern char* 	Temp_File_Dir;

extern char* 	CERT_PEM_File;
extern char* 	SKEY_PEM_File;
extern char* 	CA_PEM_File;

extern tList* 	Process_List;
extern tList* 	Relay_List;
extern tList* 	Allow_IPaddr;



//////////////////////////////////////////////////////////////////////////
// Functions

// sl_vmain
void   	sl_vmain_term(int signal);
void  	sl_sigterm_child(int signal);

// sl_vconfig.c
void   	read_config_file(char* fn);

// sl_voice_relay
void    exchange_info_with_relay(int nofd, unsigned short iport, unsigned short vport, char* passwd);
void 	vivox_https_relay(char* server, unsigned short port, int scok);

void    exec_exchange_info_with_relay(int sock, int iport, int vport, char* passwd);
void    exec_vivox_https_relay(int sock);
int     exec_sip_forwarder_main(int sock, int execsip, char* passwd);

tXML*	get_vivox_info(char* server, unsigned short port);



#endif


