/* vi: set tabstop=4 nocindent paste: */

#ifndef  __JBL_COMMON_HEADER_
#define  __JBL_COMMON_HEADER_


/**
汎用共通ヘッダ   common.h  v5.0  '07/1/8
				 by Fumi.Iseki (C)
*/



#ifdef HAVE_CONFIG_H
	#include "config.h"
#endif

/**/



#define _INCLUDE_POSIX_SOURCE
#define __EXTENSIONS__			// for Solaris


#include <stdio.h>
#include <stdlib.h>
#include <string.h>



// 動作環境
#ifdef __MINGW32__
	#define MINGW32
#elif defined __CYGWIN__
	#define CYGWIN
#endif



// for Windows VC++
#ifdef  WIN32   // for Windows
	#include <io.h>
	#ifndef _MFC_APP_
		#define _WINSOCKAPI_		// network.h で winsock2.h を読み込むため
		#include <windows.h>
	#endif
	#define  Intel
	#define  bzero(p, n)	ZeroMemory((p), (n))
	#define  bcopy(f, t, n) CopyMemory((t), (f), (n))
	#define  snprintf	   	_snprintf
	#define  vsnprintf	  	_vsnprintf
	#define  strcasecmp	 	_stricmp 
	#define  strncasecmp	_strnicmp
	#define  close(p)		_close(p)
	#define  mode_t		 	int 

	#ifdef _WINDLL						   
		#define DllExport __declspec(dllexport)
		#define DllImport __declspec(dllimport)
	#endif

	#define WIN32_NULL 	(void*)0xdddddddd
#endif

				
#ifndef DllExport   
	#define DllExport
	#define DllImport
#endif



/////////////////////////////////////////////////////////////////////////
// for Solaris
#ifndef LOG_PERROR
	#define LOG_PERROR 0
#endif




/////////////////////////////////////////////////////////////////////////
typedef  unsigned char  uByte;
typedef  char			sByte;
typedef  unsigned short uWord;
typedef  short			sWord;
typedef  unsigned int   uDWord;
typedef  int			sDWord;



#define  MAXBUFSZ  		65536
#define  LARGEBUFSZ		32768
#define  RECVBUFSZ 		16384
#define  LGBUFSZ  		8192
#define  BUFSZ	  		4096

#define  LFRAME   		2048
#define  LBUF  			1024
#define  LMESG	  		512
#define  LDATA	  		256
#define  LNAME	  		128
#define  LMNAME  		64
#define  LPASS	  		64
#define  LGUID			40		// 16*2 + 4(-) + 1('\0') = 37 以上の 4の倍数
#define  LUUID			36		// 16*2 + 1('\0') = 33 以上の 4の倍数
#define  LADDR	  		32
#define  LSNAME	  		32
#define  L_ID	  		16

#define  LEN_INT		22		// log 2^64 + '\0' + 1(予備)
#define  LEN_IPADDR		17		// strlen("AAA.BBB.CCC.DDD") + '\0' + 1(予備)
#define  LEN_PORT		7		// strlen("65536") + '\0' + 1(予備)
#define  LEN_IPPORT		23		// strlen("AAA.BBB.CCC.DDD:65536") + '\0' + 1(予備)


#define  STRLEN_GUID	36		// GUID の長さ






#define  WORK_FILENAME_LEN	16


#define  EPS	  	 1.0e-6
#define  PI		  	 3.1415926535898
#define  SINTMAX   	 2147483647
#define  SINTMIN	-2147483648
#define  UINTMAX	 4294967295
#define  SWORDMAX  	 32767
#define  SWORDMIN  	-32768
#define  UWORDMAX  	 65535

#ifdef  WIN32   // for Windows	
	#define  RANDMAX  32767
#else
	#define  RANDMAX  2147483647
#endif


#ifndef  FALSE
	#define  FALSE  0
#endif
#ifndef  TRUE
	#define  TRUE   1
#endif

#define  UNKNOWN	999


#define  NORM   	0
#define  NORMAL 	0
#define  ERR   		-1
#define  ON	 		1
#define  OFF		0
#define  OK	 		1
#define  NG	 		0
#define  YES		1
#define  NO	 		0
#define  NONE   	0



#ifndef  Max
	#define  Max(x, y)	(((x)<(y)) ? (y):(x))
#endif
#ifndef  Min
	#define  Min(x, y)	(((x)>(y)) ? (y):(x))
#endif
#ifndef  Sign
	#define  Sign(x)	(((x)>=0)  ? (1):(-1))
#endif


#define  Loop 	   			while(1)
#define  Xabs(x)			(((x)>=0)  ? (x):(-(x)))
#define  getBit(x, n)	 	((sByte)((*(x+(n)/8)>>(7+(n)/8*8-(n)))&0x01))
#define  setBit(x, n, i)  	((i)?(*(x+(n)/8)|=(0x80>>(n-(n)/8*8))):(*(x+(n)/8)&=~(0x80>>(n-(n)/8*8))))
#define  checkBit(dat, bit) (((dat)&(bit))==(bit))
#define  maskBit(dat, bit) 	((dat)&(0xff>>(8-(bit))))


#define  Frand()	((float)rand()/RANDMAX)
#define  Drand(x)	((int)((float)rand()/RANDMAX*(x+1)))
#define  LDrand(x)  ((long int)((float)rand()/RANDMAX*(x+1)))


#ifndef  Error
	#define  Error(s)	{perror(s); return -1;}
#endif



/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
/**
Parameter
	汎用パラメター   32Byte
*/
typedef struct {
	sByte pm[32];
} Parameter32;


/**/


#endif

