
#ifndef  __JBL_JPEG_TOOL_H_
#define  __JBL_JPEG_TOOL_H_


/*
JPEG TOOL HEADER:  jpeg_tool.h v0.9   '09/3/8   (C) Fumi.Iseki
 

*/



#include "xtools.h"
#include "gdata.h"

#include <jpeglib.h>



typedef struct {
	int		xs;
	int		ys;
	int		col;
	int		state;
	JSAMPLE*   gp;
	JSAMPARRAY img;
} JPEGImage;




#if JPEG_LIB_VERSION < 80

typedef struct {
  struct jpeg_destination_mgr pub; 	// public fields 

  unsigned char ** outbuffer;   	// target buffer 
  unsigned long * outsize;
  unsigned char * newbuffer;    	// newly allocated buffer 
  JOCTET * buffer;              	// start of buffer 
  size_t bufsize;
} my_mem_destination_mgr;

typedef my_mem_destination_mgr * my_mem_dest_ptr;

#endif





//////////////////////////////////////////////////////////////////////////////////////////

JPEGImage  read_jpeg_file (char* fname);
int  	   write_jpeg_file(char* fname, JPEGImage jp, int qulty);
int  	   write_jpeg_mem(unsigned char** buf, unsigned long* len, JPEGImage jp, int qulty);

WSGraph    JPEGImage2WSGraph(JPEGImage jp);
BSGraph    JPEGImage2BSGraph(JPEGImage jp);
JPEGImage  WSGraph2JPEGImage(WSGraph vp);
JPEGImage  BSGraph2JPEGImage(BSGraph vp);

JPEGImage  make_JPEGImage(int xs, int ys, int col);
void       free_JPEGImage(JPEGImage* jp);


//
#if JPEG_LIB_VERSION < 80

GLOBAL(void)  		jpeg_mem_dest(j_compress_ptr cinfo, unsigned char** buf, unsigned long* len);
METHODDEF(void)    	mem_init_destination(j_compress_ptr cinfo);
METHODDEF(boolean) 	mem_empty_output_buffer(j_compress_ptr cinfo);
METHODDEF(void)    	mem_term_destination(j_compress_ptr cinfo);

#endif





#endif



