/* vi: set tabstop=4 nocindent noautoindent: */

#ifndef  __JBL_INFO_SYSTEM_NET_H_
#define  __JBL_INFO_SYSTEM_NET_H_



/**

ISNET用 汎用プロトコル処理


*/



#include "tlist.h"
#include "password.h"
#include "cipher.h"
#include "xtools.h"

#include "ssl_tool.h"

#ifdef ENABLE_LDAP
	#include "ldap_tool.h"
#endif



extern Buffer*  User_ID;
extern Buffer*  User_Passwd;
extern Buffer*  User_Salt;

extern int      No_isNet_Chlng;
extern int      Use_isNet_Ldap;
extern int      Use_isNet_Crypt;



/**
コマンド：
	HELLO: 	接続を確認

	BYE:	クライアントからの切断

	USERID: サーバにユーザID を送る．

	NOCHLNG: チャレンジキーを使用しない．

	PASSWD: サーバにパスワードを送る

	KEYEX:	暗号化のためのキーをサーバと交換する
		RSAは未実装(ssl_tool.cの中で実装される)

	CRYPT: 	使用する暗号方式をサーバに通知する．
		現在はまだ，AES128CBC, 3DES3CBC のみサポート
*/



/**/

// サーバ側でのコマンド受信処理
Buffer  get_command(Buffer); 
Buffer  get_operand(Buffer);  
Buffer  get_comment(Buffer); 

int		command_HELLO  (Buffer operand, Buffer comment, int sock);	// 100
int		command_BYE    (Buffer operand, Buffer comment, int sock);	// 110
int		command_USERID (Buffer operand, Buffer comment, int sock);	// 120
int		command_PASSWD (Buffer operand, Buffer comment, int sock);	// 130
int		command_NOCHLNG(Buffer operand, Buffer comment, int sock);	// 140
int		command_KEYEX  (Buffer operand, Buffer comment, int sock);	// 160
int		command_CRYPT  (Buffer operand, Buffer comment, int sock);	// 170


// クライアント側でのコマンド送信処理
int     send_command_recv_ans(int sock, char* command, int tm);
Buffer  recv_mesg_until_end(int sock, int tm);

Buffer	send_algor_recv_spki(int sock, char* algor, int tm);
int		send_spki_recv_ans  (int sock, Buffer mkey, int tm);


// クライアント側での認証処理
int  	check_auth(Buffer ahost, int aport, Buffer userid, Buffer passwd, int chmod, int keyex, int cryptm, char* cfn, int cont);


// クライアント側での暗号化開始・終了処理
int   	start_CRYPT_transfer(int sock, int keyex, int cryptm, Buffer ipaddr, char* cfn, int tm);
int		stop_CRYPT_transfer (int sock, int tm);




/**/

#endif

