/* vi:set tabstop=4 noautoindent nocindent: */

/** 
ǧڥ Ver 3.4.0

	Diffie-Hellman б

*/


#include "authd.h"



int   PortNo	  = 9000;	  // ǥեȥݡֹ 
int   DaemonMode  = ON;
int   NoCheckMode = OFF;
int   SecureMode  = OFF;
int   NoChlngMode = OFF;



tList* Allow_IPaddr = NULL;

char*  IPaddr;
char*  MnName;
char*  Unknown_User = "unknown user";

unsigned char*  IPaddr_num;





/*
  ޥɲ
*/
int command_pase(Buffer mesg, int sock)
{
	int		cc, endflag = OFF;
	Buffer  buf, dec, command, operand, comment;
	char*   user_id;


	buf = make_Buffer(LBUF);
	dec = get_plain_sBuffer(mesg, NULL);
	chomp_Buffer(&dec);
	command = get_command(dec);
	operand = get_operand(dec);
	comment = get_comment(dec);
	DEBUG_MODE print_message("CLIENT = %s\n", dec.buf);
	free_Buffer(&dec);


	if (!strcasecmp("HELLO", (char*)command.buf)){
		cc = command_HELLO(operand, comment, sock);
	}

	else if (!strcasecmp("KEYEX", (char*)command.buf)){
		cc = command_KEYEX(operand, comment, sock);
	}

	else if (!strcasecmp("CRYPT", (char*)command.buf)){
		cc = command_CRYPT(operand, comment, sock);
	}

	else if (!strcasecmp("USERID", (char*)command.buf)){
		if (NoCheckMode==ON) {  // ǥХå OK֤
			cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
		}
		else if (SecureMode==ON && CRYPT_Algorism==0) {
			cc = tcp_send_crypt_mesg(sock, "ERR 801 Secure Mode required CRYPT connection.\r\n", NULL);
   			endflag = ON;
	  		//socket_close(sock);
		}
		else if (NoChlngMode==ON && No_Chlng==FALSE) {
			cc = tcp_send_crypt_mesg(sock, "ERR 802 Use NOCHLNG command.\r\n", NULL);
			endflag = ON; 
			//socket_close(sock);
		}    
		else if (CRYPT_Algorism==0 && No_Chlng==TRUE) {
			cc = tcp_send_crypt_mesg(sock, "ERR 803 CRYPT Algorism required at NOCHLNG connection.\r\n", NULL);
			endflag = ON; 
			//socket_close(sock);
		}    
		else {
			cc = command_USERID(operand, comment, sock);
		}
	}

	else if (!strcasecmp("PASSWD", (char*)command.buf)){ 
		if (NoCheckMode==ON) {
			cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
		}
		else {
			cc = command_PASSWD(operand, comment, sock);
		}
	}

	else if (!strcasecmp("BYE", (char*)command.buf)){ 
		cc = command_BYE(operand, comment, sock);
   		endflag = ON;
	}

	else {
		copy_s2Buffer("ERR 988 Unknown Command: ", &buf);
		cat_Buffer(&command, &buf);
		cat_s2Buffer(".\r\n", &buf);
	  	//tcp_send_sBufferln(sock, &buf);
		cc = tcp_send_crypt_mesg(sock, (char*)buf.buf, NULL);
   		endflag = ON;
		if (User_ID==NULL) user_id = Unknown_User;
		else               user_id = (char*)User_ID->buf;
		syslog(LOG_INFO, "[%s] %s: %s", IPaddr, user_id, buf.buf);
		DEBUG_MODE print_message("[%s] %s: %s", IPaddr, user_id, buf.buf);
	}


	if (endflag==ON) {
	  	socket_close(sock);
		if (User_ID==NULL) user_id = Unknown_User;
		else               user_id = (char*)User_ID->buf;
		syslog(LOG_INFO, "[%s] %s: session end.\n", IPaddr, user_id);
		DEBUG_MODE print_message("[%s] %s: session end.\n", IPaddr, user_id);
		exit(0);
	}

	free_Buffer(&buf);
	free_Buffer(&command);
	free_Buffer(&operand);
	free_Buffer(&comment);

	return 0;
}








/*
  mainؿ
  -p : ³ƥݡֹꤹ롥
  -k : ³ƥ¸ե̾ꤹ롥
  -a : ³³ĥե̾ꤹ롥
  -f : ³ƥץIDե̾ꤹ롥
  -i : started by inetd (no daemon mode)
  -s : 奢⡼ɡʶŹ沽⡼)
  -m : 󥸥򴹤ʤ⡼ɤǤΤư奢⡼ɻꤷΤͭ
  -d : ǥХå⡼
  -n : no check mode
  -h : إɽ
  -v : Сɽ
*/
int main(int argc, char** argv)
{   
	int	   i, port=0;
	int	   sofd, nsofd;
	socklen_t cdlen;
	struct sockaddr_in cl_addr;
	Buffer pki, dhkeyfile, allowfile, pidfile;


	dhkeyfile = make_Buffer(LNAME);
	allowfile = make_Buffer(LNAME);
	pidfile   = make_Buffer(LNAME);
	for (i=1; i<argc; i++) {
		if		(!strcasecmp(argv[i],"-p")) {if (i!=argc-1) port = atoi(argv[i+1]);}
		else if (!strcasecmp(argv[i],"-k")) {if (i!=argc-1) copy_s2Buffer(argv[i+1], &dhkeyfile);}
		else if (!strcasecmp(argv[i],"-a")) {if (i!=argc-1) copy_s2Buffer(argv[i+1], &allowfile);}
		else if (!strcasecmp(argv[i],"-f")) {if (i!=argc-1) copy_s2Buffer(argv[i+1], &pidfile);}
		else if (!strcasecmp(argv[i],"-d"))  DebugMode   = ON;					 
		else if (!strcasecmp(argv[i],"-i"))  DaemonMode  = OFF;					 
		else if (!strcasecmp(argv[i],"-n"))  NoCheckMode = ON;					 
		else if (!strcasecmp(argv[i],"-s"))  SecureMode  = ON;					 
		else if (!strcasecmp(argv[i],"-m"))  NoChlngMode = ON;					 
		else if (!strcasecmp(argv[i],"-v")) {fprintf(stderr, PACKAGE_VERSION); exit(0);}
		else if (!strcasecmp(argv[i],"-h")) {fprintf(stderr, ARGHELP); exit(0);}
		else if (!strcasecmp(argv[i],"-help")) {fprintf(stderr, ARGHELP); exit(0);}
	}
	if (port==0) port = PortNo;
	else		 PortNo = port;
	if (dhkeyfile.buf[0]=='\0') copy_s2Buffer(DHKEY_FILE, &dhkeyfile);
	if (allowfile.buf[0]=='\0') copy_s2Buffer(ALLOW_FILE, &allowfile);

	if (SecureMode==OFF) NoChlngMode = OFF ;


//	signal(SIGCHLD, SIG_IGN);
	set_sigterm_child(NULL);
	signal(SIGINT, interrupt);

//	openlog("Authd", LOG_PERROR|LOG_PID, LOG_AUTH); // open syslog 
	openlog("Authd", LOG_PID, LOG_AUTH); 			// open syslog 

	Allow_IPaddr = read_ipaddr_file((char*)allowfile.buf);

	DEBUG_MODE print_message("DHŹ沽\n");
	Base64_DHspki = new_Buffer();
    pki = get_DHspki_ff((char*)dhkeyfile.buf, 1024);
    *Base64_DHspki = encode_base64_Buffer(pki);
    free_Buffer(&pki);
	free_Buffer(&dhkeyfile);
	free_Buffer(&allowfile);
	DEBUG_MODE print_message("DHŹ沽λ\n");

	sofd  = tcp_server_socket(port);
	cdlen = sizeof(cl_addr);

    // PIDեκ
    if (pidfile.buf[0]!='\0') {
        FILE*  fp;
        pid_t  pid;
        fp = fopen((char*)pidfile.buf, "w");
        if (fp!=NULL) {
            pid = getpid();
            fprintf(fp, "%d", (int)pid);
            fclose(fp);
        }
		free_Buffer(&pidfile);
    }


//	seteuid(-2);
	if (DaemonMode==ON) {
		Loop{
			nsofd = accept_intr(sofd, (struct sockaddr*)&cl_addr, &cdlen);
			if (nsofd<0) Error("accept");
			if (fork()==0) receipt(nsofd, cl_addr);
			close(nsofd);
		}
	}
	else {
		nsofd = accept_intr(sofd, (struct sockaddr*)&cl_addr, &cdlen);
		if (nsofd<0) Error("accept");
		receipt(nsofd, cl_addr);
		close(nsofd);
		close(sofd);
	}

	return 0;
}






/*  
  饤Ȥ̿Ԥ
*/
void  receipt(int sofd, struct sockaddr_in addr)
{
	int	   cc;
	Buffer buf, msg;

	CRYPT_Algorism = 0;
	IPaddr_num = get_ipaddr_num(addr.sin_addr);
	IPaddr	   = get_ipaddr(addr.sin_addr);
	MnName     = get_hostname_bynum(IPaddr_num);

	init_rand();

	if (Allow_IPaddr!=NULL) {
		if (!is_host_in_list(Allow_IPaddr, IPaddr_num, MnName)) {
			syslog(LOG_INFO, "[%s] access denied.\n", IPaddr);
			DEBUG_MODE print_message("[%s] access denied.\n", IPaddr);
			socket_close(sofd);
			exit(1);
		}
	}

	syslog(LOG_INFO, "[%s] session start.\n", IPaddr);
	DEBUG_MODE print_message("[%s] session start.\n", IPaddr);


	msg = make_Buffer(LBUF);
	buf = make_Buffer(LBUF);

	do {
		cc = tcp_recv_sBuffer(sofd, &buf, TIME_OUT);
		if(cc>0) {
			cc = cat_Buffer(&buf, &msg);
			if (buf.buf[cc-1]==LF) {
				command_pase(msg, sofd);
				clear_Buffer(&msg);
			}
			clear_Buffer(&buf);
		}
	} while (cc>0);


	if (cc<0) {
		tcp_send_mesgln(sofd, "ERR 999 Time Out.");
		syslog(LOG_INFO, "[%s] time out.\n", IPaddr);
		DEBUG_MODE print_message("[%s] time out.\n",  IPaddr);
	}
  

	close(sofd);
	syslog(LOG_INFO, "[%s] session end.\n", IPaddr);
	DEBUG_MODE print_message("[%s] session end.\n", IPaddr);

	free_Buffer(&buf);
	free_Buffer(&msg);
	free(IPaddr);
	free(IPaddr_num);
	free(MnName);

	exit(0);
}		





void  interrupt(int signal)
{
	exit(signal);
}



