/* vi: set tabstop=4 nocindent noautoindent: */

/**
	Bufferݡȥץ  buffer.c   v.1.3

  	إå
	  	#include "buffer.h"

 */


#include "buffer.h"




/**
Buffer*  new_Buffer()

	ǽBufferѿĤФ

	ʤ

	͡ĤФ BufferѿؤΥݥ󥿡
			˼ԤNULL֤롥
*/
Buffer*  new_Buffer(void)
{
	Buffer*  buf;

	buf = (Buffer*)malloc(sizeof(Buffer));
	if (buf==NULL) return NULL;

	memset(buf, 0, sizeof(Buffer));
	buf->vldsz = -1;

	return buf;
}





/**
Buffer  init_Buffer()

	ǽBufferѿ֤

	͡줿Bufferѿ

	㡧
		a = init_Buffer() Ȥ硤a˸ͤäƤ硤ͤ free
		ʤΤա
*/
Buffer  init_Buffer()
{
	Buffer  buf;

	memset(&buf, 0, sizeof(Buffer));
	buf.vldsz = -1;

	return buf;
}





/**
Buffer  make_Buffer(int sz)

	ǽBufferѿΥХåեĤФ
		  sz  BufferѿΥХåե礭
		  Хåե 0x00ǽ롥bufsz=sz, vldsz=0 Ȥʤ롥

	sz -- BufferѿΥХåե礭

	͡ĤФ Bufferѿ
			Хåեκ˼Ԥ,ХåեΥ(bufsz) 0,ХåեؤΥݥ󥿤 NULLȤʤ롥
*/
Buffer  make_Buffer(int sz)
{
	Buffer  buf;

	memset(&buf, 0, sizeof(Buffer));
	if (sz<=0) return buf;

	buf.bufsz = sz;
	buf.buf = (unsigned char*)malloc(buf.bufsz+1);

	if (buf.buf==NULL) {
		buf.bufsz = 0;
		buf.vldsz = -1;
	}
	else memset(buf.buf, 0, buf.bufsz+1);

	return buf;
}





/**
Buffer  make_Buffer_bystr(char* str)

	ǽʸ󤫤顤BufferѿΥХåեĤФ
		  make_Buffer_bystr("")  BufferѿνˤѤ롥
		  Хʥǡ BufferѿФˤϡset_Buffer()Ѥ롥 

	sz -- BufferѿΥХåե˳Ǽʸ

	͡ĤФ BufferѿХåեκ˼Ԥ,
			ХåեΥ(bufsz) 0,ХåեؤΥݥ󥿤 NULLȤʤ롥

	#define  make_Buffer_bystr(s)	set_Buffer((void*)(s), -1)
*/






/**
Buffer  make_Buffer_bychar(unsigned char cc)

	ǽʸ顤BufferѿΥХåեĤФ
		  make_Buffer_bychar('\0')  BufferѿνˤѤ롥

	sz -- BufferѿΥХåե˳Ǽʸ

	͡ĤФ BufferѿХåեκ˼Ԥ,
			ХåեΥ(bufsz) 0,ХåեؤΥݥ󥿤 NULLȤʤ롥
*/
Buffer  make_Buffer_bychar(unsigned char cc)
{
	Buffer  buf;
	
	buf = make_Buffer(LADDR);
	if (buf.buf==NULL) return buf;

	buf.buf[0] = cc;
	buf.vldsz = 1;
	return buf;
}








/**
void  free_Buffer(Buffer* buf)

	ǽBufferѿΥХåե롥

	buf  -- Хåեä BufferǡؤΥݥ󥿡

 */
void  free_Buffer(Buffer* buf)
{
	if (buf!=NULL) {
		freeNull(buf->buf);
		memset(buf, 0, sizeof(Buffer));
		buf->vldsz = -1;
	}
}





/**
void   del_Buffer(Buffer** buf)

	ǽnew_Buffer()ǺФ Bufferѿ롥

	buf --  BufferǡΥݥ󥿤ؤΥݥ󥿡

 */
void   del_Buffer(Buffer** buf)
{
	if (buf!=NULL && *buf!=NULL) {
		freeNull((*buf)->buf);
		free(*buf);
		*buf = NULL;
	}
}





/**
Buffer  set_Buffer(void* buf, int len)

	ǽBufferѿΥХåե򿷤, ΥХåե 
		  buf򥳥ԡ롥lenϥԡǡĹ⤷ len 0̤
		  , bufʸȤư롥
		  buf ʸξ make_Buffer_bystr() Ѳǽ

	buf  -- ԡХåեؤΥݥ󥿡
		  len  -- ХåեĹ(Хñ)

	; 줿 Bufferǡ
 */
Buffer  set_Buffer(void* buf, int len)
{
	Buffer  str;

	str = init_Buffer();
	if (buf==NULL) return str;

	if (len<0) len = (int)strlen((char*)buf);
	str = make_Buffer((int)((len+1)*BUFFER_FACT));
	if (str.buf==NULL) return str;

	memcpy(str.buf, buf, len);
	str.vldsz = len;
	return  str;
}





/**
Buffer  dup_Buffer(Buffer buf)

	ǽBufferѿΥԡĤ롥

	buf -- ԡѿ

	; 줿 Bufferǡ
 */
Buffer  dup_Buffer(Buffer buf)
{
	Buffer  str;

	str = make_Buffer(buf.bufsz);
	memcpy(str.buf, buf.buf, buf.bufsz);
	str.vldsz = buf.vldsz;
	str.state = buf.state;
	return  str;
}





/**
void  clear_Buffer(Buffer* str)

	ǽBufferѿ ΥХåե 0ꥢ롥

	str -- ꥢ BufferǡؤΥݥ󥿡

 */
void  clear_Buffer(Buffer* str)
{
	memset(str->buf, 0, str->bufsz+1);
	str->vldsz = 0;
	str->state = 0;
}






/**
int  copy_Buffer(Buffer* src, Buffer* dst)
  
	ǽBufferѿ src dstإХåե򥳥ԡ롥⤷, dst 
		  srcΥХåե򥳥ԡΥڡ̵, 
		  Хåեΰݤƥԡ롥

	src -- ԡؤΥݥ󥿡
		  dst -- ԡؤΥݥ󥿡

	͡ 0ʾ  dstΥХåե˥ԡ줿ʸ
				-1  srcޤ dst NULL 
				-2  γݤ˼Ԥ¹Ԥʤä


	(): ؿǻѤ,ȷʳΰФƤδؿѤƤ
			  ʤĤޤʲΤ褦ʻȤϴְ㤤

			  func(Buffer buf){ 
				  ...............
				  copy_Buffer(&src, &buf);
				  ...............
			  }

		ϲΤ褦ѹ롥

			  func(Buffer buf){ 
				  ...............
				  copy_Buffer(&src, &buf);
				  ...............
			  }

		ͳؿǥХåե礭Ѥǽ뤬ƤӽФ¦
			  ϤΤȤΤ뤳ȤǤʤ

 */
int  copy_Buffer(Buffer* src, Buffer* dst)
{
	int sz, dz;

	if (src==NULL || dst==NULL) return -1;
	if (src->buf==NULL) return -1;

	sz = src->vldsz;
	if (sz<0)  sz = (int)strlen((const char*)src->buf);
	if (sz==0) return 0;

	if (dst->bufsz < sz) {
		unsigned char* buf;
		dz  = (int)((src->bufsz+1)*BUFFER_FACT);
		buf = (unsigned char*)malloc(dz+1);
		if (buf==NULL) return -2;

	   	free(dst->buf);
		dst->bufsz = dz;
		dst->buf   = buf;
	}

	memset(dst->buf, 0, dst->bufsz+1);
	memcpy(dst->buf, src->buf, sz);
	dst->vldsz = sz;
	dst->state = 0;

	return  sz;
}





/**
int  cat_Buffer(Buffer* src, Buffer* dst)
  
	ǽBufferѿ src dstإХåե cat롥⤷, dst src
		  Хåե catΥڡ̵Ͽ˥Хåեΰ
		  ݤ cat롥

	src -- catؤΥݥ󥿡
		  dst -- catؤΥݥ󥿡

	͡ 0ʾ  dstΥХåե˥ԡ줿ʸ
				-1  srcޤ dst NULL 
				-2  γݤ˼Ԥ¹Ԥʤä


	(): ؿǻѤ,ȷʳΰФƤδؿѤƤ
			  ʤĤޤʲΤ褦ʻȤϴְ㤤

			  func(Buffer buf){ 
				  ...............
				  cat_Buffer(&src, &buf);
				  ...............
			  }

		ϲΤ褦ѹ롥

			  func(Buffer* buf){ 
				  ...............
				  cat_Buffer(&src, buf);
				  ...............
			  }

		ͳؿǥХåե礭Ѥǽ뤬ƤӽФ¦
			  ϤΤȤΤ뤳ȤǤʤ

 */
int  cat_Buffer(Buffer* src, Buffer* dst)
{
	int sz, dz;

	if (src==NULL || dst==NULL) return -1;
	if (src->buf==NULL) return -1;

	sz = src->vldsz;
	if (sz<0) sz = (int)strlen((const char*)src->buf);
	if (sz==0) return 0;

	dz = dst->vldsz;
	if (dz<0) {
		if (dst->buf!=NULL) dz = (int)strlen((const char*)dst->buf);
		else				dz = 0;
	}

	if (dst->bufsz < sz+dz) {
		Buffer buf;			 	// dst 
		buf.bufsz = dst->bufsz;
		buf.vldsz = dz;
		buf.buf   = (unsigned char*)malloc(buf.bufsz+1);
		if (buf.buf==NULL) return -2;

 		buf.buf[buf.bufsz] = '\0';
		memcpy(buf.buf, dst->buf, buf.bufsz);
		free_Buffer(dst);

		dst->bufsz = (int)((buf.bufsz+src->bufsz+1)*BUFFER_FACT);
		dst->buf   = (unsigned char*)malloc(dst->bufsz+1);
		if (dst->buf==NULL) {
	   		*dst = buf;
	   		return -2;
		}
		memset(dst->buf, 0, dst->bufsz+1);
		memcpy(dst->buf, buf.buf, buf.vldsz);
		free_Buffer(&buf);
	}

	memset(dst->buf+dz, 0, dst->bufsz-dz+1);
	memcpy(dst->buf+dz, src->buf, sz);
	dst->vldsz = sz + dz;
	dst->state = 0;

	return  dst->vldsz;
}





/**
int  copy_b2Buffer(void* src, Buffer* dst, int sz)
  
	ǽǤդΥХʥǡsrc Bufferѿdst copy롥
		  ⤷, dst srcΥХåե copyΥڡ̵
		  ˥Хåեΰݤ copy롥
		  sz 0̤ξ, srcʸȤư롥

	src -- copyǤեǡؤΥݥ󥿡
		  dst -- copyBufferѿؤΥݥ󥿡
		  sz  -- copyХȿ

	͡ 0ʾ  dstΥХåե˥ԡ줿ʸ
				-1  srcޤ dst NULL 
				-2  γݤ˼Ԥ¹Ԥʤä


	(): ؿǻѤ,ȷʳΰФƤδؿѤƤ
			  ʤĤޤʲΤ褦ʻȤϴְ㤤

			  func(Buffer buf){ 
				  ...............
				  copy_b2Buffer(&src, &buf, n);
				  ...............
			  }

		ϲΤ褦ѹ롥

			  func(Buffer* buf){ 
				  ...............
				  copy_b2Buffer(&src, buf, n);
				  ...............
			  }

		ͳؿǥХåե礭Ѥǽ뤬ƤӽФ¦
			  ϤΤȤΤ뤳ȤǤʤ

 */
int  copy_b2Buffer(void* src, Buffer* dst, int len)
{
	int sz, dz;

	if (src==NULL || dst==NULL) return -1;
	if (len<0) sz = (int)strlen((const char*)src);
	else	   sz = len;
	if (sz<=0) return 0;

	if (dst->bufsz < sz) {
		unsigned char* buf;
		dz  = (int)((sz+1)*BUFFER_FACT);
		buf = (unsigned char*)malloc(dz+1);
		if (buf==NULL) return -2;
	   	free(dst->buf);
		dst->bufsz = dz;
		dst->buf   = buf;
	}

	memcpy(dst->buf, src, sz);
	dst->buf[sz] = '\0';
	dst->vldsz = sz;
	dst->state = 0;

	return  sz;
}





/**
int  cat_b2Buffer(void* src, Buffer* dst, int len)

	ǽǤդΥХʥǡsrc Bufferѿdst cat롥
		  ⤷, dst srcΥХåե catΥڡ̵
		  ˥Хåեΰݤ cat롥
		  sz 0̤ξ, srcʸȤư롥

	src -- catǤեǡؤΥݥ󥿡
		  dst -- catBufferѿؤΥݥ󥿡
		  len -- catХȿ

	͡ 0ʾ  dstΥХåե˥ԡ줿ʸ
				-1  srcޤ dst NULL 
				-2  γݤ˼Ԥ¹Ԥʤä


	(): ؿǻѤ,ȷʳΰФƤδؿѤƤ
			  ʤĤޤʲΤ褦ʻȤϴְ㤤

			  func(Buffer buf){ 
				  ...............
				  cat_b2Buffer(&src, &buf, n);
				  ...............
			  }

		ϲΤ褦ѹ롥

			  func(Buffer* buf){ 
				  ...............
				  cat_b2Buffer(&src, buf, n);
				  ...............
			  }

		ͳؿǥХåե礭Ѥǽ뤬ƤӽФ¦
			  ϤΤȤΤ뤳ȤǤʤ

 */
int  cat_b2Buffer(void* src, Buffer* dst, int len)
{
	int sz, dz;

	if (src==NULL || dst==NULL) return -1;
	if (len<0) sz = (int)strlen((const char*)src);
	else	   sz = len;
	if (sz<=0) return 0;
   
	dz = dst->vldsz;
	if (dz<0) {
		if (dst->buf!=NULL) dz = (int)strlen((const char*)dst->buf);
		else				dz = 0;
	}

	if (dst->bufsz < sz+dz) {
		Buffer buf;			 // dst 
		buf.bufsz = dst->bufsz;
		buf.vldsz = dz;
		buf.buf   = (unsigned char*)malloc(buf.bufsz+1);
		if (buf.buf==NULL) return -2;

 		buf.buf[buf.bufsz] = '\0';
		memcpy(buf.buf, dst->buf, buf.bufsz);
		free_Buffer(dst);

		dst->bufsz = (int)((buf.bufsz+sz+1)*BUFFER_FACT);
		dst->buf   = (unsigned char*)malloc(dst->bufsz+1);
		if (dst->buf==NULL) {
	   		*dst = buf;
	   		return -2;
		}
		memset(dst->buf, 0, dst->bufsz+1);
		memcpy(dst->buf, buf.buf, buf.vldsz);
		free_Buffer(&buf);
	}

	memcpy(dst->buf+dz, src, sz);
	dst->buf[dz+sz] = '\0';
	dst->vldsz = sz + dz;
	dst->state = 0;

	return  dst->vldsz;
}




/**
int  copy_s2Buffer(char* src, Buffer* dst)
  
	ǽchar*ѿ src Bufferѿdstʸ copy롥
		  ⤷, dst src򥳥ԡΥڡ̵, 
		  Хåեΰݤƥԡ롥

	src -- ԡؤΥݥ󥿡
		  dst -- ԡؤΥݥ󥿡

	͡	 0  srcޤ dst NULL 
				-1  γݤ˼Ԥ¹Ԥʤä
			 1ʾ  dstΥХåե˥ԡ줿ʸ
*/
#ifdef EBUG
int  copy_s2Buffer(char* src, Buffer* dst)
{
	return copy_b2Buffer((void*)src, dst, (int)strlen(src));
}
#endif




/**
int  cat_s2Buffer(char* src, Buffer* dst)
  
	ǽchar*ѿ src Bufferѿdstʸ cat롥
		  ⤷, dst srcʸ catΥڡ̵
		  ˥Хåեΰݤ cat롥

	src -- catؤΥݥ󥿡
		  dst -- catؤΥݥ󥿡

	͡	 0  srcޤ dst NULL 
				-1  γݤ˼Ԥ¹Ԥʤä
			 1ʾ  dstΥХåե˥ԡ줿ʸ
*/
#ifdef EBUG
int  cat_s2Buffer(char* src, Buffer* dst)
{
	return cat_b2Buffer((void*)src, dst, (int)strlen(src));
}
#endif





int  copy_i2Buffer(int src, Buffer* dst)
{
	char num[LEN_INT];

	snprintf(num, LEN_INT-1, "%d", src);
	return copy_b2Buffer((void*)num, dst, (int)strlen(num));
}





int  cat_i2Buffer(int src, Buffer* dst)
{
	char num[22];

	snprintf(num, 21, "%d", src);
	return cat_b2Buffer((void*)num, dst, (int)strlen(num));
}





/**
int  cmp_Buffer(Buffer src, Buffer dst, int n)
  
	ǽХåեӡ
		  Bufferѿ src dstΥХåեʬӤ롥n<=0 ʤ ,
		  n>0 ʤ Ƭ nХӤ롥

	src -- ӸؤΥݥ󥿡
		  dst -- ؤΥݥ󥿡
		  n   -- ʸ

	͡ 0  src dstϰפƤ롥
			 1  src dstȰפƤʤ
			-1  Хåե NULL
			-2  n  vldsz 礭

	: ʸǡΤŬѡǥ󥰤٥٥
 */
int  cmp_Buffer(Buffer src, Buffer dst, int n)
{
	int i;

	if (src.buf==NULL || dst.buf==NULL) return -1;
	if (n>src.vldsz   || n>dst.vldsz)   return -2;
	
	if (n<=0) {
		if (src.vldsz!=dst.vldsz) return 1;
		else n = src.vldsz;
	}
	
	for (i=0; i<n; i++) {
		if (src.buf[i]!=dst.buf[i]) return 1;
	}
	return 0;
}





/**
Buffer  encode_base64_Buffer(Buffer buf)

	ǽХʥǡ buf.buf buf.vldszХȤ Base64˥󥳡
		  롥buf.vldsz -1ʲξ buf.vldsz buf.bufκǽ 
		  0x00ΤޤǤĹ(strlen()+1)Ȥʤ롥Ĥޤ buf.buf ʸ
		  ʤ롥

		  ϥХåե 3byte(8bit*3)ξ, ϥХåե 4byte
		  (6bit*4)Ȥʤ롥ϥХåե 6bitǤʤ, 6bit
		  ޤ 0ղä줿ȸ롥 
		  ϥХåե 4byteǤʤ, 4byteޤ '='ղ
		  ƽϤ롥 ޤ,ϥХåեǤ 60byteβԤϹԤʤ
		  ̤ n byte Ϥ줿, Base64νϤʸ (n+2)/3*4 
		  byte Ȥʤ롥

	buf -- Base64˥󥳡ɤǡ

	͡Base64˥󥳡ɤ줿ʸ(Buffer)

	㡧'A',0x00,0x01 ʸ(sz=1)Ȥߤʤ沽 "QQ==" Ȥʤ롥
		'A',0x00,0x01  3byte沽(sz=3) "QQAB" Ȥʤ롥
*/
Buffer  encode_base64_Buffer(Buffer buf)
{
	unsigned char* bas;
	int	 sz;
	Buffer  ecd;
	 
	memset(&ecd, 0, sizeof(Buffer));

	if (buf.buf==NULL) return ecd;
	if (buf.vldsz<0) sz = (int)strlen((const char*)buf.buf);
	else		 	 sz = buf.vldsz;
	bas = encode_base64(buf.buf, sz);
	if (bas==NULL) return ecd;
	
	ecd = make_Buffer(sz);
	if (ecd.buf==NULL) {
		free(bas);
		return ecd;
	}

	copy_s2Buffer((char*)bas, &ecd);

	free(bas);
	return ecd;
}




/**
Buffer  decode_base64_Buffer(Buffer str)

	ǽstrΥХåե Base64ǥɤ롥
		  Ѵ str.bufƬ缡Ԥ롥A-Za-z0-9+/ ʳ̵
		  (㤨вԥ)

		  ϥХåե 4byte(6bit*4)ξ, ϥХåե 3byte
		  (8bit*3)Ȥʤ롥ϥХåեΥХȿ 4ܿǤʤ
		  (ʥǡ), ­ʤϥХåեˤ '='Ƥ
		  ΤȤߤʤ

	str -- Base64ǥɤʸ

	͡Base64ǥɤ줿ǡ(Buffer)

	㡧"QQ" ǥɤ 'A',0x00 Ȥʤ롥
*/
Buffer  decode_base64_Buffer(Buffer str)
{
	int	sz;
	Buffer dcd;
	unsigned char* bas;

	memset(&dcd, 0, sizeof(Buffer));
	if (str.buf==NULL) return dcd;

	bas = decode_base64(str.buf, &sz);
	if (bas==NULL) return dcd;

	dcd = make_Buffer(sz);
	if (dcd.buf==NULL) {
		free(bas);
		return dcd;
	}

	copy_b2Buffer(bas, &dcd, sz);
	dcd.vldsz = sz;

	free(bas);
	return dcd;
}





/**
Buffer  get_line_Buffer(Buffer str, int n)

	ǽʣԤʸХåեǤդιԤФ
		  strΥХåե nܤФԥɤϺ롥
		  n  1롥ФԤ BufferѿΥХåե˳Ǽʥԡ
		  ֤

	str -- оݤʸ(ޤ)
		  n   -- Ԥλꡥ

	͡ꤵ줿 nܤʸ(Buffer)Ԥϴޤޤʤ
*/
Buffer  get_line_Buffer(Buffer str, int n)
{
	int i, j, pos, cnt;
	unsigned char* buf;
	Buffer ret;

	ret = init_Buffer();
	buf = str.buf;
	for(i=0,j=0; j<n-1; j++) {
		while (buf[i]!=LF && buf[i]!=CR && buf[i]!='\0') i++;
		while (buf[i]==LF || buf[i]==CR) i++;
	}
	if (buf[i]=='\0') return  ret;

	pos = i;
	while (buf[i]!=LF && buf[i]!=CR && buf[i]!='\0') i++;
	cnt = i - pos;

	if (cnt!=0) {  
	ret = make_Buffer(cnt);
	if (ret.buf==NULL) return str;
		for(i=0; i<cnt; i++) ret.buf[i] = buf[pos+i];
	}
	ret.vldsz = (int)strlen((const char*)ret.buf);

	return  ret;
}





/**
Buffer  awk_Buffer(Buffer str, char cc, int n)

	ǽBufferʸФ awk
		  ccڤ국Ȥ, strΥХåե nܤιܤ֤
		  n  1롥

	str -- оʸ
		  cc  -- ڤʸ
		  n   -- ܤλꡥ

	͡ꤵ줿 nܤιܤʸ(Buffer)

*/
Buffer  awk_Buffer(Buffer str, char cc, int n)
{
	int i, j, pos, cnt;
	unsigned char*  buf;
	Buffer item;

	item = init_Buffer();
	if (n<=0) n = 1;

	buf = str.buf;
	for(i=0,j=0; j<n-1; j++) {
		while (buf[i]!='\0' && buf[i]!=cc) i++;
		if (buf[i]==cc) i++;
	}
	if (buf[i]=='\0') return item;

	pos = i;
	while (buf[i]!='\0' && buf[i]!=cc) i++;
	cnt = i - pos;

	item = make_Buffer(cnt);
	if (item.buf==NULL) return item;
	for (i=0; i<cnt; i++) item.buf[i] = buf[pos+i];
	item.vldsz = (int)strlen((const char*)item.buf);

	return item;
}





/**
Buffer  cawk_Buffer(Buffer str, char cc, int n)

	ǽBufferʸФ(ѷ)awk
		  ccڤ국Ȥ, strΥХåե nܤιܤ֤
		  n  1롥Ϣ³ cc(ڤ)ϰĤζڤȤߤʤ

	str -- оʸ
		  cc  -- ڤʸ
		  n   -- ܤλꡥ

	͡ꤵ줿 nܤιܤʸ(Buffer)
*/
Buffer  cawk_Buffer(Buffer str, char cc, int n)
{
	int i, j, pos, cnt;
	unsigned char*  buf;
	Buffer item;

	item = init_Buffer();
	if (n<=0) n = 1;

	buf = str.buf;
	i = 0;
	for(j=0; j<n-1; j++) {
		while (buf[i]!='\0' && buf[i]!=cc) i++;
		while (buf[i]!='\0' && buf[i]==cc) i++;
	}
	if (buf[i]=='\0')  return item;

	pos = i;
	while (buf[i]!='\0' && buf[i]!=cc) i++;
	cnt = i - pos;

	item = make_Buffer(cnt);
	if (item.buf==NULL) return  item;
	for (i=0; i<cnt; i++) item.buf[i] = buf[pos+i];
	item.vldsz = (int)strlen((const char*)item.buf);

	return item;
}




/**
void kanji_convert_Buffer(Buffer* str)

	ǽѿ KanjiCode(tools.h) ˽äƴɤѴ롥

	str -- ѴʸBufferǡƤ񤭴롥

	ߤ KanjiCode SJISξΤ EUC SJISѴ롥
 */
void kanji_convert_Buffer(Buffer* str)
{
	int i; 
	unsigned char *c1, *c2;

	if (KanjiCode==SJIS) {
		i = 0;
		while(str->buf[i]!='\0'){
			c1 = &(str->buf[i]);
			c2 = c1 + 1;
			if(*c1>=0xa1 && *c1<=0xfe){
				euc2sjis(c1, c2);	
				i = i + 2;
			} 
			else  i++;
		}
	}			  
	/*
	else if (KanjiCode==EUC) {
		i = 0;
		while(str->buf[i]!='\0'){
			c1 = (unsigned char) str->buf[i];
			c2 = (unsigned char) str->buf[i+1];
			if((c1>=0x81 && c1<=0x9f) || (c1>=0xe0 && c1<=0xff)) {
				sjis2euc(c1, c2);	
				i = i + 2;
			} 
			else  i++;
		}
	} 
	*/			 
}




/**
Buffer  randstr_Buffer(int n)

	ǽ A-Za-z0-9+/ ޤǤʸ nʸ롥

	n -- Ϥʸ

	͡줿 nʸʸ(Buffer)
*/
Buffer  randstr_Buffer(int n)
{
	char   base[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
	Buffer pass;
	int	i, sz;

	pass = make_Buffer(n);
	if (pass.buf==NULL) return pass;

	sz = (int)strlen(base);
	for (i=0; i<n; i++) pass.buf[i] = base[rand()%sz];
	pass.vldsz = n;

	return pass;
}





/**
Buffer  randbit_Buffer(int n) 

	ǽ n bitΥХʥ롥

	n -- Ϥ bit

	͡줿 n bitΥǡ(Buffer)
 */
Buffer  randbit_Buffer(int n) 
{
	int   i, sz;
	Buffer str;
	
	sz = (n+7)/8;
	str = make_Buffer(sz);
	if (str.buf==NULL) return str;
	str.vldsz = sz;

	for (i=0; i<n; i++) setBit(str.buf, i, rand()%2);
	return str;	 
}





/**
void  dump_Buffer(Buffer buf)

	ǽBufferѿΥǥХå 16ʽϡstderr
		  buf.buf buf.vldszХȤ16ɽ롥 
		  buf.vldsz<0 ξ ʸȤߤʤ

	buf -- ɽ Bufferǡ

	#define dump_Buffer(b)    fdump(stdout, (b).buf, (b).vldsz);
*/
/*
void  dump_Buffer(Buffer buf)
{
	int  i, sz;

	if (buf.buf==NULL) {
		debug_message("(DUMP_BUFFER: Buffer is NULL)\n");
		return;
	}
	if (buf.vldsz<0) sz = strlen((const char*)buf.buf)+1;
	else			 sz = buf.vldsz;

	for (i=0; i<sz; i++) {
		fprintf(stderr, "%02x  ", (unsigned char)buf.buf[i]);
		if ((i+1)%16==0) fprintf(stderr, "\n");
	}
	fprintf(stderr, "\n");
}
*/





/**
void  chomp_Buffer(Buffer* str)

	ǽǽβԥɰʹߤ̵뤹롥

	str -- Ԥ̵ˤʸ(Buffer)
 */
void  chomp_Buffer(Buffer* str)
{
	int i, len;
	
	if (str->buf==NULL) return;

	len = (int)strlen((const char*)str->buf);
	for (i=0; i<len; i++) {
		if (str->buf[i]==LF || str->buf[i]==CR) {
			str->buf[i] = '\0';
			str->vldsz = (int)strlen((const char*)str->buf);
			return;
		}
	}
}




////////////////////////////////////////////////////////////////////////////////////
//
// File I/O
// 

/**
int  fgets_Buffer(Buffer* str, FILE* fp)

	ǽĥfgetsʸɤ߹ߤ˻Ѥ롥ԥɤϺ롥
	 	  strΥХåեͽώʬ礭ݤƤʤФʤʤ 

	str -- ʸɤߤि BufferǡХåե
		  fp  -- ʸɤߤեؤΥݥ󥿡

	͡ɤ߹ʸĹʲԥɤޤˡ
*/
int  fgets_Buffer(Buffer* str, FILE* fp)
{
	int   n, m;

	memset(str->buf, 0, str->bufsz);
	fgets((char*)str->buf, str->bufsz, fp);
	m = (int)strlen((const char*)str->buf);

	n = 0;
	while(str->buf[n]!=LF && str->buf[n]!=CR && str->buf[n]!='\0') n++;
	str->buf[n] = '\0';
	str->vldsz  = n;

//	if (KanjiCode!=US) kanji_convert_Buffer(str);

	return m;
}






/**
int  read_lines_Buffer(Buffer* str, FILE* fp)

	ǽʣʸԤɤ߹ߡʸɤ߹ߤ˻Ѥ롥
	 	  strΥХåեͽώʬ礭ݤƤʤФʤʤ 

	str -- ʸɤߤि BufferǡХåե
		  fp  -- ʸɤߤեؤΥݥ󥿡

	͡ɤ߹ǡĹ
*/
int  read_lines_Buffer(Buffer* str, FILE* fp)
{
	Buffer buf;

	buf = make_Buffer(str->bufsz);
	if (buf.buf==NULL) return -1;

	fgets((char*)buf.buf, buf.bufsz, fp);
	buf.vldsz = (int)strlen((const char*)buf.buf);
	copy_Buffer(&buf, str);
	clear_Buffer(&buf);

	while (!feof(fp)) {
		fgets((char*)buf.buf, buf.bufsz, fp);
		buf.vldsz = (int)strlen((const char*)buf.buf);
		cat_Buffer(&buf, str);
		clear_Buffer(&buf);
	}

	free_Buffer(&buf);
	return str->vldsz;
}






/**
Buffer  read_Buffer_file(char* fn)

	ǽե fn Ƥ Bufferѿɤ߹֤

*/
Buffer  read_Buffer_file(char* fn)
{
	int     cc, sz;
	Buffer  buf;
	FILE*   fp;

	buf = init_Buffer();
	sz = file_size(fn);
	if (sz<0) return buf;

	fp = fopen(fn, "rb");
	if (fp==NULL) return buf;

	buf = make_Buffer(sz);
	if (buf.buf==NULL) {
		fclose(fp);
		return buf;
	}
	buf.vldsz = sz;

	cc = (int)fread(buf.buf, buf.vldsz, 1, fp);
	if (cc!=1) {
		free_Buffer(&buf);
		return buf;
	}
	
	fclose(fp);
	
	return buf;
}





/**
int   save_Buffer_file(Buffer buf, char* fn)

	ǽե fn  Bufferѿ buf񤭹ࡥ

	buf -- 񤭹 Bufferѿ
		  fn  -- ե̾

	͡TRUE񤭹
		FALSE 񤭹ߤ˼ԡեƤݾڤʤ
*/
int   save_Buffer_file(Buffer buf, char* fn)
{
	int   cc;
	FILE* fp;

	fp = fopen(fn, "wb");
	if (fp==NULL) return FALSE;

	cc = (int)fwrite(buf.buf, buf.vldsz, 1, fp);
	if (cc!=1) return FALSE;
	fclose(fp);
	
	return TRUE;
}






////////////////////////////////////////////////////////////////////////////////////
//
//  ʸִ
// 
/**
Buffer  replace_Buffer(Buffer buf, Buffer frm, Buffer tos)

	ǽbuf.buf  frm.buf  tos.buf ֤Τ֤
		  frm.buf  buf.buf ȥΰ褬ŤʤäƤϤʤ
		  ʸ󷿤 Buffer ˤΤб

	buf --  Bufferѿ
		  frm -- ѴʸǼBufferѿ
		  tos -- ѴʸǼBufferѿ

	͡ѴʸǼ Bufferѿfree

	#define replace_Buffer(b, f, t)    replace_sBuffer_bystr((b), (char*)((f).buf), (char*)((t).buf))
*/




/**
Buffer  replace_sBuffer_bystr(Buffer buf, char* frm, char* tos)

	ǽbuf.buf  frm  tos ֤Τ֤
		  frm  buf.buf ȥΰ褬ŤʤäƤϤʤ
		  ʸ󷿤 Buffer ˤΤб

	buf --  Bufferѿ
		  frm -- Ѵʸ
		  tos -- Ѵʸ

	͡ѴʸǼ Bufferѿfree

	#define replace_sBuffer(b, f, t)    replace_sBuffer_bystr((b), (f), (t))
*/





/**
Buffer  replace_sBuffer_bystr(Buffer buf, char* frm, char* tos)

	ǽbuf.buf  frm  tos ֤Τ֤
		  frm  buf.buf ȥΰ褬ŤʤäƤϤʤ
		  ʸ󷿤 Buffer ˤΤб

	buf --  Bufferѿ
		  frm -- Ѵʸ
		  tos -- Ѵʸ

	͡ѴʸǼ Bufferѿfree
*/
Buffer  replace_sBuffer_bystr(Buffer buf, char* frm, char* tos)
{
	int	i, j, flen, tlen;
	Buffer res;

	res = init_Buffer();
	if (buf.buf==NULL || frm==NULL || tos==NULL) return res;

	flen = (int)strlen(frm);
	tlen = (int)strlen(tos);
	buf.vldsz = (int)strlen((const char*)buf.buf);

	res = make_Buffer((int)((buf.vldsz+tlen-flen+1)*BUFFER_FACT));

	i = j = 0;
	while (i<buf.vldsz && j<res.bufsz) {
		if (!strncmp((const char*)(buf.buf+i), frm, flen)){
			res.vldsz = (int)strlen((const char*)res.buf);
			cat_s2Buffer(tos, &res);
			i += flen;
			j += tlen;
		}
		else {
			res.buf[j++] = buf.buf[i++];
		}
	}

	res.vldsz = (int)strlen((const char*)res.buf);
	return res;
}





/**
int  replace_sBuffer_file(char* fn, Buffer frm, Buffer tos)

	ǽƥȥե frm ʸ tos ˽񤭴

	fn  -- ե̾
		  frm -- Ѵʸ
		  tos -- Ѵʸ

	͡TRUE񤭹
		FALSE 񤭹ߤ˼ԡեƤݾڤʤ
*/
int  replace_sBuffer_file(char* fn, Buffer frm, Buffer tos)
{
	int  ret;
	Buffer buf, res;

	buf = read_Buffer_file(fn);
	if (buf.buf==NULL) return FALSE;

	res = replace_Buffer(buf, frm, tos);
	free_Buffer(&buf);
	if (res.buf==NULL) return FALSE;

	ret = save_Buffer_file(res, fn);
	free_Buffer(&buf);

	return ret;
}








////////////////////////////////////////////////////////////////////////////////////
//
//  إåʽ񼰡üեI/O
// 
/**
int   save_Buffer2_fp(Buffer key, Buffer buf, FILE* fp)

	ǽե fp  2ĤBufferѿ key buf񤭹ࡥ
	      ǡѥեȤ˻Ѥ롥

	key -- 񤭹७Bufferѿ
		  buf -- 񤭹ǡBufferѿ
		  fp  -- եǥץ

	͡TRUE񤭹
		FALSE 񤭹ߤ˼ԡեƤݾڤʤ
*/
int   save_Buffer2_fp(Buffer key, Buffer buf, FILE* fp)
{
	int   cc;
	
	cc = save_Buffer_fp(key, fp);
	if (!cc) return FALSE;

	cc = save_Buffer_fp(buf, fp);
	if (!cc) return FALSE;
	
	return TRUE;
}





/**
int   save_Buffer_fp(Buffer buf, FILE* fp)

	ǽե fp  Bufferѿ buf񤭹ࡥbufΩ
	buf礭 int ǽ񤭹ޤ롥

	buf -- 񤭹 Bufferѿ
		  fp  -- եǥץ

	͡TRUE񤭹
		FALSE 񤭹ߤ˼ԡեƤݾڤʤ
*/
int   save_Buffer_fp(Buffer buf, FILE* fp)
{
	int   cc, sz;

	sz = htonl(buf.vldsz);
	cc = (int)fwrite(&sz, sizeof(sz), 1, fp);
	if (cc!=1) return FALSE;

	cc = (int)fwrite(buf.buf, buf.vldsz, 1, fp);
	if (cc!=1) return FALSE;
	
	return TRUE;
}





/**
Buffer  read_Buffer_fp(FILE* fp)

	ǽե fp  Bufferѿ bufɤ߹ࡥ
		  եƬ˥ե륵򼨤4Byteͤɬ

	fp  -- եǥץ
	
	͡ɤ߹ buf Bufferѿ

*/
Buffer  read_Buffer_fp(FILE* fp)
{
	int     cc, sz;
	Buffer  buf;

	buf = init_Buffer();
	cc = (int)fread(&sz, sizeof(sz), 1, fp);
	if (cc!=1) return buf;
	sz = ntohl(sz);

	buf = make_Buffer(sz);
	if (buf.buf==NULL) return buf;
	buf.vldsz = sz;
	cc = (int)fread(buf.buf, buf.vldsz, 1, fp);
	if (cc!=1) {
		free_Buffer(&buf);
		return buf;
	}
	
	return buf;
}





/**
int  read_Buffer2_fp(Buffer* key, Buffer* buf, FILE* fp)

	ǽե fp  2ĤBufferѿ key bufɤ߹ࡥ
	      ǡѥե뤫ɤ߹߻˻Ѥ롥

	key -- ɤ߹७BufferѿؤΥݥ󥿡
		  buf -- ɤ߹ǡBufferѿؤΥݥ󥿡
		  fp  -- եǥץ
	
	͡TRUEɤ߹
		FALSE ɤ߹ߤ˼ԡ

*/
int  read_Buffer2_fp(Buffer* key, Buffer* buf, FILE* fp)
{
	if (key==NULL || buf==NULL) return FALSE;

	*key = init_Buffer();
	*buf = init_Buffer();
	
	*key = read_Buffer_fp(fp);
	if (key->buf==NULL) return FALSE;

	*buf = read_Buffer_fp(fp);
	if (buf->buf==NULL) {
		free_Buffer(key);
		return FALSE;
	}

	return TRUE;
}









/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// etc. etc.
//

/**
char*  dup_string(char* src)

	ǽʸ򥳥ԡ롥

*/
char*  dup_string(char* src)
{
	if (src==NULL) return NULL;
		
	Buffer buf = make_Buffer_bystr(src);
	return (char*)buf.buf;
}



