/* vi: set tabstop=4 nocindent noautoindent: */

/**
	Bufferݡȥإå  buffer.h

  	¸ط
	  	#include "common.h"
	  	#include "tools.h"

 */



#ifndef _BUFFER_H
#define _BUFFER_H

#include "tools.h"



/**
Buffer ѿΰݤΤΰΨ
  BUFFER_FACT
*/
#define  BUFFER_FACT   (1.5)




/**
Buffer

  Bufferʸ˲ɻߤ롥buffer.c Bufferб
  ؿȤ¤, ץ(饤֥Ѽ)˲θɬפ̵
  ̾, vldszϥץ(饤֥Ѽ)ݾڤʤФʤʤ
  äBufferѿ֤ؿǤϾ vldszꤵƤ뤫դ٤Ǥ롥
  ,ǡʸξ -1ʲˤƤƤ褤
   bufszϥХåեĹ򸽤ѿǤꡤץޤ񤭴ƤϤʤ

  BufferѿϥХåեΰưŪ˳ݤΤ,Ѥäɬ
  del_Buffer(ޤ free_Buffer)ǥХåեΰʤФʤʤ

  buf[bufsz]ϥƥबѤΤ,ץޤ buf[bufsz]̵
	  ΤȤưȡ
  
  ѿ
	int   bufsz		 ݤƤХåե礭 - 1
	int   vldsz		 Хʥǡ򰷤,ǡͭĹ򤷤᤹
	int   state		 ѿξ֤ɽ
	unsigned char* buf  ХåեƬؤΥݥ󥿡str[bufsz]ɬ 0x00Ȥʤ롥
*/
typedef struct {
	int   bufsz;
	int   vldsz;
	int   state;
	unsigned char* buf;
} Buffer;




/**/
Buffer* new_Buffer(void);
Buffer  init_Buffer(void);
Buffer  make_Buffer(int sz);
Buffer  make_Buffer_bychar(unsigned char cc);
Buffer  set_Buffer(void* buf, int sz);
Buffer  dup_Buffer(Buffer str);

void	del_Buffer(Buffer** buf);
void	free_Buffer(Buffer* buf);
void	clear_Buffer(Buffer* buf);

#define make_Buffer_bybin(s, l)	set_Buffer((void*)(s), (l))
#define make_Buffer_bin(s, l)	set_Buffer((void*)(s), (l))
#define make_Buffer_bystr(s)	set_Buffer((void*)(s), -1)
#define make_Buffer_str(s)		set_Buffer((void*)(s), -1)
#define make_Buffer_char(s)  	make_Buffer_bychar(s)

int		copy_Buffer(Buffer* src, Buffer* dst);
int		cat_Buffer (Buffer* src, Buffer* dst);

int		copy_b2Buffer(void* src, Buffer* dst, int sz);
int		cat_b2Buffer (void* src, Buffer* dst, int sz);
int		copy_i2Buffer(int src, Buffer* dst);
int		cat_i2Buffer (int src, Buffer* dst);

#ifdef EBUG
	int  	copy_s2Buffer(char* src, Buffer* dst);
	int		cat_s2Buffer (char* src, Buffer* dst);
#else
	#define copy_s2Buffer(s, d) 	copy_b2Buffer((void*)(s), d, (int)strlen((const char*)(s)))
	#define cat_s2Buffer(s, d) 	 	cat_b2Buffer((void*)(s),  d, (int)strlen((const char*)(s)))
#endif



// ġ
void	kanji_convert_Buffer(Buffer* mesg);
Buffer  encode_base64_Buffer(Buffer buf);
Buffer  decode_base64_Buffer(Buffer buf);

Buffer  get_line_Buffer(Buffer buf, int n);  
Buffer  awk_Buffer (Buffer buf, char cc, int n);
Buffer  cawk_Buffer(Buffer buf, char cc, int n);

int	 	cmp_Buffer(Buffer src, Buffer dst, int n);
void	chomp_Buffer(Buffer*);

#define dump_Buffer(b)	fdump(stdout, (unsigned char*)((b).buf), ((b).vldsz));

#define strcmp_Buffer(a, b)		cmp_Buffer((a), (b), 0)
#define strncmp_Buffer(a, b, n)	cmp_Buffer((a), (b), (n))
#define bincmp_Buffer(a, b)		cmp_Buffer((a), (b), 0)
#define binncmp_Buffer(a, b, n)	cmp_Buffer((a), (b), (n))

Buffer  randstr_Buffer(int n);			   // ѿ n 
Buffer  randbit_Buffer(int n);			   // ӥåȤ n 


// եI/O
int	 	fgets_Buffer(Buffer* str, FILE* fp);	// ĥfgets
int		read_lines_Buffer(Buffer* str, FILE* fp);

Buffer  read_Buffer_file(char* fn);
int	 	save_Buffer_file(Buffer buf, char* fn);


// ʸִ
Buffer  replace_sBuffer_bystr(Buffer buf, char* frm, char* tos);
int	 	replace_sBuffer_file(char* fn, Buffer frm, Buffer tos);
#define replace_sBuffer(b, f, t)	replace_sBuffer_bystr((b), (f), (t))
#define replace_Buffer(b, f, t)		replace_sBuffer_bystr((b), (char*)((f).buf), (char*)((t).buf))



// إå()դüեI/O
int	 	save_Buffer_fp(Buffer, FILE*);
Buffer  read_Buffer_fp(FILE*);
int   	save_Buffer2_fp(Buffer  key, Buffer  buf, FILE* fp);
int  	read_Buffer2_fp(Buffer* key, Buffer* buf, FILE* fp);



// ¾
char*  dup_string(char* src);
#define dup_str(s)		dup_string((s))



/**/





#endif




