/* vi: set tabstop=4 nocindent noautoindent: */

/**
Źѥ饤֥  cipher.c

  إå 
	  #include "cipher.h"

 */





#include "cipher.h"




/**
Buffer  xlcrypt(Buffer str, Buffer salt)

	ǽ: cryptؿ(DES)ˤ passwd¿šʣ˥ϥåͲ
		  saltĹ˱,ѥɤ¿Ť˥ϥåͲ롥
		  salt2Byte˰ϥåͲԤ

	: passwd	ϥåͲѥɡ
		  salt 		salt(ʸ

	: ϥåͤ줿ѥɥȥ󥰡salt֤ʤ̾ 11Byte.

 */
Buffer  xlcrypt(Buffer str, Buffer salt)
{
	int   i, len, lsalt;
	char* passwd;
	char  pass[LPASS+1];
	Buffer ret;

	memset(pass, 0, LPASS+1);
	len = Min((int)strlen((const char*)str.buf), LPASS);
	memcpy(pass, str.buf, len);

	lsalt = ((int)strlen((const char*)salt.buf)/2)*2;
	if (lsalt>=2) {
		passwd = (char*)crypt((const char*)pass, (const char*)salt.buf);
		for (i=2; i<lsalt; i=i+2) {
			passwd = (char*)crypt((const char*)(passwd+2), (const char*)(salt.buf+i));
		}
		ret = set_Buffer(passwd+2, -1);
	}
	else {
		ret = init_Buffer();
	}

	return ret;
}





/**
void  setkey_byBase64(Buffer key)

	ǽ: Base64ˤäƥ󥳡ɤ줿ʸǥɤ,
		  encryptؿ(DES)ΰŹ沽Ȥꤹ롥Ĺ̾
		  8Byte(64bit),ͭʤΤϺǽ7Byte(56bit)Ǥ롥

	: key	 Ź沽Υ

	: ʤ
*/
void  setkey_byBase64(Buffer key)
{
	Buffer tmpkey, deskey; 

	tmpkey = decode_base64_Buffer(key);
	deskey = to_bin64(tmpkey); 

	setkey((const char*)deskey.buf);
	free_Buffer(&tmpkey);
	free_Buffer(&deskey);
	return;
}
	



/**
void  setkey_byBuffer(Buffer key)

	ǽ: ʸ(8Byte)Ѥ,encryptؿ(DES)ΰŹ沽
		  ꤹ롥,ȤͭʤΤϺǽ7ByteǤ롥

	: key  -- Ź沽Υ

	: ʤ
*/
void  setkey_byBuffer(Buffer key)
{
	Buffer deskey; 

	deskey = to_bin64(key); 
	setkey((const char*)deskey.buf);
	free_Buffer(&deskey);

	return;
}





/**
Buffer  encrypt_Buffer(Buffer buf, int mode)

	ǽ: ХʥǡΰŹ沽ޤ沽Ԥ(DES)
		  δؿƤ, setkey_XXXX()ؿǰŹ沽ꤷʤ
		  ʤʤ

	: buf   --  Ź沽ޤ沽Ԥǡ
		  mode  --  0  Ź沽
				--  1  沽

	: Ź沽ξ -- Ź沽줿ǡ
			沽ξ -- 沽줿ǡ
*/
Buffer  encrypt_Buffer(Buffer buf, int mode)
{
	Buffer  str, cry;

	str = to_bin64(buf);
	encrypt((char*)str.buf, mode);
	cry = from_bin64(str);
	free_Buffer(&str);
	return  cry;
}




/**
Buffer  encrypt_Base64(Buffer str, int mode)

	ǽ: ʸΰŹ沽ޤ沽Ԥ(DES)Ź沽ޤ沽
		  ʸBase64ǥ󥳡ɤƤ롥Ǥϰö Base64
		  ǥɤƽʤ졤Ƥӥ󥳡ɤ롥
		  δؿƤ, setkey_XXXX()ؿǰŹ沽ꤷʤ
		  ʤʤ

	: str   --  Ź沽ޤ沽Ԥ Base64ʸ
		  mode  --  0  Ź沽
				--  1  沽

	: Ź沽ޤ沽줿ʸBase64ǥ󥳡ɤ롥
*/
Buffer  encrypt_Base64(Buffer buf, int mode)
{
	Buffer dec, str, enc;

	dec = decode_base64_Buffer(buf);
	str = encrypt_Buffer(dec, mode);
	free_Buffer(&dec);

	enc = encode_base64_Buffer(str);
	free_Buffer(&str);
	return enc;
}






/**
Buffer  to_bin64(Buffer str)

	ǽBit 0,1ΥХ(64Byte)Ѵ (bin64˷ؤ)
		  㤨С 2 0,0,0,0,0,.....,0,1,0 ΥХ(64Byte)ˤʤ롥

	str   ХѴӥå

	͡Ѵ줿Х1ХȤ 0,1bin64
*/
Buffer  to_bin64(Buffer str)
{
	int	i, mi;
	Buffer ret;

	ret = make_Buffer(64);
	if (ret.buf==NULL) return ret;

	mi = Min(64, str.vldsz*8);
	for (i=0; i<mi; i++) ret.buf[i] = (uByte)getBit(str.buf, i);
	ret.vldsz = mi;
	return ret;
}





/**
Buffer  from_bin64(Buffer str)

	ǽ0,1ΥХ(64Byte, bin64) 8byteΥӥåѴ롥

	str   ӥåѴХ64Byte. bin64

	͡Ѵ줿ӥå8Byte.  64bit.
*/
Buffer  from_bin64(Buffer str)
{
	int	i;
	Buffer ret;
	
	ret = init_Buffer();
	if (str.vldsz!=64) return ret;

	ret = make_Buffer(8);
	if (ret.buf==NULL) return ret;

	for (i=0; i<64; i++) setBit(ret.buf, i, (int)str.buf[i]);
	ret.vldsz = 8;
	return  ret;
}





/**
void  dump_bin64(char* format, Buffer str)

	ǽbin64ɸ२顼Ϥɽ롥

	format  bin64Ƥɽɽ륿ȥ롥
		  str	 ɽ bin64ΥХ

	͡ʤ
*/
void  dump_bin64(char* format, Buffer str)
{
	int  i;

	fprintf(stderr, format);
	for (i=0; i<str.vldsz; i++) fprintf(stderr, "%1d", str.buf[i]);
	fprintf(stderr, "\n");
}



