/* vi: set tabstop=4 nocindent noautoindent: */

/**
  ޥȥå٥ȥ饤֥ إå  matrix.h

  ¸ط
      common.h

*/


#ifndef  _MATRIX_H
#define  _MATRIX_H


#include "common.h"
#include <math.h>



/**
  ٥ȥ뷿  ivector
       int x     xʬ      
       int y     yʬ
       int z     zʬ
       float r   ٥ȥ礭

   ˹®פꤿ˻Ѥ롣
 */
typedef struct {
    int x;
    int y;
    int z;
    float r;
} ivector;




/**
  ¿٥ȥ뷿  vector
        float x    xʬ      
        float y    yʬ
	float z    zʬ
	float r    ٥ȥ礭
 */
typedef struct {
    float x;
    float y;
    float z;
    float r;
} vector;





/**
  ¿ޥȥå  imatrix
        int n       
        int r       ǿ sz[0]+sz[1]+...+sz[n-1] 
        int *sz     Ƽǿ sz[0]sz[n-1]
        int *mx      mx[0]mx[r-1] 

  ˹®פꤿ˻Ѥ롣

  : imatrixΰ (, , ....)Ȥʤ,ºݤˤϸ
      ˥Ǽ(եåȤϵ gdata.c)Τ
      ľܥ˥դɬפǤ롣

 */
typedef struct {
    int n;
    int r;
    int *sz;
    int *mx;
} imatrix;





/**
  ¿¿ޥȥå  matrix
        int n       
        int r       ǿ sz[0]+sz[1]+...+sz[n-1] 
        int *sz     Ƽǿ sz[0]sz[n-1]
        float *mx    mx[0]mx[r-1] 

  : matrixΰ (, , ....)Ȥʤ,ºݤˤϸ
      ˥Ǽ(եåȤϵ gdata.c)Τ
      ľܥ˥դɬפǤ롣

 */
typedef struct {
    int n;
    int r;
    int *sz;
    float *mx;
} matrix;





/** 
٥ȥ ܱ黻ؿޥ
        in_vector(a, b)   ٥ȥ a, bѤȤ롣
        add_vector(a, b)  ٥ȥ a, b­, ̤¿٥ȥ֤
        sub_vector(a, b)  ٥ȥ a, b, ̤¿٥ȥ֤
        add_ivector(a, b) ٥ȥ a, b­, ̤٥ȥ֤
        sub_ivector(a, b) ٥ȥ a, b, ̤٥ȥ֤
        normal_vector(a)  ٥ȥ a礭׻롣
 */
#define  in_vector(a, b)   ((a).x*(b).x+(a).y*(b).y+(a).z*(b).z)
#define  add_vector(a, b)  set_vector((a).x+(b).x,(a).y+(b).y,(a).z+(b).z);
#define  add_ivector(a, b) set_ivector((a).x+(b).x,(a).y+(b).y,(a).z+(b).z);
#define  sub_vector(a, b)  set_vector((a).x-(b).x,(a).y-(b).y,(a).z-(b).z);
#define  sub_ivector(a, b) set_ivector((a).x-(b).x,(a).y-(b).y,(a).z-(b).z);
#define  normal_vector(a)  {(a).r = sqrt((float)(a).x*(a).x+(a).y*(a).y+(a).z*(a).z);}


/** 
ޥȥå ʰץؿޥ
    ǥǥåϣ롣
        Vt(m, i)            ޥȥå iܤǤ֤
        Mx(m, i, j)	    	ޥȥå (i, j)Ǥ֤
        Mx1(m, i)           ޥȥå iܤǤ֤
        Mx2(m, i, j)        ޥȥå (i, j)Ǥ֤
        Mx3(m, i, j, k)     ޥȥå (i, j, k)Ǥ֤
        Mx4(m, i, j, k, l)  ޥȥå (i, j, k, l)Ǥ֤
 */
#define Vt(m, i)  	((m).mx[(i)-1])
#define Mx(m, i, j)	((m).mx[(j)-1+(m).sz[1]*((i)-1)])

#define Mx1(m, i)  	   	   ((m).mx[(i)-1])
#define Mx2(m, i, j)	   ((m).mx[(j)-1+(m).sz[1]*((i)-1)])
#define Mx3(m, i, j, k)    ((m).mx[(k)-1+(m).sz[2]*((j)-1)+(m).sz[1]*(m).sz[2]*((i)-1)])
#define Mx4(m, i, j, k, l) ((m).mx[(l)-1+(m).sz[3]*((k)-1)+(m).sz[2]*(m).sz[3]*((j)-1) +\
				(m).sz[1]*(m).sz[2]*(m).sz[3]*((i)-1)])



/**/
vector   unit_vector(vector a);
vector   unit_ivector(ivector a);
vector   set_vector(float x, float y, float z);
ivector  set_ivector(int x, int y, int z);
vector   ex_vector(vector a, vector b);

ivector  f2ivector(vector a);
vector   i2vector(ivector a);

matrix   make_matrix1(int n);
matrix   make_matrix2(int n, int m);
matrix   make_matrix (int n, int* sz);

imatrix  make_imatrix1(int n);
imatrix  make_imatrix2(int n, int m);
imatrix  make_imatrix (int n, int* sz);



matrix   add_matrix(matrix a, matrix b);
matrix   sub_matrix(matrix a, matrix b);
matrix   mlt_matrix(matrix a, matrix b);
void     copy_matrix(matrix a, matrix b);
void     free_matrix(matrix* a);
void     clear_matrix(matrix* a);
void     print_matrix(matrix a);

imatrix  add_imatrix(imatrix a, imatrix b);
imatrix  sub_imatrix(imatrix a, imatrix b);
imatrix  mlt_imatrix(imatrix a, imatrix b);
void     copy_imatrix(imatrix a, imatrix b);
void     free_imatrix(imatrix* a);
void     clear_imatrix(imatrix* a);
void     print_imatrix(imatrix a);

matrix   decompQR(matrix xx, imatrix col);
matrix   trans_matrix(matrix a);
matrix   minimum2(matrix a, matrix x);
matrix   invrU_matrix(matrix x);

/**/


#endif
