/* vi: set tabstop=4 nocindent noautoindent: */


/**
ͥåȥѥ饤֥   network.c

إå
	#include "network.h"


*/



#include "network.h"





/**
int  udp_server_socket(int port)   

	ǽ: UDPΥХåȤ,³Ԥ֤ˤʤ롥
  
		  δؿǸƤӽФͥåȥؿ
			  socket(), bind()

	: port -- ݡֹ

	: 0ʾ  줿åȵһҡ
			   -1  åȤǤʤä
			   -3  Хɤ˼ԡ
 */
int  udp_server_socket(int port) 
{
	int  sofd, err;
	struct sockaddr_in sv_addr;
 
	sofd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sofd<0) return -1;
 
	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	// TIME_WAIT ʤꡥ
/*	struct linger lg;
	lg.l_onoff  = 1;
	lg.l_linger = 0;
	err = setsockopt(sofd, SOL_SOCKET, SO_LINGER, &lg, sizeof(lg));
	if (err<0) {
		socket_close(sofd);
		return -2;
	} 
*/
	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	return sofd;
}





/**
int  udp_server_socket_setopt(int port, int opt, const void* optval, int optlen) 

	ǽ: UDPΥХåȤ,³Ԥ֤ˤʤ롥
		  setsockopt()դ
  
		  δؿǸƤӽФͥåȥؿ
			  socket(), setsockopt(), bind()

	: port -- ݡֹ

	: 0ʾ  줿åȵһҡ
			   -1  åȤǤʤä
			   -2  åȥץ˼ԡ
			   -3  Хɤ˼ԡ
 */
int  udp_server_socket_setopt(int port, int opt, const void* optval, int optlen) 
{
	int  sofd, err;
	struct sockaddr_in sv_addr;
 
	sofd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sofd<0) return -1;
 
	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	if (opt>0) {
		#ifdef WIN32
			err = setsockopt(sofd, SOL_SOCKET, opt, (const char*)optval, optlen);
		#else
			err = setsockopt(sofd, SOL_SOCKET, opt, optval, optlen);
		#endif
		if (err<0) {
			socket_close(sofd);
			return -2;
		} 
	}

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	return sofd;
}





/**
int  udp_client_socket(char* hostname, int port, struct sockaddr_in* sv_addr)

	ǽ: UDPΥ饤ȥåȤ롥
		  ｪλ, *sv_addr˥Фξ󤬳Ǽ롥

		  δؿǸƤӽФͥåȥؿ
			  socket(), gethostbyname()

	:  hostname   ̾
		   port	   Хݡֹ
		   sv_addr	sockaddr_in¤ΤؤΥݥ

	: 줿åȵһҡ
			顼ξ0̤ͤ롥
				-1  åȤǤʤä
				-2  оμ˼ԡ
*/
int  udp_client_socket(char* hostname, int port, struct sockaddr_in* sv_addr)
{
	int  sofd;
	struct hostent	 *shost;
 
	sofd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sofd<0) return -1;
 
	shost = gethostbyname(hostname); 
	if (shost==NULL) {
		socket_close(sofd);
		return -2;
	}

	memset(sv_addr, 0, sizeof(*sv_addr));
	sv_addr->sin_family = AF_INET;
	sv_addr->sin_port   = htons(port);
	memcpy(&(sv_addr->sin_addr), shost->h_addr, shost->h_length);
   
	return sofd;
}





/**
int  udp_bind(int sofd, int port)  

	ǽ: UDPåȤ˥ݡȤХɤ롥

 */
int  udp_bind(int sofd, int port) 
{
	int  err;
	struct sockaddr_in sv_addr;
 
	if (sofd<=0) return sofd;

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -1;
	}

	return sofd;
}





/**
int  udp_bind_setopt(int sofd, int port, int opt, const void* optval, int optlen) 

	ǽ: UDPåȤ˥ݡȤХɤ롥
		  setsockopt()դ

 */
int  udp_bind_setopt(int sofd, int port, int opt, const void* optval, int optlen) 
{
	int  err;
	struct sockaddr_in sv_addr;
 
	if (sofd<=0) return sofd;

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	if (opt>0) {
		#ifdef WIN32
			err = setsockopt(sofd, SOL_SOCKET, opt, (const char*)optval, optlen);
		#else
			err = setsockopt(sofd, SOL_SOCKET, opt, optval, optlen);
		#endif
		if (err<0) {
			socket_close(sofd);
			return -2;
		} 
	}

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -1;
	}

	return sofd;
}





/**
int  tcp_server_socket(int port)

  ǽ: TCPΥХåȤꡢåˤ³׵
		  ˤ롥δؿ³ accept()ؿƤֻˤ,ºݤ³Ԥ
		  ֤Ȥʤ롥
  
		  δؿǸƤӽФͥåȥؿ
			  socket(), bind(), listen()

	: port  ݡֹ桥

	: к줿åȵһҡ
			Ԥ0̤֤ͤ롥
				-1  åȤκ˼ԡ
				-3  Хɤ˼ԡ
				-4  å˼ԡ
*/
int  tcp_server_socket(int port) 
{
	int  sofd, err;
	struct sockaddr_in sv_addr;
 
	sofd = socket(AF_INET, SOCK_STREAM, 0);
	if (sofd<0) return -1;
 
	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	err = listen(sofd, 10);
	if (err==-1) {
		socket_close(sofd);
		return -4;
	}

	return sofd;
}





/**
int  tcp_server_socket_setopt(int port, int opt, const void* optval, int optlen) 

  ǽ: TCPΥХåȤꡢåˤ³׵֤ˤ롥
		  δؿ³ accept()ؿƤֻˤ,ºݤ³Ԥ֤Ȥʤ롥
		  setsockopt()դ
  
		  δؿǸƤӽФͥåȥؿ
			  socket(), setsockopt(), bind(), listen()

	: port  ݡֹ桥

	: к줿åȵһҡ
			Ԥ0̤֤ͤ롥
				-1  åȤκ˼ԡ
				-2  åȥץ˼ԡ
				-3  Хɤ˼ԡ
				-4  å˼ԡ
*/
int  tcp_server_socket_setopt(int port, int opt, const void* optval, int optlen) 
{
	int  sofd, err;
	struct sockaddr_in sv_addr;
 
	sofd = socket(AF_INET, SOCK_STREAM, 0);
	if (sofd<0) return -1;
 
	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	if (opt>0) {
		#ifdef WIN32
			err = setsockopt(sofd, SOL_SOCKET, opt, (const char*)optval, optlen);
		#else
			err = setsockopt(sofd, SOL_SOCKET, opt, optval, optlen);
		#endif
		if (err<0) {
			socket_close(sofd);
			return -2;
		}
	}

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	err = listen(sofd, 10);
	if (err==-1) {
		socket_close(sofd);
		return -4;
	}

	return sofd;
}





/**
int  tcp_server_bind(int port)

  ǽ: TCPΥФΥåȵһҤꡢХɤ롥
		  tcp_server_socket() Ȥΰ㤤 listen()ؿƤӽФʤˤ롥

		  δؿǸƤӽФͥåȥؿ 
			  socket(), bind()

	: port  ݡֹ桥

	: к줿åȵһҡ
			Ԥ0̤֤ͤ롥
				-1  åȤκ˼ԡ
				-3  Хɤ˼ԡ
 */
int  tcp_server_bind(int port) 
{
	int  sofd, err;
	struct sockaddr_in sv_addr;
 
	sofd = socket(AF_INET, SOCK_STREAM, 0);
	if (sofd<0) return -1;
 
	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	return sofd;
}





/**
int  tcp_server_bind_setopt(int port, int opt, const void* optval, int optlen) 

  ǽ: TCPΥФΥåȵһҤꡢХɤ롥
		  tcp_server_socket() Ȥΰ㤤 listen()ؿƤӽФʤˤ롥
		  setsockopt()դ

		  δؿǸƤӽФͥåȥؿ 
			  socket(), setsockopt(), bind()

	: port  ݡֹ桥

	: к줿åȵһҡ
			Ԥ0̤֤ͤ롥
				-1  åȤκ˼ԡ
				-2  åȥץ˼ԡ
				-3  Хɤ˼ԡ
 */
int  tcp_server_bind_setopt(int port, int opt, const void* optval, int optlen) 
{
	int  sofd, err;
	struct sockaddr_in sv_addr;
 
	sofd = socket(AF_INET, SOCK_STREAM, 0);
	if (sofd<0) return -1;
 
	if (opt>0) {
		#ifdef WIN32
			err = setsockopt(sofd, SOL_SOCKET, opt, (const char*)optval, optlen);
		#else
			err = setsockopt(sofd, SOL_SOCKET, opt, optval, optlen);
		#endif
		if (err<0) {
			socket_close(sofd);
			return -2;
		}
	}

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	return sofd;
}





/**
int  tcp_client_socket(char* hostname, int port)

	ǽ: TCPΥ饤ȥåȤꡢФ³롥

		  δؿǸƤӽФͥåȥؿ 
			  socket(), gethostbyname(), connect()

	: hostname   ̾
		  port	     Хݡֹ

	: к줿åȵһҡ
			Ԥˤ0̤ͤ롥
				-1  åȤκ˼ԡ
				-2  оμ˼ԡ
				-3  Фؤ³˼ԡ
  */
int  tcp_client_socket(char* hostname, int port) 
{
	int sofd, err;
	struct hostent	 *shost;
	struct sockaddr_in sv_addr;

	sofd = socket(AF_INET, SOCK_STREAM, 0);
	if (sofd<0) return -1;
 
	shost = gethostbyname(hostname); 
	if (shost==NULL) {
		socket_close(sofd);
		return -2;
	}

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	memcpy(&sv_addr.sin_addr, shost->h_addr, shost->h_length);

	err = connect(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	return sofd;
}






/**
int  tcp_client_bind_socket(char* hostname, int sport, int cport)  

	ǽ: TCPΥ饤ȥåȤꡢФ³롥

		  δؿǸƤӽФͥåȥؿ 
			  socket(), bind(), gethostbyname(), connect()

	: hostname   ̾
		  sport	     Хݡֹ
		  cport      ʬΥݡֹ

	: к줿åȵһҡ
			Ԥˤ0̤ͤ롥
				-1  åȤκ˼ԡ
				-2  BINDԡ
				-3  оμ˼ԡ
				-4  Фؤ³˼ԡ
  */
int  tcp_client_bind_socket(char* hostname, int sport, int cport)  
{
	int sofd, err;
	struct hostent  *shost;
	struct sockaddr_in sv_addr;

	sofd = socket(AF_INET, SOCK_STREAM, 0);
	if (sofd<0) return -1;
 
	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(cport);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -2;
	}

	shost = gethostbyname(hostname); 
	if (shost==NULL) {
		socket_close(sofd);
		return -3;
	}

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(sport);
	memcpy(&sv_addr.sin_addr, shost->h_addr, shost->h_length);

	err = connect(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -4;
	}

	return sofd;
}





/**
int  tcp_bind(int sofd, int port)  

	ǽ: TCPåȤ˥ݡȤХɤ롥

 */
int  tcp_bind(int sofd, int port)  
{
	int  err;
	struct sockaddr_in sv_addr;
 
	if (sofd<=0) return sofd;

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -1;
	}

	return sofd;
}





/**
int  tcp_bind_setopt(int sofd, int port, int opt, const void* optval, int optlen)  

	ǽ: TCPåȤ˥ݡȤХɤ롥
		  setsockopt() դ

 */
int  tcp_bind_setopt(int sofd, int port, int opt, const void* optval, int optlen)  
{
	int  err;
	struct sockaddr_in sv_addr;
 
	if (sofd<=0) return sofd;

	if (opt>0) {
		#ifdef WIN32
			err = setsockopt(sofd, SOL_SOCKET, opt, (const char*)optval, optlen);
		#else
			err = setsockopt(sofd, SOL_SOCKET, opt, optval, optlen);
		#endif
		if (err<0) {
			socket_close(sofd);
			return -2;
		} 
	}

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -1;
	}

	return sofd;
}





/**
int  accept_intr(int sock, struct sockaddr* cl_addr, socklen_t* cdlen)

	ǽ: accept()ǥ֥å˳ߤݤäơaccept()ԤǽλƤ
          ƻܹԤǤ褦ˤ뤿Υåѡؿ (for Solaris)

	: sock     å
		  cl_addr  åȤξ sockaddr¤ΤؤΥݥ
cdlen    *cl_addr Υ

	: к줿åȵһҡ
			Ԥˤ0̤ͤ롥
			-1  顼
  */
int accept_intr(int sock, struct sockaddr* cl_addr, socklen_t* cdlen)
{
	int nsofd = 0;

	do {
		nsofd = accept(sock, cl_addr, cdlen);
	} while (nsofd==-1 && errno==EINTR);

	//if (nsofd<0) Error("accept_intr");

	return nsofd;
}





/*
int  tcp_connect(int sofd, char* hostname, int port)

	ǽ: TCPΥ饤ȥåȤ̤ơФ³롥

		  δؿǸƤӽФؿ
			  gethostbyname(), connect()

	: sofd	   åȼ̻
		  hostname   ̾
		  port	   Хݡֹ

	:  0
			Ԥˤ0̤ͤ롥
				-1  оμ˼ԡ
				-2  Фؤ³˼ԡ
  */
int  tcp_connect(int sofd, char* hostname, int port) 
{
	int  err;
	struct hostent  *shost;
	struct sockaddr_in sv_addr;

	shost = gethostbyname(hostname); 
	if (shost==NULL) return -1;

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	memcpy(&sv_addr.sin_addr, shost->h_addr, shost->h_length);

	err = connect(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) return -2;
	return 0;
}





/**
int  socket_close(int sofd)

	ǽ: ̤Υǡ˴ơåȤĤ롥

	: sofd   åȵһҤꡥ

	: ˽λкǸ˼Хȿ򡢤Ǥʤˤ-1֤
*/
int  socket_close(int sofd)
{
	int  err = -1;

	if (sofd>0) {
		#ifdef WIN32
			closesocket(sofd);
		#else
			err = shutdown(sofd, 2);
			close(sofd);
		#endif
	}
	return err;
}







/////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

/**
int  udp_recv(int sock, char* rmsg, int size, struct sockaddr_in* sv_addr)

	ǽ: recvform() åԥ󥰤ؿUDPǡ롥

	: sock	 åȵһ
		  rmsg	 ѥǡХåե
		  size	 ǡХåեΥ
		  sv_addr  Фξ󤬳Ǽ줿 sockaddar_in ¤ΤؤΥݥ󥿡
 
	: ˹ԤФΥХȿ
			Ԥ-1֤
*/
int  udp_recv(int sock, char* rmsg, int size, struct sockaddr_in* sv_addr)
{
	int cc;
 	socklen_t cadlen;

	cadlen = sizeof(*sv_addr);
	memset(rmsg, 0, size);
	cc = recvfrom(sock, rmsg, size, 0, (struct sockaddr*)sv_addr, &cadlen);

	return cc;
}





/**
int  udp_send(int sock, char* smsg, int size, struct sockaddr_in* sv_addr)

	ǽ: sendto() åԥ󥰤ؿUDPͳǥǡ롥
		  ǡ(smsg)Υ size0ʲꤷϡsmsgʸ
		  ȸʤƥưŪ˷׻롥

	: sock	 åȵһ
		  smsg	 ǡ
		  size	 ǡsmsgˤΥ 0ʲξ
				   smsgʸǤȤߤʤ
		  sv_addr  ФξǼ sockaddar_in ¤ΤؤΥݥ󥿡

	: ˹ԤФΥХȿ
			Ԥ-1֤
*/
int  udp_send(int sock, char* smsg, int size, struct sockaddr_in* sv_addr)
{
	int cc;

	if (size<=0) size = strlen(smsg);
//	hton_ar(smsg, size);
	cc = sendto(sock, smsg, size, 0, (struct sockaddr*)sv_addr, sizeof(*sv_addr));

	return cc;
}





/**
int  tcp_recv(int sock, char* rmsg, int size)
 
	ǽ: recv()åԥ󥰤ؿTCPͳǥǡ롥

	: sock	 åȵһ
		  rmsg	 ѥǡХåե
		  size	 ǡХåեΥ

	: ˹ԤФΥХȿ
			Ԥ-1֤
			0 ξǡ
*/
int  tcp_recv(int sock, char* rmsg, int size)
{
	int cc;

	memset(rmsg, 0, size);
	cc = recv(sock, rmsg, size, 0);

	return cc;
}





/**
int  tcp_send(int sock, char* smsg, int size)

	ǽ: send()åԥ󥰤ؿTCPͳǥǡ롥
		  ǡ(smsg)Υ size0ʲꤷϡsmsgʸ
		  Ǥȸʤ,ưŪ˷׻롥

	: sock   åȵһ
		  smsg   ǡ
		  size   ǡsmsgˤΥ 0ʲξ
				 smsgʸǤȤߤʤ

	: ϤХȿ
			Ԥˤ-1֤롥
*/
int  tcp_send(int sock, char* smsg, int size)
{
	int cc;

	if (size<=0) size = strlen(smsg);
	cc = send(sock, smsg, size, 0);

	return cc;
}




/**
int  udp_recv_mesg(int sock, char* rmsg, int size, struct sockaddr_in* sv_addr)

	ǽ: UDPʸǡ롥

	: sock	 åȵһ
		  rmsg	 ѥǡХåե
		  size	 ǡХåեΥ
		  sv_addr  Фξ󤬳Ǽ줿 sockaddar_in ¤ΤؤΥݥ󥿡
 
	: ˹ԤФΥХȿ
			Ԥ-1֤

	#define  udp_recv_mesg(s, m, l, a)     udp_recv((s), (m), (l), (a))
*/






/**
int  udp_send_mesg(int sock, char* smsg, struct sockaddr_in* sv_addr)

	ǽ: UDPʸǡ롥

	: sock	 åȵһ
		  smsg	 ǡ
		  sv_addr  ФξǼ sockaddar_in ¤ΤؤΥݥ󥿡

	: ˹ԤФΥХȿ
			Ԥ-1֤

	#define  udp_send_mesg(s, m, a)     udp_send((s), (m), 0, (a))
*/






/**
int  tcp_recv_mesg(int sock, char* mesg, int sz, int tm)

  	ǽTCPͳǥå(ʸ)롥Хʥġ
  		  ॢȤ꤬ǽॢȤ 0ꤷ, recv_wait()
  		  ؿƤӽФɤ߹߲ǽǡʤФ˥ॢ
     	  Ȥʤ (RECV_TIMEOUTED ֤)

  	:
	  	sock	åȵһ
	  	mesg	ѥǡХåե
	  	sz	 	ǡХåեΥ
	  	tm	 	ॢȻ֡ñ̡

  	:
	  	1ʾ   Хȿ
	  	0		餯¦å򥯥
	  	-1		顼
	  	RECV_TIMEOUTED	  	ॢȡ
*/
int  tcp_recv_mesg(int sock, char* mesg, int sz, int tm)
{
	int  cc;

	if (recv_wait(sock, tm)) {
		cc = recv(sock, mesg, sz, 0); 
		if (cc<=0) debug_message("TCP_RECV_MESG: Session Closed.\n");
	}
	else {
		debug_message("TCP_RECV_MESG: Time Out.\n");
		return RECV_TIMEOUTED;
	}
	return cc;
}





/**
int  tcp_send_mesg(int sock, char* mesg)

  	ǽTCPͳǥå(ʸ)롥

  	
	  	sock	 åȵһ
	  	mesg	 ѥå

  	͡
	  	ϤХȿ
	  	Ԥˤ-1֤롥

  	ǤϼΤϥޥǤ롥
	  #define  tcp_send_mesg(s, m)  tcp_send((s), (m), 0)
*/







/**
int  tcp_send_mesgln(int sock, char* mesg)

	ǽTCPå(ʸ)˲(\r\n)դä롥

	
	  sock	 åȵһ
	  mesg	 ѥå

  	͡
	  Ϥʸ(ޤ)
	  Ԥˤ-1֤롥
*/
int  tcp_send_mesgln(int sock, char* mesg)
{
	int   cc, sz;
	char* buf;

	sz = strlen(mesg)+3;	/* CR+LF+0x00 */
	buf = (char*)malloc(sz);
	if (buf==NULL) return -1;

	strncpy(buf, mesg, sz);
	strncat(buf, "\r\n", 2);
//	hton_ar(buf, strlen(buf));
	cc = send(sock, buf, strlen(buf), 0);

	free(buf);
	return cc;
}






/**
int  tcp_recv_mstream(int sock, char* mesg, int sz, mstream* sb, int tm)

	ǽTCPͳǥå(ʸ)롥åϥåȥ꡼
		Хåե˰öХåե󥰤졤δؿˤԤɤ߽Ф롥mesgˤϺ
		sz-1ʸǼ롥⤷ХåեΰԤΥǡ sz-1礭
		Ϥ߽ФʬϼΤƤ롥
		  mesg˳ǼβԥɤϺ졤ˤɬ \0 롥
  		  ॢȤ꤬ǽǥॢȤ 0ꤷ, ƤӽФ
  		  ɤ߹߲ǽǡʤФ˥ॢȤȤʤ (RECV_TIMEOUTED ֤)
		  åȥ꡼ΥХåեݤƤʤϡǽ˸ƤӽФ줿
		ݤ롥öδؿѤơǡХåե󥰤顤åȤ
		  ޤǡɤ߼ˤɬƱȥ꡼ѤƤδؿƤӽФФ
		  Фʤʤ̵ϼǡݾڤʤ

  	
	 	sock	åȵһ
	  	mesg	ѥǡХåեͽώʬʥΰݤƤ
	  	sz	 	ǡХåեΥ
		sb      ȥ꡼Хåեʥ󥰥ХåեΥȥ꡼Хåե
                ХåեݤƤʤСưŪ˳ݤ롥
	  	tm	 	ॢȻ֡ñ̡

	͡
	  	1ʾ   mesg˳ǼåΥХȿ
	  	0  		餯¦å򥯥
	  	-1  	顼
		-2  	 NULLΥǡ롥
		-3  	åХåե̵Τǳݤ褦Ȥݤ˼Ԥ
		-4  	åХåե˥ǡ¸ߤϤͳˤ˼Ԥ
		-5  	åХåեΥǡĹmesgĹ礭Ϥ߽ФʬϼΤƤ줿
	  	RECV_TIMEOUTED  	ॢȡ
*/
int  tcp_recv_mstream(int sock, char* mesg, int sz, mstream* sb, int tm)
{
	int  cc;
	unsigned char* pp;

	if (mesg==NULL || sb==NULL) return -2;
	memset(mesg, 0, sz);

	if (sb->buf==NULL) {
		*sb = make_mstream(RECVBUFSZ);
		if (sb->buf==NULL) return -3;
	}

	while (sb->datano==0) {
		cc = tcp_recv_mesg(sock, mesg, sz, tm);
		if (cc<=0) return cc;
		put_mstream(sb, (unsigned char*)mesg);
		memset(mesg, 0, sz);
	}

	pp = get_mstream(sb);
	if (pp==NULL) return -4;
	if (strlen((const char*)pp)>=(unsigned int)sz) {
		memcpy(mesg, pp, sz-1);
		free(pp);
		return -5;
	}
	memcpy(mesg, pp, strlen((const char*)pp));

	free(pp);
	return strlen(mesg);
}





///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// ʥ
//		tools.c ذư 2006 9/5

/**
void  set_sigterm_child()

	ǽchild ץνλꡥ

	tools.c ذư 2006 9/5
*/
/*
void  set_sigterm_child()
{
	struct sigaction ca;

	ca.sa_handler = sigterm_child;
	ca.sa_flags   = SA_NOCLDSTOP | SA_RESTART;
	sigemptyset(&ca.sa_mask);
	sigaction(SIGCHLD, &ca, NULL);
}
*/




/**
void  sigterm_child(int signal)

	ǽchild ץνλ

	tools.c ذư 2006 9/5
*/
/*
void  sigterm_child(int signal)
{
	pid_t pid = 0;
	int ret;

	do {
		pid = waitpid(-1, &ret, WNOHANG);
	} while(pid>0);
}
*/







///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// ɥ쥹
//

/**
char*  get_hostname_bynum(unsigned char* num) 

	ǽ: IPɥ쥹Ĺ4byte 1byte unsigned ˤۥ̾հ롥 

	IPɥ쥹Ĺ4byte 1byte unsigned ˡ 

	͡ۥ̾ʸ
*/
char*  get_hostname_bynum(unsigned char* num) 
{
	int   len;
	char* hname;
	struct hostent* hent;

	#ifdef WIN32
		hent = gethostbyaddr((const char*)num, 4, AF_INET);
	#else
		hent = gethostbyaddr(num, 4, AF_INET);
	#endif
	
	if (hent==NULL) return NULL;

	len = strlen(hent->h_name);
	hname = (char*)malloc(len+1);
	if (hname==NULL) {
		free(hent);
		return NULL;
	}
	memcpy(hname, hent->h_name, len+1);

	return hname;	
}

	



/**
char*  get_hostname(char* ipaddr) 

	ǽ: IPɥ쥹ʸˤۥ̾հ롥 
		  FQDNꤷϡƵհΤǡFQDNΥå
		ѤǤ롥

	IPɥ쥹ʸˤޤ FQDN 

	͡ۥ̾ʸ
*/
char*  get_hostname(char* ipaddr) 
{
	char*  name;
	unsigned char* num;

	num  = to_address_num4(ipaddr, 1);
	if (num==NULL) return NULL;

	name = get_hostname_bynum(num); 
	free(num);

	return name;	
}

	




#ifdef WIN32

unsigned char*  get_myipaddr_num() 
{
	unsigned char* ipnum  = NULL;
	char* ipaddr = get_localip();

	if (ipaddr!=NULL) {
		ipnum = to_address_num8(ipaddr, 0);
		free(ipaddr);
	}

	return ipnum;
}


#else

/**
char*  get_myipaddr() 

	ǽ: ͥåȥ󥿡ե򸡺ֺǽ˸Ĥ
UP֤ǥ롼ץХåǤʤ󥿡եIPɥ쥹
		  ͥåȥޥ֤륤󥿡եο
 		   MAXIFNO Ǥꡤ¿Τ̵뤹롥

		  ͥåȥޥɬפʤʤ get_localip() ѤƤɤ

	: ʤ

	: [IPɥ쥹]/[ͥåȥޥ] ʸ

 */
char*  get_myipaddr() 
{
	char* addr;
	unsigned char* n;

	n = get_myipaddr_num();
	if (n==NULL) return NULL;

	addr = (char*)malloc(32);
	if (addr==NULL) {
		free(n);
		return NULL;
	}
	memset(addr, 0, 32);

	snprintf(addr, 31, "%d.%d.%d.%d/%d.%d.%d.%d", n[0], n[1], n[2], n[3], n[4], n[5], n[6], n[7]);

	free(n);
	return addr;
}






/**
unsigned char*  get_myipaddr_num() 

	ǽ: ͥåȥ󥿡ե򸡺ֺǽ˸Ĥ
UP֤ǥ롼ץХåǤʤ󥿡եIPɥ쥹
		  ͥåȥޥ֤륤󥿡եο
 		   MAXIFNO Ǥꡤʾ̵뤹롥

		  ʬȤIPɥ쥹ΤˡȤƤϡ gethostname() 
		  gethostbyname() Ȥˡ⤢롥
			 struct hostent  *shost;
				.....................
				gethostname(hostname, sizeof(hostname));
				shost = gethostbyname(hostname);

		  ޤget_localip() ˡȤ롥

	: ʤ

	: [IPɥ쥹],[ͥåȥޥ] Ĺ8byte 1byte unsigned 

 */

unsigned char*  get_myipaddr_num() 
{
	int	i, sofd, len;

	unsigned char*  addr = NULL;
	struct ifconf  ifc;
	struct ifreq*  ifq;
	struct ifreq*  ifp;


	len = sizeof(struct ifreq)*MAXIFNO;
	ifp = ifq = (struct ifreq*)malloc(len);
	if (ifq==NULL) return NULL;
	ifc.ifc_len = len;
	ifc.ifc_req = ifq;

	sofd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sofd<0) {
      	perror("get_myipaddr_num: socket");
		return NULL;
	}


	// 󥿡ե̾μ
	if (ioctl(sofd, SIOCGIFCONF, &ifc)<0) {
		socket_close(sofd);
		free(ifq);
		return NULL;
	}


	ifp = ifq;
	for (i=0; i<MAXIFNO; i++) {

		// 󥿡եΥե饰
		if (ioctl(sofd, SIOCGIFFLAGS, ifp)<0) {
			socket_close(sofd);
			free(ifq);
			return NULL;
		}

		if ((ifp->ifr_flags&IFF_UP) && !(ifp->ifr_flags&IFF_LOOPBACK)) {
			int j;
			unsigned char* p = (unsigned char*)ifp->ifr_addr.sa_data;

			addr = (unsigned char*)malloc(8);
			if (addr==NULL) {
				socket_close(sofd);
				free(ifq);
				return NULL;
			}

			// ɥ쥹
			if (ioctl(sofd, SIOCGIFADDR, ifp)<0) {
				socket_close(sofd);
				free(ifq);
				free(addr);
				return NULL;
			}
			for (j=0; j<4; j++) addr[j] = p[j+2];

			// ͥåȥޥ
			if (ioctl(sofd, SIOCGIFNETMASK, ifp)<0) {
				socket_close(sofd);
				free(ifq);
				free(addr);
				return NULL;
			}
			for (j=0; j<4; j++) addr[j+4] = p[j+2];

			return addr;
		}
		ifp++;
	}
	
	socket_close(sofd);
	free(ifq);
	return NULL;
}

#endif





/**
char*  get_localip()

	ǽ: ʬȤ IPɥ쥹⤦Ĥˡ
		  ⡼ȥޥ³ʥߡˤߡΥ󥿡ե
롥

	: ʤ

	: IPɥ쥹 ʸ
            Ѥä free() ɬפ

 */
// #define get_localip() get_localip_bydest("202.26.158.1")
           




/**
char*  get_localip_bydest(char* dest)

	ǽ: ³ꤷơ³ 󥿡եIPɥ쥹
		  ʬȤ IPɥ쥹⤦Ĥˡ

	: ³

	: IPɥ쥹 ʸ
            Ѥä free() ɬפ

 */
char*  get_localip_bydest(char* dest)
{
    int   err, sofd;
	socklen_t len;
	char* addr;
	char* ip;
	struct sockaddr_in localif;  
	struct sockaddr_in remote;             
	
	if (dest==NULL) return NULL; 	
	ip = get_ipaddr_byname(dest);
	if (ip ==NULL)  return NULL;

	memset(&localif, 0, sizeof(struct sockaddr_in));  
	memset(&remote,  0, sizeof(struct sockaddr_in));  
	remote.sin_family      = AF_INET;  
	remote.sin_addr.s_addr = inet_addr(ip);  
	remote.sin_port        = htons(9999);             
	free(ip);

	sofd = socket(AF_INET, SOCK_DGRAM, 0);  
	if (sofd<0) return NULL;

  	err = connect(sofd, (struct sockaddr*)&remote, sizeof(remote));
  	if (err<0) {
      	socket_close(sofd);
     	return NULL;
    }

  	len = sizeof(localif);
  	err = getsockname(sofd, (struct sockaddr *)&localif, &len);
	if (err<0) {
      	socket_close(sofd);
      	return NULL;
    }
  	socket_close(sofd);

	addr = get_ipaddr(localif.sin_addr);
  	return addr;
}
           




/**
char*  get_ipaddr(struct in_addr sin_addr)

	ǽ: in_addr¤Τ IPɥ쥹롥

	: in_addr  -- sockaddr_in¤ΤΥФ,̾ sin_addrǤ롥

	: IPɥ쥹(ʸ)ؤΥݥ󥿡
            Ѥä free() ɬפ

	:
	   struct sockaddr_in addr
	   .........;
	   ipaddr = get_ipaddr(addr.sin_addr); 

*/
char*  get_ipaddr(struct in_addr sin_addr)
{
	char* ip;
	unsigned char* pp;

	pp = (unsigned char*)&(sin_addr);
	if (pp[0]==0) return NULL;

	ip = (char*)malloc(16);
	if (ip==NULL) return NULL;
	memset(ip, 0, 16);

	snprintf(ip, 15, "%d.%d.%d.%d", pp[0], pp[1], pp[2], pp[3]);

	return ip;
}




/**
unsigned char*  get_ipaddr_num(struct in_addr sin_addr)

	ǽ: in_addr¤Τ IPɥ쥹롥

	: in_addr  -- sockaddr_in¤ΤΥФ,̾ sin_addrǤ롥

	: IPɥ쥹(1byte unsiged )ؤΥݥ󥿡Ĺ4byteˡ
            Ѥä free() ɬפ

	:
	   struct sockaddr_in addr
	   .........;
	   ipaddr = get_ipaddr_num(addr.sin_addr); 

*/
unsigned char*  get_ipaddr_num(struct in_addr sin_addr)
{
	unsigned char* ip;
	unsigned char* pp;

	ip = (unsigned char*)malloc(4);
	if (ip==NULL) return NULL;

	pp = (unsigned char*)&(sin_addr);
	memcpy(ip, pp, 4);

	return ip;
}





/**
char*  get_ipaddr_byname(char* hostname)

	ǽ: ۥ̾ IPɥ쥹롥

	: hostname -- ۥ̾

	: IPɥ쥹(ʸ)ؤΥݥ󥿡
            Ѥä free() ɬפ

*/
char*  get_ipaddr_byname(char* hostname)
{
	struct hostent *host;
	char* ip;
	unsigned char* pp;

	host = gethostbyname(hostname); 
	if (host==NULL) return NULL;

	ip = (char*)malloc(16);
	if (ip==NULL) return NULL;
	memset(ip, 0, 16);

	pp = (unsigned char*)(host->h_addr);
	snprintf(ip, 15, "%d.%d.%d.%d", pp[0], pp[1], pp[2], pp[3]);

	return ip;
}





/**
char*  get_ipaddr_byname_num(char* hostname)

	ǽ: ۥ̾ IPɥ쥹롥

	: hostname -- ۥ̾

	: IPɥ쥹(1byte unsiged )ؤΥݥ󥿡Ĺ4byteˡ
            Ѥä free() ɬפ

*/
unsigned char*  get_ipaddr_byname_num(char* hostname)
{
	struct hostent *host;
	unsigned char* ip;
	unsigned char* pp;

	host = gethostbyname(hostname); 
	if (host==NULL) return NULL;
	ip = (unsigned char*)malloc(4);
	if (ip==NULL) return NULL;

	pp = (unsigned char*)(host->h_addr);
	memcpy(ip, pp, 4);

	return ip;
}





/**
char*  get_mynetaddr()

	ǽ: ʬΥͥåȥɥ쥹֤

	: ͥåȥɥ쥹(ʸ)ؤΥݥ󥿡
            Ѥä free() ɬפ
*/
char*  get_mynetaddr()
{
	char* net;
	unsigned char* pp;

	pp = get_mynetaddr_num();
	if (pp==NULL) return NULL;

	net = (char*)malloc(16);
	if (net==NULL) {
		free(pp);
		return NULL;
	}
	memset(net, 0, 16);

	snprintf(net, 15, "%d.%d.%d.%d", pp[0], pp[1], pp[2], pp[3]);

	free(pp);
	return net;
}





/**
unsigned char*  get_mynetaddr_num()

	ǽ: ʬΥͥåȥɥ쥹֤

	: ͥåȥɥ쥹(1byte unsiged )ؤΥݥ󥿡Ĺ4byteˡ
            Ѥä free() ɬפ

*/
unsigned char*  get_mynetaddr_num()
{
	int  i;
	unsigned char* net;
	unsigned char* ip;
	unsigned char* mk;
		
	ip = get_myipaddr_num();
	if (ip==NULL) return NULL;
	mk = &(ip[4]);

	net = (unsigned char*)malloc(4);
	if (net==NULL) {
		free(ip);
		return NULL;
	}

	for (i=0; i<4; i++) net[i] = ip[i] & mk[i];

	free(ip);
	return net;
}




/**


*/
struct sockaddr_in  get_sockaddr(char* hostname, unsigned short cport)
{
	struct sockaddr_in  ss_addr;
	struct hostent *shost;

	// Serverξ ss_addr˳Ǽ
	shost = gethostbyname(hostname);
	if (shost==NULL) {
		//DEBUG_MODE print_message("GET_HOST_INFO: Error: cannot find hostname %s\n", hostname);
		ss_addr.sin_family = 0;
		ss_addr.sin_port   = 0;
		return ss_addr;
	}

	memset(&ss_addr, 0, sizeof(ss_addr));
	ss_addr.sin_family = AF_INET;
	ss_addr.sin_port   = htons(cport);
	memcpy(&(ss_addr.sin_addr), shost->h_addr, shost->h_length);

	return ss_addr;
}




struct sockaddr_in  get_sockaddr_bynum(char* ipnum, unsigned short cport)
{
	struct sockaddr_in  ss_addr;

	memset(&ss_addr, 0, sizeof(ss_addr));
	ss_addr.sin_family = AF_INET;
	ss_addr.sin_port   = htons(cport);
	memcpy(&(ss_addr.sin_addr), ipnum, 4);

	return ss_addr;
}





struct sockaddr_in  get_local_sockaddr(unsigned short cport)
{
	struct sockaddr_in  ss_addr;
	struct hostent *shost;


	// localhost ξ ss_addr˳Ǽ
	shost = gethostbyname("127.0.0.1");

	memset(&ss_addr, 0, sizeof(ss_addr));
	ss_addr.sin_family = AF_INET;
	ss_addr.sin_port   = htons(cport);
	memcpy(&(ss_addr.sin_addr), shost->h_addr, shost->h_length);

	return ss_addr;
}




/**
int  is_same_sockaddr(struct sockaddr_in addr1, struct sockaddr_in addr2) 

	addr1  addr2Ǽ IPɥ쥹ȥݡֹ椬Ʊɤ


*/
int  is_same_sockaddr(struct sockaddr_in addr1, struct sockaddr_in addr2) 
{
	int i, len;
	unsigned char *p1, *p2;

	p1  = (unsigned char*)&(addr1.sin_addr);
	p2  = (unsigned char*)&(addr2.sin_addr);
	len = sizeof(addr1.sin_addr);

	for (i=0; i<len; i++) {
		if (p1[i]!=p2[i]) return FALSE;
	}

	p1  = (unsigned char*)&(addr1.sin_port);
	p2  = (unsigned char*)&(addr2.sin_port);
	len = sizeof(addr1.sin_port);

	for (i=0; i<len; i++) {
		if (p1[i]!=p2[i]) return FALSE;
	}

	return TRUE;
}





/**
int  is_same_network_num(unsigned char* addr1, unsigned char* addr2, unsigned char* mask)

	ǽɥ쥹 addr1  addr2Ʊͥåȥ°Ƥ뤫ɤå롥

	addr1, addr2 -- Ӥ륢ɥ쥹ʿ4Byte
		  mask		   -- ͥåȥޥʿ4Byte

	͡FALSE  ƱͥåȥǤʤ
		 	TRUE   ƱͥåȥǤ롥

*/
int  is_same_network_num(unsigned char* addr1, unsigned char* addr2, unsigned char* mask)
{
	int i;

	if (addr1==NULL || addr2==NULL || mask==NULL) return FALSE;
	for (i=0; i<4; i++) {
		if ((addr1[i]&mask[i]) != (addr2[i]&mask[i])) return FALSE;
	}
	return TRUE;
}






/**
int  is_same_network(char* addr1, char* addr2, char* mask)

	ǽʸɥ쥹 addr1  addr2Ʊͥåȥ°Ƥ뤫ɤå롥
		  addr1, addr2  FQDNǤġ

	addr1, addr2 -- Ӥ륢ɥ쥹ʸ
		  mask		   -- ͥåȥޥʸ

	͡FALSE  ƱͥåȥǤʤ
		 	TRUE   ƱͥåȥǤ롥

*/
int  is_same_network(char* addr1, char* addr2, char* mask)
{
	int  ret;
	unsigned char* a1;
	unsigned char* a2;
	unsigned char* mk;

	if (addr1==NULL || addr2==NULL || mask==NULL) return FALSE;

	a1 = to_address_num4(addr1, 1);
	a2 = to_address_num4(addr2, 1);
	mk = to_address_num4(mask,  0);
	if (a1==NULL || a2==NULL || mk==NULL) {
		freeNull(a1);
		freeNull(a2);
		freeNull(mk);
		return FALSE;
	}

	ret = is_same_network_num(a1, a2, mk);
	freeNull(a1);
	freeNull(a2);
	freeNull(mk);
	
	return TRUE;
}








/**
unsigned char*  to_address_num8(char* addr, int mode)

	ǽʸΥɥ쥹 [IPɥ쥹]/[ͥåȥޥ] (㡧202.26.159.140/255.255.255.0ˤ
		  Υɥ쥹unsigned char* num[8]8Byte Ѵ롥
		  ά줿 0Ȥߤʤ㡧202.26/255  202.26.0.0/255.0.0.0
		  ͥåȥޥΤά줿 IPɥ쥹˰¸롥(202.26.  202.26.0.0/255.255.0.0)
		  CIDERˤб
		  ͥåȥޥϥåʤ

	addr -- ѴʸIPɥ쥹
		  mode -- 0 : IPɥ쥹ʳΤΡʱѻˤ NULL ֤
				0ʳFQDNIPɥ쥹Ѵ֤ʻ֤

	: [IPɥ쥹],[ͥåȥޥ] Ĺ8byte 1byte unsigned 
*/
unsigned char*  to_address_num8(char* addr, int mode)
{
	unsigned char* num;
	char* ps;
	char* pc;
	char* uc = NULL;
	int   i;

	if (addr==NULL) return NULL;

	num = (unsigned char*)malloc(8);
	if (num==NULL) return NULL;
	memset(num, 0, 8);


	// IPɥ쥹Ѵ
 	ps = awk(addr, '/', 1);
	if (ps==NULL) {
		free(num);
		return NULL;
	}

	i = strlen(ps) - 1;
	while (i>0 && ps[i]=='.') i--;
	if (i>0) {
		if (isalpha(ps[i])) {
			if (mode==0) { // mode==0ʤ FQDN->IPɥ쥹 ϹԤʤʤ
				free(num);
				free(ps);
				return NULL;
			}
			uc = (char*)get_ipaddr_byname_num(ps);
			if (uc==NULL) {
				free(num);
				free(ps);
				return NULL;
			}
		}
	}

	if (uc==NULL) { 						// IPɥ쥹ɽν	
		for (i=0; i<4; i++) {
			pc = awk(ps, '.', i+1);
			if (pc==NULL) break;
			num[i] = (unsigned char)atoi(pc);
			free(pc);
		}
	}
	else { 									// ۥ̾ɽν
		for (i=0; i<4; i++) num[i] = uc[i];
		free(uc);
	}
	free(ps);


 	ps = awk(addr, '/', 2);

	// ֥ͥåȥޥά줿ν
	if (ps==NULL) {
		int f = OFF;
		for (i=3; i>=0; i--) {
			if (num[i]!=0 || f==ON) {
				num[i+4] = 0xff;
				f = ON;
			}
			else {
				num[i+4] = 0;
			}
		}
		return num;
	}


	// ֥ͥåȥޥν
	for (i=0; i<4; i++) {
		pc = awk(ps, '.', i+1);
		if (pc==NULL) break;
		num[i+4] = (unsigned char)atoi(pc);
		free(pc);
	}
	free(ps);


	// CIDERб
	if (num[4]<=32 && num[5]==0 && num[6]==0 && num[7]==0) {
		int nn, cl = (int)num[4];
		for (i=0; i<4; i++) {
			nn = 8 - Max(0, Min(8, cl-8*i));
			num[i+4] = 0xff<<nn;
		}
	}

	return  num;
}







/**
char*  to_address_char8(unsigned char* num)

	ǽ IPɥ쥹 num 8ByteʸΡ[IPɥ쥹]/[ͥåȥޥ]Ѵ롥
		  num ɬͥåȥޥξޤߡĹ 8ByteǤʤȤʤ8Byte꾯ʤ
		  餯ơ󥨥顼򵯤
		  ա
		  to_address_num()ФǻȤΤ

	Ĺ 8byte 1byte unsigned  [IPɥ쥹],[ͥåȥޥ]

	͡[IPɥ쥹]/[ͥåȥޥ] ʸ
*/
char*  to_address_char8(unsigned char* n)
{
	char* addr;
	if (n==NULL) return NULL;

	addr = (char*)malloc(32);
	if (addr==NULL) return NULL;
	memset(addr, 0, 32);

	snprintf(addr, 31, "%d.%d.%d.%d/%d.%d.%d.%d", n[0], n[1], n[2], n[3], n[4], n[5], n[6], n[7]);

	return addr;
}






/**
unsigned char*  to_address_num4(char* addr, int mode)

	ǽʸΥɥ쥹 [IPɥ쥹] (㡧202.26.159.140ˤ
		  Υɥ쥹unsigned char* num[4]4Byte Ѵ롥
		  ά줿 0Ȥߤʤ㡧202.26  202.26.0.0
		   free()

	addr -- ѴʸIPɥ쥹
		  mode -- 0 : IPɥ쥹ʳΤΡʱѻˤ NULL ֤
				0ʳFQDNIPɥ쥹Ѵ֤ʻ֤

	: [IPɥ쥹] Ĺ4byte 1byte unsigned 
*/
unsigned char*  to_address_num4(char* addr, int mode)
{
	unsigned char* num;
	char* pc;
	char* uc = NULL;
	int   i;

	if (addr==NULL) return NULL;

	num = (unsigned char*)malloc(4);
	if (num==NULL) return NULL;
	memset(num, 0, 4);


	// IPɥ쥹Ѵ
	i = strlen(addr) - 1;
	while (i>0 && addr[i]=='.') i--;
	if (i>0) {
		if (isalpha(addr[i])) {
			if (mode==0) { // mode==0ʤ FQDN->IPɥ쥹 ϹԤʤʤ
				free(num);
				return NULL;
			}
			uc = (char*)get_ipaddr_byname_num(addr);
			if (uc==NULL) {
				free(num);
				return NULL;
			}
		}
	}

	if (uc==NULL) { 						// IPɥ쥹ɽν	
		for (i=0; i<4; i++) {
			pc = awk(addr, '.', i+1);
			if (pc==NULL) break;
			num[i] = (unsigned char)atoi(pc);
			free(pc);
		}
	}
	else { 									// ۥ̾ɽν
		for (i=0; i<4; i++) num[i] = uc[i];
		free(uc);
	}

	return  num;
}







/**
char*  to_address_char4(unsigned char* num)

	ǽ IPɥ쥹 num 4Byteʸ [IPɥ쥹] Ѵ롥
		  num ɬͥåȥޥξޤߡĹ 4ByteǤʤȤʤ4Byte꾯ʤ
		  餯ơ󥨥顼򵯤
		  ա
		  to_address_num4()ФǻȤΤ

	Ĺ 4byte 1byte unsigned  [IPɥ쥹]

	͡[IPɥ쥹] ʸ
*/
char*  to_address_char4(unsigned char* n)
{
	char* addr;
	if (n==NULL) return NULL;

	addr = (char*)malloc(16);
	if (addr==NULL) return NULL;
	memset(addr, 0, 16);

	snprintf(addr, 15, "%d.%d.%d.%d", n[0], n[1], n[2], n[3]);

	return addr;
}






/**
int   recv_wait(int sock, int tm)

	ǽʰ wait. åȤ˥ǡޤԤġ

	sock		ƻ뤹륽å
		tm		ॢȤÿ

	͡		Хåե˥ǡ롥
					ॢȤ
*/
int   recv_wait(int sock, int tm)
{
	int    nd, rslt;
	fd_set mask;
	struct timeval timeout;

	do {
		timeout.tv_sec  = tm;
		timeout.tv_usec = 0;
		FD_ZERO(&mask);
		FD_SET(sock, &mask);
		//DEBUG_MODE print_message("Waiting sock = %d for %ds.\n", sock, tm);
		nd = select(sock+1, &mask, NULL, NULL, &timeout);
	} while (nd<0);

	rslt = FD_ISSET(sock, &mask); 	
	//DEBUG_MODE print_message("Waited  sock = %d Result is %d.\n", sock, rslt);
	
	return rslt; 	
}



/**
int   send_wait(int sock, int tm)

	ǽʰ wait. ǡǽˤʤޤԤġ

	sock		ƻ뤹륽å
		tm		ॢȤÿ

	͡		Хåե˥ǡ롥
					ॢȤ
*/
int   send_wait(int sock, int tm)
{
	int    nd, rslt;
	fd_set mask;
	struct timeval timeout;

	do {
		timeout.tv_sec  = tm;
		timeout.tv_usec = 0;
		FD_ZERO(&mask);
		FD_SET(sock, &mask);
		//DEBUG_MODE print_message("Waiting sock = %d for %ds.\n", sock, tm);
		nd = select(sock+1, NULL, &mask, NULL, &timeout);
	} while (nd<0);

	rslt = FD_ISSET(sock, &mask); 	
	//DEBUG_MODE print_message("Waited  sock = %d Result is %d.\n", sock, rslt);
	
	return rslt; 	
}




/**
void  udp_hole_punching(int sock, struct sockaddr_in addr, int nm)

	ǽsock Ȥäơaddr nmХȤ NULLǡ롥

*/
void  udp_hole_punching(int sock, struct sockaddr_in addr, int nm)
{
	char data[LBUF];

	if (nm<=0) nm = 4;				// for SLVoice
	else if (nm>LBUF) nm = LBUF;

	memset(data, 0, nm);
	udp_send(sock, data, nm, &addr);

	return;
}










////////////////////////////////////////////////////////////////////////////////////////
// get_valid_..._socket
//

int  get_valid_udp_socket(int min, int max, unsigned short* port)
{
	int  i, sock, range;

	range = max - min + 1;
	*port = rand()%range + min;

	i = 1;
	sock = udp_server_socket((int)*port);
	while(sock<=0 && i<range) {
		(*port)++;
		if (*port>max) *port = ((int)*port)%max + min - 1;
		sock = udp_server_socket((int)*port);
		i++;
	}

	if (sock<=0) *port = 0;

	return sock;
}




int  get_valid_tcp_server_socket(int min, int max, unsigned short* port)
{
	int  i, sock, range;

	range = max - min + 1;
	*port = rand()%range + min;

	i = 1;
	sock = tcp_server_socket((int)*port);
	while(sock<=0 && i<range) {
		(*port)++;
		if (*port>max) *port = ((int)*port)%max + min - 1;
		sock = tcp_server_socket((int)*port);
		i++;
	}

	if (sock<=0) *port = 0;

	return sock;
}




int  get_valid_tcp_client_socket(int min, int max, char* hname, unsigned short sport, unsigned short* cport)
{
	int  i, sock, range;

	range  = max - min + 1;
	*cport = rand()%range + min;

	i = 1;
	sock = tcp_client_bind_socket(hname, (int)sport, (int)*cport);
	while(sock<0 && i<range) {
		(*cport)++;
		if (*cport>max) *cport = ((int)*cport)%max + min - 1;
		sock = tcp_client_bind_socket(hname, (int)sport, (int)*cport);
		i++;
	}

	if (sock<=0) *cport = 0;

	return sock;
}







//////////////////////////////////////////////////////////////////////////////////
//
// WinSock
//

int  init_network(void)
{
	int ret = 0;

#ifdef WIN32
	WSADATA wsaData;

	ret = WSAStartup(MAKEWORD(2,0), &wsaData);
#endif

	return  ret;
}



void  cleanup_network(void)
{
#ifdef WIN32
	WSACleanup();
#endif
}
