/* vi: set tabstop=4 nocindent noautoindent: */

/**
Tiny List ¤饤֥		tlist.c
											by Fumi.Iseki 2008 2/1

  إå
	  #include "tlist.h"
*/




#include  "tlist.h"




/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// List Data
//
//     Ū롥 
//

/**
tList_data  init_tListdata(void)
  
	ǽ: ΥΡɥǡŪ˺
		  ǡΤ˻Ѥ롥

	: 줿Ρɥǡ
*/
tList_data  init_tListdata(void)
{
	tList_data pp;

	memset(&pp, 0, sizeof(tList_data));
	return pp;
}





/**
tList_data  make_tListdata(int id, int lv, Buffer key, Buffer val, void* ptr, int sz)
  
	ǽ: ǡꤷƥΡɥǡ
		  sz>0  ptr==NULL ξ ptrΰݤ0ꥢ롥

	: id  -- ΡɤID
		  lv  -- ΡɤΥǡ
		  key -- ΡɤΥ	(Buffer)	ʣ
		  val -- ΡɤΥǡ (Buffer)	ʣ
		ptr -- ѥǡؤΥݥ		ʣ
		  sz  -- *ptr Υ

	: 줿Ρɥǡ
*/
tList_data  make_tListdata(int id, int lv, Buffer key, Buffer val, void* ptr, int sz)
{
	tList_data pp;

	memset(&pp, 0, sizeof(tList_data));

	pp.id  = id;
	pp.lv  = lv;
	pp.sz  = sz;
	pp.key = dup_Buffer(key);	
	pp.val = dup_Buffer(val);

	if (sz>0) {
		pp.ptr = (void*)malloc(sz);
		if (pp.ptr!=NULL) {
			if (ptr!=NULL) memcpy(pp.ptr, ptr, sz);
			else           memset(pp.ptr, 0,   sz);
		}
	}
	
	return pp;
}





/**
tList_data  make_tListdata_bystr(int id, int lv, char* key, char* val, void* ptr, int sz)
  
	ǽ: ǡꤷƥΡɥǡ
		  sz>0  ptr==NULL ξ ptrΰݤ0ꥢ롥

	: id  -- ΡɤID
		  lv  -- ΡɤΥǡ
		  key -- ΡɤΥ	 			ʣ
		  val -- ΡɤΥǡ 			ʣ
		ptr -- ѥǡؤΥݥ		ʣ
		  sz  -- *ptr Υ

	: 줿Ρɥǡ
*/
tList_data  make_tListdata_bystr(int id, int lv, char* key, char* val, void* ptr, int sz)
{
	tList_data pp;
	
	memset(&pp, 0, sizeof(tList_data));

	pp.id  = id;
	pp.lv  = lv;
	pp.sz  = sz;
	pp.key = make_Buffer_bystr(key);	// key==NULLʤ init_Buffer()
	pp.val = make_Buffer_bystr(val);

	if (sz>0) {
		pp.ptr = (void*)malloc(sz);
		if (pp.ptr!=NULL) {
			if (ptr!=NULL) memcpy(pp.ptr, ptr, sz);
			else           memset(pp.ptr, 0,   sz);
		}
	}

	return pp;
}





/**
void  free_tListdata(tList_data* ldat)
  
	ǽ: ΡɥǡΥХåե򥯥ꥢ롥
		  ǡȤϺʤ

	: ldat -- ꥢΡɥǡ

	: ʤ
*/
void  free_tListdata(tList_data* ldat)
{
	if (ldat==NULL) return;

	ldat->id = 0;
	ldat->lv = 0;
	ldat->sz = 0;

	free_Buffer(&(ldat->key));	
	free_Buffer(&(ldat->val));
	if (ldat->ptr!=NULL) free(ldat->ptr);
	del_all_tList(&(ldat->lst));

	ldat->key = init_Buffer();
	ldat->val = init_Buffer();
	ldat->ptr = NULL;
	ldat->lst = NULL;

	return;
}





/**
tListdata  dup_tListdata(tList_data ldat)
  
	ǽ: Ρɥǡʣ롥
		  ldat.sz ˤΤ ldat.ptrΥꤵƤɬפ롥

	: ldat -- ʣΡɥǡ

	: ʣΡɥǡؤΥݥ󥿡

*/
tList_data  dup_tListdata(tList_data ldat)
{
	tList_data dup;	

	memcpy(&dup, &ldat, sizeof(tList_data));
	dup.key = dup_Buffer(ldat.key);
	dup.val = dup_Buffer(ldat.val);
	if (ldat.ptr!=NULL && ldat.sz>0) {
		dup.ptr = (void*)malloc(ldat.sz);
		if (dup.ptr!=NULL) memcpy(dup.ptr, ldat.ptr, ldat.sz);
	}
	dup.lst = dup_tList(ldat.lst);
	
	return dup;
}








/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tiny List
//

/**
tList*  new_tList_node(void)

	ǽ: ꥹѤζΡɤưŪ

	: 줿ΡɤؤΥݥ󥿡
*/
tList*  new_tList_node(void)
{
	tList* pp;

	pp = (tList*)malloc(sizeof(tList));
	if (pp==NULL) return NULL;
	memset(pp, 0, sizeof(tList));
	pp->ldat = init_tListdata();

	return pp;
}





/**
tList   make_tList_node(tList_data ldat)

	ǽ: ꥹѥΡɤŪ롥
		  ldat ϤΤޤ޿ѿǻѤ롥ñ

		  δؿΡɤ del_*_tList()ؿǺƤϤʤ

	: ldat  -- Ρɥǡ

	: 줿Ρɡ
*/
tList   make_tList_node(tList_data ldat)
{
	tList pp;

	memset(&pp, 0, sizeof(tList));
	pp.ldat = ldat;	

	return pp;
}




/**
tList*  add_tList_node_bydata(tList* pp, tList_data ldat) 

	ǽ: ǡ(ldat)ꥹѥΡɤĤФ(new),ꤷꥹȤθɲá
		  ꥹȥݥ ppؤΡɤθˤĤФ Ρɤ롥
		  ldat ϻꤵ줿ΤΤޤ޻Ѥ롥

	: pp   -- ɲäμΥΡɤؤΥݥ󥿡
		  ldat -- ɲäΡɥǡΥǡΤޤ޻Ѥ롥
		   
	: ɲäΡɤؤΥݥ󥿡
*/
tList*  add_tList_node_bydata(tList* pp, tList_data ldat) 
{
	tList* pt;

	pt = new_tList_node();
	pt->ldat = ldat;

	if (pp==NULL) return pt;

	pt->next = pp->next;
	pt->prev = pp;
	pp->next = pt;
	if (pt->next!=NULL) (pt->next)->prev = pt;	

	return pt;
}





/**
tList*  add_tList_node_bystr(tList* pp, int id, int lv, char* key, char* val, void* ptr, int sz) 

	ǽ: ǡꥹѥΡɤĤФ(new),ꥹȤɲá
		  ꥹȥݥ ppؤΡɤθˤĤФ Ρɤ롥
		  sz>0  ptr==NULL ξ ptrΰݤ0ꥢ롥

	: pp  -- ɲäμΥΡɤؤΥݥ󥿡
		  id  -- ɲäǡ
		  lv  -- ɲäǡ
		  key -- ɲäǡ		ʣ
		  val -- ɲäǡ		ʣ
		ptr -- ѥǡؤΥݥ	ʣ
		  sz  -- *ptr Υ
		   
	: ɲäΡɤؤΥݥ󥿡
*/
tList*  add_tList_node_bystr(tList* pp, int id, int lv, char* key, char* val, void* ptr, int sz) 
{
	tList* pt;
	tList_data ldat;

	ldat = make_tListdata_bystr(id, lv, key, val, ptr, sz);
	pt   = add_tList_node_bydata(pp, ldat);

	return pt;
}




/**
tList*  add_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 

	ǽ: ǡꥹѥΡɤĤФ(new),ꥹȤɲá
		  ꥹȥݥ ppؤΡɤθˤĤФ Ρɤ롥
		  sz>0  ptr==NULL ξ ptrΰݤ0ꥢ롥

	: pp  -- ɲäμΥΡɤؤΥݥ󥿡
		  id  -- ɲäǡ
		  lv  -- ɲäǡ
		  key -- ɲäǡ			ʣ
		  val -- ɲäǡ			ʣ
		*ptr -- ѥǡؤΥݥ	ʣ
		  sz   -- *ptr Υ
		   
	: ɲäΡɤؤΥݥ󥿡
*/
tList*  add_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 
{
	tList* pt;
	tList_data ldat;

	ldat = make_tListdata(id, lv, key, val, ptr, sz);
	pt   = add_tList_node_bydata(pp, ldat);

	return pt;
}





/**	
tList*  free_tList_node(tList** node) 

	ǽ: 
		ꥹѥΡɤΥХåե(ǡ)γ
		*node ˤ NULL롥

	: *node  -- ΡɤؤΥݥ󥿡
*/
void   free_tList_node(tList** node)
{
	if (node==NULL || *node==NULL) return;

	free_tListdata(&((*node)->ldat));
	*node = NULL;

	return;
}	





/**	
tList*  del_tList_node(tList* node) 

	ǽ: ꥹѤΥΡɤ
		  ꥹȥݥ nodeؤΡɤ,ꥹȹ¤ͤ롥

	: node  -- ΡɤؤΥݥ󥿡

	: ΡɤľΥΡɤؤΥݥ󥿡
*/
tList*  del_tList_node(tList* node) 
{	
	tList* pp = NULL;

	if (node==NULL) return NULL;

	free_tListdata(&(node->ldat));

	if (node->prev!=NULL) node->prev->next = node->next;
	if (node->next!=NULL) {
		node->next->prev = node->prev;
		pp = node->next;
	}
	free(node);

	return pp;
}





/**
tList*  dup_tList_node(tList* node)

	ǽΡɤʣ (new)ΡɤΥݥ󥿤ʣʤ

*/			 
tList*  dup_tList_node(tList* node)
{
	tList* pp;
	int	sz;

	if (node==NULL) return NULL;

	sz = sizeof(tList);
	pp = (tList*)malloc(sz);
	if (pp==NULL) return NULL;

	memcpy(pp, node, sz);
	pp->ldat = dup_tListdata(node->ldat);
	pp->next = NULL;
	pp->prev = NULL;
	pp->altp = NULL;
	pp->back = NULL;
	pp->esis = NULL;
	pp->ysis = NULL;

	return pp;
}




/**
tList*  move_tList_node(tList* pp, tList* node)

	ǽ: node򸽺ߤΥꥹȤڤΥppذư롥
		  nodeʤ del_tList_node(), add_tList_node() ¹Ԥ褦ʤΡ

	: pp    -- ưǿƤȤʤΡɤؤΥݥ󥿡
		  node  -- ưΡɤؤΥݥ󥿡

	: ưΡɥΡɤؤΥݥ󥿡
*/
tList*  move_tList_node(tList* pp, tList* node)
{
	if (pp==NULL || node==NULL) return NULL;
    
	if (node->prev!=NULL) node->prev->next = node->next;
	if (node->next!=NULL) node->next->prev = node->prev;

	node->prev = pp;
	node->next = pp->next;
	if (pp->next!=NULL) pp->next->prev = node;
	pp->next   = node;
	
	return node;
}





/**
void	set_tList_node_bydata(tList* pp, tList_data ldat)

	ǽꥹȤΥΡɤͤꤹ롥
		  ldat ϻꤵ줿ΤΤޤ޻Ѥ롥

	: pp   -- ꤹΡɤؤΥݥ󥿡
		  ldat -- ꤹΡɥǡΥǡΤޤ޻Ѥ롥

*/
void	set_tList_node_bydata(tList* node, tList_data dat)
{
	if (node==NULL) return;

	free_tListdata(&(node->ldat));
	node->ldat = dat;
}





/**
void	set_tList_node_bystr(tList* pp, int id, int lv, char* key, char* val, void* ptr, int sz)

	ǽꥹȤΥΡɤͤꤹ롥줾Υǡʣꤵ롥
		  key, val NULLξϡͤϥΡɤꤵʤ

	: id  -- ΡɤID
		  lv  -- ΡɤΥǡ
		  key -- ΡɤΥ				ʣ
		  val -- ΡɤΥǡ 			ʣ
		ptr -- ѥǡؤΥݥ		ʣ
		  sz  -- *ptr Υ

*/
void	set_tList_node_bystr(tList* pp, int id, int lv, char* key, char* val, void* ptr, int sz)
{
	if (pp==NULL) return;

	pp->ldat.id = id;
	pp->ldat.lv = lv;
	pp->ldat.sz = sz;

	if (key!=NULL) {
		free_Buffer(&(pp->ldat.key));
		pp->ldat.key = make_Buffer_bystr(key);
	}
	if (val!=NULL) {
		free_Buffer(&(pp->ldat.val));
		pp->ldat.val = make_Buffer_bystr(val);
	}

	if (sz>0 && ptr!=NULL) {
		if (pp->ldat.ptr!=NULL) free(pp->ldat.ptr);
		pp->ldat.ptr = (void*)malloc(sz);
		if (pp->ldat.ptr!=NULL) memcpy(pp->ldat.ptr, ptr, sz);
	}
}





/**
void	set_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz)

	ǽꥹȤΥΡɤͤꤹ롥줾Υǡʣꤵ롥
		  key.buf, val.buf NULLξϡͤϥΡɤˤꤵʤ

	: id  -- ΡɤID
		  lv  -- ΡɤΥǡ
		  key -- ΡɤΥ	(Buffer)	ʣ
		  val -- ΡɤΥǡ (Buffer)	ʣ
		ptr -- ѥǡؤΥݥ		ʣ
		  sz  -- *ptr Υ

*/
void	set_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz)
{
	if (pp==NULL) return;

	pp->ldat.id = id;
	pp->ldat.lv = lv;

	if (pp->ldat.key.buf!=NULL) {
		free_Buffer(&(pp->ldat.key));
		pp->ldat.key = dup_Buffer(key);
	}

	if (pp->ldat.val.buf!=NULL) {
		free_Buffer(&(pp->ldat.val));
		pp->ldat.val = dup_Buffer(val);
	}

	if (sz>0 && ptr!=NULL) {
		if (pp->ldat.ptr!=NULL) free(pp->ldat.ptr);
		pp->ldat.ptr = (void*)malloc(sz);
		if (pp->ldat.ptr!=NULL) memcpy(pp->ldat.ptr, ptr, sz);
	}
}





/**
tList*	update_tList_node(tList* pp, tList* pt)

	ǽpp pt->keyǸΡɤХΡɤ򥳥ԡ롥̵кǸ˥Ρɤɲä(new)

	: pp -- 򳫻ϤΡɤؤΥݥ󥿡
		  pt -- ꤹΡɤؤΥݥ󥿡 pt->key

	͡ޤɲäΡɤؤΥݥ
*/
tList*	update_tList_node(tList* pp, tList* pt)
{
	tList* pm;
	tList_data ldat;

	if (pt==NULL) return pp;
	
	ldat = pp->ldat;
	pm = update_tList_node_byBuffer(pp, ldat.id, ldat.lv, ldat.key, ldat.val, ldat.ptr, ldat.sz);
	
	return pm;
}





/**
tList*	update_tList_node_bydata(tList* pp, char* srch, tList_data ldat)

	ǽpp srchǸΡɤХΡɤꤹ롥̵кǸ˥Ρɤɲä(new)
		  ldat ϻꤵ줿ΤΤޤ޻Ѥ롥

	: pp   -- 򳫻ϤΡɤؤΥݥ󥿡
		  srch -- 
		  ldat -- ɲäΡɥǡΥǡΤޤ޻Ѥ롥

	͡ޤɲäΡɤؤΥݥ
*/
tList*	update_tList_node_bydata(tList* pp, char* srch, tList_data ldat)
{
	tList* pm = NULL;

	if (pp==NULL || srch==NULL) return NULL;

	pm = strncmp_tList(pp, srch, 0, 1);
	if (pm!=NULL) set_tList_node_bydata(pm, ldat);
	else {
		pm = find_tList_end(pp);
		pm = add_tList_node_bydata(pm, ldat);
	}
	
	return pm;
}





/**
tList*	update_tList_node_bystr(tList* pp, int id, int lv, char* key, char* val, void* ptr, int sz)

	ǽpp keyǸΡɤХΡɤꤹ롥̵кǸ˥Ρɤɲä(new)
		  줾Υǡʣ롥

	: pp  -- 򳫻ϤΡɤؤΥݥ󥿡
		  id  -- ΡɤID
		  lv  -- ΡɤΥǡ
		  key -- ΡɤΥ		ʣ
		  val -- ΡɤΥǡ (Buffer)	ʣ
		ptr -- ѥǡؤΥݥ		ʣ
		  sz  -- *ptr Υ

	͡ޤɲäΡɤؤΥݥ
*/
tList*	update_tList_node_bystr(tList* pp, int id, int lv, char* key, char* val, void* ptr, int sz)
{
	tList* pm = NULL;

	if (pp==NULL || key==NULL) return NULL;

	pm = strncmp_tList(pp, key, 0, 1);
	if (pm!=NULL) {
		set_tList_node_bystr(pm, id, lv, NULL, val, ptr, sz);
	}
	else {
		pm = find_tList_end(pp);
		pm = add_tList_node_bystr(pm, id, lv, key, val, ptr, sz);
	}
	
	return pm;
}





/**
tList*	update_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz)

	ǽpp key.bufǸΡɤХΡɤꤹ롥̵кǸ˥Ρɤɲä(new)
		  줾Υǡʣ롥

	: pp  -- 򳫻ϤΡɤؤΥݥ󥿡
		  id  -- ΡɤID
		  lv  -- ΡɤΥǡ
		  key -- ΡɤΥ   (Buffer)	ʣ
		  val -- ΡɤΥǡ (Buffer)	ʣ
		ptr -- ѥǡؤΥݥ		ʣ
		  sz  -- *ptr Υ

	͡ޤɲäΡɤؤΥݥ
*/
tList*	update_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz)
{
	tList* pm = NULL;

	if (pp==NULL || key.buf==NULL) return NULL;

	pm = strncmp_tList(pp, (char*)key.buf, 0, 1);
	if (pm!=NULL) set_tList_node_byBuffer(pm, id, lv, key, val, ptr, sz);
	else {
		pm = find_tList_end(pp);
		pm = add_tList_node_byBuffer(pm, id, lv, key, val, ptr, sz);
	}
	
	return pm;
}







/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// tiny List
//

/**	
tList*  del_tList(tList** pp) 

	ǽ: ꥹѤλꤷΡɰʹߤΥΡɤ

	: *pp  -- ΡɤؤΥݥ󥿡

	: Ρ(s)ľΥΡɤؤΥݥ󥿡
*/
tList*  del_tList(tList** pp) 
{	
	tList* pt;
	tList* pm;
	tList* pw;

	if (pp==NULL || *pp==NULL) return NULL;

	pt = (*pp)->prev;
	if (pt!=NULL) pt->next = NULL;

	pm = *pp;
	while (pm!=NULL) {
		pw = pm;
		pm = pm->next;
   		free_tListdata(&(pw->ldat));
		free(pw);
	}
	*pp = NULL;

	return pt;
}





/**
void  del_all_tList(tList** pp)

	ǽ: ꥹȤΡɤκ
		  ݥ ppΥΡɤޤꥹΤ롥
		  pp ϤꥹǤСɤؤƤƤɤ

	: *pp  -- 򳫻ϤΡɤؤΥݥ󥿡

	: ʤ
*/
void  del_all_tList(tList** pp)
{
	tList* pm;
	tList* pv;

	if (pp==NULL || *pp==NULL) return;

	pm = *pp;
	pv = (*pp)->prev;

	do {
		pm = del_tList_node(pm);
	} while (pm!=NULL);

	pm = pv;
	while (pm!=NULL) {
		pv = pm->prev;
		del_tList_node(pm);
		pm = pv;
	}

	*pp = NULL;
}





/**
tList*  dup_tList(tList* pp)

	ǽꥹȤʣ롥

*/			 
tList*  dup_tList(tList* pp)
{
	tList* pt;
	tList* pl;
	tList* tt;

	if (pp==NULL) return NULL;

	pt = pl = dup_tList_node(pp);
	pp = pp->next;

	while(pp!=NULL) {
		tt = dup_tList_node(pp);
		pl = add_tList(pl, tt);
		pp = pp->next;
	}

	return pt;
}





/**
tList*  add_tList(tList* pp, tList* pt)

	ǽΡ ppθ ꥹpt 롥
*/
tList*  add_tList(tList* pp, tList* pt)
{
	tList* pe;
	
	if (pt==NULL) return pp;
	if (pp==NULL) return pt;

	pe = find_tList_end(pt);
	if (pp->next!=NULL) pp->next->prev = pe;
	pe->next = pp->next;
	pp->next = pt;
	pt->prev = pp;
	
	return pt;
}





/**
void  print_tList(File* fp, tList* pp)

	ǽ: ꥹȤɽ
		  ݥ ppʹߤƤΥΡɤΥΥХåեɸ२顼Ϥɽ롥

	: fp -- ϤեؤΥݥ󥿡NULLξ stderr
		  pp -- ɽ򳫻ϤΡɤؤΥݥ󥿡

	: ʤ

*/
void  print_tList(FILE* fp, tList* pp)
{
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		while(pp!=NULL) {
			tList_data ld = pp->ldat;
			fprintf(fp, "[%d] [%d] [%s] [%s]\n", ld.id, ld.lv, ld.key.buf, ld.val.buf);
			//if (pp->next!=NULL) print_tList(pp->next);
			pp = pp->next;
		}
	}
	else {
		fprintf(fp, "(List is NULL)\n");
	}
	return;
}





/**
int  count_tList(tList* pp)

	ǽꥹȤ ppΡɰʹߤΥΡɤο롥

	: pp -- ϤΡɤؤΥݥ󥿡

	: Ρɤο
*/
int  count_tList(tList* pp)
{
	int cnt = 0;

	while (pp!=NULL) {
		cnt++;
		pp = pp->next;
	}	
	return cnt;
}






///////////////////////////////////////////////////////////////////////////////////////////
//
// String Compare
//

/**
tList*  strncmp_tList(tList* pl, char* key, int len, int no)

	ǽ: char*ѿˤΡɤΥ
		  ݥ plʹߤΥΡɤ,ʸ keyסʬŪġˤΡɤ⡤
		  noܤˤΤܤФ

	: pl   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- ʸ
		  len  -- 1ʾ: פĹ
					 TLIST_MATCH_COMPLETE   (0): ס
					 TLIST_MATCH_TLISTKEY  (-1): pl->key.buf Ĺ˹碌롥
					 TLIST_MATCH_STRINGKEY (-2): key Ĺ˹碌롥
		  no  -- פʪǲܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tList*  strncmp_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (ex_strncmp((char*)pl->ldat.key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->next;
	}
	return NULL;
}





/**
tList*  strncasecmp_tList(tList* pl, char* key, int len, int no)

	ǽ: char*ѿˤΡɤΥʸʸ̵뤹롥
		  ݥ plʹߤΥΡɤ,ʸ keyסʬŪġˤΡɤ⡤
		  noܤˤΤܤФ

	: pl   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- ʸ
		  len  -- 1ʾ: פĹ
					  0: ס
					 -1: pl->key Ĺ˹碌롥
					 -2: key Ĺ˹碌롥
		  no  -- פʪǲܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tList*  strncasecmp_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (ex_strncasecmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->next;
	}
	return NULL;
}





/**
tList*  strnrvscmp_tList(tList* pl, char* key, int len, int no)

	ǽ: char*ѿˤΡɤΥ
		  ݥ plʹߤΥΡɤ,ʸ keyȸסʬŪġˤΡɤ⡤
		  noܤˤΤܤФ

	: pl   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- ʸ
		  len  -- 1ʾ: פĹ
					  0: ס
					 -1: pl->key Ĺ˹碌롥
					 -2: key Ĺ˹碌롥
		  no  -- פʪǲܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tList*  strnrvscmp_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (ex_strnrvscmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->next;
	}
	return NULL;
}





/**
tList*  strncaservscmp_tList(tList* pl, char* key, int len, int no)

	ǽ: char*ѿˤΡɤΥʸʸ̵롥
		  ݥ plʹߤΥΡɤ,ʸ keyȸסʬŪġˤΡɤ⡤
		  noܤˤΤܤФ

	: pl   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- ʸ
		  len  -- 1ʾ: פĹ
					  0: ס
					 -1: pl->key Ĺ˹碌롥
					 -2: key Ĺ˹碌롥
		  no  -- פʪǲܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tList*  strncaservscmp_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (ex_strncaservscmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->next;
	}
	return NULL;
}





/**
tList*  strstr_tList(tList* pl, char* key, int len, int no)

	ǽ: char*ѿˤΡɤΥ
		  ݥ plʹߤΥΡɤ,ʸޤ keyʸʸ˴ޤޤ
		  Ρɤ⡤noܤˤΤܤФ

	: pl   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- 
		  len  -- >=0: key  plΥ˴ޤޤ뤫ɤ롥
				   <0: plΥ Key˴ޤޤ뤫ɤ롥
		  no  -- פʪǲܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tList*  strstr_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (len>=0) {
			if (strstr((char*)(pl->ldat).key.buf, (char*)key)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}
		else if (len<0) {
			if (strstr((char*)key, (char*)(pl->ldat).key.buf)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}

		pl = pl->next;
	}
	return NULL;
}





/**
tList*  strstrcase_tList(tList* pl, char* key, int len, int no)

	ǽ: char*ѿˤΡɤΥʸʸ̵롥
		  ݥ plʹߤΥΡɤ,ʸޤ keyʸʸ˴ޤޤ
		  Ρɤ⡤noܤˤΤܤФ

	: pl   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- 
		  len  -- >=0: key  plΥ˴ޤޤ뤫ɤ롥
				   <0: plΥ Key˴ޤޤ뤫ɤ롥
		  no  -- פʪǲܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tList*  strstrcase_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (len>=0) {
			if (strstrcase((char*)(pl->ldat).key.buf, (char*)key)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}
		else if (len<0) {
			if (strstrcase((char*)key, (char*)(pl->ldat).key.buf)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}

		pl = pl->next;
	}
	return NULL;
}






///////////////////////////////////////////////////////////////////////////////////////////
//
// String Compare Back List
//

/**
tList*  strncmp_back_tList(tList* pl, char* key, int len, int no)

	ǽ: char*ѿˤΡɤΥ
		  ݥ plʹߤΥΡɤ,ʸ keyסʬŪġˤΡɤ⡤
		   noܤˤΤܤФ

	: pl   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- ʸ
		  len  -- 1ʾ: פĹ
					  0: ס
					 -1: pl->key Ĺ˹碌롥
					 -2: key Ĺ˹碌롥
		  no  -- פʪǸơܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tList*  strncmp_back_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	pl = find_tList_end(pl);
	
	while (pl!=NULL) {
		if (ex_strncmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->prev;
	}
	return NULL;
}





/**
tList*  strncasecmp_back_tList(tList* pl, char* key, int len, int no)

	ǽ: char*ѿˤΡɤΥʸʸ̵뤹롥
		  ݥ plʹߤΥΡɤ,ʸ keyסʬŪġˤΡɤ⡤
		   noܤˤΤܤФ

	: pl   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- ʸ
		  len  -- 1ʾ: פĹ
					  0: ס
					 -1: pl->key Ĺ˹碌롥
					 -2: key Ĺ˹碌롥
		  no  -- פʪǸơܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tList*  strncasecmp_back_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (ex_strncasecmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->prev;
	}
	return NULL;
}





/**
tList*  strnrvscmp_back_tList(tList* pl, char* key, int len, int no)

	ǽ: char*ѿˤΡɤΥ
		  ݥ plʹߤΥΡɤ,ʸ keyȸסʬŪġˤΡɤ⡤
		   noܤˤΤܤФ

	: pl   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- ʸ
		  len  -- 1ʾ: פĹ
					  0: ס
					 -1: pl->key Ĺ˹碌롥
					 -2: key Ĺ˹碌롥
		  no  -- פʪǸơܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tList*  strnrvscmp_back_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (ex_strnrvscmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->prev;
	}
	return NULL;
}





/**
tList*  strncaservscmp_back_tList(tList* pl, char* key, int len, int no)

	ǽ: char*ѿˤΡɤΥʸʸ̵롥
		  ݥ plʹߤΥΡɤ,ʸ keyȸסʬŪġˤΡɤ⡤
		   noܤˤΤܤФ

	: pl   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- ʸ
		  len  -- 1ʾ: פĹ
					  0: ס
					 -1: pl->key Ĺ˹碌롥
					 -2: key Ĺ˹碌롥
		  no  -- פʪǸơܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tList*  strncaservscmp_back_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (ex_strncaservscmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->prev;
	}
	return NULL;
}





/**
tList*  strstr_back_tList(tList* pl, char* key, int len, int no)

	ǽ: char*ѿˤΡɤΥ
		  ݥ plʹߤΥΡɤ,ʸޤ keyʸʸ˴ޤޤ
		  Ρɤ⡤ noܤˤΤܤФ

	: pl   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- 
		  len  -- >=0: key  plΥ˴ޤޤ뤫ɤ롥
				   <0: plΥ Key˴ޤޤ뤫ɤ롥
		  no  -- פʪǸơܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tList*  strstr_back_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (len>=0) {
			if (strstr((char*)(pl->ldat).key.buf, (char*)key)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}
		else if (len<0) {
			if (strstr((char*)key, (char*)(pl->ldat).key.buf)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}

		pl = pl->prev;
	}
	return NULL;
}





/**
tList*  strstrcase_back_tList(tList* pl, char* key, int len, int no)

	ǽ: char*ѿˤΡɤΥʸʸ̵롥
		  ݥ plʹߤΥΡɤ,ʸޤ keyʸʸ˴ޤޤ
		  Ρɤ⡤ noܤˤΤܤФ

	: pl   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- 
		  len  -- >=0: key  plΥ˴ޤޤ뤫ɤ롥
				   <0: plΥ Key˴ޤޤ뤫ɤ롥
		  no  -- פʪǸơܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tList*  strstrcase_back_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (len>=0) {
			if (strstrcase((char*)(pl->ldat).key.buf, (char*)key)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}
		else if (len<0) {
			if (strstrcase((char*)key, (char*)(pl->ldat).key.buf)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}

		pl = pl->prev;
	}
	return NULL;
}







///////////////////////////////////////////////////////////////////////////////////////////

/**
tList*  find_tList_top(tList* pl)

	ǽ: ꥹȤκǽΥΡɤؤõ

	: pl -- 򳫻ϤΡɤؤΥݥ󥿡

	: ꥹȤκǽΥΡɤؤΥݥ󥿡
*/
tList*  find_tList_top(tList* pl)
{
	if (pl==NULL) return NULL;

	while (pl->prev!=NULL) pl = pl->prev;
	return pl;
}





/**
tList*  find_tList_end(tList* pl)

	ǽ: ꥹȤκǸΥΡɤؤõ
		  ꥹȹ¤κǸΥΡɤõؿʤΤǡtTree ¤ŬѤƤ
		Ρɤ򸫤Ĥ뤳ȤϽʤtTreeФƤ find_tTree_end()Ȥȡ

	: pl -- 򳫻ϤΡɤؤΥݥ󥿡

	: ꥹȤκǸΥΡɤؤΥݥ󥿡
*/
tList*  find_tList_end(tList* pl)
{
	if (pl==NULL) return NULL;

	while (pl->next!=NULL) pl = pl->next;
	return pl;
}




/**
Buffer  search_key_tList(tList* list, char* key, int no) 

	ǽꥹȤ椫 noܤ keyΡ(ldat.key)õФldat.valΥԡ֤
		  key ϥ󥻥󥷥ƥ֡

	key  -- إå̡

	͡
			free
*/
Buffer  search_key_tList(tList* list, char* key, int no) 
{
	tList* pp;
	Buffer buf;

	buf = init_Buffer();
	if (list==NULL || key==NULL) return buf;
	
	pp = strncasecmp_tList(list, key, 0, no);		// 
	if (pp!=NULL) {
		buf = dup_Buffer(pp->ldat.val);
	}
	
	return buf;
}





/**
Buffer  search_key_value_tList(tList* list, char* key, char* data, int no) 

	ǽꥹȤ椫 noܤ keyΡɤõФdata ǻϤޤΡ֤ͤ
		  key, dataϥ󥻥󥷥ƥ֡

	key  -- إå̡
	data -- إåͤκǽʸ
*/
Buffer  search_key_value_tList(tList* list, char* key, char* data, int no) 
{
	tList* pp;
	Buffer buf;
	char*  str;
	int	   len;

	buf = init_Buffer();
	if (list==NULL || key==NULL) return buf;

	if (data==NULL) {
		buf = search_key_tList(list, key, no);
		return buf;
	}

	buf = init_Buffer();
	len = strlen(data); 
	
	pp = strncasecmp_tList(list, key, 0, no);
	if (pp!=NULL) {
		str = (char*)pp->ldat.val.buf;
		if (str!=NULL && !strncasecmp(str, data, len)) {
			buf = make_Buffer_bystr(str);
			return buf;
		}
	}

	return buf;
}






/*
int   set_value_tList(tList* list, char* key, int no, char* value, int add_mode)

	ǽꥹ(lt) noܤ keyΡɤͤ valueꤹ롥
		no  0ʲξϡƤ keyΡɤͤФ꤬Ԥ롥
		keyΡɤ¸ߤ mode==ON ξϡꥹȤκǸɲä롥

	
		list   -- оݤΥꥹ
		key    -- ԤΡɤΥ
	 	value  -- ꤵʸ
		no     -- keyפ벿ܤΥΡɤФԤ1롥
				  0ʲξkeyפ뤹٤ƤΥΡɤФԤ
		add_mod - ͤON ĻꤷΡɤ̵硤ΡɤꥹȤκǸɲä롥

	͡
		ꤵ줿Ρɤοꤵ줿Ρɤ¸ߤʤϡɲä줿0
		ξϥ顼

*/
int   set_value_tList(tList* list, char* key, int no, char* value, int add_mode)
{
	int    cn = 0;
	tList* pm;

	if (list==NULL || key==NULL || value==NULL) return -1;

	if (no>0) {
		pm = strncasecmp_tList(list, key, 0, no);
		if (pm!=NULL) {
			int rep = set_value_tList_node(pm, value);
			if (rep) cn = 1;
		}
	}
	else {		// no<=0
		int nn = 1;
		cn = 0;
		pm = strncasecmp_tList(list, key, 0, nn);
		while (pm!=NULL) {
			int rep = set_value_tList_node(pm, value);
			if (rep) cn++;
			pm = strncasecmp_tList(list, key, 0, ++nn);
		}
	}

	// Not Found
	if (add_mode==ON && cn==0) {
		add_tList_node_str(list, key, value);
	}

	return cn;
}





int   set_value_tList_node(tList* lp, char* value)
{
	if (lp==NULL || value==NULL) return FALSE;
	
	Buffer buf = make_Buffer_bystr(value);
	free_Buffer(&lp->ldat.val);
	lp->ldat.val = buf;

	return TRUE;
}





/**
int	 replace_value_tList(tList* list, char* key, int no, char* srcval, char* value)

	ǽꥹ(lt) noܤ keyΡɤͤ srcvalʬ value ֤롥
		no  0ʲξϡƤ keyΡɤͤФ֤Ԥ롥

	
		list   -- оݤΥꥹ
		key    -- ֤ԤΡɤΥ
		srcval -- ֤оݤʸNULLʤꤷܤʸΡ
	 	value  -- ֤Ԥʸ
		no     -- ܤΥΡɤ֤뤫1롥0ʲξkeyפƤΥΡɤ֤

	͡
		ѹ줿Ρɤοꤵ줿Ρɤ¸ߤʤϡɲä줿0
		ξϥ顼

*/
int	 replace_value_tList(tList* list, char* key, int no, char* srcval, char* value)
{
	int	cn = 0;
	tList* pm;

	if (list==NULL || key==NULL || value==NULL) return -1;
	if (srcval==NULL) {
		return set_value_tList(list, key, no, value, OFF);
	}

	if (no>0) {
		pm = strncasecmp_tList(list, key, 0, no);
		if (pm!=NULL) {
			int rep = replace_value_tList_node(pm, srcval, value);
			if (rep) cn = 1;
		}
	}
	else {	  // no<=0
		int nn = 1;
		cn = 0;
		pm = strncasecmp_tList(list, key, 0, nn);
		while (pm!=NULL) {
			int rep = replace_value_tList_node(pm, srcval, value);
			if (rep) cn++;
			pm = strncasecmp_tList(list, key, 0, ++nn);
		}
	}
	
	return cn;
}





int	 replace_value_tList_node(tList* lp, char* srcval, char* value)
{
	if (lp==NULL || value==NULL) return FALSE;
	if (srcval==NULL) {
		return set_value_tList_node(lp, value);
	}

	Buffer buf = replace_sBuffer(lp->ldat.val, srcval, value);
	free_Buffer(&lp->ldat.val);
	lp->ldat.val = buf;
	
	return TRUE;
}
	







tList*	awk_tList(char* str, char cc)
{
	int    nn = 1;
	char*  item;
	tList* lp = NULL;

	if (str==NULL) return NULL;

	item = awk(str, cc, nn);
	while (item!=NULL) {
		lp = add_tList_node_bystr(lp, nn, 0, item, NULL, NULL, 0);
		free(item);
		item = awk(str, cc, ++nn);
	}

	if (lp!=NULL) lp = find_tList_top(lp);
	return lp;
}





tList*	cawk_tList(char* str, char cc)
{
	int    nn = 1;
	char*  item;
	tList* lp = NULL;

	if (str==NULL) return NULL;

	item = cawk(str, cc, nn);
	while (item!=NULL) {
		lp = add_tList_node_bystr(lp, nn, 0, item, NULL, NULL, 0);
		free(item);
		item = cawk(str, cc, ++nn);
	}

	if (lp!=NULL) lp = find_tList_top(lp);
	return lp;

}




tList*	awk_Buffer_tList(Buffer buf, char cc)
{
	int    nn = 1;
	Buffer item;
	tList* lp = NULL;

	if (buf.buf==NULL) return NULL;

	item = awk_Buffer(buf, cc, nn);
	while (item.buf!=NULL) {
		lp = add_tList_node_bystr(lp, nn, 0, (char*)item.buf, NULL, NULL, 0);
		free_Buffer(&item);
		item = awk_Buffer(buf, cc, ++nn);
	}

	if (lp!=NULL) lp = find_tList_top(lp);
	return lp;
}





tList*	cawk_Buffer_tList(Buffer buf, char cc)
{
	int    nn = 1;
	Buffer item;
	tList* lp = NULL;

	if (buf.buf==NULL) return NULL;

	item = cawk_Buffer(buf, cc, nn);
	while (item.buf!=NULL) {
		lp = add_tList_node_bystr(lp, nn, 0, (char*)item.buf, NULL, NULL, 0);
		free_Buffer(&item);
		item = cawk_Buffer(buf, cc, ++nn);
	}

	if (lp!=NULL) lp = find_tList_top(lp);
	return lp;

}





char*  get_str_join_tList(tList* lp, char* deli)
{
	Buffer buf = get_Buffer_join_tList(lp, deli);
	return (char*)buf.buf;
}






Buffer  get_Buffer_join_tList(tList* lp, char* deli)
{
	Buffer buf;
	
	buf = init_Buffer();
	if (lp==NULL) return buf;

	buf = make_Buffer(LBUF);

	if (lp!=NULL && lp->ldat.key.buf!=NULL) {
		cat_s2Buffer((char*)lp->ldat.key.buf, &buf);
		lp = lp->next;

		while (lp!=NULL && lp->ldat.key.buf!=NULL) {
			if (deli!=NULL) cat_s2Buffer(deli, &buf);
			cat_s2Buffer((char*)lp->ldat.key.buf, &buf);
			lp = lp->next;
		}
	}

	return buf;
}









//////////////////////////////////////////////////////////////////////////
// for Configuration File
//

char*  get_strparam_tList(tList* lt, char* key, char* dflt)
{
	Buffer buf;

	buf = search_key_tList(lt, key, 1);
	if (buf.buf!=NULL) return (char*)buf.buf;
	
	return dflt;
}




int  get_intparam_tList(tList* lt, char* key, int dflt)
{
	Buffer buf;

	buf = search_key_tList(lt, key, 1);
	if (buf.buf!=NULL) {
		int ret = atoi((char*)buf.buf);
		free_Buffer(&buf);
		return ret;
	}
	return dflt;
}









/////////////////////////////////////////////////////////////////////////////
//
// Tiny List File I/O
//

/**
tList*  read_tList_file(char* fname, int mode) 

	ǽե뤫ԤŤɤ߹ǥꥹȤΥ˳Ǽ
		  ԤϥꥹȤ˲äʤ

	fname -- ե̾ 
		  mode  -- 0 ξ硤ե򤽤Τޤɤ߹ࡥ
			 	   1 ξ硤Ƭ # ιԤϥꥹȤ˲äʤޤζ¾Ϣ³1ĤζѴ롥
				   ˥֤ϰĤζȤƽ롥

	͡ǼꥹȤؤΥݥ󥿡
*/
tList*  read_tList_file(char* fname, int mode) 
{
	tList* lp = NULL;
	FILE* fp;

	fp = fopen(fname, "rb");
	if (fp!=NULL) {
		lp = read_tList_fp(fp, mode);
		fclose(fp);
	}
	else {
		//DEBUG_MODE print_message("READ_TLIST_FILE: cannot file open [%s]\n", fname);
	}

	return lp;
}






/**
tList*  read_tList_fp(FILE* fp, int mode) 

	ǽեݥ󥿤ե뤫ԤŤɤ߹ǥꥹȤΥ˳Ǽ
		  ԤϥꥹȤ˲äʤ

	fp   -- եݥ󥿡 
		  mode -- 0 ξ硤ե򤽤Τޤɤ߹ࡥ
				  1 ξ硤Ƭ # ιԤϥꥹȤ˲äʤޤζ
				¾Ϣ³1ĤζѴ롥
				  ޤ֤ϰĤζȤƽ롥

	͡ǼꥹȤؤΥݥ󥿡

	Хǥ쥯ȥɤޤȡäƤʤ

*/
tList*  read_tList_fp(FILE* fp, int mode) 
{
	char	val[LBUF+1];
	char*   str;
	tList*   lp = NULL;
	tList*   lt = NULL;

	if (fp==NULL) return NULL;

	fgets(val, LBUF, fp);
	while (!feof(fp)) {
		if (mode>0) str = pack_char(val, ' ');
		else {
			str = (char*)malloc(LBUF+1);
			if (str!=NULL) strncpy(val, str, LBUF);
		}
		if (str!=NULL) {
			if (strlen(str)>0) {	// ԤΥå
				if (mode==0 || str[0]!='#') {
					lt = add_tList_node_str(lt, str, NULL);
					if (lp==NULL) lp = lt;
				}
			}
			free(str);
		}
		fgets(val, LBUF, fp);
	}
	
	return lp;
}





/**
tList*  read_index_tList_file(char* fname, char deli) 

	ǽե뤫ԤŤɤ߹ǡdeliڤʸˤƥꥹȤΥȥǡ˳Ǽ
		  ԤϥꥹȤ˲äʤ#ǻϤޤԤϥꥹȤ˲äʤ

	fname -- ե̾ 
		  deli  -- ڤʸ

	͡ǼꥹȤؤΥݥ󥿡
*/
tList*  read_index_tList_file(char* fname, char deli) 
{
	tList* lp = NULL;
	FILE* fp;

	fp = fopen(fname, "rb");
	if (fp!=NULL) {
		lp = read_index_tList_fp(fp, deli);
		fclose(fp);
	}
	return lp;
}





/**
tList*  read_index_tList_file(char* fname, char deli) 

	ǽե뤫ԤŤɤ߹ǡdeliڤʸˤƥꥹȤΥȥǡ˳Ǽ
		  ԤϥꥹȤ˲äʤ#ǻϤޤԤϥꥹȤ˲äʤ

	fp	-- եݥ󥿡 
		  deli  -- ڤʸ

	͡ǼꥹȤؤΥݥ󥿡
*/
tList*  read_index_tList_fp(FILE* fp, char deli)
{
	Buffer key, val;
	tList* pl;
	tList* pp;
	tList* lt = NULL;

 	pp = pl = read_tList_fp(fp, 1);
	while (pp!=NULL) {
		key = awk_Buffer(pp->ldat.key, deli, 1);
		val = awk_Buffer(pp->ldat.key, deli, 2);
			
		if (lt==NULL) lt = add_tList_node_byBuffer(NULL, 0, 0, key, val, NULL, 0);
		else               add_tList_node_byBuffer(lt,   0, 0, key, val, NULL, 0);
	
		free_Buffer(&key);
		free_Buffer(&val);
		
		pp = pp->next;
	}
	del_all_tList(&pl);

	return lt;
}





/**
tList*  read_Buffer_tList_file(char* fname) 

	ǽե뤫 Bufferѿ򣲤ĤŤɤ߹ǡꥹȤΥȥХåե˳Ǽ֤

	fname -- ե̾ 

	͡ǼꥹȤؤΥݥ󥿡
*/
tList*  read_Buffer_tList_file(char* fname) 
{
	tList* lp = NULL;
	FILE* fp;

	fp = fopen(fname, "rb");
	if (fp!=NULL) {
		lp = read_Buffer_tList_fp(fp);
		fclose(fp);
	}
	return lp;
}






/**
tList*  read_Buffer_tList_fp(FILE* fp) 

	ǽե뤫 Bufferѿ򣲤ĤŤɤ߹ǡꥹȤΥȥХåե˳Ǽ֤

	fp   -- եݥ󥿡 

	͡ǼꥹȤؤΥݥ󥿡

*/
tList*  read_Buffer_tList_fp(FILE* fp) 
{
	int	cc;
	tList*  lp = NULL;
	tList*  lt = NULL;
	Buffer key, val;

	if (fp==NULL) return NULL;

	cc = read_Buffer2_fp(&key, &val, fp);
	while (!feof(fp) && cc) {
		lt = add_tList_node_Buffer(lt, key, val);
		if (lp==NULL) lp = lt;
		free_Buffer(&key);	
		free_Buffer(&val);	
		cc = read_Buffer2_fp(&key, &val, fp);
	}
	
	free_Buffer(&key);	
	free_Buffer(&val);	
	return lp;
}





/**
int  save_Buffer_tList_file(char* fname, tList* lp) 

	ǽꥹȤΥȥХåե Bufferѿեؽ񤭹
		  ե뤬ˤϡɲý񤭹ߤ롥

	fname -- ե̾ 

	͡TRUE   񤭹
			FALSE  񤭹߼
*/
int  save_Buffer_tList_file(char* fname, tList* lp) 
{
	int   ret=FALSE;
	FILE* fp;

	fp = fopen(fname, "ab");
	if (fp!=NULL) {
		ret = save_Buffer_tList_fp(fp, lp);
		fclose(fp);
	}
	return ret;
}






/**
int   save_Buffer_tList_fp(FILE* fp, tList* lp) 

	ǽꥹȤΥȥХåե Bufferѿեؽ񤭹
		  ե뤬ˤϡɲý񤭹ߤ롥

	fp   -- եݥ󥿡 

	͡TRUE   񤭹
			FALSE  񤭹߼

*/
int   save_Buffer_tList_fp(FILE* fp, tList* lp) 
{
	int cc=TRUE;

	if (fp==NULL) return FALSE;

	while (lp!=NULL && cc) {
		cc = save_Buffer2_fp(lp->ldat.key, lp->ldat.val, fp);	
		lp = lp->next;
	}

	if (!cc) return FALSE;
	return TRUE;
}









/////////////////////////////////////////////////////////////////////////////////////////////////////
/**

	Tiny Tree Graph



*/

/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Ρ
//

/**
tTree*  new_tTree_node(void)

	ǽ: ĥ꡼ѤζΡɤưŪ

	: 줿ΡɤؤΥݥ󥿡

	#define new_tTree_node()     new_tList_node()

*/





/**
tTree   make_tTree_node(tList_data ldat)

	ǽ: ĥ꡼ѥΡɤŪ

	: ldat  -- Ρɥǡ

	: 줿Ρɡ

	#define make_tTree_node(d)     make_tList_node(d)
*/





/**
tTree*  add_tTree_node(tTree* pp, tTree* node) 

	ǽ: ĥ꡼ ppإΡ nodeɲáݥ ppؤΡɤλҥΡɤȤ nodeʤΤΡˤɲä롥
		  node ҥΡɤľϡɲä롥
		  node ΡɤäƤƤ⤽̵뤹롥

	: pp    -- ɲäΡɤοƤȤʤΡɤؤΥݥ󥿡
		  node  -- ɲäΡɤؤΥݥ󥿡node->next ʲĥ꡼Ǥɤ
		   
	: ɲäΡɤؤΥݥ󥿡Ԥ NULL
*/
tTree*  add_tTree_node(tTree* pp, tTree* node) 
{
	if (node==NULL) return NULL;
	if (pp==NULL) return node;

	node->prev = pp;
	node->ysis = NULL;
	node->esis = pp->back;

	if (pp->back!=NULL) pp->back->ysis = node;
	if (pp->next==NULL) pp->next = node;
	pp->back = node;

	node->depth = pp->depth + 1;
	pp->num++;
	
	if (node->next!=NULL) {
		node->next->depth = node->depth + 1;
		adjust_tTree_depth(node->next);
	}

	return node;
}





/**
tTree*  add_tTree_node_bydata(tTree* pp, tList_data ldat) 

	ǽ: ǡ TreeΡɤĤФ, ppλҥΡɤȤɲá
		  ldat ϻꤵ줿ΤΤޤ޻Ѥ롥

	: pp   -- ɲäΡɤοƤȤʤΡɤؤΥݥ󥿡
		  ldat -- ɲäΡɥǡΥǡΤޤ޻Ѥ롥
		   
	: ɲäΡɤؤΥݥ󥿡
*/
tTree*  add_tTree_node_bydata(tTree* pp, tList_data ldat) 
{
	tTree* pt;

	pt = new_tTree_node();
	pt->ldat  = ldat;
	pt->depth = 1;

	if (pp==NULL) return pt;

	pt->prev = pp;
	pt->esis = pp->back;

	if (pp->back!=NULL) pp->back->ysis = pt;
	if (pp->next==NULL) pp->next = pt;
	pp->back = pt;

	pt->depth = pp->depth + 1;
	pp->num++;
	
	return pt;
}





/**
tTree*  add_tTree_node_byBuffer(tTree* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 

	ǽ: ǡΡɤĤФ,ꥹȤɲá
		  ꥹȥݥ ppؤΡɤθˤĤФ Ρɤ롥

	: pp  -- ɲäμΥΡɤؤΥݥ󥿡
		  id  -- ɲäǡ
		  lv  -- ɲäǡ
		  key -- ɲäǡ		ʣ
		  val -- ɲäǡ		ʣ
		ptr -- ѥǡؤΥݥ	ʣ
		  sz  -- *ptr Υ
		   
	: ɲäΡɤؤΥݥ󥿡
*/
tTree*  add_tTree_node_byBuffer(tTree* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 
{
	tTree* pt;
	tList_data ldat;

	ldat = make_tListdata(id, lv, key, val, ptr, sz);
	pt   = add_tTree_node_bydata(pp, ldat);

	return pt;
}





/**
tTree*  add_tTree_node_bystr(tTree* pp, int id, int lv, char* key, char* val, void* ptr, int sz) 

	ǽ: ǡΡɤĤФ,ꥹȤɲá
		  ꥹȥݥ ppؤΡɤθˤĤФ Ρɤ롥

	: pp  -- ɲäμΥΡɤؤΥݥ󥿡
		  id  -- ɲäǡ
		  lv  -- ɲäǡ
		  key -- ɲäǡ		ʣ
		  val -- ɲäǡ		ʣ
		ptr -- ѥǡؤΥݥ	ʣ
		  sz  -- *ptr Υ
		   
	: ɲäΡɤؤΥݥ󥿡
*/
tTree*  add_tTree_node_bystr(tTree* pp, int id, int lv, char* key, char* val, void* ptr, int sz) 
{
	tTree* pt;
	tList_data ldat;

	ldat = make_tListdata_bystr(id, lv, key, val, ptr, sz);
	pt   = add_tTree_node_bydata(pp, ldat);

	return pt;
}





/**	
tTree*  free_tTree_node(tTree* node) 

	ǽ: ΡɤΥХåե(ǡ)γ

	: node  -- ΡɤؤΥݥ󥿡

	#define free_tTree_node(p)    free_tList_node(p)
*/





/**	
tTree*  del_tTree_node(tTree** node) 

	ǽ: ĥ꡼Ρɤκ줿ΡɤҥΡɤľϡλҥΡ
		ʾ夲ڹ¤ͤ
		  node ưŪ˳ݤ줿ѿǤʤФʤʤ

	: *node  -- ΡɤؤΥݥ󥿡

	: Ρɤ˵ͤ줿ҥΡɤؤΥݥ󥿡
			⤷ΡɤʤʺΡɤҥΡɤʤ˾ NULL
*/
tTree*  del_tTree_node(tTree** node) 
{
	tTree* pp = NULL;

	if (node==NULL || *node==NULL) return pp;

	if ((*node)->next!=NULL) {	// 	ҥΡɤľ
		tTree* ss;
		(*node)->next->depth--;
		adjust_tTree_depth((*node)->next);

		ss = (*node)->next;
		ss->prev = (*node)->prev;
		while (ss->ysis!=NULL) {
			ss = ss->ysis;
			ss->prev = (*node)->prev;
		} 

		ss->ysis = (*node)->ysis;
		(*node)->next->esis = (*node)->esis;
		if ((*node)->ysis!=NULL) (*node)->ysis->esis = ss;
		if ((*node)->esis!=NULL) (*node)->esis->ysis = (*node)->next;

		if ((*node)->prev!=NULL) {
			if ((*node)->prev->next==(*node)) (*node)->prev->next = (*node)->next;
			if ((*node)->prev->back==(*node)) (*node)->prev->back = ss;
		}
	}

	else {					// ҥΡɤʤ
		if ((*node)->prev!=NULL) {
			if ((*node)->prev->next==(*node)) (*node)->prev->next = (*node)->ysis;
			if ((*node)->prev->back==(*node)) (*node)->prev->back = (*node)->esis;
		}
		if ((*node)->ysis!=NULL) (*node)->ysis->esis = (*node)->esis;
		if ((*node)->esis!=NULL) (*node)->esis->ysis = (*node)->ysis;
	}

	pp = (*node)->prev;
  	free_tListdata(&((*node)->ldat));
	if ((*node)->prev!=NULL) (*node)->prev->num += (*node)->num - 1;

	free(*node);
	*node = NULL;

	return pp;
}




/**	
tTree*  move_tTree_node(tTree* pp, tTree* node) 

	ǽ: node򸽺ߤΥĥ꡼ڤΥppذư롥
		Υĥ꡼˱ơnodeҥΡɤľϡλҥΡɤʾ夲ڹ¤ͤ
		  ư˱Ƥϡnode ΡɤäƤƤ⤽̵뤹롥
		  nodeʤ del_tTree_node(), add_tTree_node() ¹Ԥ褦ʤΡ

	: pp    -- ưǿƤȤʤΡɤؤΥݥ󥿡
		  node  -- ưΡɤؤΥݥ󥿡node->next ʲĥ꡼Ǥɤ

	: ưΡɥΡɤؤΥݥ󥿡
*/
tTree*  move_tTree_node(tTree* pp, tTree* node) 
{
	if (node==NULL || pp==NULL) return NULL;

	// ΡɤڤΥ
	if (node->next!=NULL) {	// 	ҥΡɤľ
		tTree* ss;
		node->next->depth--;
		adjust_tTree_depth(node->next);

		ss = node->next;
		ss->prev = node->prev;
		while (ss->ysis!=NULL) {
			ss = ss->ysis;
			ss->prev = node->prev;
		} 

		ss->ysis = node->ysis;
		node->next->esis = node->esis;
		if (node->ysis!=NULL) node->ysis->esis = ss;
		if (node->esis!=NULL) node->esis->ysis = node->next;

		if (node->prev!=NULL) {
			if (node->prev->next==node) node->prev->next = node->next;
			if (node->prev->back==node) node->prev->back = ss;
		}
	}
	else {					// ҥΡɤʤ
		if (node->prev!=NULL) {
			if (node->prev->next==node) node->prev->next = node->ysis;
			if (node->prev->back==node) node->prev->back = node->esis;
		}
		if (node->ysis!=NULL) node->ysis->esis = node->esis;
		if (node->esis!=NULL) node->esis->ysis = node->ysis;
	}
	if (node->prev!=NULL) node->prev->num += node->num - 1;


	// ΡɤκƷʰư
	node->prev = pp;
	node->ysis = NULL;
	node->esis = pp->back;

	if (pp->back!=NULL) pp->back->ysis = node;
	if (pp->next==NULL) pp->next = node;
	pp->back = node;

	node->depth = pp->depth + 1;
	pp->num++;
	
	if (node->next!=NULL) {
		node->next->depth = node->depth + 1;
		adjust_tTree_depth(node->next);
	}

	return node;
}





/**
void  replace_all_tTree_node(tTree* pp, char* key, char* src, char* dst, int len)

	ǽĥ꡼ pp key򥭡srcΡͤȤƻƤΥΡɤΥΡͤ dst ˽񤭴롥

	tp  -- ִоݤΥĥ꡼
		  key -- 
		  src -- ִоݤΥΡ
		  dst -- ִΥΡ
		  len -- 1ʾ: פĹ
					 0: ס
					-1: ĥ꡼ΥͤĹ˹碌롥
					-2:  key Ĺ˹碌롥

	֤͡Ρɤο

*/
int  replace_all_tTree_node(tTree* tp, char* key, char* src, char* dst, int len)
{
	int nn = 0;

	do { 
		if (ex_strncmp((char*)(tp->ldat).key.buf, (char*)key, len)) {
			if (ex_strncmp((char*)(tp->ldat.val.buf), (char*)src, len)) {
				free_Buffer(&(tp->ldat.val));
				tp->ldat.val = make_Buffer_bystr(dst);
				nn++;
			}
		}

		if (tp->next!=NULL) nn += replace_all_tTree_node(tp->next, key, src, dst, len);

		tp = tp->ysis;
	} while(tp!=NULL);

	return nn;
}







/////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// ĥ꡼
//

/**
tTree*  del_tTree(tTree** pp) 

	ǽꤷΡɰʲΥĥ꡼롥

	*pp -- ĥ꡼ƬΡ

	͡ĥ꡼οƥΡɤؤΥݥ󥿡

*/
tTree*  del_tTree(tTree** pp) 
{
	tTree* pt;

	if (pp==NULL || *pp==NULL) return NULL;

	// ҥΡɤκ
	if ((*pp)->next!=NULL) del_sisters_children_tTree(&((*pp)->next));

	// ʬȤκ
	pt = (*pp)->prev;
	if (pt!=NULL) {
		if (pt->next==*pp) pt->next = (*pp)->ysis;
		if (pt->back==*pp) pt->back = (*pp)->esis;
		pt->num--;
	}
	if ((*pp)->ysis!=NULL) (*pp)->ysis->esis = (*pp)->esis;
	if ((*pp)->esis!=NULL) (*pp)->esis->ysis = (*pp)->ysis;

  	free_tListdata(&((*pp)->ldat));
	free(*pp);
	*pp = NULL;

	return pt;
}





/**
tTree*  del_children_tTree(tTree** pp) 

	ǽꤷΡɤλҥĥ꡼롥ꤷΡɤϺʤ

	*pp -- ҥĥ꡼οƥΡ

	͡ĥ꡼οƥΡɤؤΥݥ󥿡*pp Τޤ֤롥

*/
tTree*  del_children_tTree(tTree** pp) 
{	
	if (pp==NULL || *pp==NULL) return NULL;

	if ((*pp)->next!=NULL) del_sisters_children_tTree(&((*pp)->next));

	(*pp)->num  = 0;
	(*pp)->next = NULL;
	(*pp)->back = NULL;

	return *pp;
}





/**
tTree*  del_sisters_children_tTree(tTree** pp) 

	ǽꤷΡɤλĥ꡼ҥĥ꡼롥
		  ꤷΡɤ롥

	*pp -- ĥ꡼εΡ

	͡ĥ꡼οƥΡɤؤΥݥ󥿡

	˺ƵѡƥΡɤФϹԤʤΤǡӸƤӽФ¦ǹԤȡ

*/
tTree*  del_sisters_children_tTree(tTree** pp) 
{
	tTree* pm;
	tTree* pt;

	if (pp!=NULL || *pp==NULL) return NULL;
	pt = (*pp)->prev;

	pm = *pp;
	while (pm->esis!=NULL) pm = pm->esis;
	while (pm!=NULL) {
		tTree* pw = pm;
		if (pm->next!=NULL) del_sisters_children_tTree(&(pm->next)); 
		pm = pm->ysis;

  		free_tListdata(&(pw->ldat));
		free(pw);
	}

	*pp = NULL;

	return pt;
}





/**
void  del_all_tTree(tTree** pp)

	ǽ: ĥ꡼Ρɤκ
		  ݥ ppΥΡɤޤĥ꡼Τ롥
		  *pp ϥĥ꡼ǤСɤؤƤƤɤ

	: *pp -- 򳫻ϤΡɤؤΥݥ󥿡
		   		 ĥ꡼ǤСɤؤƤƤɤ

	: ʤ
*/
void  del_all_tTree(tTree** pp)
{
	tTree* pm;

	if (pp==NULL || *pp==NULL) return;

	pm = *pp;
	while (pm->prev!=NULL) pm = pm->prev;
	del_tTree(&pm);

	*pp = NULL;
	return;
}






/**
tTree*  add_tTree(tTree* tp, tTree* tt)

	ǽ: ĥ꡼ tp ĥ꡼ ttɲá
		  add_tTree_node() Ȥϡadd_tTree()Ƭ(tt)λΡɤĥ꡼ tpɲäˤ롥

	: tp  -- ɲäĥ꡼οƤȤʤΡɤؤΥݥ󥿡
		  tt  -- ɲäĥ꡼ؤΥݥ󥿡
		   
	: ɲäĥ꡼ΥΡɤؤΥݥ󥿡Ԥ NULL
*/
tTree*  add_tTree(tTree* tp, tTree* tt)
{
	int	nn;
	tTree* tm;
	tTree* tw;

	if (tt==NULL) return NULL;
	if (tp==NULL) return tt;

	while(tt->esis!=NULL) tt = tt->esis;
	tt->esis = tp->back;
	if (tp->back!=NULL) tp->back->ysis = tt;
	if (tp->next==NULL) tp->next = tt;

	nn = 0;
	tm = tw = tt;
	while (tm!=NULL) {
		nn++;
		tm->prev  = tp;
		tm->depth = tp->depth + 1;

		if (tm->next!=NULL) {
			tm->next->depth = tm->depth + 1;
			adjust_tTree_depth(tm->next);
		}
		tw = tm;
		tm = tm->ysis;
	}

	tp->back = tw;
	tp->num += nn;

	return tt;
}





/**
tTree*  div_tTree(tTree* tp, tTree* tt)

	ǽ: ĥ꡼ tp  ĥ꡼ ttʬΥ롥

	: tt -- ĥ꡼ؤʬΥݥȡ
		   
	: ʬΥĥ꡼θƥΡɤؤΥݥ󥿡Ԥ NULL
*/
tTree*  div_tTree(tTree* tt)
{
	if (tt==NULL) return NULL;
	if (tt->prev==NULL) return tt;

	if (tt->prev->next==tt) tt->prev->next = tt->ysis;
	if (tt->prev->back==tt) tt->prev->back = tt->esis;

	if (tt->ysis!=NULL) tt->ysis->esis = tt->esis;
	if (tt->esis!=NULL) tt->esis->ysis = tt->ysis;

	tt->depth = 1;
	if (tt->next!=NULL) {
		tt->next->depth = 2;
		adjust_tTree_depth(tt->next);
	}

	tt->prev->num--;
	tt->prev = NULL;

	return tt;
}





/**
tTree*  dup_merge_tTree(tTree* pp, tTree* tp)

	ǽĥ꡼ ppľ˥ĥ꡼ tpʣ롥
		  pp NULLξϡĥ꡼οĴʤ

	pp -- ʣ줿ĥ꡼ΥȥåפȤʤΡ
		  tp -- ʣĥ꡼

	͡ʣ줿ĥ꡼ؤΥݥ󥿡
			pp NULLǤʤ pp
			pp NULLξϡʣĥ꡼Υȥåס

*/			 
tTree*  dup_merge_tTree(tTree* pp, tTree* tp)
{
	if (tp==NULL) return pp;

	if (pp!=NULL) {
		while(tp->esis!=NULL) tp = tp->esis;
		while(tp!=NULL) {
			tTree* pt = dup_tList_node(tp);
			pt->next = pt->prev = pt->back = pt->ysis = pt->esis = NULL;
			add_tTree(pp, pt);
			if (tp->next!=NULL) dup_merge_tTree(pt, tp->next);
			tp = tp->ysis;
		}		
	}
	else {
		pp = dup_tList_node(tp);
		pp->next = pp->prev = pp->back = pp->ysis = pp->esis = NULL;
		if (tp->next!=NULL) dup_merge_tTree(pp, tp->next);
	}

	return pp;
}







/**
void  merge_tTree(tTree* tp, tTree* tt)

	ǽĥ꡼ tp ˥ĥ꡼ tt 礹롥塤tt Ƥϲ(tpȥΡɤ򴹤ˤʤ)
		  tt  tpΰƱ¤()ľ硤üΡɤ ttΥΡɤ֤롥
		  tp ¸ߤʤޤɲä롥
		  ĥ꡼ο tp򿼤򸵤˺Ʒ׻롥
		  
	tp -- tt ηݥ
		tt -- 礹ĥ꡼

	͡tp -- Υĥ꡼
			tt -- 롥

	----------------------------------------------------------------
	㡧	tp							tr
			A --> B --> M				A --> B --> X
			  --> C --> M --> X			  --> C --> M
						  --> Y			  --> D
					--> N

		ξ硤merge_tTree(tp, tr) ¹ԤȰʲΤ褦ˤʤ롥

			tp
			A --> B --> M 
					--> X (tr)
			  --> C --> M (tr)
					--> N 
			  --> D (tr)

			tt
			A --> B 
			  --> C --> M --> X (tp)
						  --> Y (tp)
*/
void  merge_tTree(tTree* tp, tTree* tt)
{
	tTree* tl;
	tTree* nt;
	tTree* nl;
	int	depth;

	if (tp==NULL || tt==NULL) return;

	depth = tp->depth;
	tl = tp;
	while (tt!=NULL) {
		if ((tt->ldat).key.buf==NULL) return;
		if (tl!=NULL && (tl->ldat).key.buf==NULL) return;
		while (tl!=NULL && strcmp((char*)((tl->ldat).key.buf), (char*)((tt->ldat).key.buf))) tl = tl->ysis;

		nt = tt;
		nl = tl;
		tt = tt->ysis;

		if (tl==NULL) {	
			div_tTree(nt);
			add_tTree(tp->prev, nt);
			tl = nt;
			return;
		}
		else if (nl->next!=NULL && nt->next!=NULL) {
			merge_tTree(nl->next, nt->next);
			tl = tl->ysis;
		}
		else {
			tl = tl->ysis;
			exchange_tTree(nl, nt);
		}
	}

	tp->depth = depth;
	adjust_tTree_depth(tp);

	return;
}





/**
void  exchange_tTree(tTree* tl, tTree* tt)

	ǽĥ꡼ tl ĥ꡼ tt򴹤롥

	tl -- оݤΥĥ꡼
		  tt -- оݤΥĥ꡼

	͡ʤ

*/
void  exchange_tTree(tTree* tl, tTree* tt)
{
	int	dt = tt->depth;
	tTree* pt = tt->prev;
	tTree* yt = tt->ysis;
	tTree* et = tt->esis;


	if (tl->esis!=NULL) tl->esis->ysis = tt;
	if (tl->ysis!=NULL) tl->ysis->esis = tt;
	if (tl->prev!=NULL) {
		if (tl->prev->next==tl) tl->prev->next = tt;
		if (tl->prev->back==tl) tl->prev->back = tt;
	}

	tt->ysis  = tl->ysis;
	tt->esis  = tl->esis;
	tt->prev  = tl->prev;
	tt->depth = tl->depth;
	if (tt->next!=NULL) {
		tt->next->depth = tt->depth + 1;
		adjust_tTree_depth(tt->next);
	}


	if (et!=NULL) et->ysis = tl;
	if (yt!=NULL) yt->esis = tl;
	if (pt!=NULL) {
		if (pt->next==tt) pt->next = tl;
		if (pt->back==tt) pt->back = tl;
	}

	tl->ysis  = yt;
	tl->esis  = et;
	tl->prev  = pt;
	tl->depth = dt;
	if (tl->next!=NULL) {
		tl->next->depth = dt + 1;
		adjust_tTree_depth(tl->next);
	}
}





/**
void   adjust_tTree_depth(tTree* pp)

	ǽꤷΡ ppˤơڤο¬ľ

	pp -- ȤʤΡɤؤΥݥ

*/
void   adjust_tTree_depth(tTree* pp)
{
	int depth;
	tTree* pt;
	
	if (pp==NULL) return;

	depth = pp->depth;
	pt = pp;
	while (pt->ysis!=NULL) {
		pt = pt->ysis;
		pt->depth = depth;
		if (pt->next!=NULL) {
			pt->next->depth = depth + 1;
			adjust_tTree_depth(pt->next);
		}
	}

	pt = pp;
	while (pt->esis!=NULL) {
		pt = pt->esis;
		pt->depth = depth;
		if (pt->next!=NULL) {
			pt->next->depth = depth + 1;
			adjust_tTree_depth(pt->next);
		}
	}

	if (pp->next!=NULL) {
		pp->next->depth = depth + 1;
		adjust_tTree_depth(pp->next);
	}

	return;
}





/**
void   print_tTree(FILE* fp, tTree* pp, char* space)

	ǽ: ĥ꡼ɽ
		  ݥ ppʹߤƤΥΡɤΥΥХåեɸ२顼Ϥɽ롥

	: fp    -- ϤեؤΥݥ󥿡NULLξ stderr
		  pp	-- ɽ򳫻ϤΡɤؤΥݥ󥿡
		  space -- Ϥν񼰤·뤿ζ

	: ʤ

*/
void   print_tTree(FILE* fp, tTree* pp, char* space)
{
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		while(pp->esis!=NULL) pp = pp->esis;
		do { 
			int i;
			tList_data ld = pp->ldat;

			if (pp->depth>1) fprintf(fp, " -> ");
			fprintf(fp, "%d: %d %d %s %s", pp->depth, ld.id, ld.lv, ld.key.buf, ld.val.buf);
			//fprintf(fp, "%d: %d %d %s %s, %04x", pp->depth, ld.id, ld.lv, ld.key.buf, ld.val.buf, pp->altp);

			if (pp->next!=NULL) print_tTree(fp, pp->next, space);
			else fprintf(fp, "\n");

			pp = pp->ysis;
			if (pp!=NULL) {
				for(i=1; i<pp->depth; i++)   fprintf(fp, space);
				for(i=1; i<pp->depth-1; i++) fprintf(fp, "    "); 		// for " -> "
			}
		} while(pp!=NULL);
	}
	else {
		fprintf(fp, "(Tree is NULL)\n");
	}
	fflush(fp);

	return;
}





/**
tTree*  find_tTree_top(tTree* pp)

	ǽĥ꡼Υȥåסʥ롼ȡˤ򸫤Ĥ

	#define find_tTree_top(p)   find_tList_top(p)
*/





/**
tTree*  find_tTree_end(tTree* pp)

	ǽĥ꡼κǽΡɤ򸫤Ĥ롥

*/
tTree*  find_tTree_end(tTree* pp)
{
	if (pp==NULL) return NULL;

	while(pp->prev!=NULL) pp = pp->prev;	// Top õ
	while(pp->back!=NULL) pp = pp->back;

	return pp;
}





/**
int  count_tTree(tTree* pp)

	ǽĥ꡼ ppΡɰʹߤΥΡɤο롥

	: pp -- ϤΡɤؤΥݥ󥿡Ρɤ롥

	: Ρɤο
*/
int  count_tTree(tTree* pp)
{
	int cnt = 0;

	if (pp==NULL) return 0;
	while(pp->esis!=NULL) pp = pp->esis;

	do { 
		cnt++;
		if (pp->next!=NULL) cnt += count_tTree(pp->next);
		pp = pp->ysis;
	} while(pp!=NULL);

	return cnt;
}








////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Pattern Matching
//

/**
tTree*  strncmp_tTree(tTree* pp, char* key, int len, int no)

	ǽ: ĥ꡼ΡɤΥͤΥ
		  ݥ ppʹߤΥΡɤ,ʸ keyסʬŪġˤΡɤ
		   noܤˤΤܤФ

	: pp   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- ʸ
		  len  -- 1ʾ: פĹ
					  0: ס
					 -1: ĥ꡼ΥͤĹ˹碌롥
					 -2: key Ĺ˹碌롥
		  no  -- פʪǲܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tTree*  strncmp_tTree(tTree* pp, char* key, int len, int no)
{
	tTree* pt = NULL;
	int nn = 0;

	if (pp==NULL) return NULL;
	if (len<=-3)  return NULL;
	if (no<=0) no = 1;

	if (ex_strncmp((char*)(pp->ldat).key.buf, (char*)key, len)) {
		nn++;
		if (no==nn) return pp;
	}
	if (pp->next!=NULL) pt = next_strncmp_vertical_tTree(pp->next, key, len, no, &nn);

	return pt;
}





/**
tTree*  strncasecmp_tTree(tTree* pp, char* key, int len, int no)

	ǽ: ĥ꡼ΡɤΥͤΥʸʸ̵뤹롥
		  ݥ ppʹߤΥΡɤ,ʸ keyסʬŪġˤΡɤ
		   noܤˤΤܤФ

	: pp   -- 򳫻ϤΡɤؤΥݥ󥿡
		  key  -- ʸ
		  len  -- 1ʾ: פĹ
					  0: ס
					 -1: ĥ꡼ΥͤĹ˹碌롥
					 -2: key Ĺ˹碌롥
		  no  -- פʪǲܤʪ֤ꤹ롥1롥

	: פΡɤؤΥݥ󥿡
			פΤ̵ NULL
*/
tTree*  strncasecmp_tTree(tTree* pp, char* key, int len, int no)
{
	tTree* pt = NULL;
	int nn = 0;

	if (pp==NULL) return NULL;
	if (len<=-3)  return NULL;
	if (no<=0) no = 1;

	if (ex_strncasecmp((char*)(pp->ldat).key.buf, (char*)key, len)) {
		nn++;
		if (no==nn) return pp;
	}
	if (pp->next!=NULL) pt = next_strncasecmp_vertical_tTree(pp->next, key, len, no, &nn);

	return pt;
}






/**
tTree*  cmp_sisters_tTree(tTree* tp, tTree* tr)

	ǽΡtpλΡɤ ΡtrλΡɤƱѥʥͤӤäƤ뤫ɤ򸡺롥
		  tr->ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ΥΡɤ٤ʤ(˰פȤ)
		  ޤ tp->ctrl  TREE_ALREADY_FOUND_NODE ξϡ˰פʤ
		  ⤷ƱΡɥѥ󤬤硤trγƥΡɤ altpˤб tpγƥΡɤؤΥݥ󥿤Ǽ롥

	tp -- ٤ΡɤĹΡ
		  tr -- õΡɥѥĹΡ

	͡tp trƱѥ󤬻ϤޤΡɤؤΥݥ󥿡
		  	trγƥΡɤ altpˤб tpγƥΡɤؤΥݥ󥿤Ǽ롥
			NULL: tpƱѥ̵ξ硤traltpͤȤʤ롥


	----------------------------------------------------------------
	㡧	tp						tr
			--> A (1)				--> A 		A, B, X  (ldat.key.buf)
			--> B (2)				--> X
			--> A (3)
			--> X (4)
			--> A (5)
			--> X (6)

		ξ硤cmp_sisters_tTree(tp, tr)  (3)ؤΥݥ󥿤֤ޤ tr AΡ
		 altp ˤ (3) ؤΥݥ󥿤tr XΡɤaltpˤ(4)ؤΥݥ󥿤Ǽ
		롥ǽ˸ĤäѥΤɾ롥

*/
tTree*  cmp_sisters_tTree(tTree* tp, tTree* tr)
{
	tTree* ta;
	tTree* tb = NULL;
	tTree* ts;

	ts = tp;
	while (ts!=NULL){
		ta = ts;
		tb = tr;
		while (ta!=NULL && tb!=NULL) {
			if (ta->ctrl==TREE_ALREADY_FOUND_NODE) break;
			if (tb->ctrl!=TREE_NOCMP_NODE && tb->ctrl!=TREE_NOCMP_COPY_NODE) {
				if ((ta->ldat).key.buf!=NULL && (tb->ldat).key.buf!=NULL) {
					if (strcmp((char*)((ta->ldat).key.buf), (char*)((tb->ldat).key.buf))) break;
				}
				else break;
			}
			tb->altp = ta;
			ta = ta->ysis;
			tb = tb->ysis;
		}

		if (tb==NULL) return ts;

		ts = ts->ysis;
	}
	if (tb!=NULL) return NULL;

	return ts;
}






/**
int  check_match_tTree(tTree* tp, tTree* tr)

	ǽĥ꡼ tp ĥ꡼ trƱѥ()äƤ뤫ɤ򸡺롥
		  tp Υȥåפ tr ΥȥåפϥͤפƤɬפ롥פƤʤСƱѥ̵Ȥ롥
		  tr->ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ΥΡɤ٤ʤ(˰פȤ)

		  ٸĤ tpλޤκǸΥΡɤФƤ ctrl TREE_ALREADY_FOUND_NODE ꤹΤǡ³ƥå
		ʤɤ ctrl 򥯥ꥢɬפ롥

		  ⤷Ʊĥ꡼ѥ󤬤硤trγƥΡɤ altpˤϡֺǽ˸Ĥä
		  б tpγƥΡɤؤΥݥ󥿤Ǽ롥

	tp -- оݤΥĥ꡼
		  tr -- ѥΥĥ꡼

	͡TRUE:  tp trƱĥ꡼ѥ¸ߤ롥
		  		   trγƥΡɤ altpˤϡֺǽ˸Ĥäб tpγƥΡɤؤΥݥ󥿤Ǽ롥
			FALSE: tpƱĥ꡼ѥ̵ξ硤traltpͤȤʤ롥

*/
int  check_match_tTree(tTree* tp, tTree* tr)
{
	int  ret;
	tTree* ts;
	tTree* tt;
	tTree* ta;
	tTree* tb;
	tTree* te;


	if (tp==NULL || tr==NULL) return FALSE;

	te = find_tList_end(tr);

	ts = tp;
	while (ts!=NULL) {
		tt = cmp_sisters_tTree(ts, tr);		// γؤǥͤưפƤ뤫ǧ
		if (tt==NULL) return FALSE;			// פƤʤСFALSE
		
		ta  = tt;							// ٤ĥ꡼
		tb  = tr;							// ٤ѥ
		ret = TRUE;
		while (tb!=NULL && ret) {
			if (tb->next==NULL) ret = TRUE;
			// ->ta, ->tb->tx: FALSE
			else if (tb->next!=NULL && ta->next==NULL) ret = FALSE;
			// ->ta->xa, ->tb->xb: xaxbå
			else ret = check_match_tTree(ta->next, tb->next);

			ta = ta->ysis;
			tb = tb->ysis;
		}

		if (ret) {
			if (tr==te) tt->ctrl = TREE_ALREADY_FOUND_NODE;
			return TRUE;
		}

		ts = tt->ysis;
	}

	return FALSE;
}






/**
int find_match_tTree(tTree* pp, tTree* pt)

	ǽĥ꡼ pp ĥ꡼ ptƱѥλޤõ 
		  ƱѥõǤ ͤΤߤӤΡͤӤʤ
		  pt->ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ΥΡɤ٤ʤ(˰פȤ)
	
		  ⤷Ʊĥ꡼ѥ󤬤硤trγƥΡɤ altpˤϡֺǽ˸Ĥäб ppγƥΡɤ
		  Υݥ󥿤Ǽ롥

	check_match_tTree() Ȥΰ㤤
		check_match_tTree() Ǥ٤ޤγϥΡɤpp˸ꤵ롥
		find_match_tTree()  ppưʤ鸡Ǥ롥

	pp -- оݤΥĥ꡼
		  pt -- ѥΥĥ꡼

	͡TRUE:  pp ptƱĥ꡼ѥ¸ߤ롥
		  		   ptγƥΡɤ altpˤϡֺǽ˸Ĥäб ppγƥΡɤؤΥݥ󥿤Ǽ롥
			FALSE: ppƱĥ꡼ѥ̵ξ硤ptaltpͤȤʤ롥
*/
int  find_match_tTree(tTree* pp, tTree* pt)
{
	int   ret;
	tTree* pm;

	pm = pp;
	while(pp!=NULL) {
		ret = check_match_tTree(pp, pt);
		if (ret) return TRUE;

		if (pp->next!=NULL) {
			ret = find_match_tTree(pp->next, pt);
			if (ret) {
				clear_tTree_ctrl(pm);
				return TRUE;
			}
		}
		pp = pp->ysis;
	}

	return FALSE;
}







/**
void   clear_tTree_ctrl(tTree* pp)

	ǽpp Υĥ꡼ ctrl 򥯥ꥢ롥

*/
void   clear_tTree_ctrl(tTree* pp)
{
	while (pp->esis!=NULL) pp = pp->esis;

	while (pp!=NULL) {
		pp->ctrl = TREE_NOCTRL_NODE;
		if (pp->next!=NULL) clear_tTree_ctrl(pp->next);
		pp = pp->ysis;
	}
}







/**
tList*  find_match_tTree_endlist(tTree* pp, tTree* pt)

	ǽĥ꡼ pp ĥ꡼ ptƱѥλޤõơλޤκǸΥΡɤؤξꥹȤˤ֤
		ΡɤؤΥݥ󥿤 ֤줿ƥꥹȤaltp ݻƤ롥 

		  ӤǤ ͤΤߤӤΡͤӤʤ
		  ޤpt->ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ΥΡɤ٤ʤ(˰פȤ)
	
	pp -- оݤΥĥ꡼
		  pt -- ѥΥĥ꡼

	͡ΡɤؤΥݥ󥿤ݻꥹȡ

*/
tList*  find_match_tTree_endlist(tTree* pp, tTree* pt)
{
	tTree* te;
	tList* lp;

	te = find_tTree_end(pt);
	while(pp->esis!=NULL) pp = pp->esis;

	lp = find_match_tTree_endlist_rcsv(pp, pt, te);
	if (lp!=NULL) clear_tTree_ctrl(pp);
	
	return lp;
}





/**
tList*  find_match_tTree_endlist_rcsv(tTree* pp, tTree* pt, tTree* te)

	ǽfind_match_tTree_endlist() ؿ

*/
tList*  find_match_tTree_endlist_rcsv(tTree* pp, tTree* pt, tTree* te)
{
	tList* lt = NULL;
	tList* lp = NULL;

	while(pp!=NULL) {
		int ret = check_match_tTree(pp, pt);
		if (ret && te->altp!=NULL) {
			tList* lm = new_tList_node();
			lm->altp = te->altp;
			lt = add_tList(lt, lm);
			if (lp==NULL) lp = lt;
			te->altp = NULL;
		}
			
		if (pp->next!=NULL) {
			tList* lm = find_match_tTree_endlist_rcsv(pp->next, pt, te);
			if (lm!=NULL) {
				lt = add_tList(lt, lm);
				if (lp==NULL) lp = lt;
				clear_tTree_ctrl(pp->next);
			}
		}
	
		if (!ret) pp = pp->ysis;	// ĤäϤ⤦١Ĥʤäؼء
	}
	
	return lp;
}






/**
void  replace_tTree_node(tTree* pp, tTree* pt)

	ǽĥ꡼ pp ĥ꡼ ptƱѥʥͤӡˤλޤ򸡺pp˰פѥλޤС
		  λޤγƥΡɤФơб뤽줾Ρpt->ctrl  TREE_COPY_NODE ޤ TREE_NOCMP_COPY_NODE Ǥ
		  ptΥΡɤ°֤롥
		  ѥΰסʸˤǤ ldat.keyʥ͡ˤӤ롥

		֤° ldat.id, ldat.lv, ldat.sz, ldat.key, ldat.val, ldat.ptr, ldat.lst
		  ֤ԤΤ pt->ctrl  TREE_COPY_NODE ޤ TREE_NOCMP_COPY_NODE ξΤߤǤ롥()
		ldat.val, ldat.ptr, ldat.lst ˤĤƤϡptͤꤵƤʤС֤Ԥʤ
	
	pp -- ֤оݤΥĥ꡼
		  pt -- ֤ĥ꡼

	͡TRUE : ִޤ򸫤Ĥִ줿ɤ
			FALSE: ִޤ򸫤Ĥʤä

*/
int replace_tTree_node(tTree* pp, tTree* pt)
{
	int ret;

	if (pp==NULL || pt==NULL) return FALSE;
	while(pp->esis!=NULL) pp = pp->esis;
	
	ret = find_match_tTree(pp, pt);
	if (ret) {
		copy_tTree_byctrl(pt);
		adjust_tTree_depth(pp);
	}

	return ret;
}






/**
void  copy_tTree_byctrl(tTree* pt)

	ǽreplace_tTree_node()ؿ
		  ĥ꡼ ptˤơpt->ctrl  TREE_COPY_NODE ޤ TREE_NOCMP_COPY_NODE ξ硤
		  pt->altp ΥΡɤ pt°򥳥ԡ롥

		  pt->ldat.sz ˤΤ pt->ldat.ptrΥꤵƤɬפ롥
*/
void  copy_tTree_byctrl(tTree* pt)
{
	while(pt!=NULL) {
		if (pt->altp!=NULL) {
			if (pt->ctrl==TREE_COPY_NODE || pt->ctrl==TREE_NOCMP_COPY_NODE) {
				pt->altp->ldat.id = pt->ldat.id;		
				pt->altp->ldat.lv = pt->ldat.lv;
				pt->altp->ldat.sz = pt->ldat.sz;

				if (pt->ldat.key.buf!=NULL) {
					free_Buffer(&(pt->altp->ldat.key));
					pt->altp->ldat.key = dup_Buffer(pt->ldat.key);
				}
				if (pt->ldat.val.buf!=NULL) {
					free_Buffer(&(pt->altp->ldat.val));
					pt->altp->ldat.val = dup_Buffer(pt->ldat.val);
				}

				if (pt->ldat.ptr!=NULL && pt->ldat.sz>0) {
					if (pt->altp->ldat.ptr!=NULL) free(pt->altp->ldat.ptr);
					pt->altp->ldat.ptr = (void*)malloc(pt->ldat.sz);
					if (pt->altp->ldat.ptr!=NULL) memcpy(pt->altp->ldat.ptr, pt->ldat.ptr, pt->ldat.sz);
				}

				if (pt->ldat.lst!=NULL) {
					del_all_tList(&(pt->altp->ldat.lst));
					pt->altp->ldat.lst = dup_tList(pt->ldat.lst);
				}
			}
		}

		if (pt->next!=NULL) copy_tTree_byctrl(pt->next);
		pt = pt->ysis;
	}

	return;
}






/**
Buffer  get_value_tTree(tTree* pp, tTree* pt)

	ǽĥ꡼ pp ĥ꡼ ptƱѥλޤ򸡺pp˰פѥ
		  ޤСλޤκǸΥΡɤ֤ͤ

	pp -- оݤΥĥ꡼
		  pt -- ѥ

	͡ptκǸΥΡɤб ppΥΡɤΥΡ


	----------------------------------------------------------------
	㡧	tp							tr
			A --> B --> M				C --> M --> Y
			  --> C --> M --> X 			  
						  --> Y(*)		 
					--> N

		ξ硤Y(*) ΥΡ֤ͤ롥
*/
Buffer  get_value_tTree(tTree* pp, tTree* pt)
{
	int fnd;
	Buffer val;

	val = init_Buffer();
	if (pp==NULL || pt==NULL) return val;

	while(pp->esis!=NULL) pp = pp->esis;
	
	fnd = find_match_tTree(pp, pt);
	if (fnd) {
		tTree* tt = find_tTree_end(pt);
		if (tt->altp!=NULL) {
			val = dup_Buffer(tt->altp->ldat.val);
		}
	}

	return val;
}











/////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

/**
tTree*  next_strncmp_vertical_tTree(tTree* pp, char* key, int len, int no, int* nn)
tTree*  next_strncmp_horizon_tTree (tTree* pp, char* key, int len, int no, int* nn)
tTree*  next_strncasecmp_vertical_tTree(tTree* pp, char* key, int len, int no, int* nn)
tTree*  next_strncasecmp_horizon_tTree (tTree* pp, char* key, int len, int no, int* nn)

	tTree ؿhorizon ϵŪʲõʴʲõǤϤʤ

*/
tTree*  next_strncmp_vertical_tTree(tTree* pp, char* key, int len, int no, int* nn)
{
	do { 
		if (ex_strncmp((char*)(pp->ldat).key.buf, (char*)key, len)) {
			(*nn)++;
			if (no==*nn) return pp;
		}
		if (pp->next!=NULL) {
			tTree* tt = next_strncmp_vertical_tTree(pp->next, key, len, no, nn);
			if (tt!=NULL) return tt;
		}
		pp = pp->ysis;
	} while(pp!=NULL);

	return NULL;
}





tTree*  next_strncmp_horizon_tTree(tTree* pp, char* key, int len, int no, int* nn)
{
	do { 
		if (ex_strncmp((char*)(pp->ldat).key.buf, (char*)key, len)) {
			(*nn)++;
			if (no==*nn) return pp;
		}
		if (pp->ysis!=NULL) {
			tTree* tt = next_strncmp_horizon_tTree(pp->ysis, key, len, no, nn);
			if (tt!=NULL) return tt;
		}
		pp = pp->next;
	} while(pp!=NULL);

	return NULL;
}





tTree*  next_strncasecmp_vertical_tTree(tTree* pp, char* key, int len, int no, int* nn)
{
	do { 
		if (ex_strncasecmp((char*)(pp->ldat).key.buf, (char*)key, len)) {
			(*nn)++;
			if (no==*nn) return pp;
		}
		if (pp->next!=NULL) {
			tTree* tt = next_strncasecmp_vertical_tTree(pp->next, key, len, no, nn);
			if (tt!=NULL) return tt;
		}
		pp = pp->ysis;
	} while(pp!=NULL);

	return NULL;
}





tTree*  next_strncasecmp_horizon_tTree(tTree* pp, char* key, int len, int no, int* nn)
{
	do { 
		if (ex_strncasecmp((char*)(pp->ldat).key.buf, (char*)key, len)) {
			(*nn)++;
			if (no==*nn) return pp;
		}
		if (pp->ysis!=NULL) {
			tTree* tt = next_strncasecmp_horizon_tTree(pp->ysis, key, len, no, nn);
			if (tt!=NULL) return tt;
		}
		pp = pp->next;
	} while(pp!=NULL);

	return NULL;
}





