/* vi: set tabstop=4 paste nocindent noautoindent: */

/**
Tiny List, Tiny Tree Graph ¤饤֥إå		tlist.h


*/



#ifndef  _TLIST_TTREE_H
#define  _TLIST_TTREE_H


#include "buffer.h"









struct  _tList_data;
struct  _tList;



/**
tList_data ¤
	int	 	id;				// ΡID
	int	 	lv;				// Ρ͡
	Buffer  key;			// ΡɤΥ
	Buffer  val;			// Ρ͡ʸ
	void*	ptr;			// ѡ¤ΤʤɤؤΥݥ󥿡freeǤʤΤǡꥹȤΤ褦ʥݥ󥿤ꤷƤϤʤ
	int	 	sz;				// *ptr Υ
	struct _tList* 	lst;	// ꥹȥǡؤΥݥ
*/
struct  _tList_data {
	int	 	id;				// ΡID
	int	 	lv;				// Ρ͡
	Buffer  key;			// ΡɤΥ
	Buffer  val;			// Ρ͡ʸ
	void*	ptr;			// ѡʹ¤Τʤɡ
	int	 	sz;				// *ptrΥ
	struct _tList* 	lst;	// ꥹȥǡؤΥݥ
};




/**
tList ¤
   
	tList_data 	ldat	ǡ
	tList*	 	next	ҥΡɤؤΥݥ
	tList*	 	prev	ƥΡɤؤΥݥ
	tList*		altp	¾ΥΡɤؤΥݥ

	tList*		back	ҡûҡ˥ΡɤؤΥݥ 	for tTree
	tList*		esis	λΡɤؤΥݥ 		for tTree
	tList*		ysis	λΡɤؤΥݥ 		for tTree

	int 		depth								for tTree
	int			num		ҥΡɤο					for tTree
	int			ctrl								for tTree
	int			state   Ρɤξ
 */
struct  _tList {
	struct _tList_data	ldat;
	struct _tList* 	next;
	struct _tList* 	prev;
	struct _tList* 	altp;

	struct _tList* 	back;
	struct _tList* 	esis;
	struct _tList* 	ysis;

	int 			depth;
	int 			num;
	int 			ctrl;
	int				state;
};


typedef  struct _tList_data 	tList_data;
typedef  struct _tList  		tList;
typedef  struct _tList  		tTree;



// Anchor Node
#define	LIST_ANCHOR		"LIST_ANCHOR"


// for strncmp_tList()
#define TLIST_MATCH_COMPLETE	0	
#define TLIST_MATCH_TLISTKEY	-1		
#define TLIST_MATCH_STRINGKEY 	-2		
#define TLIST_MATCH_STRKEY 		-2		



// ldat.ctrl ꥹ
#define	TREE_NOCTRL_NODE 				0			// ¡ˤƤʤΡɡǥեȡ
#define	TREE_NOCMP_NODE 				100			// оȤ鳰Ρɡ̵̾ǰפ롥
#define	TREE_NOCMP_COPY_NODE 			101			// оȤ鳰Ǹ˥ԡԤΡɡ̵̾ǰפ롥
#define	TREE_COPY_NODE					102			// ǥԡԤΡɡcopy_tTree_byctrl()ʤɡ
#define	TREE_ALREADY_FOUND_NODE			110			// ʤɤˤƴ˸ĤΡɡĤȤꤷΡɡ
#define	TREE_ALREADY_FOUND_NODE_TEMP 	111			// ŪоȤ鳰˥Ρɡꡥ








/**/
////////////////////////////////////////////////////////////////////////////////////////////////////
//
// List Data
//

tList_data  init_tListdata(void);

tList_data  make_tListdata      (int id, int lv, Buffer key, Buffer val, void* ptr, int sz);
tList_data  make_tListdata_bystr(int id, int lv, char*  key, char*  val, void* ptr, int sz);
#define  	make_tListdata_byBuffer(i, l, k, v, d, s)	make_tListdata((i), (l), (k), (v), (d), (s))

#define  	make_tListdata_int(k, v)			make_tListdata_bystr((k), (v), NULL, NULL, NULL, 0)
#define  	make_tListdata_str(k, v)			make_tListdata_bystr(0, 0, (char*)(k), (char*)(v), NULL, 0)
#define  	make_tListdata_Buffer(k, v)			make_tListdata(0, 0, (k), (v), NULL, 0)

tList_data	dup_tListdata (tList_data ldat);
void   		free_tListdata(tList_data* ldat);




////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tiny List Node
//

tList*  new_tList_node(void);
tList  	make_tList_node(tList_data data);

// ɲä new_tList_node() 
tList*  add_tList_node_bydata  (tList* pp, tList_data ldat); 
tList*  add_tList_node_bystr   (tList* pp, int id, int lv, char*  key, char*  val, void* ptr, int sz);
tList*  add_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz); 
#define add_tList_node_int(p, k, v)  			add_tList_node_bystr((p), (k), (v), NULL, NULL, NULL, 0)
#define add_tList_node_str(p, k, v)  			add_tList_node_bystr((p), 0, 0, (char*)(k), (char*)(v), NULL, 0)
#define add_tList_node_null(p)					add_tList_node_bystr((p), 0, 0, NULL, NULL, NULL, 0)
#define add_tList_node_Buffer(p, k, v)			add_tList_node_byBuffer((p), 0, 0, (k), (v), NULL, 0)
#define add_tList_node(p, t)					add_tList((p), (t))

// 
void	set_tList_node_bydata  (tList* pp, tList_data ldat);
void	set_tList_node_bystr   (tList* pp, int id, int lv, char*  key, char*  val, void* ptr, int sz);
void	set_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz);
#define set_tList_node_int(p, k, v) 	 		set_tList_node_bystr((p), (k), (v), NULL, NULL, NULL, 0)
#define set_tList_node_str(p, k, v)  			set_tList_node_bystr((p), 0, 0, (char*)(k), (char*)(v), NULL, 0)
#define set_tList_node_Buffer(p, k, v)			set_tList_node_byBuffer((p), 0, 0, (k), (v), NULL, 0)

// ƹ̵ɲáɲä new_tList_node()ѡ
tList*	update_tList_node		  (tList* pp, tList* pt);
tList*	update_tList_node_bydata  (tList* pp, char* key, tList_data ldat);
tList*	update_tList_node_bystr   (tList* pp, int id, int lv, char*  key, char*  val, void* ptr, int sz);
tList*	update_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz);
#define update_tList_node_int(p, k, v)  		update_tList_node_bystr((p), (k), (v), NULL, NULL, NULL, 0)
#define update_tList_node_str(p, k, v)	  		update_tList_node_bystr((p), 0, 0, (char*)(k), (char*)(v), NULL, 0)
#define update_tList_node_Buffer(p, k, v)		update_tList_node_byBuffer((p), 0, 0, (k), (v), NULL, 0)


tList*  del_tList_node (tList* node); 
tList*  dup_tList_node (tList* node);
tList*  move_tList_node(tList* node, tList* pp); 
void  	free_tList_node(tList** node); 




////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tiny List
//

tList*  add_tList(tList* pp, tList* pt); 
tList*  dup_tList(tList* pp);
void   	print_tList(FILE* fp, tList* pp);
int		count_tList(tList* pp);

tList*  del_tList(tList** pp); 
void   	del_all_tList(tList** pp);

tList*  find_tList_top(tList* pp); 
tList*  find_tList_end(tList* pp); 


//   ꥹȤؤΥݥ󥿤֤ 
//		len: 1ʾ:פĹ0:ס-1:pl->keyĹ˹碌롤-2:keyĹ˹碌
tList*  strncmp_tList   (tList* pl, char*  key, int len, int no);
tList*  strnrvscmp_tList(tList* pl, char*  key, int len, int no);
tList*  strstr_tList    (tList* pl, char*  key, int len, int no);

tList*  strncasecmp_tList   (tList* pl, char*  key, int len, int no);
tList*  strncaservscmp_tList(tList* pl, char*  key, int len, int no);
tList*  strstrcase_tList    (tList* pl, char*  key, int len, int no);


tList*  strncmp_back_tList   (tList* pl, char*  key, int len, int no);
tList*  strnrvscmp_back_tList(tList* pl, char*  key, int len, int no);
tList*  strstr_back_tList    (tList* pl, char*  key, int len, int no);

tList*  strncasecmp_back_tList   (tList* pl, char*  key, int len, int no);
tList*  strncaservscmp_back_tList(tList* pl, char*  key, int len, int no);
tList*  strstrcase_back_tList    (tList* pl, char*  key, int len, int no);


// ldat.val Υԡ֤ 
Buffer  search_key_tList(tList* lt, char* key, int no);
Buffer  search_key_value_tList(tList* lt, char* key, char* data, int no);


// Tools
tList*	awk_tList (char* str, char cc);
tList*	cawk_tList(char* str, char cc);
tList*	awk_Buffer_tList (Buffer buf, char cc);
tList*	cawk_Buffer_tList(Buffer buf, char cc);
char*   get_str_join_tList(tList* lp, char* deli);				//  free
Buffer  get_Buffer_join_tList(tList* lp, char* deli);


// ѹ
int     set_value_tList(tList* lt, char* key, int no, char* value, int mode);
int     replace_value_tList(tList* lt, char* key, int no, char* srcval, char* value);

int     set_value_tList_node(tList* lt, char* value);
int     replace_value_tList_node(tList* lt, char* srcval, char* value);



// for Configuration File
char* 	get_strparam_tList(tList* lt, char* key, char* dflt);
int  	get_intparam_tList(tList* lt, char* key, int dflt);




////////////////////////////////////////////////////////////////////////////////////////////////////
//
// File I/O with Tiny List
//

tList*  read_tList_fp(FILE* fp, int mode);
tList*  read_tList_file(char* fn, int mode);
tList*  read_index_tList_fp(FILE* fp, char deli);
tList*  read_index_tList_file(char* fn, char deli);

tList*  read_Buffer_tList_fp(FILE* fp);
tList*  read_Buffer_tList_file(char* fn);
int  	save_Buffer_tList_fp(FILE* fp, tList* lt);
int		save_Buffer_tList_file(char* fn, tList* lt);




////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tiny Tree Graph Node
//

#define	new_tTree_node()						new_tList_node()
#define	make_tTree_node(p)						make_tList_node(p)

tTree* 	add_tTree_node		   (tTree* pp, tTree* pt);
tTree* 	add_tTree_node_bydata  (tTree* pp, tList_data ldat);
tTree*  add_tTree_node_bystr   (tTree* pp, int id, int lv, char*  key, char*  val, void* ptr, int sz);
tTree* 	add_tTree_node_byBuffer(tTree* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz); 

#define add_tTree_node_int(p, k, v)				add_tTree_node_bystr((p), (k), (v), NULL, NULL, NULL, 0)
#define add_tTree_node_str(p, k, v)         	add_tTree_node_bystr((p), 0, 0, (char*)(k), (char*)(v), NULL, 0)
#define add_tTree_node_Buffer(p, k, v)      	add_tTree_node_byBuffer((p), 0, 0, (k), (v), NULL, 0)

tTree*  del_tTree_node(tTree** node); 
tTree*  move_tTree_node(tTree* node, tTree* pp); 
int  	replace_all_tTree_node(tTree* pp, char* key, char* src, char* dst, int len);

#define set_tTree_node_bydata(p, k)						set_tList_node_bydata((p), (k))
#define set_tTree_node_bystr(p, i, l, k, v, d, s) 		set_tList_node_bystr((p), (i), (l), (k), (v), (d), (s))
#define set_tTree_node_byBuffer(p, i, l, k, v, d, s) 	set_tList_node_byBuffer((p), (i), (l), (k), (v), (d), (s))

#define set_tTree_node_int(p, k, d) 	 		set_tList_node_bystr((p), (k), (v), NULL, NULL, NULL, 0)
#define set_tTree_node_str(p, k, d)  			set_tList_node_bystr((p), 0, 0, (char*)(k), (char*)(v), NULL, 0)
#define set_tTree_node_Buffer(p, k, d)			set_tList_node_byBuffer((p), 0, 0, (k), (v), NULL, 0)

#define	free_tTree_node(p)						free_tList_node(p)
#define dup_tTree_node(p)						dup_tList_node(p)




////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tiny Tree Graph
//

tTree*  del_tTree(tTree** pp); 
void   	del_all_tTree(tTree** pp);
tTree*	del_children_tTree(tTree** pp);
tTree*	del_sisters_children_tTree(tTree** pp);

void   	adjust_tTree_depth(tTree* pp);
void   	print_tTree(FILE* fp, tTree* pp, char* space);

tTree* 	add_tTree(tTree* pp, tTree* pt);
tTree* 	div_tTree(tTree* pp);
tTree*	dup_merge_tTree(tTree* pp, tTree* tp);
void  	merge_tTree(tTree* pp, tTree* pt);
void  	exchange_tTree(tTree* tl, tTree* tt);
int		count_tTree(tTree* pp);

#define	find_tTree_top(p)					find_tList_top(p)
tTree*	find_tTree_end(tTree* pp);


// /ִ
tTree*  strncmp_tTree    (tTree* pp, char*  key, int len, int no);
tTree*  strncasecmp_tTree(tTree* pp, char*  key, int len, int no);

tTree*  cmp_sisters_tTree (tTree* tp, tTree* tr);
int  	check_match_tTree (tTree* tp, tTree* tr);
int 	find_match_tTree  (tTree* pp, tTree* pt);
int 	replace_tTree_node(tTree* pp, tTree* pt);
void 	copy_tTree_byctrl (tTree* pt);

tList*	find_match_tTree_endlist(tTree* pp, tTree* pt);
tList*	find_match_tTree_endlist_rcsv(tTree* pp, tTree* pt, tTree* te);
void   	clear_tTree_ctrl(tTree* pp);

Buffer	get_value_tTree  (tTree* pp, tTree* pt);
#define	set_value_tTree(p, t)				replace_tTree_node((p), (t))


// Ūؿ
tTree*  next_strncmp_vertical_tTree    (tTree* pp, char* key, int len, int no, int* nn);
tTree*  next_strncasecmp_vertical_tTree(tTree* pp, char* key, int len, int no, int* nn);

tTree*  next_strncmp_horizon_tTree    (tTree* pp, char* key, int len, int no, int* nn);
tTree*  next_strncasecmp_horizon_tTree(tTree* pp, char* key, int len, int no, int* nn);



/**/


#endif


