/* vi: set tabstop=4 nocindent paste: */

/**
ѥġإå  tools.h

  ¸ط
	  #include "common.h"

 */



#ifndef __TOOLS_HEADER_
#define __TOOLS_HEADER_


#include "common.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <stdarg.h>
#include <ctype.h>


#ifdef WIN32
	#include <winsock2.h>		// for ntohl, ntohs, htonl, htons
#else
	#include <unistd.h>	
#endif


#ifdef HAVE_ARPA_INET_H
	#include <arpa/inet.h>
#endif

#ifdef TIME_WITH_SYS_TIME
	#include <time.h>
	#include <sys/time.h>
#else
	#ifdef HAVE_TIME_H 
		#include <time.h>
	#endif 
	#ifdef HAVE_SYS_TIME_H 
		#include <sys/time.h>
	#endif 
#endif

#ifdef HAVE_SYS_PARAM_H 
	#include <sys/param.h>
#endif

#ifdef HAVE_SYSLOG_H
	#include <syslog.h>
#endif

#ifdef HAVE_WAIT_H 
	#include <wait.h>
#endif
#ifdef HAVE_SYS_WAIT_H 
	#include <sys/wait.h>
#endif

#ifdef HAVE_SYS_ERRNO_H 
	#include <sys/errno.h>
#else
	#include <errno.h>
#endif
#include <signal.h>



/**
ޥ

  CR   				^M  0x0d
  LF   饤ե  	^J  0x0a
  TAB  				^I  0x09			
 */
#define  CR	 	0x0d		//  
#define  LF	 	0x0a		// 饤ե 
#define  TAB	0x09		//  

#define  US	 	0
#define  EUC	1			//  
#define  SJIS   2			//  



/**
󥰥Хåե

*/
typedef  struct {
	unsigned char* buf;
	int   bufsz;			// ХåեΥ
	int   spoint;			// Хåեǡγ
	int   epoint;			// Хåեǡν+1 (ǡɲ)
	int   npoint;			// ΥåΥȥݥ
	int   datasz;			// ¸ƤǡΤĹ
	int   datano;			// ǼƤǡο
	int   state;			// 󥰥Хåեξ
} ringbuffer;


#define  mstream   ringbuffer	// åȥ꡼




/**
ѿ

  int DebugMode;  ON ξ ǥХå⡼ɤǤ뤳Ȥ򼨤ǥեȤOFF
  int KanjiCode;  ѴɡUS, SJIS, EDU롥ǥեȤ US

 */
extern int   DebugMode; 
extern int   KanjiCode;
extern int   UnitTestMode;

extern char  LocalIPNum[4];


#define  LOCAL_IPADDR  "127.0.0.1"



// not C++
#ifndef CPLUSPLUS
	int  isNull(void* p);
	#define freeNull(p)     {if(!isNull(p)) free(p); (p)=NULL;}
#endif




/**/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// ʸ
char*   get_line(char*, int);						// strΥХåե nܤФԥɤϺ롥free
char*   awk (char*, char, int);						// ccڤ국Ȥ, strΥХåե nܤιܤ֤free
char*   cawk(char*, char, int);						// Ϣ³ccڤ국Ȥ, strΥХåե nܤιܤ֤free

char*   cut_str(char* buf, int ls, int le);			// buf[ls]buf[le] ڤФ free
char*   dup_str(char* buf);							// ʸʣ롥 free
char*	skip_char(char* mesg, const char* check);	// check[]β줫ʸޤǥݥ󥿤򥹥åפ롥 " ' ϴå
char*  	pack_char(char* mesg, char cc);				// ʸڤӡƬcc(ʣ)cc(ʣ)CR, LF  free
char*  	pack_head_tail_char(char* mesg, char cc);	// ʸƬcc(ʣ)TAB, CR, LFcc(ʣ)TAB, CR, LF  free
char*  	change_esc(char* mesg);						// ʸ CR, LF  \r, \n Ѵ롥 free
char*   chomp(char*);								// ǽβԥɰʹߤ̵ˤ롥
char*   double_bs(char* fn);						// ʸ \  \\֤ʸ֤ free
char*   numbering_name(char* fmt, int n);			// եޥå fmt˽äơnޤʸФ free

char*	ltostr(long int n);							// long int ʸѴ롥free 	
char*	ultostr(unsigned long int n);				// unsigned long int ʸѴ롥free 	
char*	ftostr(float n);							// float ʸѴ롥free 	

void	swap_byte(void* p, int s, int b);			// ХȽսˤ롥
short   swaps(short p);								// 16bit ξ岼8bitؤ롥
int	 	swapl(int   p);								// 32bit p8bitŤĵսˤ
short   swaps(short p);								// 16bit ξ岼8bitؤ롥
void	reverse_str(uByte* p, int s);				// Х(octet)սˤ롥
void	upper_string(char* str);
//void	int_swap(int* p, int* s);					// ǡؤ롥
#define int_swap(p, s) 	{int swap=(p); (p)=(s); (s)=swap;}



// 
int  	bincmp(unsigned char* b1, unsigned char* b2, int n);		// Хʥǡ n Byte٤
int	 	strnrvscmp(const char* s1, const char* s2, int n);			// ʸ s1 s2 nʸӤ롥
int	 	strncaservscmp(const char* s1, const char* s2, int n);		// ʸ s1 s2 nʸӤ롥
char*   strstrcase(const char* buf, const char* nd);				// ʸ bufʸ nd뤫ɤå롥ʸʸ϶̤ʤ

int	 	ex_strncmp(const char* s1, const char* s2, int n);			// ʸ s1s2ĥӤ롥
int	 	ex_strncasecmp(const char* s1, const char* s2, int n);	  	// ʸ s1s2ĥӤ롥
int	 	ex_strnrvscmp(const char* s1, const char* s2, int n);		// ʸ s1s2ĥӤ롥
int	 	ex_strncaservscmp(const char* s1, const char* s2, int n);	// ʸ s1s2ĥӤ롥


// ǥ  (ޥ isBigEndian ntohs() ѤΡ
int 	is_little_endian(void);
int 	is_big_endian(void);


// 
void	print_escape(char* format, char* mesg);			// ʸޤåνϡstderr
void	fdump(FILE* fp, unsigned char* mesg, int n);	// 16ʥפǤФ
void	print_16x(FILE* fp, unsigned char* mesg, int n);// 16ʥפǤФʣԡ


// 
void	kanji_convert(unsigned char* mesg);				// ѿ KnjiCode˽äƴɤѴ롥
void	kanji_convert_euc2sjis(unsigned char* mesg);	// EUCSJISѴ롥
void	kanji_convert_sjis2euc(unsigned char* mesg);	// SJISEUCѴ롥
void	euc2sjis(unsigned char *c1, unsigned char *c2);	// EUC  -> SJIS
void	sjis2euc(unsigned char *c1, unsigned char *c2);	// SJIS -> EUC


// ե
int	 	file_from_to(char* s, char* d, char* mode);		// mode˽ä,ե s d˥ԡ롥
char*   get_file_name(char* str);						// եѥե̾ؤΥݥ󥿤Ф
long 	file_size(char* fn);							// ե礭֤
int	 	file_exist(char* fn);							// ե¸ߤ򸡺롥
FILE* 	file_chmod_open(char* fn, char* fm, mode_t mode);
char*   temp_filename(const char*, int);


// 
void	init_rand(void);								// /dev/urandom ǡη
char*   randstr(int n);									//  A-Za-z0-9 ޤǤʸ nʸ롥
unsigned char* randbit(int n);							//  n bitΥХʥ롥
#define random_str(n)   temp_filename(NULL, (n))


// Base64
unsigned char*  encode_base64(unsigned char* str, int  sz);
unsigned char*  decode_base64(unsigned char* str, int* sz);
unsigned char*  encode_urlenc(unsigned char* str, int  sz);
unsigned char*  decode_urlenc(unsigned char* str, int* sz);
unsigned char*  encode_quoted_printable(unsigned char* str, int  sz);
unsigned char*  decode_quoted_printable(unsigned char* str, int* sz);
unsigned char*  encode_hex(unsigned char cc);
unsigned char	decode_hex(unsigned char c1, unsigned char c2);


// 󥰥Хåե
ringbuffer* 	new_ringbuffer(void);
ringbuffer  	init_ringbuffer(void);
ringbuffer  	make_ringbuffer(int sz);
void  			del_ringbuffer  (ringbuffer** pp);
void  			free_ringbuffer (ringbuffer* pp);
void  			clear_ringbuffer(ringbuffer* pp);
int   			put_ringbuffer(ringbuffer* rb, unsigned char* pp, int sz);
unsigned char* 	get_ringbuffer(ringbuffer* rb, int sz);

#define  char_ringbuffer(b, n)		(b).buf[((n)%((b).bufsz))]


// åȥ꡼
int   			put_mstream(mstream* sb, unsigned char* pp);
unsigned char* 	get_mstream(mstream* sb);
unsigned char* 	fgets_mstream(unsigned char* mesg, mstream* sb);

#define  new_mstream()		new_ringbuffer()
#define  make_mstream(s)  	make_ringbuffer((s))
#define  free_mstream(s)  	free_ringbuffer((s))
#define  del_mstream(s)   	del_ringbuffer((s))
#define  clear_mstream(s) 	clear_ringbuffer((s))


// UUID
unsigned char*  uuid2guid(unsigned char* p);
unsigned char*  guid2uuid(unsigned char* p);


#ifndef WIN32
// ץ
void  	set_sigterm_child(void (*handler)(int));
void  	sigterm_child(int signal);

void  	ignore_sigterm_child(void);

void	set_sigsegv_handler(void (*handler)(int));
void	trap_segmentation_falt(int signal);

#define  set_sigseg_handler(h)    set_sigsegv_handler((h))

#endif

/**/

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// ޥؿ
//

/**
	copy_file(src, dst)	 src dsإե򥳥ԡ롥
	cat_file (src, dst)	 src dstإե cat롥
*/
#define copy_file(src, dst)  file_from_to((src), (dst), "w");
#define cat_file(src, dst)   file_from_to((src), (dst), "aw");



#define  isBigEndian  ((sWord)1==htons((sWord)1))


/**
  ntoh_st(p, s)   network hostء¤pФ sХȤŤѴ
  hton_st(p, s)   host networkء¤pФ sХȤŤѴ
  ntoh_ar(p, s)   network hostءĹsХȤpФѴ
  hton_ar(p, s)   host networkءĹsХȤpФѴ
 */
#define  ntoh_st(p, s) {if (!isBigEndian) swap_byte((void*)(p), sizeof(*(p)), (s));}
#define  hton_st(p, s) {if (!isBigEndian) swap_byte((void*)(p), sizeof(*(p)), (s));}
#define  ntoh_ar(p, s) {if (!isBigEndian) swap_byte((void*)(p), (s), sizeof(*(p)));}
#define  hton_ar(p, s) {if (!isBigEndian) swap_byte((void*)(p), (s), sizeof(*(p)));}




/////////////////////////////////////////////////////////////////////////////////////
// for Debug

/**
顼åؿ
	debug_message  print_message ΰ㤤

	debug_message: -DEBUG ץĤǥѥ뤵졤 DebugMode==ON λ˽Ϥ롥
				   Ū椹˻ѡĤޤΥǥХåǻѤ˻ѤǤǤϺǽ

	print_message: ɬϤ롥
*/

void	print_message(char*, ...);					// Хåե󥰤ʤΥåϡstderr

#define  print_mesg  print_message


#ifdef _DEBUG
	#ifndef EBUG
		#define EBUG
	#endif
#endif


#ifdef EBUG
	#define debug_message  if(DebugMode==ON)print_message
	#ifndef _DEBUG
		#define _DEBUG
	#endif
#else
	#define debug_message(f, ...)  {}
#endif


#define  DEBUG_MODE  if(DebugMode==ON)


#endif


