
#include "txml.h"


/**
	Tiny XML  txml.c v1.0	'09 2/10

	֥å XML ʰץѡ 


	ƤΥѥΥѡǽݾ㤹ΤǤϤޤ
	ʣ XMLϥѡǤޤ

		<?xml ... ?> ʳ <? ..... ?>  <! ..... > Ͻʤɤ߹ߤϹԤ
		ƥƥϽʤ

*/

//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Parser
//

/**
tXML*  xml_parse(char* pp)

	ǽXMLǡᤷơtXMLΥĥ꡼¤˳Ǽ롥

	pp -- XMLǡؤΥݥ󥿡

	͡ return -- XMLǡǼ tXMLΥ󥫡ؤΥݥ 
					   顼򵯤 ->state  XML_PARSED ʳ͡0ʲˤ롥
					 顼ξϡ->next ʲˤϥ顼򵯤ľޤǤƤ¸

*/
tXML*  xml_parse(char* pp)
{
	tXML* xml;
	tXML* tag;


	xml = new_tTree_node();					// 󥫡
	xml->ldat.id = XML_ANCHOR_TAG;

	// ѡ
	tag = xml_partial_parse(xml, pp, TRUE);
	if (tag->state<0) return xml;


	// ä
	if (xml==tag) {
		xml->state = XML_PARSED;
	}
	else {
        xml->state = XML_PARSE_ERROR;
		return xml;
	}

	// XML rootο
	if (xml->next!=NULL) {
		int n = 0;
		tag = xml->next;
		while(tag!=NULL) {
			if (tag->ldat.id==XML_TAG_NAME) n++;
			tag = tag->ysis;
		}
		if (n!=1) xml->state = XML_MULTI_ROOT;
	}
	else xml->state = XML_DEFAULT_STATE;

	return xml;
}





/**
tXML*  xml_parse_seq(tXML* xml, char* pp)

	ǽʬŪ XMLǡᤷơtXMLΥĥ꡼¤˳Ǽ롥
		   XMLǡǤʤƤǤȤޤǤϲ᤹롥
		  xml NULLξϼưŪ˥ĥ꡼롥
		  Ū XMLǡϤ˻Ѥ롥

	 pp  -- XMLǡؤΥݥ󥿡
		   xml -- XMLǡǼĥ꡼¤ΤƬؤΥݥ󥿡ĥ꡼ΥǤ

	͡ return -- XMLĥ꡼ǡΥ󥫡ؤΥݥ
					   ->altp ˺Ǹ˽ؤΥݥ󥿤Ǽ롥
					   ᤬Դξ ->state ˾֤ͤ롥

*/
tXML*  xml_parse_seq(tXML* xml, char* pp)
{
	int   skip = FALSE;
	tXML* tag;

	if (xml==NULL) {
		xml = new_tTree_node();
		xml->ldat.id = XML_ANCHOR_TAG;
		skip = TRUE;
	}
	else {
		tXML* top = find_xml_top(xml);
		if (top==xml) top->state = XML_DEFAULT_STATE;
	}

	tag = xml_partial_parse(xml, pp, skip);
	xml = find_xml_top(xml);
	xml->altp = tag;

	if (xml!=tag) return xml;

	if (tag->state==0) xml->state = XML_PARSED;
	else			   xml->state = tag->state;

	if (xml->next!=NULL) {
		int n = 0;
		tag = xml->next;
		while(tag!=NULL) {
			if (tag->ldat.id==XML_TAG_NAME) n++;
			tag = tag->ysis;
		}
		if (n!=1) xml->state = XML_MULTI_ROOT;
	}
	else xml->state = XML_DEFAULT_STATE;

	return xml;
}





/**
tXML*  xml_parse_file(char* fn)

	ǽե뤫ɤ߹ǥѡ롥

	fn -- ɤ߹ե̾

	͡ return -- XMLǡǼ tXMLΥ󥫡ؤΥݥ 

*/
tXML*  xml_parse_file(char* fn)
{
	tXML*  xml = NULL;
	Buffer buf;

	buf = read_Buffer_file(fn);
	if (buf.buf!=NULL) {
		xml = xml_parse((char*)(buf.buf));
		free_Buffer(&buf);
	}

	return xml;
}





/**
tXML*  xml_partial_parse(tXML* xml, char* pp, int skip)

	ǽʬŪ XMLǡᤷơtXMLΥĥ꡼¤˳Ǽ롥
		   XMLǡǤʤƤǤȤޤǤϲ᤹롥
		  ѡΥᥤؿ桼ľܤδؿѤ뤳Ȥ¿ʬ̵

	 pp  -- XMLǡؤΥݥ󥿡
		   xml -- XMLǡǼĥ꡼¤ΤƬؤΥݥ󥿡
		   skip - ǽΥǡʥȥʤɡˤ򥹥åפ뤫 TRUE or FLASE

	͡ return -- Ǹ˽ΡɤؤΥݥ󥿡
					   顼ξ ->state  0̤ͤ롥
					   pp NULLξ xml, xml NULLξ NULL֤롥

*/
tXML*  xml_partial_parse(tXML* xml, char* pp, int skip)
{
	int   n, tag_end;
	char* tag_name = NULL;
	char* tag_attr = NULL;
	char* value	   = NULL;
	

	if (pp ==NULL) return xml;
	if (xml==NULL) return NULL;

	if (skip) while (*pp!='\0' && *pp!='<') pp++;

	while (*pp!='\0') {
		n = 1;

		if (*pp=='<') {
			// End TAG		</   >
			if (*(pp+1)=='/') {
				if (xml->state==XML_TAG_STARTED) {
					n = xml_parse_end_tag(pp, &tag_name);
					if (n>0) {
						if (tag_name!=NULL && xml->ldat.key.buf!=NULL) {
							if (!strcmp((const char*)tag_name, (const char*)(xml->ldat.key.buf))) {
								xml->state = XML_TAG_ENDED;
								if (xml->prev!=NULL) xml = xml->prev;
								else n = xml->state = XML_SEQUENCE_ERROR;
							}
							else n = xml->state = XML_PARSE_ERROR;
						}
						else n = xml->state = XML_PARSE_ERROR;
					}
					else xml->state = n;					// 顼
				}
				else n = xml->state = XML_PARSE_ERROR;
			}


			// Comment TAG		<!--   -->
			else if (!strncmp(pp+1, "!--", 3)) {
				n = xml_parse_comment_tag(pp, &value);
				if (n>0) {
					xml = add_tTree_node_bystr(xml, XML_COMMENT_TAG, 0, XML_COMMENT_TAG_KEY, value, NULL, 0);
					xml->state = XML_TAG_EMPTY;
					if (xml->prev!=NULL) xml = xml->prev;
					else n = xml->state = XML_SEQUENCE_ERROR;
				}
			}


			// Data TAG			<!     >
			else if (*(pp+1)=='!') {
				n = xml_parse_data_tag(pp, &value);
				if (n>0) {
					xml = add_tTree_node_bystr(xml, XML_DATA_TAG, 0, XML_DATA_TAG_KEY, value, NULL, 0);
					xml->state = XML_TAG_EMPTY;
					if (xml->prev!=NULL) xml = xml->prev;
					else n = xml->state = XML_SEQUENCE_ERROR;
				}
			}


			// Processing TAG  	<?   ?>
			else if (*(pp+1)=='?') {
				n = xml_parse_processing_tag(pp, &tag_name, &tag_attr);
				if (n>0) {
					if (!strncasecmp("xml", tag_name, 3)) {
						tList* lp = xml_parse_attr(tag_attr);
						xml = add_tTree_node_bystr(xml, XML_DOC_TAG, 0, tag_name, NULL, NULL, 0);
						xml->ldat.lst = lp;
					}
					else {
						xml = add_tTree_node_bystr(xml, XML_PROCESS_TAG, 0, tag_name, tag_attr, NULL, 0);
					}
					xml->state = XML_TAG_EMPTY;
					if (xml->prev!=NULL) xml = xml->prev;
					else n = xml->state = XML_SEQUENCE_ERROR;
				}
			}


			// Start TAG  <   > 
			else {
				n = xml_parse_start_tag(pp, &tag_name, &tag_attr, &tag_end);

				if (n>0) {
					tList* lp = xml_parse_attr(tag_attr);
					xml = add_tTree_node_bystr(xml, XML_TAG_NAME, 0, tag_name, NULL, NULL, 0);
					xml->ldat.lst = lp;

					if (tag_end) {
						xml->state = XML_TAG_EMPTY;
						if (xml->prev!=NULL) xml = xml->prev;
						else n = xml->state = XML_SEQUENCE_ERROR;
					}
					else {
						int m;
						xml->state = XML_TAG_STARTED;
						// 
						m = xml_parse_content(pp+n, &value);			// 0 ֤ǽ
						if (m>=0) {
							n += m;
							if (value!=NULL) {
								xml = add_tTree_node_bystr(xml, XML_TAG_CONTENT, 0, value, NULL, NULL, 0);
								xml->state = XML_TAG_ENDED;
								if (xml->prev!=NULL) {
									xml = xml->prev;
									xml->ldat.lv++;
								}
								else n = xml->state = XML_SEQUENCE_ERROR;
							}
						}
						else n = xml->state = m;					// 顼
					}
				}
			}


			freeNull(tag_name);
			freeNull(tag_attr);
			freeNull(value);
		}


		// Content		(ŪϤXML content ǽäƤʤ)
		else {
			if (xml->state==XML_TAG_STARTED) {
				n = xml_parse_content(pp, &value);
				if (n>0) {
					if (value!=NULL) {
						xml = add_tTree_node_bystr(xml, XML_TAG_CONTENT, 0, value, NULL, NULL, 0);
						xml->state = XML_TAG_ENDED;
						if (xml->prev!=NULL) {
							xml = xml->prev;
							xml->ldat.lv++;
						}
						else n = xml->state = XML_SEQUENCE_ERROR;
					}
				}
				else n = xml->state = XML_PARSE_ERROR;
				freeNull(value);
			}
			else n = xml->state = XML_PARSE_ERROR;
		}


		// 顼
		if (n<=0) return xml;

		pp += n;
		while (*pp==' ' || *pp==TAB || *pp==LF || *pp==CR) pp++;
	}

	return xml;
}






///////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Paese of TAG
// 

/**
int  xml_parse_start_tag(char* pp, char** tag_name, char** tag_attr, int* tag_end)

	ǽXMLγϥ롥Ǥ륿η
			<tag_name attr1="value1" attr2="value2">
			<tag_name attr1="value1" attr2="value2" />
	
		 ˤδؿǤϡ°ʬ(*tag_attr)βϹԤʤΤǡ xml_parse_attr() 
			 ǹԤɬפ롥

	pp		-- ؤΥݥ󥿡'<' ؤݥ󥿡
		  *tag_name -- ̾Ǽݥ󥿡
		  *tag_attr -- °ʬǼݥ󥿡
		  *tag_end  -- ñȤĤƤ뤫ɤǼѿ

	͡
		  return	-- 1>=: ΤĹ0 ֤뤳Ȥ̵
					   XML_PARSE_ERROR:  ѡ顼
					   XML_MEMORY_ERROR: ꥨ顼
		  *tag_name -- ̾Ǽ롥free
		  *tag_attr -- °ʬǼ롥ʲˤϹԤʤfree
		  *tag_end  -- ñȤĤƤ(Empty Tag) TRUE, Ǥʤ FALSEfree
*/
int  xml_parse_start_tag(char* pp, char** tag_name, char** tag_attr, int* tag_end)
{
	int   nn, mm;
	char* pt;

	*tag_end  = FALSE;
	*tag_name = NULL;
	*tag_attr = NULL;

	if (*pp!='<') return XML_PARSE_ERROR;
	pt = pp = pp + 1;
	pt = skip_char(pt, " />");
	if (pt==NULL) return XML_PARSE_ERROR;

	nn = mm = (int)(pt - pp);
	if (mm==0) return XML_PARSE_ERROR;

	nn = nn + 1;
	*tag_name = (char*)malloc((size_t)(mm + 1));
	if (*tag_name==NULL) return XML_MEMORY_ERROR;
	memcpy(*tag_name, pp, mm);
	(*tag_name)[mm] = '\0';
	//print_message("START --> %s  %d\n", *tag_name, (int)strlen(*tag_name));

	if (isnot_xml_name((unsigned char*)(*tag_name))) return XML_PARSE_ERROR;


	// Empty TAG
	if (*pt=='/') {
		if (*(pt+1)!='>') {
			freeNull(*tag_name);
			return XML_PARSE_ERROR;
		}
		nn += 1;
		*tag_end = TRUE;
		//print_message("END   --> %s  %d\n", *tag_name, (int)strlen(*tag_name));
	}


	// Attribute
	else if (*pt==' ') {
		pp = pt = pt + 1;
		while (*pt==' ' || *pt==TAB || *pt==LF || *pt==CR) pt++;
		nn += (int)(pt - pp) + 1;

		pp = pt;
		pt = skip_char(pt, "/>");
		if (pt==NULL) {
			freeNull(*tag_name);
			return XML_PARSE_ERROR;
		}

		mm = (int)(pt - pp);
		if (mm>0) {
			*tag_attr = (char*)malloc((size_t)(mm + 1));
			if (*tag_attr==NULL) {
				freeNull(*tag_name);
				return XML_MEMORY_ERROR;
			}
			memcpy(*tag_attr, pp, mm);
			(*tag_attr)[mm] = '\0';
			nn += mm;
			//print_message("ATTR  --> %s  %d\n", *tag_attr, (int)strlen(*tag_attr));
		}

		if (*pt=='/') {
			if (*(pt+1)!='>') {
				freeNull(*tag_name);
				freeNull(*tag_attr);
				return XML_PARSE_ERROR;
			}
			nn += 1;
			*tag_end = TRUE;
			//print_message("END   --> %s  %d\n", *tag_name, (int)strlen(*tag_name));
		}
	}
	
	//else {}   *pt=='>'

	return nn + 1;
}





/**
int  xml_parse_end_tag(char* pp, char** tag_name)

	ǽXMLνλ롥Ǥ륿η </tag_name>
	
	pp		-- ؤΥݥ󥿡'<' ؤݥ󥿡
		  *tag_name -- ̾Ǽݥ󥿡

	͡
		  return	-- 0>: ΤĹ0 ֤뤳Ȥ̵
					   XML_PARSE_ERROR:  ѡ顼
					   XML_MEMORY_ERROR: ꥨ顼
		  *tag_name -- ̾Ǽ롥free
*/
int  xml_parse_end_tag(char* pp, char** tag_name)
{
	int   nn, mm;
	char* pt;
	char* work;

	if (pp==NULL) return XML_PARSE_ERROR;
	*tag_name = NULL;

	if (strncmp(pp ,"</", 2)) return XML_PARSE_ERROR;

	pt = pp = pp + 2;
	pt = skip_char(pt, ">");
	if (pt==NULL) return XML_PARSE_ERROR;

	nn = mm = (int)(pt - pp);
	if (mm==0) return XML_PARSE_ERROR;

	nn += 2;
	work = (char*)malloc((size_t)(mm+1));
	if (work==NULL) return XML_MEMORY_ERROR;
	memcpy(work, pp, mm);
	work[mm] = '\0';
	*tag_name = pack_head_tail_char(work, ' ');
	free(work);
	//print_message("END   --> %s  %d\n", *tag_name, (int)strlen(*tag_name));

	return nn + 1;
}





/**
int  xml_parse_content(char* pp, char** content)

	ǽXMLΥƥȤ롥 <tag_name attr="tag_attr">content</tag_name>
		  ͤζTAB, LF, CRϺ롥
	
	pp	   -- ƥȤƬؤΥݥ󥿡Start Tag '>' μؤݥ󥿡
		  *content -- ƥȤǼݥ󥿡ƥȤʤ NULLǤġ

	͡
		  return   -- 0>=: ΤĹ0 ֤ǽ⤢(<a></a>ξ
					  XML_PARSE_ERROR:  ѡ顼
					  XML_MEMORY_ERROR: ꥨ顼
		  *content -- ƥȤǼ롥 , TAB, LF, CRϺƤ롥free
*/
int  xml_parse_content(char* pp, char** content)
{
	int   nn=0, mm;
	char* pt;
	char* work;

	if (pp==NULL || content==NULL) return XML_PARSE_ERROR;
	*content = NULL;

	while (*pp==' ' || *pp==TAB || *pp==LF || *pp==CR) {
		pp++;
		nn++;
	}
	if (*pp=='<') return nn;			// <tag><

	pt = pp;
	while (*pt!='<' && *pt!='\0') pt++;

	mm = (int)(pt - pp);
	if (mm==0) return nn;
	nn += mm;

	work = (char*)malloc((size_t)(mm+1));
	if (work==NULL) return XML_MEMORY_ERROR;
	memcpy(work, pp, mm);
	work[mm] = '\0';

	*content = pack_head_tail_char(work, ' ');
	free(work);
	//print_message("VALUE --> %s  %d\n", *content, (int)strlen(*content));

	return nn;
}





/**
tList*  xml_parse_attr(char* pp)

	ǽXMLΥ°ᤷơꥹ(tList)ˤ롥 ᤹  AAA="GGG" xxxx="1234"

	ƥȤ¸Ƥ°ؤΥݥ󥿡

	͡ꥹȤƬؤΥݥ󥿡
			ѡ顼ξ state  XML_PARSE_ERROR ꤵ롥˽λ
			 XML_TAG_ENDED ꤵ롥
*/
tList*  xml_parse_attr(char* pp)
{
	int	   sz;
	char*  nm;
	char*  vl;
	char*  pt;
	char   qt;
	tList* lp = NULL;
	tList* lt = NULL;


	// ȥγ
	if (pp==NULL) return NULL;
	sz = (int)strlen((const char*)pp) + 1;
	nm = (char*)malloc(sz);
	if (nm==NULL) return NULL;
	vl = (char*)malloc(sz);
	if (vl==NULL) {
		free(nm);
		return NULL;
	}

	// Parse for AAA="BBB" CCC="DDDD"
	while (*pp==' ' && *pp!='\0') pp++;
	while (*pp!='\0') {
		pt = pp;
		while (*pt!='=' && *pt!='\0') pt++;
		if (*pt=='\0') {
			if (lt!=NULL) lt->state = XML_PARSE_ERROR;
			break;
		}

		sz = (int)(pt - pp);
		memcpy(nm, pp, (size_t)sz);
		nm[sz] = '\0';

		pt++;
		if (*pt!='"' && *pt!='\'') {
			if (lt!=NULL) lt->state = XML_PARSE_ERROR;
			break;
		}
		else qt = *pt;

		pt++;
		pp = pt;
		while(*pt!=qt && *pt!='\0') pt++;
		if (*pt=='\0') {
			if (lt!=NULL) lt->state = XML_PARSE_ERROR;
			break;
		}

		sz = (int)(pt - pp);
		memcpy(vl+1, pp, (size_t)sz);
		vl[0]	 = qt;
		vl[sz+1] = qt;
		vl[sz+2] = '\0';

		lp = add_tList_node_str(lp, nm, vl);
		if (lt==NULL) lt = lp;
		pp = pt + 1;

		if (*pp!=' ' && *pp!='\0') {
			lt->state = XML_PARSE_ERROR;
			break;
		}
		while (*pp==' ' && *pp!='\0') pp++;
	}

	//
	free(nm);
	free(vl);

	if (lt!=NULL) {
		if (lt->state!=XML_PARSE_ERROR) lt->state = XML_TAG_ENDED;
	}
	return lt;
}





/**
int  xml_parse_processing_tag(char* pp, char** tag_name, char** tag_attr)

	ǽXMLΥץå󥰥롥Ǥ륿η <?processing?>
		  ץåʬϲ᤻ˡΤޤ tag_name, tag_attr˳Ǽ롥

	pp		-- ؤΥݥ󥿡'<' ؤݥ󥿡
		  *tag_name -- ץå󥰤̾ʬǼݥ󥿡
		  *tag_attr -- ץå󥰤°ʬǼݥ󥿡

	͡
		  return	-- 0>: ΤĹ0 ֤뤳Ȥ̵
					   XML_PARSE_ERROR:  ѡ顼
					   XML_MEMORY_ERROR: ꥨ顼
		  *tag_name -- ץå󥰤̾ʬǼ롥free
		  *tag_attr -- ץå󥰤°ʬǼ롥free
*/
int  xml_parse_processing_tag(char* pp, char** tag_name, char** tag_attr)
{
	int   nn, mm;
	char* pt;

	*tag_name = NULL;
	*tag_attr = NULL;

	if (pp==NULL) return XML_PARSE_ERROR;
	if (strncmp(pp, "<?", 2)) return XML_PARSE_ERROR;

	pt = pp = pp + 2;
	pt = skip_char(pt, " ?");
	if (pt==NULL) return XML_PARSE_ERROR;

	nn = mm = (int)(pt - pp);
	if (mm==0) return XML_PARSE_ERROR;

	nn += 2;
	*tag_name = (char*)malloc((size_t)(mm + 1));
	if (*tag_name==NULL) return XML_MEMORY_ERROR;
	memcpy(*tag_name, pp, mm);
	(*tag_name)[mm] = '\0';

	if (isnot_xml_name((unsigned char*)(*tag_name))) return XML_PARSE_ERROR;

	// for attribute
	if (*pt==' ') {
		pp = pt = pt + 1;
		while (*pt==' ' || *pt==TAB || *pt==LF || *pt==CR) pt++;
		nn += (int)(pt - pp) + 1;

		pp = pt;
		pt = skip_char(pt, "?");
		if (pt==NULL) {
			freeNull(*tag_name);
			return XML_PARSE_ERROR;
		}

		mm = (int)(pt - pp);
		if (mm>0) {
			*tag_attr = (char*)malloc((size_t)(mm + 1));
			if (*tag_attr==NULL) {
				freeNull(*tag_name);
				return XML_MEMORY_ERROR;
			}
			memcpy(*tag_attr, pp, mm);
			(*tag_attr)[mm] = '\0';
			nn += mm;
			//print_message("ATTR  --> %s  %d\n", *tag_attr, (int)strlen(*tag_attr));
		}
	}
	
	if (strncmp(pt, "?>", 2)) {
		freeNull(*tag_name);
		freeNull(*tag_attr);
		return XML_PARSE_ERROR;
	}

	return nn + 2;
}





/**
int  xml_parse_comment_tag(char* pp, char** comment)

	ǽXMLΥȥ롥Ǥ륿η <!--comment-->
		  xml_parse_data_tag() ΩäŬѤɬפ롥

	pp	  -- ؤΥݥ󥿡'<' ؤݥ󥿡
		  *coment -- ȤǼݥ󥿡

	͡
		  return   -- 0>: ΤĹ0 ֤뤳Ȥ̵
					  XML_PARSE_ERROR:  ѡ顼
					  XML_MEMORY_ERROR: ꥨ顼
		  *commnet -- ʬΤޤ޳Ǽ롥free
*/
int  xml_parse_comment_tag(char* pp, char** comment)
{
	int   nn, mm;
	char* pt;

	*comment = NULL;
	if (pp==NULL) return XML_PARSE_ERROR;
	if (strncmp(pp, "<!--", 4)) return XML_PARSE_ERROR;

	pt = pp = pp + 4;
	pt = skip_char(pt, ">");
	if (pt==NULL) return XML_PARSE_ERROR;

	pt -= 2;
	if (strncmp(pt, "-->", 3)) return XML_PARSE_ERROR;

	nn = mm = (int)(pt - pp);
	if (mm==0) return XML_PARSE_ERROR;

	nn += 4;
	*comment = (char*)malloc((size_t)(mm+1));
	if (*comment==NULL) return XML_MEMORY_ERROR;
	memcpy(*comment, pp, mm);
	(*comment)[mm] = '\0';
	//print_message("COMMENT-> %s  %d\n", *comment, (int)strlen(*comment));

	return nn + 3;
}





/**
int  xml_parse_data_tag(char* pp, char** data)

	ǽXMLΥǡʤ¾ȥʤɡˤ롥
		  Ǥ륿η <!data>
		  ǡʬϲ᤻ˡΤޤ data˳Ǽ롥

	pp	-- ؤΥݥ󥿡'<' ؤݥ󥿡
		  *data -- ǡʬǼݥ󥿡

	͡
		  return -- 0>: ΤĹ0 ֤뤳Ȥ̵
					XML_PARSE_ERROR:  ѡ顼
					XML_MEMORY_ERROR: ꥨ顼
		  *data  -- ǡʬΤޤ޳Ǽ롥free
*/
int  xml_parse_data_tag(char* pp, char** data)
{
	int   nn, mm;
	char* pt;

	*data = NULL;
	if (pp==NULL) return XML_PARSE_ERROR;
	if (strncmp(pp, "<!", 2)) return XML_PARSE_ERROR;

	pt = pp = pp + 2;
	pt = skip_char(pt, ">");
	if (pt==NULL) return XML_PARSE_ERROR;

	nn = mm = (int)(pt - pp);
	if (mm==0) return XML_PARSE_ERROR;

	nn += 2;
	*data = (char*)malloc((size_t)(mm+1));
	if (*data==NULL) return XML_MEMORY_ERROR;
	memcpy(*data, pp, mm);
	(*data)[mm] = '\0';
	//print_message("DATA ---> %s  %d\n", *data, (int)strlen(*data));

	return nn + 1;
}






/**
int  isnot_xml_name(char* pp)

	ǽXML̾ȤŬڤɤޤȽǤ
		  ʤꤤøʤΤǡFALSEȤäơ̩XML̾ȤŬڤǤȤϸ¤ʤ

	pp --  XML̾ؤΥݥ

	͡TRUE  -- XML̾ȤŬ
			FALSE -- XML̾ȤŬڤ⤷ʤ
*/
int  isnot_xml_name(unsigned char* pp)
{
	if (pp==NULL)  return TRUE;
	if (*pp=='\0') return TRUE;

	while (*pp!='\0') {
		if (*pp<=0x2c) return TRUE;					//  !"#$%&'()*+,
		if (*pp==0x2f) return TRUE;					// /
		if (*pp>=0x3b && *pp<=0x40) return TRUE;	// ;<=>?@
		if (*pp>=0x5b && *pp<=0x5e) return TRUE;	// [\]^
		if (*pp==0x60) return TRUE;					// `
		if (*pp>=0x7b && *pp<=0x7f) return TRUE;	// {|}~DEL
		pp++;
	}
	
	return FALSE;
}







//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tools
//

/** 
void   close_xml(tXML* pp)
	
	ǽ: ѡ顼򵯤ĥ꡼Ūﲽ롥

	: pp -- ﲽĥ꡼ؤΥݥ󥿡

	: ʤ

*/
void   close_xml(tXML* pp)
{
	if (pp!=NULL) {

		// 󥫡
 		if (pp->ldat.id==XML_ANCHOR_TAG) {
			pp->state = XML_PARSED;
			pp->depth = 0;
			if (pp->next!=NULL) {
				pp->next->depth = 1;
				adjust_tTree_depth(pp->next);
				close_xml(pp->next);
			}
			return;
		}

		while(pp->esis!=NULL) pp = pp->esis;
		do {
			if (pp->state!=XML_TAG_EMPTY) pp->state = XML_TAG_ENDED;
			if (pp->ldat.lst!=NULL) {
				if ((pp->ldat.lst)->state!=XML_TAG_EMPTY) (pp->ldat.lst)->state = XML_TAG_ENDED;
			}

			if (pp->next!=NULL) close_xml(pp->next);
	   
			pp = pp->ysis;
		} while(pp!=NULL);
	}  
	   
	return;
}




/** 
void   print_xml(FILE* fp, tXML* pp, int mode)
	
	ǽ: XMLɽ

	: fp   -- ϤեؤΥݥ󥿡NULLξ stderr
		  pp   -- ɽ򳫻ϤXMLؤΥݥ󥿡
		  mode -- XML_ONELINE_FORMAT, XML_CRLF_FORMAT, XML_INDENT_FORMAT

	: ʤ

*/
void   print_xml(FILE* fp, tXML* pp, int mode)
{
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		Buffer buf = xml_inverse_parse(pp, mode);
		if (buf.buf!=NULL) {
			fprintf(fp, "%s", buf.buf);
			free_Buffer(&buf);
		}
		else fprintf(fp, "(XML is NULL)\n");
	}  
	else {
		fprintf(fp, "(XML is NULL)\n");
	} 
	fflush(fp);
	   
	return;
}




/** 
void   print_xml_tree(FILE* fp, tXML* pp, char* space)
	
	ǽ: XMLĥ꡼򤽤Τޤޥĥ꡼ɽ롥ǥХåѡ
		  ݥ ppʹߤƤΥΥΥХåեɸ२顼Ϥɽ롥
		  ɽҤοID, Ρɾ, ̾()°θĿ

	: fp    -- ϤեؤΥݥ󥿡NULLξ stderr
		  pp	-- ɽ򳫻ϤΡɤؤΥݥ󥿡
		  space -- Ϥν񼰤·뤿ζʥǥȡˤꤹ롥

	: ʤ

*/
/*
void   print_xml_tree(FILE* fp, tXML* pp, char* space)
{
	int i;
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		for(i=1; i<pp->depth; i++)   fprintf(fp, space);
		for(i=1; i<pp->depth-1; i++) fprintf(fp, "    ");	   // for " -> "
		if (pp->ldat.id==XML_ANCHOR_TAG) pp = pp->next;

		if (pp!=NULL) {
			print_sister_xml_tree_rcsv(fp, pp, space);
		}
		else {
			fprintf(fp, "(XML is ANCHOR only)\n");
		}
	}  
	else {
		fprintf(fp, "(XML is NULL)\n");
	} 
	fflush(fp);
	   
	return;
}
*/

void   print_xml_tree(FILE* fp, tXML* pp, char* space)
{
	int i;
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		for(i=1; i<pp->depth; i++)   fprintf(fp, space);
		for(i=1; i<pp->depth-1; i++) fprintf(fp, "    ");      // for " -> "
		if (pp->ldat.id==XML_ANCHOR_TAG) pp = pp->next;

		if (pp!=NULL) {
			tList_data ld = pp->ldat;
			fprintf(fp, "%d: %d [%d] %s (0)", pp->depth, ld.id, pp->state, ld.key.buf);
			if (pp->next!=NULL) print_sister_xml_tree(fp, pp->next, space);
			else fprintf(fp, "\n");
		}
		else {
			fprintf(fp, "(XML is ANCHOR only)\n");
		}
	}  
	else {
		fprintf(fp, "(XML is NULL)\n");
	}  
	fflush(fp);
  
	return;
}





/** 
void   print_sister_xml_tree(FILE* fp, tXML* pp, char* space)
	
	ǽ: XMLĥ꡼ɽppλΡɤϤ롥
		  ݥ ppʹߤƤΥΡɤΥΥХåեɸ२顼Ϥɽ롥
		  ɽҤοID, Ρɾ, ̾()°θĿ

	: fp    -- ϤեؤΥݥ󥿡NULLξ stderr
		  pp	-- ɽ򳫻ϤΡɤؤΥݥ󥿡(ΡɤϤ
		  space -- Ϥν񼰤·뤿ζʥǥȡˤꤹ롥

	: ʤ

*/
void   print_sister_xml_tree(FILE* fp, tXML* pp, char* space)
{
	int i;
	if (pp!=NULL) {
		for(i=1; i<pp->depth; i++)   fprintf(fp, space);
		for(i=1; i<pp->depth-1; i++) fprintf(fp, "    ");	   // for " -> "
	}

	print_sister_xml_tree_rcsv(fp, pp, space);
}





/**
void   print_sister_xml_tree_rcsv(FILE* fp, tXML* pp, char* space)

	ǽprint_sister_xml_tree() κƵѴؿ

*/
void   print_sister_xml_tree_rcsv(FILE* fp, tXML* pp, char* space)
{
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		if (pp->ldat.id==XML_ANCHOR_TAG) {
			if (pp->next!=NULL) pp = pp->next;
		}

		while(pp->esis!=NULL) pp = pp->esis;
		do {
			int i;
			tList_data ld = pp->ldat;

		   	if (pp->depth>1) fprintf(fp, " -> ");
			i = count_tList((tList*)ld.lst);
			fprintf(fp, "%d: %d [%d] %s (%d)", pp->depth, ld.id, pp->state, ld.key.buf, i);

			if (pp->next!=NULL) print_sister_xml_tree_rcsv(fp, pp->next, space);
			else fprintf(fp, "\n");
	   
			pp = pp->ysis;
			if (pp!=NULL) {
				for(i=1; i<pp->depth; i++)   fprintf(fp, space);
				for(i=1; i<pp->depth-1; i++) fprintf(fp, "    ");	   // for " -> "
			}
		} while(pp!=NULL);
	}  
	else {
		fprintf(fp, "(XML is NULL)\n");
	} 
	fflush(fp);
	   
	return;
}








///////////////////////////////////////////////////////////////////////////////////////
//
// Operation
//

/**
tXML* 	add_xml_tag(tXML* xml, char* name)

	ǽXMLĥ꡼xml ľ˳ϥ롥

*/
tXML* 	add_xml_tag(tXML* xml, char* name)
{
	tList* pp;

	if (xml==NULL || name==NULL) return NULL;

	pp = add_tTree_node_bystr(xml, XML_TAG_NAME, 0, name, NULL, NULL, 0);
	pp->state = XML_TAG_STARTED;
	if (pp->prev!=NULL) pp->prev->ldat.lv++;

	return pp;
}




/**
tXML* 	add_xml_content(tXML* xml, char* content)

	ǽXMLĥ꡼xml ľ˥ƥȤ롥
		  xml̾ΡɤǤʤХ顼NULL֤

*/
tXML* 	add_xml_content(tXML* xml, char* content)
{
	tList* pp;

	if (xml==NULL || content==NULL) return NULL;
	if (xml->ldat.id!=XML_TAG_NAME) return NULL;

	pp = add_tTree_node_bystr(xml, XML_TAG_CONTENT, 0, content, NULL, NULL, 0);
	pp->state = XML_TAG_ENDED;
	if (pp->prev!=NULL) pp->prev->ldat.lv++;
  
	return pp;
}




/**
tXML*  get_xml_tag(tXML* pp, tXML* pt)

	ǽXMLĥ꡼ pp XMLĥ꡼ ptƱѥλޤõpt˺ǽ˰פޤΡ
		  ǸΥΡɤؤΥݥ󥿤֤

		  ޤpt  ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_NODE ȤʤäƤ륿Ӥʤ
		  ֤äƤ tXML*  free ƤϤʤ

	pp -- оݤΥĥ꡼
		  pt -- ѥ

	͡ptκǸΥб륿ؤΥݥ󥿡freeƤϤʤ

	----------------------------------------------------------------
	㡧	pp						  pt
			A --> B --> M			  C --> M --> Y
			  --> C --> M --> X			   
						  --> Y	--> Z   
					--> N
		ξ硤pp YؤΥݥ󥿤֤롥
*/
tXML*  get_xml_tag(tXML* pp, tXML* pt)
{
	int fnd;
	tXML* tt;
	tXML* pm;

	if (pp==NULL || pt==NULL) return NULL;

	pm = pp;
	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return NULL;
	}
	if (pt->ldat.id==XML_ANCHOR_TAG) {
		if (pt->next!=NULL) pt = pt->next;
		else return NULL;
	}

	tt = find_xml_end(pt);
	if (tt==NULL) return FALSE;

	while(pp->esis!=NULL) pp = pp->esis;
	fnd = find_match_xml(pp, pt);
	if (fnd) tt = tt->altp;
	else     tt = NULL;

	clear_tTree_ctrl(pm);

	return tt;
}




/**
int set_xml_tag(tXML* pp, tXML* pt, char* name)

	ǽXMLĥ꡼ pp XMLĥ꡼ ptƱѥλޤõpt˺ǽ˰פޤΡ
		ǸΥΡɤ˥̾򥳥ԡ롥

		pt  ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ȤʤäƤ
		  ΡɤӤʤ
	
	pp   -- оݤXMLĥ꡼
		  pt   -- ѥ
		  name -- ptκǸΥб륿˥ԡ륿̾

	͡TRUE : ꤹ륿Ρɤ򸫤Ĥ줿ɤ
			FALSE: ꤹ륿Ρɤ򸫤Ĥʤä
*/
int set_xml_tag(tXML* pp, tXML* pt, char* name)
{
	tXML* tt;

	if (pp==NULL || pt==NULL || name==NULL) return FALSE;

	tt = get_xml_tag(pp, pt);
	if (tt==NULL) return FALSE;
	
	copy_s2Buffer(name, &(tt->ldat.key));

	return TRUE;
}




/**
int set_xml_end_tag(tXML* pp, tXML* pt)

	ǽXMLĥ꡼ pp XMLĥ꡼ ptƱѥλޤõpt˺ǽ˰פޤΡ
	ǸΥΡɤ ptκǸΥ͡ʴޤ°ˤԡ롥

		ptκǸΥΡɤ˴ؤƤӤʤ(ԡѤ)

		  pt  ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ȤʤäƤΡɤ
		  ӤʤΥΡɤɬפ롥
		  ԡԤΤ ptκǸΥΡɤΤߤǤ롥

		ԡ° ldat.id, ldat.lv, ldat.sz, ldat.key, ldat.val, ldat.ptr, ldat.lst
		ldat.val, ldat.ptr, ldat.lst ˤĤƤϡptͤꤵƤʤС֤Ԥʤ
	
	pp -- оݤXMLĥ꡼
		  pt -- ѥ

	͡TRUE : ꤹޤ򸫤Ĥ줿ɤ
			FALSE: ꤹޤ򸫤Ĥʤä
*/
int set_xml_end_tag(tXML* pp, tXML* pt)
{
	int	  ret;
	tXML* tt;
	tXML* pm;


	if (pp==NULL || pt==NULL) return FALSE;

	pm = pp;
	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return FALSE;
	}
	if (pt->ldat.id==XML_ANCHOR_TAG) {
		if (pt->next!=NULL) pt = pt->next;
		else return FALSE;
	}

	tt = find_xml_end(pt);
	if (tt==NULL) return FALSE;
	tt->ctrl = TREE_NOCMP_COPY_NODE;		// ٤ʤǸ˥ԡ

	while(pp->esis!=NULL) pp = pp->esis;
	ret = find_match_xml(pp, pt);
	if (ret) {
		copy_tTree_byctrl(pt);
		adjust_tTree_depth(pp);
	}

	clear_tTree_ctrl(pm);

	return ret;
}




/**
tXML*  get_xml_content(tXML* pp, tXML* pt)

	ǽXMLĥ꡼ pp XMLĥ꡼ ptƱѥλޤõpt˺ǽ˰פޤΡ
		  ǸΥΥƥȤؤΥݥ󥿤֤

		  pt  ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ȤʤäƤΡɤ
		  ӤʤΥΡɤɬפ롥

		  ֤äƤ tXML*  free ƤϤʤ

	pp -- оݤΥĥ꡼
		  pt -- ѥ

	͡ptκǸΥμΥб륳ƥȤؤΥݥ󥿡freeƤϤʤ

	----------------------------------------------------------------
	㡧	pp						  pt
			A --> B --> M			  C --> M --> Y
			  --> C --> M --> X			   
						  --> Y	--> Z   
					--> N
		ξ硤Z ؤΥݥ󥿤֤롥
*/
tXML*  get_xml_content(tXML* pp, tXML* pt)
{
	int fnd;
	tXML* tt = NULL;
	tXML* pm;
	tXML* dm;

	if (pp==NULL || pt==NULL) return NULL;

	pm = pp;
	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return NULL;
	}
	if (pt->ldat.id==XML_ANCHOR_TAG) {
		if (pt->next!=NULL) pt = pt->next;
		else return NULL;
	}

	tt = find_xml_end(pt);
	if (tt==NULL) return NULL;
	dm = add_xml_content(tt, "DUMMY");
	dm->ctrl = TREE_NOCMP_NODE;

	while(pp->esis!=NULL) pp = pp->esis;

	fnd = find_match_xml(pp, pt);
	if (fnd) tt = dm->altp;
	else     tt = NULL;

	del_xml(&dm);
	clear_tTree_ctrl(pm);

	return tt;
}




/**
int set_xml_content(tXML* pp, tXML* pt, char* content)

	ǽXMLĥ꡼ pp XMLĥ꡼ ptƱѥλޤõpt˺ǽ˰פޤΡ
	ǸΥΥƥȤ content֤롥

		  pt  ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ȤʤäƤΡɤ
		  ӤʤΥΡɤɬפ롥
	
	pp  -- оݤXMLĥ꡼
		  pt  -- ѥ
		  val -- ptκǸΥб륿˥ԡ륿͡

	͡TRUE : ꤹޤ򸫤Ĥ줿ɤ
			FALSE: ꤹޤ򸫤Ĥʤä
*/
int set_xml_content(tXML* pp, tXML* pt, char* content)
{
	tXML* tt;

	if (pp==NULL || pt==NULL || content==NULL) return FALSE;

	tt = get_xml_content(pp, pt);
	if (tt==NULL) return FALSE;
	
	copy_s2Buffer(content, &(tt->ldat.key));

	return TRUE;
}




/**
tList*  get_xml_attr(tXML* pp, tXML* pt)

	ǽXMLĥ꡼ pp XMLĥ꡼ ptƱѥλޤõpt˺ǽ˰פޤΡ
		  ǸΥΡɤΥ°֤ͤ

		  pt  ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ȤʤäƤΡɤ
		  ӤʤΥΡɤɬפ롥

	pp -- оݤΥĥ꡼
		  pt -- ѥ

	͡ptκǸΥбˤ롤ppΥ°

*/
tList*  get_xml_attr(tXML* pp, tXML* pt)
{
	tList* lp = NULL;
	tXML*  tt;

	if (pp==NULL || pt==NULL) return NULL;

	tt  = get_xml_tag(pp, pt);
	if (tt!=NULL) lp = tt->ldat.lst;	

	return lp;
}




/**
int   set_xml_attr(tXML* pp, tXML* pt, tList* at)

	ǽXMLĥ꡼ pp XMLĥ꡼ ptƱѥλޤõpt˺ǽ˰פޤΡ
	ǸΥΡɤ˥°Ȥ atͤ򥳥ԡ롥

		  pt  ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ȤʤäƤΡɤ
		  ӤʤΥΡɤɬפ롥

	pp -- оݤΥĥ꡼
		  pt -- ѥ
		  at -- ꤹ°γǼ줿ꥹȡldat.key°̾ldat.val°("'դ)

	͡TRUE : ꤹޤ򸫤Ĥ֤줿ɤ
			FALSE: ꤹޤ򸫤Ĥʤä

*/
int   set_xml_attr(tXML* pp, tXML* pt, tList* at)
{
	tXML* tt;

	if (pp==NULL || pt==NULL || at==NULL) return FALSE;

	tt  = get_xml_tag(pp, pt);
	if (tt!=NULL) {
		del_all_tList(&(tt->ldat.lst));
		tt->ldat.lst = dup_tList(at);
	}
	else return FALSE;

	return TRUE;
}




/**
char*   get_first_tag_name(tXML* xml)

	ǽXMLĥ꡼κǽΥ֤̾

	xml -- XMLĥ꡼

	͡XMLĥ꡼κǽΥ̾freeƤϤʤ

*/
char*   get_first_tag_name(tXML* xml)
{  
	char* tagname = NULL;
   
	if (xml==NULL) return NULL;
	tList* lp = xml;
	if (lp->ldat.id==XML_ANCHOR_TAG) lp = lp->next;
   
	while (lp!=NULL) {
		if (lp->ldat.id==XML_TAG_NAME) {
			if (lp->ldat.key.buf!=NULL) {
				tagname = (char*)lp->ldat.key.buf;
				break;
			}
		}
		lp = lp->ysis;
	}
	return tagname;
}




/**
int	  replace_xml_content(tXML*pp, tXML* pt, char* src, char* dst)


*/
int	  replace_xml_content(tXML*pp, tXML* pt, char* src, char* dst)
{
	tXML*  tt;
	Buffer tg;

	if (pp==NULL || pt==NULL || src==NULL || dst==NULL) return FALSE;

	tt = get_xml_content(pp, pt);
	if (tt==NULL) return FALSE;

	tg = replace_sBuffer_bystr(tt->ldat.key, src, dst);
	if (tg.buf==NULL) return FALSE;

	free_Buffer(&(tt->ldat.key));
	tt->ldat.key = tg;
	
	return TRUE;
}




/**
tXML*  find_match_xml_end_tag(tXML* pp, tXML* pt)

	ǽXMLĥ꡼ pp XMLĥ꡼ ptƱѥλޤõptκǸΥб 
		  ppΥΡɤؤΥݥ󥿤֤Ρɤ ̾ƥȤΤɤǤġ

	pp -- оݤXML
		  pt -- ѥʸ

	͡strκǸΥΡɤб ppΥΡɡ

*/
tXML*  find_match_xml_end_tag(tXML* pp, tXML* pt)
{
	int    ret;
	tXML*  tt = NULL;
	tXML*  pm;

	if (pp==NULL || pt==NULL) return NULL;

	pm  = pp;
	ret = find_match_tTree(pp, pt);
	if (ret) {
		tt = find_xml_end(pt);
		if (tt!=NULL) {
			tt = tt->altp;
		}
	}

	clear_tTree_ctrl(pm);

	return tt;
}






////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
	tXML*  	get_xml_tag(tXML* pp, tXML* pt)
	tXML*  	set_xml_tag(tXML* pp, tXML* pt, char* val)
	int 	set_xml_end_tag(tXML* pp, tXML* pt)

	tXML*  	get_xml_content(tXML* pp, tXML* pt)
	int 	set_xml_content(tXML* pp, tXML* pt, char* val)
	tList*  get_xml_attr(tXML* pp, tXML* pt)
	int   	set_xml_attr(tXML* pp, tXML* pt, tList* at)

	int	  	replace_xml_content(tXML*pp, tXML* pt, char* src, char* dst)

	 _bystr С
*/

tXML*  get_xml_tag_bystr(tXML* pp, char* str)
{
	tXML* tx;
	tXML* tt;

	if (pp==NULL || str==NULL) return FALSE;

	tx = xml_parse(str);
	tt = get_xml_tag(pp, tx);
	del_xml(&tx);

	return tt;
}



int  set_xml_tag_bystr(tXML* pp, char* str, char* val)
{
	tXML*  tx;
	int	rt;

	if (pp==NULL || str==NULL || val==NULL) return FALSE;

	tx = xml_parse(str);
	rt = set_xml_tag(pp, tx, val);
	del_xml(&tx);

	return rt;
}



int  set_xml_end_tag_bystr(tXML* pp, char* str)
{
	tXML*  tx;
	int	rt;

	if (pp==NULL || str==NULL) return FALSE;

	tx = xml_parse(str);
	rt = set_xml_end_tag(pp, tx);
	del_xml(&tx);

	return rt;
}



tXML*  get_xml_content_bystr(tXML* pp, char* str)
{
	tXML* tx;
	tXML* tt;

	if (pp==NULL || str==NULL) return FALSE;

	tx = xml_parse(str);
	tt = get_xml_content(pp, tx);
	del_xml(&tx);

	return tt;
}




int  set_xml_content_bystr(tXML* pp, char* str, char* val)
{
	tXML*  tx;
	int	rt;

	if (pp==NULL || str==NULL || val==NULL) return FALSE;

	tx = xml_parse(str);
	rt = set_xml_content(pp, tx, val);
	del_xml(&tx);

	return rt;
}




tList*  get_xml_attr_bystr(tXML* pp, char* str)
{
	tXML*  tx;
	tList* tt;

	if (pp==NULL || str==NULL) return FALSE;

	tx = xml_parse(str);
	tt = get_xml_attr(pp, tx);
	del_xml(&tx);

	return tt;
}



int  set_xml_attr_bystr(tXML* pp, char* str, tList* at)
{
	tXML* tx;
	int   rt;

	if (pp==NULL || str==NULL || at==NULL) return FALSE;

	tx = xml_parse(str);
	rt = set_xml_attr(pp, tx, at);
	del_xml(&tx);

	return rt;
}



int	  replace_xml_content_bystr(tXML*pp, char* str, char* src, char* dst)
{
	tXML* tx;
	int   rt;

	if (pp==NULL || src==NULL || src==NULL || dst==NULL) return FALSE;

	tx = xml_parse(str);
	rt = replace_xml_content(pp, tx, src, dst);
	del_xml(&tx);

	return rt;
}







////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
tList*  get_xml_tag_list(tXML* pp, tXML* pt)

	ǽXMLĥ꡼ pp XMLĥ꡼ ptƱѥλޤõpt˰פޤΡǸΥΡɤؤ
		  ݥ󥿤ꥹȤ˳Ǽ֤ݥ󥿤ϥꥹȤ altp˳Ǽ롥

		  pt  ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ȤʤäƤΡɤ
		  ӤʤΥΡɤɬפ롥

	pp -- оݤΥĥ꡼
		  pt -- ѥ

	͡ΡɤؤΥݥ󥿾(altp)ޤꥹȤؤΥݥ
*/
tList*  get_xml_tag_list(tXML* pp, tXML* pt)
{
	tList* lp;

	if (pp==NULL || pt==NULL) return NULL;

	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return NULL;
	}
	if (pt->ldat.id==XML_ANCHOR_TAG) {
		if (pt->next!=NULL) pt = pt->next;
		else return NULL;
	}

	lp = find_match_xml_endlist(pp, pt);

	return lp;
}




/**
tList*  get_xml_content_list(tXML* pp, tXML* pt)

	ǽXMLĥ꡼ pp XMLĥ꡼ ptƱѥλޤõpt˰פޤΡǸΥ
		  ƥȤؤΥݥ󥿤ꥹȤ˳Ǽ֤ݥ󥿤ϥꥹȤ altp˳Ǽ롥

		  pt  ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ȤʤäƤΡɤ
		  ӤʤΥΡɤɬפ롥

	pp -- оݤΥĥ꡼
		  pt -- ѥ

	͡ΡɤؤΥݥ󥿾(altp)ޤꥹȤؤΥݥ

*/
tList*  get_xml_content_list(tXML* pp, tXML* pt)
{
	tList* lp;
	tList* dm;

	if (pp==NULL || pt==NULL) return NULL;

	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return NULL;
	}
	if (pt->ldat.id==XML_ANCHOR_TAG) {
		if (pt->next!=NULL) pt = pt->next;
		else return NULL;
	}

	dm = find_xml_end(pt);
	if (dm==NULL) return NULL;
	dm = add_xml_content(dm, "DUMMY");
	dm->ctrl = TREE_NOCMP_NODE;

	lp = find_match_xml_endlist(pp, pt);
	del_xml(&dm);

	return lp;
}




/**
int  set_xml_content_list(tXML* pp, tXML* pt, char* content)

	ǽget_xml_content_list() ǸФƥȤ, content ֤롥

	pp  -- оݤXMLĥ꡼
		  pt  -- ѥ
		  content -- 񤭴Υ  

	͡񤭴ΡɤθĿ
*/
int  set_xml_content_list(tXML* pp, tXML* pt, char* content)
{
	int    num = 0;
	tList* lt;
	tList* lp;

	if (pp==NULL  || pt==NULL || content==NULL)  return 0;

	lp = lt = get_xml_content_list(pp, pt);
	if (lt==NULL) return 0;

	while (lt!=NULL) {
		if (lt->altp!=NULL) {
			copy_s2Buffer(content, &(lt->altp->ldat.key));
			num++;
		}
		lt = lt->next;
	}
	del_tList(&lp);

	return num;
}





/**
tList*  get_xml_tag_list_bystr(tXML* pp, char* str)


*/
tList*  get_xml_tag_list_bystr(tXML* pp, char* str)
{
	tXML*  tx;
	tList* tt;

	if (pp==NULL || str==NULL) return NULL;

	tx = xml_parse(str);
	tt = get_xml_tag_list(pp, tx);
	del_xml(&tx);

	return tt;
}





/**
tList*  get_xml_conetnt_list_bystr(tXML* pp, char* str)


*/
tList*  get_xml_content_list_bystr(tXML* pp, char* str)
{
	tXML*  tx;
	tList* tt;

	if (pp==NULL || str==NULL) return NULL;

	tx = xml_parse(str);
	tt = get_xml_content_list(pp, tx);
	del_xml(&tx);

	return tt;
}




/**
int  set_xml_content_list_bystr(tXML* pp, tXML* pt, char* content)


*/
int  set_xml_content_list_bystr(tXML* pp, char* str, char* content)
{
	tXML* tx;
	int   rt;

	if (pp==NULL  || str==NULL || content==NULL) return 0;

	tx = xml_parse(str);
	rt = set_xml_content_list(pp, tx, content);
	del_xml(&tx);

	return rt;
}








////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
tXML*  dup_merge_xml(tXML* pp, tXML* tp)

	ǽXMLĥ꡼ ppľXMLĥ꡼ tpʣ롥

	pp -- ʣ줿ĥ꡼ΥȥåפȤʤΡ
		  tp -- ʣĥ꡼

	͡ʣ줿 XMLĥ꡼ؤΥݥ󥿡
			pp NULLǤʤ pp
			pp NULLξϡtpʣĥ꡼Υȥåס

*/
tXML*  dup_merge_xml(tXML* pp, tXML* tp)
{
	tXML* pt;

	if (tp==NULL) return pp;

	if (tp->ldat.id==XML_ANCHOR_TAG) {
		if (tp->next!=NULL) tp = tp->next;
		else return pp;
	}

	pp = dup_merge_tTree(pp, tp);

	if (pp->ldat.id!=XML_ANCHOR_TAG) {
		pt = new_tTree_node();
		pt->ldat.id = XML_ANCHOR_TAG;
		pt->depth = 0;
		add_tTree(pt, pp);
		close_xml(pt);
		return pt;
	}

	return pp;
}






/**
tXML*  del_xml(tXML** pp) 

	ǽꤷΡɰʲXMLĥ꡼롥

	*pp -- ĥ꡼ƬΡ

	͡XMLĥ꡼οƥΡɤؤΥݥ󥿡
*/
tXML*  del_xml(tXML** pp)
{
	tXML* pt;

	if (pp==NULL || *pp==NULL) return NULL;

	// ҥΡɤκ
	if ((*pp)->next!=NULL) del_sisters_children_xml(&((*pp)->next));

	// ʬȤκ
	pt = (*pp)->prev;
	if (pt!=NULL) {
		if (pt->next==*pp) pt->next = (*pp)->ysis;
		if (pt->back==*pp) pt->back = (*pp)->esis;
		pt->num--;
	}
	if ((*pp)->ysis!=NULL) (*pp)->ysis->esis = (*pp)->esis;
	if ((*pp)->esis!=NULL) (*pp)->esis->ysis = (*pp)->ysis;

	free_tListdata(&((*pp)->ldat));
	free(*pp);
	*pp = NULL;

	return pt;
}  



/**
tXML*  del_sister_xml(tXML** pp) 

	ǽꤷΡɰʲXMLĥ꡼롥

	*pp -- ĥ꡼ƬΡ

	͡XMLĥ꡼οƥΡɤؤΥݥ󥿡
*/
tXML*  del_sister_xml(tXML** pp)
{
	tXML* pt;

	if (pp==NULL || *pp==NULL) return NULL;

	pt = (*pp)->prev;
	if (pt!=NULL) {
		pt->next = NULL;
		pt->back = NULL;
		pt->num  = 0;
	}

	del_sisters_children_xml(pp);

	return pt;
}  




/**
tXML*  del_sisters_children_xml(tXML** pp) 
   
	ǽꤷΡɤλXMLĥ꡼XMLĥ꡼롥
		  ꤷXMLΡɤ롥
   
	*pp -- XMLĥ꡼εΡ
   
	͡ĥ꡼οƥΡɤؤΥݥ󥿡
   
	˺ƵѡƥΡɤФϹԤʤΤǡӸƤӽФ¦ǹԤȡ

*/
tXML*  del_sisters_children_xml(tXML** pp)
{  
	tXML* pm;
	tXML* pt;
   
	if (pp!=NULL || *pp==NULL) return NULL;
	pt = (*pp)->prev;
   
	pm = *pp;
	while (pm->esis!=NULL) pm = pm->esis;
	while (pm!=NULL) {
		tXML* pw = pm;
		if (pm->next!=NULL) del_sisters_children_xml(&(pm->next));
		pm = pm->ysis;

		free_tListdata(&(pw->ldat));
		free(pw);
	}
   
	*pp = NULL;

	return pt;
}





/**
void  del_all_xml(tXML** pp)
   
	ǽ: XMLĥ꡼Ρɤκݥ ppΥΡɤޤXMLĥ꡼Τ롥
		  pp ϥĥ꡼ǤСɤؤƤƤɤ
   
	: *pp -- 򳫻ϤΡɤؤΥݥ󥿡
				 ĥ꡼ǤСɤؤƤƤɤ
   
	: ʤ
*/
void  del_all_xml(tXML** pp)
{  
	tXML* pm;

	if (pp==NULL || *pp==NULL) return;
   
	pm = *pp;
	while (pm->prev!=NULL) pm = pm->prev;
	del_xml(&pm);

	*pp = NULL;
	return;
}








///////////////////////////////////////////////////////////////////////////////////////////////
//
// Inverse Parse
//

/**
Buffer  xml_inverse_parse(tXML* pp, int mode)

	ǽpp˳Ǽ줿 XMLǡ򸵤ν񼰤ᤷ Buffer˳Ǽ롥xml_parse() εա

	pp   -- XMLǡγǼ줿ĥ꡼ؤΥݥ
		mode -- XML᤹ν
					XML_ONELINE_FORMAT: ԤʤΰԤˤ롥
					XML_CRLF_FORMAT   : ν CR(0x0d), LF(0x0a)ǲԤ롥
					XML_INDENT_FORMAT : Ƭ˥ǥ(TAB)ĤȤ˲ CR LF (0x0d,0x0a)롥

		  XML_CRLF_FORMAT, XML_INDENT_FORMAT ǥͤϡͤϤॿϲԤʤ

	͡ѴXMLǡǼ Bufferѿ
*/
Buffer  xml_inverse_parse(tXML* pp, int mode)
{
	int cnt;
	Buffer buf;

	buf = init_Buffer();
	if (pp==NULL) return buf;
	if (pp->ldat.id==XML_ANCHOR_TAG) pp = pp->next;
	if (pp==NULL) return buf;

	cnt = count_tTree(pp);
	buf = make_Buffer(cnt*LPASS);
	if (buf.buf==NULL) return buf;

	while (pp->esis!=NULL) pp = pp->esis;
	xml_to_Buffer(pp, &buf, mode, pp->depth);

	return buf;
}






/**
void   xml_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent)

	ǽxml_inverse_parse()Ѥؿ
pp˳Ǽ줿 XMLǡ򸵤ν񼰤ᤷ Buffer˳Ǽ롥

	pp   -- XMLǡγǼ줿ĥ꡼ؤΥݥ
		  buf  -- ѴXMLǡǼ Bufferѿ
		mode -- XML᤹ν
					XML_ONELINE_FORMAT: ԤʤΰԤˤ롥
					XML_CRLF_FORMAT   : ν CR(0x0d), LF(0x0a)ǲԤ롥
					XML_INDENT_FORMAT : Ƭ˥ǥ(TAB)ĤȤ˲Ԥ롥
		  indent -- ǥȤդϤ뿼mode XML_INDENT_MODE ΤȤΤͭ
*/
void   xml_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent)
{
	do {
		xml_opentag_to_Buffer(pp, buf, mode, indent);
		if (pp->next!=NULL) xml_to_Buffer(pp->next, buf, mode, indent);
		xml_closetag_to_Buffer(pp, buf, mode, indent);
		
		pp = pp->ysis;
	} while(pp!=NULL);

	return;
}






/**
void   xml_opentag_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent)

	ǽĥ꡼XMLΥץ󥿥Υǡ򸵤ν񼰤ᤷ Buffer˳Ǽ롥

	pp   -- XMLǡγǼ줿ĥ꡼ΥΡɤؤΥݥ
		  buf  -- ѴXMLǡǼ Bufferѿ
		mode -- XML᤹ν
						XML_ONELINE_FORMAT: ԤʤΰԤˤ롥
						XML_CRLF_FORMAT   : ν CR(0x0d), LF(0x0a)ǲԤ롥
						XML_INDENT_FORMAT : Ƭ˥ǥ(TAB)ĤȤ˲Ԥ롥
		  indent -- ǥȤդϤ뿼mode XML_INDENT_MODE ΤȤΤͭ

*/
void   xml_opentag_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent)
{
	int i;


	// Name TAG
	if (pp->ldat.id==XML_TAG_NAME) {
		if (mode==XML_INDENT_FORMAT) {
			char* tabs = (char*)malloc(pp->depth-indent+1);
			if (tabs!=NULL) {
				for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
				tabs[pp->depth-indent] = '\0';
				cat_s2Buffer(tabs, buf);
				free(tabs);
			}
			//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
		}

		cat_s2Buffer("<", buf);
		cat_Buffer(&(pp->ldat.key), buf);
		if (pp->ldat.lst!=NULL) {
			xml_attr_to_Buffer(pp->ldat.lst, buf);
		}
		if (pp->next==NULL) {
			if (pp->state==XML_TAG_EMPTY) cat_s2Buffer(" />", buf);
			else {
				cat_s2Buffer("></", buf);
				cat_Buffer(&(pp->ldat.key), buf);
				cat_s2Buffer(">", buf);
			}
		}
		else {
			cat_s2Buffer(">", buf);
		}

		if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) {
			if (pp->ldat.lv!=1 || pp->num!=1) cat_s2Buffer("\r\n", buf);
		}
	}
	

	// Content
	else if (pp->ldat.id==XML_TAG_CONTENT) {
		if (mode==XML_INDENT_FORMAT) {
			if (pp->prev!=NULL && (pp->prev->ldat.lv!=1 || pp->prev->num!=1)) {
				char* tabs = (char*)malloc(pp->depth-indent+1);
				if (tabs!=NULL) {
					for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
					tabs[pp->depth-indent] = '\0';
					cat_s2Buffer(tabs, buf);
					free(tabs);
				}
				//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
			}
		}

		cat_Buffer(&(pp->ldat.key), buf);

		//if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) cat_s2Buffer("\r\n", buf);
		if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) {
			if (pp->prev!=NULL && (pp->prev->ldat.lv!=1 || pp->prev->num!=1)) cat_s2Buffer("\r\n", buf);
		}
	}


	// xml TAG
	else if (pp->ldat.id==XML_DOC_TAG) {
		if (mode==XML_INDENT_FORMAT) {
			char* tabs = (char*)malloc(pp->depth-indent+1);
			if (tabs!=NULL) {
				for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
				tabs[pp->depth-indent] = '\0';
				cat_s2Buffer(tabs, buf);
				free(tabs);
			}
			//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
		}

		cat_s2Buffer("<?", buf);
		if (pp->ldat.key.buf!=NULL) {
			cat_Buffer(&(pp->ldat.key), buf);
		}
		if (pp->ldat.lst!=NULL) {
			xml_attr_to_Buffer(pp->ldat.lst, buf);
		}
		cat_s2Buffer("?>", buf);

		if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) cat_s2Buffer("\r\n", buf);
	}


	// Comment TAG
	else if (pp->ldat.id==XML_COMMENT_TAG) {
		if (mode==XML_INDENT_FORMAT) {
			char* tabs = (char*)malloc(pp->depth-indent+1);
			if (tabs!=NULL) {
				for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
				tabs[pp->depth-indent] = '\0';
				cat_s2Buffer(tabs, buf);
				free(tabs);
			}
			//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
		}

		cat_s2Buffer("<!--", buf);
		if (pp->ldat.val.buf!=NULL) {
			cat_Buffer(&(pp->ldat.val), buf);
		}
		cat_s2Buffer("-->", buf);

		if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) cat_s2Buffer("\r\n", buf);
	}


	// Data TAG
	else if (pp->ldat.id==XML_DATA_TAG) {
		if (mode==XML_INDENT_FORMAT) {
			char* tabs = (char*)malloc(pp->depth-indent+1);
			if (tabs!=NULL) {
				for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
				tabs[pp->depth-indent] = '\0';
				cat_s2Buffer(tabs, buf);
				free(tabs);
			}
			//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
		}

		cat_s2Buffer("<!", buf);
		if (pp->ldat.val.buf!=NULL) {
			cat_Buffer(&(pp->ldat.val), buf);
		}
		cat_s2Buffer(">", buf);

		if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) cat_s2Buffer("\r\n", buf);
	}


	// Processing TAG
	else if (pp->ldat.id==XML_PROCESS_TAG) {
		if (mode==XML_INDENT_FORMAT) {
			char* tabs = (char*)malloc(pp->depth-indent+1);
			if (tabs!=NULL) {
				for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
				tabs[pp->depth-indent] = '\0';
				cat_s2Buffer(tabs, buf);
				free(tabs);
			}
			//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
		}

		cat_s2Buffer("<?", buf);
		if (pp->ldat.key.buf!=NULL) {
			cat_Buffer(&(pp->ldat.key), buf);
		}
		if (pp->ldat.lst!=NULL) {
			xml_attr_to_Buffer(pp->ldat.lst, buf);
		}
		cat_s2Buffer(" ?>", buf);

		if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) cat_s2Buffer("\r\n", buf);
	}


	return;
}





/**
void   xml_closetag_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent)

	ǽĥ꡼XMLΥΥǡ򸵤ν񼰤ᤷ Buffer˳Ǽ롥

	pp   -- XMLǡγǼ줿ĥ꡼ΥΡɤؤΥݥ
		  buf  -- ѴXMLǡǼ Bufferѿ
		mode -- XML᤹ν
					XML_ONELINE_FORMAT: ԤʤΰԤˤ롥
					XML_CRLF_FORMAT   : ν CR(0x0d), LF(0x0a)ǲԤ롥
					XML_INDENT_FORMAT : Ƭ˥ǥ(TAB)ĤȤ˲Ԥ롥
		  indent -- ǥȤդϤ뿼mode XML_INDENT_MODE ΤȤΤͭ

*/
void   xml_closetag_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent)
{
	int i;

	if (pp->ldat.id==XML_TAG_NAME) {
		if (pp->next!=NULL) {
			if (mode==XML_INDENT_FORMAT) {
				if (pp->ldat.lv!=1 || pp->num!=1) {
					char* tabs = (char*)malloc(pp->depth-indent+1);
					if (tabs!=NULL) {
						for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
						tabs[pp->depth-indent] = '\0';
						cat_s2Buffer(tabs, buf);
						free(tabs);
					}
					//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
				}
			}

			cat_s2Buffer("</", buf);
			cat_Buffer(&(pp->ldat.key), buf);
			cat_s2Buffer(">", buf);

			if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) cat_s2Buffer("\r\n", buf);
		}
	}

	return;
}





/**
void   xml_attr_to_Buffer(tList* pp, Buffer* buf)

	ǽꥹȤ¸줿°ƥȤ᤹

	pp  -- °ǡǼ줿ꥹȤؤΥݥ󥿡
		  buf -- Ѵ°ǡǼ Bufferѿ

*/
void   xml_attr_to_Buffer(tList* pp, Buffer* buf)
{
	while (pp!=NULL) {
		cat_s2Buffer(" ", buf);
		cat_Buffer(&(pp->ldat.key), buf);

		if (pp->ldat.val.buf!=NULL) {
			cat_s2Buffer("=", buf);
			cat_Buffer(&(pp->ldat.val), buf);
		}
		pp = pp->next;
	}
}







/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Search Function for XML
//         tTree ѤδؿȤۤƱ
//

/**
int  find_match_xml(tXML* pp, tXML* pt)

	ǽĥ꡼ pp ĥ꡼ ptƱѥλޤõ 
		  ƱѥõǤ ͤΤߤӤΡͤӤʤ
		  pt->ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ΥΡɤ٤ʤ(˰פȤ)
	
		  ⤷Ʊĥ꡼ѥ󤬤硤trγƥΡɤ altpˤϡֺǽ˸Ĥäб ppγƥΡɤ
		  Υݥ󥿤Ǽ롥

	check_match_xml() Ȥΰ㤤
		check_match_xml() Ǥ٤ޤγϥΡɤpp˸ꤵ롥
		find_match_xml()  ppưʤ鸡Ǥ롥

	pp -- оݤΥĥ꡼
		  pt -- ѥΥĥ꡼

	͡TRUE:  pp ptƱĥ꡼ѥ¸ߤ롥
		  		   ptγƥΡɤ altpˤϡֺǽ˸Ĥäб ppγƥΡɤؤΥݥ󥿤Ǽ롥
			FALSE: ppƱĥ꡼ѥ̵ξ硤ptaltpͤȤʤ롥
*/
int  find_match_xml(tXML* pp, tXML* pt)
{
	int   ret;
	tXML* pm;

	pm = pp;
	while(pp!=NULL) {
		ret = check_match_xml(pp, pt);
		if (ret) return TRUE;

		if (pp->next!=NULL) {
			ret = find_match_xml(pp->next, pt);
			if (ret) {
				clear_tTree_ctrl(pm);
				return TRUE;
			}
		}
		pp = pp->ysis;
	}

	return FALSE;
}




/**
tXML*  find_match_xml_endlist(tXML* pp, tXML* pt)

	ǽĥ꡼ pp ĥ꡼ ptƱѥλޤõơλޤκǸΥΡɤؤξꥹȤˤ֤
		ΡɤؤΥݥ󥿤 ֤줿ƥꥹȤaltp ݻƤ롥 

		  ӤǤ ͤΤߤӤΡͤӤʤ
		  ޤpt->ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ΥΡɤ٤ʤ(˰פȤ)
	
	pp -- оݤΥĥ꡼
		  pt -- ѥΥĥ꡼

	͡ΡɤؤΥݥ󥿤ݻꥹȡ

*/
tXML*  find_match_xml_endlist(tXML* pp, tXML* pt)
{
	tXML*  te;
	tList* lp;

	te = find_xml_end(pt);
	while(pp->esis!=NULL) pp = pp->esis;

	lp = find_match_xml_endlist_rcsv(pp, pt, te);
	if (lp!=NULL) clear_tTree_ctrl(pp);
	
	return lp;
}




/**
tList*  find_match_xml_endlist_rcsv(tXML* pp, tXML* pt, tXML* te)

	ǽfind_match_xml_endlist() ؿ

*/
tList*  find_match_xml_endlist_rcsv(tXML* pp, tXML* pt, tXML* te)
{
	tList* lt = NULL;
	tList* lp = NULL;
					
	while(pp!=NULL) {			 
		int ret = check_match_xml(pp, pt);
		if (ret && te->altp!=NULL) {
			tList* lm = new_tList_node();
			lm->altp = te->altp;  
			lt = add_tList(lt, lm);
			if (lp==NULL) lp = lt;
			te->altp = NULL;
		}  
							
		if (pp->next!=NULL) {	 
			tList* lm = find_match_xml_endlist_rcsv(pp->next, pt, te);
			if (lm!=NULL) {	   
				lt = add_tList(lt, lm);
				if (lp==NULL) lp = lt;
				clear_tTree_ctrl(pp->next);
			}
		}
								   
		if (!ret) pp = pp->ysis;	// ĤäϤ⤦١Ĥʤäؼء
	}

	return lp;
}




/**
int  check_match_xml(tXML* tp, tXML* tr)

	ǽXMLĥ꡼ tp XMLĥ꡼ trƱɤ򸡺롥

		  tp Υȥåפ tr ΥȥåפϥͤפƤɬפ롥פƤʤСƱѥ̵Ȥ롥
		  tr->ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ΥΡɤ٤ʤ(˰פȤ)

		  ٸĤ tpλޤκǸΥΡɤФƤ ctrl TREE_ALREADY_FOUND_NODE ꤹΤǡ³ƥå
		ʤɤ ctrl 򥯥ꥢɬפ롥

		  ⤷Ʊĥ꡼ѥ󤬤硤trγƥΡɤ altpˤϡֺǽ˸Ĥä
		  б tpγƥΡɤؤΥݥ󥿤Ǽ롥

	tp -- оݤΥĥ꡼
		  tr -- ѥΥĥ꡼

	͡TRUE:  tp trƱĥ꡼ѥ¸ߤ롥
		  		   trγƥΡɤ altpˤϡֺǽ˸Ĥäб tpγƥΡɤؤΥݥ󥿤Ǽ롥
			FALSE: tpƱĥ꡼ѥ̵ξ硤tr altpͤȤʤ롥

*/
int  check_match_xml(tXML* tp, tXML* tr)
{
	int   ret;
	tXML* te;
	tXML* ts;

	tXML* tt;
	tXML* ta;
	tXML* tb;


	if (tp==NULL || tr==NULL) return FALSE;

	te = find_tList_end(tr);

	ts = tp;
	while (ts!=NULL) {
		tt = cmp_sisters_xml(ts, tr);		// γؤ trưפƤʬ뤫ǧ
		if (tt==NULL) return FALSE;			// פƤʤСFALSE
		
		ta  = tt;							// ٤ĥ꡼
		tb  = tr;							// ٤ѥ
		ret = TRUE;
		while (tb!=NULL && ret) {
			if (tb->next==NULL) ret = TRUE;
			// ->ta, ->tb->tx: FALSE
			else if (tb->next!=NULL && ta->next==NULL) ret = FALSE;
			// ->ta->xa, ->tb->xb: xaxbå
			else ret = check_match_xml(ta->next, tb->next);

			ta = ta->ysis;
			tb = tb->ysis;
		}

		if (ret) {
			if (tr==te) tt->ctrl = TREE_ALREADY_FOUND_NODE;
			return TRUE;
		}

		ts = tt->ysis;
	}

	return FALSE;
}




/**
tXML*  cmp_sisters_xml(tXML* tp, tXML* tr)

	ǽXMLΡ tpλΡɤ trλΡɤƱ XMLޤϥƥȤǤ뤫Ӥ롥
		  tr->ctrl  TREE_NOCMP_NODE ޤ TREE_NOCMP_COPY_NODE ΥΡɤ٤ʤ(˰פȤ)
		  ޤ tp->ctrl  TREE_ALREADY_FOUND_NODE ξϡ˰פʤ

		  ⤷ƱΡɥѥ󤬤硤trγƥΡɤ altpˤб tpγƥΡɤؤΥݥ󥿤Ǽ롥
		  ޤ tpγƥΡɤ ctrlˤ TREE_ALREADY_FOUND_NODE ꤵ롥

	tp -- ٤ΡɤĹΡ
		  tr -- õΡɥѥĹΡ

	͡tp trƱѥ󤬻ϤޤΡɤؤΥݥ󥿡
		  	trγƥΡɤ altpˤб tpγƥΡɤؤΥݥ󥿤Ǽ롥
			NULL: tpƱѥ̵

	----------------------------------------------------------------
	㡧	tp						tr
			--> A (1)				--> A 		A, B, X  (ldat.key.buf)
			--> B (2)				--> X
			--> A (3)
			--> X (4)
			--> A (5)
			--> X (6)

		ξ硤cmp_sisters_xml(tp, tr)  (3)ؤΥݥ󥿤֤ޤ tr AΡ
		 altp ˤ (3) ؤΥݥ󥿤tr XΡɤaltpˤ(4)ؤΥݥ󥿤Ǽ
		롥ǽ˸ĤäѥΤɾ롥

*/
tXML*  cmp_sisters_xml(tXML* tp, tXML* tr)
{
	tXML* ta;
	tXML* tb = NULL;
	tXML* ts;

	ts = tp;
	while (ts!=NULL){
		ta = ts;
		tb = tr;
		while (ta!=NULL && tb!=NULL) {
			// פʤ break
			if (ta->ctrl==TREE_ALREADY_FOUND_NODE) break;
			if (tb->ctrl!=TREE_NOCMP_NODE && tb->ctrl!=TREE_NOCMP_COPY_NODE) {
				if ((ta->ldat).key.buf!=NULL && (tb->ldat).key.buf!=NULL) {
					if (ta->ldat.id!=tb->ldat.id || strcmp((char*)((ta->ldat).key.buf), (char*)((tb->ldat).key.buf))) break;
				}
				else break;
			}

			// ta  tb ϰ
			tb->altp = ta;
			ta = ta->ysis;
			tb = tb->ysis;
		}

		// ts  tr ϴ˰
		if (tb==NULL) return ts;

		ts = ts->ysis;
	}

	return NULL;
}










//////////////////////////////////////////////////////////////////////////////////////
//
// Simple Tag Functions  (ñʹ¤Υ)
//

/**
Buffer  get_tag_content(tXML* tp, char* name, int no)

	ǽtp XMLǡ noܤΥ <tag_name>tag_content</tag_name> tag_contentΥԡ롥
		  ʣΥƥȤľϡǽΥƥȤΤߤ֤

*/
Buffer  get_tag_content(tXML* tp, char* name, int no)
{
	Buffer content;
	tXML*  tt;
	
	content = init_Buffer();
	if (tp==NULL || name==NULL) return content;

	if (no<=0) no = 1;
	tt = strncmp_tTree(tp, name, 0, no);
	if (tt!=NULL) {
		if (tt->next!=NULL) {
			tt = tt->next;
			while (tt!=NULL && tt->ldat.id!=XML_TAG_CONTENT) tt = tt->ysis;
			if (tt==NULL) return content;
			content = dup_Buffer(tt->ldat.key);
		}
	}

	return content;
}




/**
int   get_tag_integer(tXML* tp, char* name, int no)

	ǽtpXMLǡ noܤΥ <tag_name>tag_content()</tag_name>  tag_content()롥

*/
int   get_tag_integer(tXML* tp, char* name, int no)
{
	int	   ret;
	Buffer content;

	content = get_tag_content(tp, name, no);

	if (content.buf==NULL) ret = 0;
	else				   ret = atoi((const char*)content.buf);
	free_Buffer(&content);

	return  ret;
}




/**
int   return_exist_tag(tXML* tp, char* name, int no, Buffer* content)

	ǽbuf  <stag>content<etag> ¸ߤ뤫ɤå롥
		  ¸ߤϤΥΥƥȤΥԡ content ˳ǼTRUE ֤

*/
int   return_exist_tag(tXML* tp, char* name, int no, Buffer* content) 
{
	Buffer buf;
	
	buf = get_tag_content(tp, name, no);
	if (buf.buf==NULL) return FALSE;

	if (content!=NULL) *content = buf;
	return TRUE;
}





/**
int  replace_all_tag_integer(tXML* tp, char* name, int src, int dst)

	ǽXMLĥ꡼ pp ̾ nameǤƤΥΥƥȡˤsrc dst˽񤭴롥
			
	tp   -- ִоݤΥĥ꡼
		  name -- ֤ԤΥ̾
		  src  -- ִоݤΥΥƥȡ
		  dst  -- ִΥΥƥȡ
	
	֤͡Ρɤο
*/
int  replace_all_tag_integer(tXML* tp, char* name, int src, int dst)
{
	int  n;
	char nums[20], numd[20];

	snprintf(nums, 10, "%d", src);
	snprintf(numd, 10, "%d", dst);

	n = replace_all_tag_contents(tp, name, nums, numd);

	return n;
}





/**
int	 replace_all_tag_contents(tXML* pp, char* name, char* src, char* dst)

	ǽXMLĥ꡼ pp ̾ nameǤƤΥΥƥȤsrc dst˽񤭴롥
		  ĤΥʣΥƥȤˤб
			
	tp   -- ִоݤΥĥ꡼
		  name -- ֤ԤΥ̾NULLξƤʸ
		  src  -- ִоݤΥΥƥȡʤΰǤġˡ NULL ξƤʸ
		  dst  -- ִΥΥƥ
	
	֤͡ο

*/
int	 replace_all_tag_contents(tXML* pp, char* name, char* src, char* dst)
{
	int  n;

	if (pp==NULL || dst==NULL) return 0;

	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return 0;
	}
	while(pp->esis!=NULL) pp = pp->esis;

	n = replace_all_tag_contents_rcsv(pp, name, src, dst);

	return n;
}





/**
int	 replace_all_tag_contents_rcsv(tXML* pp, char* name, char* src, char* dst)

	ǽreplace_all_tag_content() ؿ

*/
int	 replace_all_tag_contents_rcsv(tXML* pp, char* name, char* src, char* dst)
{
	int  n = 0;

	while(pp!=NULL) {
		if (pp->ldat.key.buf!=NULL && pp->ldat.id==XML_TAG_NAME && pp->ldat.lv>0) {
			if (name==NULL || !strcmp(name, (const char*)(pp->ldat.key.buf))) {
				tXML* tt = pp->next;

				// ʣΥƥ
				while (tt!=NULL) {
					if (tt->ldat.id==XML_TAG_CONTENT) {
						if (src==NULL) {
							copy_s2Buffer(dst, &(tt->ldat.key));
							n++;
						}
						else if (tt->ldat.key.buf!=NULL && strstr((const char*)tt->ldat.key.buf, src)!=NULL) {
							Buffer buf = replace_sBuffer_bystr(tt->ldat.key, src, dst);
							free_Buffer(&(tt->ldat.key));
							tt->ldat.key = buf;
							n++;
						}
					}
					tt = tt->ysis;
				}
			}
		}

		if (pp->next!=NULL) n += replace_all_tag_contents_rcsv(pp->next, name, src, dst);

		pp = pp->ysis;
	}

	return n;
}





/**
int	 replace_all_tag_byid(tXML* pp, char* src, char* dst, int id)

	ǽXMLĥ꡼ pp μ̤ idǤƤΥƤ src dst˽񤭴롥
			
	tp   -- ִоݤΥĥ꡼
		  src  -- ִоݤΥΥƥȡʤΰǤġˡ NULL ξƤʸ
		  dst  -- ִΥΥƥ
		  id   -- ֤оݤΥΡɤIDid<0 ʤƤΥΡ
	
	֤͡ο

*/
int	 replace_all_tag_byid(tXML* pp, char* src, char* dst, int id)
{
	int  n;

	if (pp==NULL || dst==NULL) return 0;

	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return 0;
	}
	while(pp->esis!=NULL) pp = pp->esis;

	n = replace_all_tag_byid_rcsv(pp, src, dst, id);

	return n;
}





/**
int	 replace_all_tag_byid_rcsv(tXML* pp, char* src, char* dst, int id)

	ǽreplace_all_tag_byid() ؿ

*/
int	 replace_all_tag_byid_rcsv(tXML* pp, char* src, char* dst, int id)
{
	int  n = 0;

	while(pp!=NULL) {
		if (id<0 || pp->ldat.id==id) {
			if (src==NULL) {
				copy_s2Buffer(dst, &(pp->ldat.key));
				n++;
			}
			else if (pp->ldat.key.buf!=NULL && strstr((const char*)pp->ldat.key.buf, src)!=NULL) {
				Buffer buf = replace_sBuffer_bystr(pp->ldat.key, src, dst);
				free_Buffer(&(pp->ldat.key));
				pp->ldat.key = buf;	
				n++;
			}
		}

		if (pp->next!=NULL) n += replace_all_tag_byid_rcsv(pp->next, src, dst, id);

		pp = pp->ysis;
	}

	return n;
}






