/* vi: set tabstop=4 paste nocindent noautoindent: */

#ifndef __TINY_XML_H
#define __TINY_XML_H


/**
	Tiny XML txml.h v1.0

	֥åǡXML ʰץѡ 饤֥إå

	ƤΥѥΥѡǽݾ㤹ΤǤϤޤ
	ʣ XMLϡʶ餯˥ѡǤޤ
		<?xml ... ?> ʳ <? ..... ?>  <! .....  > Ͻʤɤ߹ߤϹԤ
		ƥƥϽʤ




--------------------
tXML:   (tXML  tList, tTree Ʊ)

ǡ tXML

	int	 	ldat.id		μ̡XML_ANCHOR_TAG, XML_TAG_NAME, XML_TAG_CONTENT, ..........
	int	 	ldat.lv		ͤǤҥΡɤθĿ
	int	 	ldat.sz		̤
	Buffer  ldat.key	̾ޤϥ
	Buffer  ldat.val	<! ... > ̤ǡ <!-- ... -->ΥȾǼ 
	void*	ldat.ptr	̤ 
	tXML*	ldat.lst	°ꥹȤؤΥݥ󥿡ldat.lst->ldat.key°̾ldat.lst->ldat.val°("'դ)Ǽ

	tXML*	next		ҥĹˤؤΥݥ
	tXML*	prev		ƥؤΥݥ
	tXML*	altp		¾ؤΥݥ󥿡ѡ 
	tXML*	back		ҥûҡˤؤΥݥ 
	tXML*	esis		λʻС˥ؤΥݥ
	tXML*	ysis		λ˥ؤΥݥ

	int		depth   						
	int		num	 		ҥΡɤο	
	int		ctrl		
	int		state   	Ρɤξ  XML_PARSED, XM_TAG_OPEND, XML_TAG_ENDED, XML_PARSE_ERROR, ....



ѡXMLǼĥ꡼¤

  	<?xml version="1.0" ?><A><B><C>ABC</C><D />EFG</B><E /><!-- comment --></A> 

	ξ硤Τ褦˥ѡ롥ɽ ldat.key.buf (id)

  	NULL (XML_ANCHOR_TAG) -> xml (XML_DOC_TAG)
						  -> A (XML_TAG_NAME) -> B (XML_TAG_NAME) -> C (XML_TAG_NAME) -> ABC (XML_TAG_CONTENT)
                                                                  -> D (XML_TAG_NAME)
																  -> EFG (XML_TAG_CONTENT)
											  -> E (XML_TAG_NAME)
											  -> @COMMENT_TAG (XML_COMMENT_TAG) 	// ȤνϻŪ


ʥΡɡ˼ (ldat.id)
		XML_ANCHOR_TAG			󥫡
		XML_TAG_NAME			͡
		XML_TAG_CONTENT			ơʥƥȡ
		XML_DOC_TAG				<? xml... ?> 
		XML_COMMENT_TAG			ȥ
		XML_DATA_TAG			<! ... > 
		XML_PROCESS_TAG 		XML_DOC_TAG ʳ <? ... ?>


 (state)
		XML_DEFAULT_SATE		Ρɤϡ˥ѡ줿ɤȽϤޤԤƤʤ
		XML_PARSED				󥫡ˤΤꤵ롥XMLĥ꡼˥ѡ줿Ȥ򼨤
		XML_TAG_STARTED			ΥΡɤϥץ֤ˤ롥 <tagname>
		XML_TAG_ENDED			ΥΡɤ˥ </tagname>
		XML_TAG_EMPTY			ΥΡɤ϶ǥǤ <  />, <!--  -->, <!   >, <?   ?> η
		XML_MULTI_ROOT			󥫡ˤΤꤵ롥XMLĥ꡼ϣİʾΩĥ꡼

		XML_PARSE_ERROR			ᥨ顼
		XML_SEQUENCE_ERROR		󥫡ۤƥĥ꡼Ȥ
		XML_MEMORY_ERROR		γݥ顼

*/






#include "tlist.h"


// 	(ldat.id)
#define  XML_ANCHOR_TAG				0
#define  XML_TAG_NAME				1
#define  XML_TAG_CONTENT			2
#define  XML_DOC_TAG				3
#define  XML_COMMENT_TAG			4
#define  XML_DATA_TAG				5
#define  XML_PROCESS_TAG			6


// (Ρ)ξ֡顼 0ʲˤ롥(state)
#define  XML_DEFAULT_STATE			0
#define  XML_PARSED					1	
#define  XML_TAG_STARTED			2
#define  XML_TAG_ENDED				3
#define  XML_TAG_EMPTY				4
#define  XML_MULTI_ROOT				9

#define  XML_PARSE_ERROR			-1
#define  XML_SEQUENCE_ERROR			-2
#define  XML_MEMORY_ERROR			-9


// XML Format
#define	 XML_ONELINE_FORMAT			0
#define	 XML_CRLF_FORMAT			1
#define	 XML_INDENT_FORMAT			2


// ѥ̾ (ldat.key.buf) Ū
#define  XML_COMMENT_TAG_KEY		"@COMMENT_TAG"
#define  XML_DATA_TAG_KEY			"@DATA_TAG"




typedef  struct _tList  tXML;



/////////////////////////////////////////////////////////////////////////////////////////////
//
// XML Functions
//

// Paser
tXML*	xml_parse(char* pp);
tXML*	xml_parse_file(char* pp);
tXML*	xml_parse_seq(tXML* xml, char* pp);
tXML*	xml_partial_parse(tXML* xml, char* pp, int skip);

int 	xml_parse_content(char* pp, char** content);
tList*	xml_parse_attr(char* pp);
int  	xml_parse_start_tag(char* pp, char** tag_name, char** tag_attr, int* tag_end);
int  	xml_parse_end_tag(char* pp, char** tag_name);
int  	xml_parse_processing_tag(char* pp, char** tag_name, char** tag_attr);
int  	xml_parse_comment_tag(char* pp, char** comment);
int  	xml_parse_data_tag(char* pp, char** data);

void 	close_xml(tXML* pp);
int	 	isnot_xml_name(unsigned char* pp);


// Operation
tXML* 	add_xml_tag(tXML* xml, char* name);
tXML* 	add_xml_content(tXML* xml, char* value);

tXML*	get_xml_tag(tXML* pp, tXML* pt);
int		set_xml_tag(tXML* pp, tXML* pt, char* val);
int 	set_xml_end_tag(tXML* pp, tXML* pt);

tXML*	get_xml_content(tXML* pp, tXML* pt);
int 	set_xml_content(tXML* pp, tXML* pt, char* val);
tList*	get_xml_attr(tXML* pp, tXML* pt);
int		set_xml_attr(tXML* pp, tXML* pt, tList* at);

char*   get_first_tag_name(tXML* xml);

int		replace_xml_content(tXML*pp, tXML* pt, char* src, char* dst);
tXML*  	find_match_xml_end_tag(tXML* pp, tXML* pt);

#define find_xml_top(p)		find_tList_top(p)
#define find_xml_end(p)		find_tTree_end(p)

//
tXML*	get_xml_tag_bystr(tXML* pp, char* str);
int		set_xml_tag_bystr(tXML* pp, char* str, char* val);
int 	set_xml_end_tag_bystr(tXML* pp, char* str);

tXML*	get_xml_content_bystr(tXML* pp, char* str);
int 	set_xml_content_bystr(tXML* pp, char* str, char* val);
tList*	get_xml_attr_bystr(tXML* pp, char* str);
int		set_xml_attr_bystr(tXML* pp, char* pt, tList* at);


int		replace_xml_content_bystr(tXML*pp, char* str, char* src, char* dst);


// Operation for multi tags
tList*	get_xml_tag_list(tXML* pp, tXML* pt);
tList*	get_xml_content_list(tXML* pp, tXML* pt);
int		set_xml_content_list(tXML* pp, tXML* pt, char* content);

tList*	get_xml_tag_list_bystr(tXML* pp, char* str);
tList*	get_xml_content_list_bystr(tXML* pp, char* str);
int		set_xml_content_list_bystr(tXML* pp, char* str, char* content);


//
tXML*	dup_merge_xml(tXML* pp, tXML* tp);
void 	print_xml(FILE* fp, tXML* pp, int mode);
void 	print_xml_tree(FILE* fp, tXML* pp, char* space);
void 	print_sister_xml_tree(FILE* fp, tXML* pp, char* space);
void 	print_sister_xml_tree_rcsv(FILE* fp, tXML* pp, char* space);

tXML* 	del_xml(tXML** pp);
void  	del_all_xml(tXML** pp);
tXML* 	del_sister_xml(tXML** pp);
tXML*	del_sisters_children_xml(tXML** pp);


// եѡ
Buffer	xml_inverse_parse(tXML* pp, int mode);
void	xml_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent);
void	xml_opentag_to_Buffer (tXML* pp, Buffer* buf, int mode, int indent);
void	xml_closetag_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent);
void	xml_attr_to_Buffer(tList* pp, Buffer* buf);



///////////////////////////////////////////////////////////////////////////////////////////
// Search XML Tag (tTreeѤδؿȤۤƱ)
int  	find_match_xml(tXML* pp, tXML* pt);
tXML*  	find_match_xml_endlist(tXML* pp, tXML* pt);
tList*  find_match_xml_endlist_rcsv(tXML* pp, tXML* pt, tXML* te);
int  	check_match_xml(tXML* tp, tXML* tr);
tXML*  	cmp_sisters_xml(tXML* tp, tXML* tr);




/////////////////////////////////////////////////////////////////////////////////////////////
//
// Simple Tag Funxtions.
//
int		get_tag_integer (tXML* tp, char* name, int no);
Buffer  get_tag_content (tXML* tp, char* name, int no);
int		return_exist_tag(tXML* tp, char* name, int no, Buffer* value);

int		replace_all_tag_integer (tXML* tp, char* name, int src, int dst);
int		replace_all_tag_contents(tXML* tp, char* name, char* src, char* dst);
int 	replace_all_tag_contents_rcsv(tXML* tp, char* name, char* src, char* dst);

int 	replace_all_tag_byid(tXML* tp, char* src, char* dst, int id);
int 	replace_all_tag_byid_rcsv(tXML* tp, char* src, char* dst, int id);



/**/


#endif
