/* vim: set tabstop=4 paste nocindent noautoindent ff=unix: */

/**
	ѳĥġץ  xtools.c
											'09 2/13 v1.1  by Fumi.Iseki (C)

إå
	#include "xtools.h"
*/


#include "xtools.h"




#ifndef WIN32

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Networks
//

/**
int  udp_recv_Buffer(int sock, Buffer* str, struct sockaddr_in* sv_addr)

	ǽ: recvform()åԥ󥰤ؿUDPǡ롥

	: sock	 åȵһ
		  *str	 ѥåХåեͽݤƤ
		  sv_addr  Фξ󤬳Ǽ줿 sockaddar_in ¤ΤؤΥݥ󥿡
 
	: ˹ԤФΥХȿ
			Ԥ-1֤
*/
int  udp_recv_Buffer(int sock, Buffer* str, struct sockaddr_in* sv_addr)
{
	int cc, cadlen;

	cadlen = sizeof(*sv_addr);
	memset(str->buf, 0, str->bufsz);
	str->vldsz = 0;
	cc = recvfrom(sock, str->buf, str->bufsz, 0, (struct sockaddr*)sv_addr, (socklen_t*)&cadlen);
	if (cc>=0) str->vldsz = cc;

	return cc;
}





/**
int  udp_send_Buffer(int sock, Buffer* str, struct sockaddr_in* sv_addr)

	ǽ: sendto() åԥ󥰤ؿUDPͳǥǡ롥

	: sock	 åȵһ
		  *str	 ǡ
		  sv_addr  ФξǼ sockaddar_in ¤ΤؤΥݥ󥿡

	: ˹ԤФΥХȿ
			Ԥ-1֤
*/
int  udp_send_Buffer(int sock, Buffer* str, struct sockaddr_in* sv_addr)
{
	int cc;
	
	if (str->vldsz<0) str->vldsz = strlen((const char*)str->buf);
	cc = sendto(sock, str->buf, str->vldsz, 0, (struct sockaddr*)sv_addr, sizeof(*sv_addr));

	return cc;
}





/**
int  tcp_recv_Buffer(int sock, Buffer* str)

	ǽ: TCPͳǥǡ롥Хåե󥰤ʤ

	: sock	 åȵһ
		  *str	 ѥǡХåեͽݤƤ

	: ˹ԤФΥХȿ
			Ԥ-1֤
*/
int  tcp_recv_Buffer(int sock, Buffer* str)
{
	int cc;

	memset(str->buf, 0, str->bufsz);
	str->vldsz = 0;
	cc = recv(sock, str->buf, str->bufsz, 0);
	if (cc>=0) str->vldsz = cc;
	return cc;
}






/**
int  tcp_send_Buffer(int sock, Buffer* str)

	ǽ: TCPͳǥǡ롥

	: sock	 åȵһ
		  str	  ѥǡХåե

	: ϤХȿ
			Ԥˤ-1֤(send())

*/
int  tcp_send_Buffer(int sock, Buffer* str)
{
	int cc;

	if (str->vldsz<0) str->vldsz = strlen((const char*)str->buf);
	cc = send(sock, str->buf, str->vldsz, 0);
	return cc;
}







/**
int  udp_recv_sBuffer(int sock, Buffer* str, struct sockaddr_in* sv_addr)

	ǽ: UDPʸǡ롥

	: sock	 åȵһ
		  *str	 ѥåХåեͽݤƤ
		  sv_addr  Фξ󤬳Ǽ줿 sockaddar_in ¤ΤؤΥݥ󥿡
 
	: ˹ԤФΥХȿ
			Ԥ-1֤
	
	#define udp_recv_sBuffer(s, b, a)  udp_recv_Buffer((s), (b), (a))
*/






/**
int  udp_send_sBuffer(int sock, Buffer* str, struct sockaddr_in* sv_addr)

	ǽ: UDPͳʸǡ롥

	: sock	 åȵһ
		  *str	 ǡ
		  sv_addr  ФξǼ sockaddar_in ¤ΤؤΥݥ󥿡

	: ˹ԤФΥХȿ
			Ԥ-1֤
*/
int  udp_send_sBuffer(int sock, Buffer* str, struct sockaddr_in* sv_addr)
{
	int cc;
	
	cc = sendto(sock, str->buf, strlen((const char*)str->buf), 0, (struct sockaddr*)sv_addr, sizeof(*sv_addr));
	return cc;
}






/**
int  tcp_recv_sBuffer(int sock, Buffer* str, int tm)

	ǽ: TCPͳʸǡ롥
		  ॢȤ꤬ǽॢȤ 0ꤷ, recv_wait()
		  ؿƤӽФɤ߹߲ǽǡʤФ˥ॢ
		  Ȥʤ (RECV_TIMEOUTED ֤)

	: sock	 åȵһ
		  *str	 ѥǡХåեͽݤƤ
		  tm	   ॢȻ֡ñ̡

	: 1ʾ   줿Хȿ
			-1	  顼餯¦å򥯥
			RECV_TIMEOUTED	  ॢȡ
*/
int  tcp_recv_sBuffer(int sock, Buffer* str, int tm)
{
	int cc;

	str->vldsz = 0;
	cc = tcp_recv_mesg(sock, (char*)str->buf, str->bufsz, tm);
	if (cc>=0) str->vldsz = cc;

	return cc;
}





/**
int  tcp_send_sBuffer(int sock, Buffer* str)

	ǽ: TCPͳʸǡ롥

	: sock	 åȵһ
		  str	  ѥǡХåե

	: ϤХȿ
			Ԥˤ-1֤(send())

*/
int  tcp_send_sBuffer(int sock, Buffer* str)
{
	int cc;

	cc = send(sock, str->buf, strlen((const char*)str->buf), 0);
	return cc;
}






/**
int  tcp_send_sBufferln(int sock, Buffer* str)

	ǽ: TCPå(ʸ)˲(\r\n)դä롥

	: sock	 åȵһ
		  mesg	 ѥåХåե

	: Ϥʸ(ޤ)
			Ԥˤ-1֤(send())
*/
int  tcp_send_sBufferln(int sock, Buffer* str)
{
	int   cc;
	Buffer buf;

   	buf = dup_Buffer(*str);
	cat_s2Buffer("\r\n", &buf);
	cc = send(sock, buf.buf, strlen((const char*)buf.buf), 0);
	free_Buffer(&buf);

	return cc;
}





/**
int  tcp_recv_mstreamBuffer(int sock, Buffer* mesg, mstream* sb, int tm)

	ǽTCPͳǥå(ʸ)롥åϥåȥ꡼
		˰öХåե󥰤졤δؿˤԤɤ߽Ф롥
		  mesg˳ǼβԥɤϺ졤ˤɬ \0 롥
		  ॢȤ꤬ǽǥॢȤ 0ꤷ, ƤӽФ
		  ɤ߹߲ǽǡʤФ˥ॢȤȤʤ (RECV_TIMEOUTED ֤)
		  åȥ꡼ΥХåեݤƤʤϡǽ˸ƤӽФ줿
		ݤ롥öδؿѤơǡХåե󥰤顤åȤ
		  ޤǡɤ߼ˤɬƱȥ꡼ѤƤδؿƤӽФФ
		  Фʤʤ̵ϼǡݾڤʤ

	
		sock	åȵһ
		buf	 	ѥǡХåեХåեݤɬפϤʤ
		sb	  	åХåեʥ󥰷Υȥ꡼Хåե
				ХåեݤƤʤСưŪ˳ݤ롥
		tm	  	ॢȻ֡ñ̡

	͡
		1ʾ   mesg˳ǼåΥХȿ
		0  		餯¦å򥯥
		-1  	顼
		-2  	 NULLΥǡ롥
		-3  	åХåե̵Τǳݤ褦Ȥݤ˼Ԥ
		-4  	åХåե˥ǡ¸ߤϤͳˤ˼Ԥ
		RECV_TIMEOUTED  	ॢȡ
*/
int  tcp_recv_mstreamBuffer(int sock, Buffer* mesg, mstream* sb, int tm)
{
    int    cc;
	unsigned char* pp;

    if (mesg==NULL || sb==NULL) return -2;
	*mesg = make_Buffer(LBUF);

    if (sb->buf==NULL) {
		*sb = make_mstream(RECVBUFSZ);
		if (sb->buf==NULL) return -3;
	}

    while (sb->datano==0) {
        cc = tcp_recv_sBuffer(sock, mesg, tm);
        if (cc<=0) {
			free_Buffer(mesg);
			return cc;
		}
        put_mstream(sb, mesg->buf);
		clear_Buffer(mesg);
    }

    pp = get_mstream(sb);
    if (pp==NULL) return -4;
	copy_s2Buffer((char*)pp, mesg);
    free(pp);

    return mesg->vldsz;
}







/**
int  tcp_recv_linesBuffer(int sock, Buffer* mesg, int tm)

	ǽTCPͳǥå(ʸ)롥ʣʬ\nǽ뤳ȤݾڤˤΥǡ
		  ФȤΤǤʰץХåեǽդ餵˰ʬΥǡФˤϡ
		  get_line() ʤɤѤ롥
		  ޤͥåȥľܰԤŤļФˤϡtcp_recv_mstreamBuffer() Ȥۤɤ

	: sock	 	åȵһ
		  *mesg		ѥǡХåեͽݤƤ
		  tm	  	ॢȻ֡ñ̡

	: 1ʾ   줿Хȿ
			0		餯¦å򥯥
			-1		顼
			-2      buf NULL
			RECV_TIMEOUTED	  	ॢȡ

	ХǡɬLFǽ뤳Ȥݾ㤵ƤˤѤǤʤ
    	  ĤޤŪˤϡֻȤʤ

*/
int  tcp_recv_linesBuffer(int sock, Buffer* mesg, int tm)
{
	int    cc;
	Buffer buf;

	if (mesg==NULL) return -2;
	buf = make_Buffer(LBUF);

	cc = tcp_recv_sBuffer(sock, &buf, tm);
	while (cc>0) {
		cat_Buffer(&buf, mesg);
		if (buf.buf[cc-1]==LF) break;
		clear_Buffer(&buf);
		cc = tcp_recv_sBuffer(sock, &buf, tm);
	}
	free_Buffer(&buf);
		
	if (cc<=0) {
		free_Buffer(mesg);
		return cc;
	}

	return mesg->vldsz;
}





/**


*/
void    decomp_hostport(Buffer buf, Buffer* host, unsigned short* port)
{
	if (buf.buf==NULL) return;

	if (port!=NULL) {
		int i = 0;
		while (buf.buf[i]!='\0' && buf.buf[i]!=':') i++;
		if (buf.buf[i]!='\0') *port = (unsigned short)atoi((char*)&buf.buf[i+1]);
		else *port = 0;
	}

	if (host!=NULL) {
		Buffer hostport = dup_Buffer(buf);
	
		int i = 0;
		while (hostport.buf[i]!='\0' && hostport.buf[i]!=':') i++;
		hostport.buf[i] = '\0';
		hostport.vldsz  = strlen((char*)hostport.buf);
		*host = hostport;
	}

	return;
}




/**
Buffer  comp_hostport(char* host, unsigned short port)

	host FQDNǤѲ

*/
Buffer  comp_hostport(char* host, unsigned short port)
{
	Buffer buf;
	char   hostport[LBUF];

	hostport[0] = '\0';

	if (host!=NULL) {
		if (port!=0) snprintf(hostport, LBUF-1, "%s:%d", host, port);
		else         snprintf(hostport, LBUF-1, "%s", host);
	}
	else {
		if (port!=0) snprintf(hostport, LBUF-1, "%d", port);
	}

	buf = make_Buffer_bystr(hostport);

	return buf;
}







/**
struct sockaddr_in  get_sockaddr_Buffer(Buffer buf)

	ǽFQDN:port ޤ IPaddress:port η Bufferѿ åȾ롥
		  get_sockaddr() (in network.c)  Buffer
*/
struct sockaddr_in  get_sockaddr_Buffer(Buffer buf)
{
	int i, port = 0;
	struct sockaddr_in  addr;
	memset(&addr, 0, sizeof(struct sockaddr_in));

	if (buf.buf==NULL) return addr;
	
	i = 0;
	while (buf.buf[i]!='\0' && buf.buf[i]!=':') i++;
	buf.buf[i] = '\0';

	port = atoi((char*)&buf.buf[i+1]);
	addr = get_sockaddr((char*)buf.buf, port);

	return addr;
}






Buffer get_hostport_sockaddr(struct sockaddr_in addr)
{
	Buffer buf;
	char  hostport[LBUF];
	char* ip = get_ipaddr(addr.sin_addr);
    unsigned short port = ntohs(addr.sin_port);

	snprintf(hostport, LBUF, "%s:%d", ip, port);
	
	buf = make_Buffer_bystr(hostport);
	return buf;
}





#endif 	// WIN32










///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// File I/O 
//

/**
int   save_taggedBuffer(Buffer buf, FILE* fp, unsigned int mode, int prfm)

	ǽBufferꤵ줿˽äƥդǥե¸롥

	buf  -- ¸
		  fp   -- եݥ󥿡
		  mode -- ¸ǡμ̤¸ˡ FBRTL_ ޥǻꤹ롥
		  		  ¸ˡϸߤΤȤ FBRTL_ORIGINAL, FBRTL_BASE64 Τߥݡȡ
		  prfm -- ¸ˡ FBRTL_ORIGINAL ʳꤷ硤ηѴ뤫ɤꤹ롥
				δؿǡѴλƤ FALSE ꤹ롥
				TERUE: Ѵ롥 FALSE: Ѵʤ

	͡TRUE  
			FALSE ԡեƤݾڤʤ

	ɤɤη¸뤫ϡץޤݾڤʤФʤʤ
Ǥǡꤹ٤Ǥ롥

	͡
		tag	tag.buf[0]  ¸ǡμ
				tag.buf[1]  ¸		FBRTL_ORIGINAL, FBRTL_BASE64 򥵥ݡ

		see also  xtool.h

*/
int   save_taggedBuffer(Buffer buf, FILE* fp, unsigned int mode, int prfm)
{	
	int	    cc;
	Buffer  tag, enc;

	tag = make_Buffer(2);
	if (tag.buf==NULL) return FALSE;
	tag.buf[0] = mode & 0x0f;			// ǡμ
	tag.buf[1] = mode & 0xf0;			// ǡη


	// FBRTL_ORIGINAL, FBRTL_BASE64 ʳ̤ݡ
	if (tag.buf[1]==FBRTL_ORIGINAL || !prfm) {
		enc = dup_Buffer(buf);
	}
	else if (tag.buf[1]==FBRTL_BASE64) {
		enc = encode_base64_Buffer(buf);
	}
	else {							
		enc = dup_Buffer(buf);
	}


	tag.vldsz = 2;
	cc = save_Buffer2_fp(tag, enc, fp); 
	free_Buffer(&enc);
	free_Buffer(&tag);

	if (!cc) return FALSE;
	return  TRUE;
}




/**
Buffer   read_taggedBuffer(FILE* fp, unsigned int* mode)

	ǽBuffer򥿥˽äƥե뤫ɤ߹ࡥ

	fp	-- եݥ󥿡
		  *mode -- ɤ߽Фǡμ̤ɤ߽ФΥǡ FBRTL_ ޥǻꤹ롥
		  	 	   ¸Ƥǡɤ߽Фǡμ̤פʤϡǡ֤ʤ
				   FBRTL_ANY ꤷϰפʤȤǡ֤
				   ɤ߽ФΥǡϸߤΤȤ FBRTL_ORIGINAL, FBRTL_BASE64 Τߥݡȡ
				   ꥿ˡ¸Ƥǡμ̤Τ FBRTL_ ޥǳǼ롥

	͡TRUE  
			FALSE ԡ

	ǡFBRTL_ORIGINAL, FBRTL_BIN, FBRTL_DER¸ƤϡΥǡ
		ФƷɤϥץޤǤʤФʤʤ

	͡  
		tag	tag.buf[0]  ¸ǡμ
				tag.buf[1]  ¸		FBRTL_ORIGINAL, FBRTL_BASE64 򥵥ݡ

		see also  xtool.h

*/
Buffer   read_taggedBuffer(FILE* fp, unsigned int* mode)
{	
	unsigned char mthd, kind;
	Buffer   tmp, tag, enc, buf;

	buf = init_Buffer();
	if (mode==NULL) return buf;

	if (!read_Buffer2_fp(&tag, &enc, fp)) return buf;

	kind = *mode & 0x0f;				// ǡμ
	mthd = *mode & 0xf0;				// ǡη
	if (kind!=tag.buf[0] && kind!=FBRTL_ANY) {
		free_Buffer(&enc);
		free_Buffer(&tag);
		return buf;
	}


	// FBRTL_ORIGINAL, FBRTL_BASE64 ʳ̤ݡ
	if (mthd==tag.buf[1]) {				// ¸ȸƤӽФƱ
		buf = dup_Buffer(enc);
	}
	else {
		// ¸ǡ򥪥ꥸʥ
		if (tag.buf[1]==FBRTL_BASE64) {
			tmp = decode_base64_Buffer(enc);
		}
		else {
			tmp = dup_Buffer(enc);
		}

		// ꥸʥƤӽФ
		if (mthd==FBRTL_BASE64) {
			buf = encode_base64_Buffer(tmp);
		}
		else {
			buf = dup_Buffer(tmp);
		}
		free_Buffer(&tmp);
	}

	*mode = (unsigned int)tag.buf[0];	// ǡ
	free_Buffer(&enc);
	free_Buffer(&tag);

	return  buf;
}




/**
Buffer  fgets_mstreamBuffer(Buffer buf, mstream* sb)

    ǽå buf.buf ϥåȥ꡼˰öХåե󥰤졤δؿˤ
          Ԥɤ߽Ф롥̤֤βԥɤϺ졤ˤɬ \0 롥
          åȥ꡼ΥХåեݤƤʤϡǽ˸ƤӽФ줿
        ݤ롥öδؿѤơǡХåե󥰤顤Ǹޤɤ߼ˤ
          ɬƱȥ꡼ѤƤδؿƤӽФФФʤʤ̵ϼǡ
          ݾڤʤ

      buf     Хåե˰öǼåäBufferѿbuf.bufNULLǤġ
            sb      ȥ꡼Хåեʥ󥰥ХåեΥȥ꡼Хåե
                    ХåեݤƤʤСưŪ˳ݤ롥

    ͡ return : ФʸؤΥݥ
             sb->state : -1 åȥ꡼˥顼
                          1 åȥ꡼ͭʥǡʤreturn  NULL
*/
Buffer  fgets_mstreamBuffer(Buffer buf, mstream* sb)
{
	Buffer   ret;
	unsigned char* pp;

	ret = init_Buffer();

	pp = fgets_mstream(buf.buf, sb);
	if (pp!=NULL) {
		ret = make_Buffer(LBUF);
		copy_s2Buffer((char*)pp, &ret);
		free(pp);
	}
	return ret;
}






/////////////////////////////////////////////////////////////////////////////////////////////////
//
// Run Length
//

/**
int  get_runlength_byte(unsigned char* buf, int len, int pos)

	ǽ̤Ƥʤ֤ pos(Byte)ΰ֤0ϢĹ̤ƤǡǤϤɤΰ֤
		  뤫׻롥

	buf -- ϢĹ(0)ƤХʥǡ
		  len -- buf Ĺ
		  pos -- ̤Ƥʤΰ֡

	͡return -- ϢĹ̤ƤǡǤΰ֡
			-1     -- 0x00 ǽäƤ
			-2	   -- 0x00, 0x00 ¸ߤϢĹ̤ΥǡǤϤʤΤǤϡ
*/
int  get_runlength_byte(unsigned char* buf, int len, int pos)
{
	int i, sz;

	sz = -1;
	for (i=0; i<len; i++) {
		if (buf[i]==0x00) {
			if (i+1>=len) return -1;
			if (buf[i+1]==0x00) return -2;
			sz += buf[i+1];
			if (sz>=pos) return i;
			i++;
		}
		else sz++;

		if (sz>=pos) return i;
	}

	return -1;
}





/**
Buffer  decode_runlength(unsigned char* buf, int len, int sz)

	ǽ0ϢĹ̤줿 buf szХȤ̾ΥǡФ

	buf -- ϢĹ(0)ƤХʥǡ
		  len -- buf Ĺʥåѡ
		  sz  -- Ф0ξơ
*/
Buffer  decode_runlength(unsigned char* buf, int len, int sz)
{
	int    i, j, k;
	Buffer ret = init_Buffer();


	// Ĺ
	i = j = 0;
	if (sz<=0) {
		while (j<len) {
			if (buf[j]==0x00) {
				if (j+1<len) {
					if (buf[j+1]==0x00) return ret;
					i += (int)buf[j+1];
					j += 2;
				}
				else break;
			}
			else {
				i++;
				j++;
			}
		}

		if (j==len) sz = i;
		else return ret;
	}
		
	ret = make_Buffer(sz);
	if (ret.buf==NULL) return ret;

	i = j = 0;
	while (i<sz && j<len) {
		if (buf[j]==0x00) {
			if (j+1<len) {
				for (k=0; k<(int)buf[j+1]; k++) ret.buf[i++] = 0x00;
				j += 2;
			}
			else break;
		}	
		else ret.buf[i++] = buf[j++];
	}

	if (i==sz) ret.vldsz = sz;
	else free_Buffer(&ret);

	return ret;
}





Buffer  encode_runlength(unsigned char* buf, int len)
{
	int    i, j, k;
	Buffer ret = init_Buffer();

	ret = make_Buffer(2*len);
	if (ret.buf==NULL) return ret;

	i = j = 0;
	while (j<len) {
		ret.buf[i] = buf[j];

		if (buf[j]==0x00) {
			k = 0;
			while (buf[j]==0x00 && j<len) {
				k++;
				j++;
			}
			ret.buf[i+1] = (unsigned char)k;
			i += 2;
		}
		else {
			i++;
			j++;
		}
	}

	ret.vldsz = i;
	return ret;
}






////////////////////////////////////////////////////////////////////////////////////
//
//  Buffer 
// 

/**
Buffer*  get_Buffer_dim_tList(tList* lp)

	ǽꥹȤʬ򤷤ơ¤

	lp -- оݥꥹ

	͡ꥹȤΥ򥳥ԡBufferؤΥݥ
			Ǥ stateˤǰʹߤǿʼʬޤˤǼ롥
			ʤ0ܤǤ stateˤ礭ǽ롥

*/
Buffer*  get_Buffer_dim_tList(tList* lp)
{
	int     nn, mx;
	tList*  lt;
	Buffer* buf;
	Buffer* ret;


	if (lp==NULL) return NULL;

	lt = lp;
	nn = 0;
	while(lt!=NULL && lt->ldat.key.buf!=NULL) {
		nn++;
		lt = lt->next;
	}
	if (nn==0) return NULL;

	mx = nn;
	buf = ret = (Buffer*)malloc(sizeof(Buffer)*mx);
	if (ret==NULL) return NULL;
	
	nn = 0;
	while(lp!=NULL && lp->ldat.key.buf!=NULL) {
		*buf = dup_Buffer(lp->ldat.key);
		buf->state = mx - nn;
		nn++;
		buf++;
		lp = lp->next;
	}
		
	return ret;
}




/**
Buffer*  get_Buffer_dim_tList_value(tList* lp)

	ǽꥹȤʬ򤷤ơХ塼¤

	lp -- оݥꥹ

	͡ꥹȤΥХ塼򥳥ԡBufferؤΥݥ
			Ǥ stateˤǰʹߤǿʼʬޤˤǼ롥
			ʤ0ܤǤ stateˤ礭ǽ롥

*/
Buffer*  get_Buffer_dim_tList_value(tList* lp)
{
	int     nn, mx;
	tList*  lt;
	Buffer* buf;
	Buffer* ret;


	if (lp==NULL) return NULL;

	lt = lp;
	nn = 0;
	while(lt!=NULL && lt->ldat.val.buf!=NULL) {
		nn++;
		lt = lt->next;
	}
	if (nn==0) return NULL;

	mx = nn;
	buf = ret = (Buffer*)malloc(sizeof(Buffer)*mx);
	if (ret==NULL) return NULL;
	
	nn = 0;
	while(lp!=NULL && lp->ldat.val.buf!=NULL) {
		*buf = dup_Buffer(lp->ldat.val);
		buf->state = mx - nn;
		nn++;
		buf++;
		lp = lp->next;
	}
		
	return ret;
}




/**
Buffer*	 awk_Buffer_dim(Buffer buf, char cc)

	ǽccڤ국Ȥ, Хåեιܤˤ֤

	buf -- о Bufferѿ
		  cc  -- ڤʸ

	͡cc Ƕڤ줿ܤbuf˳ǼBufferؤΥݥ
			Ǥ stateˤǰʹߤǿʼʬޤˤǼ롥
			ʤ0ܤǤ stateˤ礭ǽ롥

*/
Buffer*	 awk_Buffer_dim(Buffer buf, char cc)
{
	Buffer* bf = NULL;

	tList*  lp = awk_Buffer_tList(buf, cc);
	if (lp!=NULL) bf = get_Buffer_dim_tList(lp);
	del_all_tList(&lp);
	
	return  bf;
}




/**
Buffer*	 cawk_Buffer_dim(Buffer buf, char cc)

	ǽccڤ국Ȥ, Хåեιܤˤ֤
		  Ϣ³ cc(ڤ)ϰĤζڤȤߤʤ

	buf -- о Bufferѿ
		  cc  -- ڤʸ

	͡cc Ƕڤ줿ܤbuf˳ǼBufferؤΥݥ
			Ǥ stateˤǰʹߤǿʼʬޤˤǼ롥
			ʤ0ܤǤ stateˤ礭ǽ롥
	
*/
Buffer*	 cawk_Buffer_dim(Buffer buf, char cc)
{
	Buffer* bf = NULL;

	tList*  lp = cawk_Buffer_tList(buf, cc);
	if (lp!=NULL) bf = get_Buffer_dim_tList(lp);
	del_all_tList(&lp);
	
	return  bf;
}





/**
Buffer  join_Buffer_dim(Buffer* dim, char* deli)
	
	ǽBufferƤҤưĤΥǡˤ롥

*/
Buffer  join_Buffer_dim(Buffer* dim, char* deli)
{
	int    i, nn;
	Buffer buf;

	buf = init_Buffer();
	if (dim==NULL) return buf;

	buf = make_Buffer(LBUF);
	nn  = dim->state;

	for (i=0; i<nn; i++) {
		cat_Buffer(dim, &buf);
		if (deli!=NULL && i!=nn-1) cat_s2Buffer(deli, &buf);
		dim++;
	}

	return buf;
}





/**
void  del_Buffer_dim(Buffer** dim)

	ǽưŪ˳ݤ줿 Buffer롥

*/
void  del_Buffer_dim(Buffer** dim)
{
	int  i, nn;
	Buffer* buf;

	if (dim==NULL || *dim==NULL) return;
	buf = *dim;
	
	nn = buf->state;
	if (nn<=0) free_Buffer(buf);

	for (i=0; i<nn; i++) {
		free_Buffer(buf);
		buf++;
	}

	free(*dim);
	*dim = NULL;
	return;
}







///////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Extend tList
//

/**
int	  set_item_tList(tList* list, char* key, int no, char deli, int nm, char* value)

	ǽkey 򥭡ˤ noܤΥΡɤͤǡdeliڤˤ nmܤιܡʸˤ
		value ꤹ롥

	list -- оݤΥإåǼꥹ
		  key  -- إå̡
		  no   -- Ʊإå̤ʣ硤ܤΥΡɤꤹ롥롥
				  no 0ʲξ keyפƤΥΡɤФԤ
		  deli -- Ρ͡ʸˤζڤʸ
		nm   -- deli ڤʸȤƲܤιܤ 1롥
		  value - ꤹʸ

	͡ԤäΡɿ

*/
int	  set_item_tList(tList* list, char* key, int no, char deli, int nm, char* value)
{
	int	cn = 0;
	tList* lp;

	if (list==NULL || key==NULL || value==NULL) return -1;

	if (no>0) {
		lp = strncasecmp_tList(list, key, 0, no);
		if (lp!=NULL) {
			int rep = set_item_tList_node(lp, deli, nm, value);
			if (rep) cn = 1;
		}
	}   
	else {	  // no<=0
		int nn = 1;
		cn = 0;
		lp = strncasecmp_tList(list, key, 0, nn);
		while (lp!=NULL) {
			int rep = set_item_tList_node(lp, deli, nm, value);
			if (rep) cn++;
			lp = strncasecmp_tList(list, key, 0, ++nn);
		}
	}

	return cn;
}






int	  set_item_tList_node(tList* lp, char deli, int nm, char* value)
{
	int	 rep = FALSE;
	char dl[2] = " ";
	Buffer* bp;


	if (lp==NULL || value==NULL) return FALSE;

	dl[0] = deli;

	bp = cawk_Buffer_dim(lp->ldat.val, deli);
	if (bp!=NULL && bp->state>=nm) {
		Buffer buf = make_Buffer_bystr(value);
		free_Buffer(&bp[nm-1]);
		bp[nm-1] = buf;

		free_Buffer(&lp->ldat.val);
		lp->ldat.val = join_Buffer_dim(bp, dl);
		rep = TRUE;
	}
	del_Buffer_dim(&bp);

	return rep;
}






/**
int	  replace_item_tList(tList* list, char* key, int no, char deli, int nm, char* srcval, char* value)

	ǽkey 򥭡ˤ noܤΥΡɤͤǡdeliڤˤ nmܤιܡʸˤ
		srcvalʬ value֤롥

	list  -- оݤΥإåǼꥹ
		  key   -- إå̡
		  no	-- Ʊإå̤ʣ硤ܤΥΡɤꤹ롥롥
				   no 0ʲξ keyפƤΥΡɤФԤ
		  deli  -- Ρ͡ʸˤζڤʸ
		nm	-- deli ڤʸȤƲܤιܤ 1롥
		  srcval - ֤оݤʸNULLʤꤷܤʸ
		  value  - ֤ʸ

	֤͡ԤäΡɿ
*/
int	  replace_item_tList(tList* list, char* key, int no, char deli, int nm, char* srcval, char* value)
{
	int	cn = 0;
	tList* lp;

	if (list==NULL || key==NULL || value==NULL) return -1;
	if (srcval==NULL) {
		return 	set_item_tList(list, key, no, deli, nm, value);
	}

	if (no>0) {
		lp = strncasecmp_tList(list, key, 0, no);
		if (lp!=NULL) {
			int rep = replace_item_tList_node(lp, deli, nm, srcval, value);
			if (rep) cn = 1;
		}
	}   
	else {	  // no<=0
		int nn = 1;
		cn = 0;
		lp = strncasecmp_tList(list, key, 0, nn);
		while (lp!=NULL) {
			int rep = replace_item_tList_node(lp, deli, nm, srcval, value);
			if (rep) cn++;
			lp = strncasecmp_tList(list, key, 0, ++nn);
		}
	}

	return cn;
}






int	  replace_item_tList_node(tList* lp, char deli, int nm, char* srcval, char* value)
{
	int	 rep = FALSE;
	char dl[2] = " ";
	Buffer* bp;
	Buffer  buf;


	if (lp==NULL || value==NULL) return FALSE;
	if (nm<=0) nm = 1;
	if (srcval==NULL) {
		return set_item_tList_node(lp, deli, nm, value);
	}

	dl[0] = deli;

	bp = cawk_Buffer_dim(lp->ldat.val, deli);
	if (bp!=NULL && bp->state>=nm) {
       	buf = replace_sBuffer(bp[nm-1], srcval, value);
		free_Buffer(&bp[nm-1]);
		bp[nm-1] = buf;
		free_Buffer(&lp->ldat.val);
		lp->ldat.val = join_Buffer_dim(bp, dl);
		rep = TRUE;
	}
	del_Buffer_dim(&bp);

	return rep;
}



















///////////////////////////////////////////////////////////////////////////////////////////////////////
//
// General Tools
//
/**
tList*  get_dir_files(const char* dirn)

	ǽꤵ줿ǥ쥯ȥˤե̾ΰ

    dirn -- ǥ쥯ȥ̾

    ͡ե̾Хåեldat.valˤ˳ǼꥹȤؤΥݥ󥿡

	եμ϶̤ʤ ȥǥ쥯ȥ'.', ƥǥ쥯ȥ'..' ꥹȤ롥
*/
tList*  get_dir_files(const char* dirn)
{
	tList* lp = NULL;

#ifdef WIN32
	tList* ln = NULL;
	WIN32_FIND_DATA FindFileData;
	HANDLE hFind;
	Buffer buf;

	buf = make_Buffer_bystr(dirn);
	cat_s2Buffer("\\*", &buf);

	hFind = FindFirstFile((LPCTSTR)(buf.buf), &FindFileData);
	if (hFind!=INVALID_HANDLE_VALUE) {
		Buffer tmp;	
		do {
			tmp = make_Buffer_bystr(dirn);
			cat_s2Buffer("\\", &tmp);
			cat_s2Buffer(FindFileData.cFileName, &tmp);
			ln = add_tList_node_str(ln, NULL, tmp.buf);
			if (lp==NULL) lp = ln;
			free_Buffer(&tmp);
		} while (FindNextFile(hFind, &FindFileData));

		FindClose(hFind);
	}

	free_Buffer(&buf);

#else

	tList* ln=NULL;
	DIR *dp;
	struct dirent *dir;
	
	dp = opendir(dirn);
	if (dp!=NULL ){
		Buffer tmp;
		dir = readdir(dp);
		while (dir != NULL ){
			tmp = make_Buffer_bystr((char*)dirn);
			cat_s2Buffer("/", &tmp);
			cat_s2Buffer(dir->d_name, &tmp);

			ln = add_tList_node_str(ln, NULL, (char*)tmp.buf);
			if (lp==NULL) lp = ln;
			dir = readdir(dp);

			free_Buffer(&tmp);
		}

		closedir(dp);
	}

#endif

	return lp;
}




