/* vi: set tabstop=4 nocindent noautoindent: */

/**
	ѳĥġإå  xtools.h
										'09 2/13 v1.1  by Fumi.Iseki (C)

*/



#ifndef _EXTEND_TOOLS_H
#define _EXTEND_TOOLS_H


#include "common.h"

#include "tools.h"
#include "buffer.h"
#include "tlist.h"

#ifndef WIN32
	#include "network.h"
	#include <dirent.h>
#endif






// File Save & Load Mode
#define  FBRTL_ANY		 	0x0000
#define  FBRTL_IPADDRESS	0x0001
#define  FBRTL_PRIV_KEY	 	0x000a
#define  FBRTL_PUB_KEY	  	0x000b
#define  FBRTL_SPKI		 	0x000c

#define  FBRTL_ORIGINAL	 	0x0000	  // Υǡۣ!!
#define  FBRTL_BIN		  	0x0000
#define  FBRTL_DER		  	0x0000
#define  FBRTL_BASE64	   	0x0010
#define  FBRTL_STRING	   	0x0030
#define  FBRTL_AES		  	0x00a0
#define  FBRTL_DES		  	0x00b0
#define  FBRTL_3DES		 	0x00c0


/**/

// Network
#ifndef WIN32
int	 	udp_recv_Buffer(int sock, Buffer* buf, struct sockaddr_in* sv);
int	 	udp_send_Buffer(int sock, Buffer* buf, struct sockaddr_in* sv);
int	 	tcp_recv_Buffer(int sock, Buffer* buf);
int	 	tcp_send_Buffer(int sock, Buffer* buf);

int	 	udp_send_sBuffer  (int sock, Buffer* buf, struct sockaddr_in* sv);
int		tcp_recv_sBuffer  (int sock, Buffer* buf, int tm);
int	 	tcp_send_sBuffer  (int sock, Buffer* buf);
int	 	tcp_send_sBufferln(int sock, Buffer* buf);   

#define udp_recv_sBuffer(s, b, a)  			udp_recv_Buffer((s), (b), (a))

int  	tcp_recv_mstreamBuffer(int sock, Buffer* buf, mstream* sb, int tm);
int  	tcp_recv_linesBuffer(int sock, Buffer* buf, int tm);

void	decomp_hostport(Buffer buf, Buffer* ipaddr, unsigned short* port);
Buffer	comp_hostport(char* ipaddr, unsigned short port);

struct  sockaddr_in  get_sockaddr_Buffer(Buffer buf);
Buffer  get_hostport_sockaddr(struct sockaddr_in addr); 

#endif



// File I/O
int	 	save_taggedBuffer(Buffer buf, FILE* fp, unsigned int mode, int prfm);
Buffer  read_taggedBuffer(FILE* fp, unsigned int* mode);
Buffer  fgets_mstreamBuffer(Buffer buf, mstream* sb);


// RunLength
int  	get_runlength_byte(unsigned char* buf, int len, int pos);
Buffer	decode_runlength  (unsigned char* buf, int len, int sz);
Buffer	encode_runlength  (unsigned char* buf, int len);

#define get_runlength_byte_Buffer(b, s) 	get_runlength_byte((b).buf, (b).vldsz, (s))
#define decode_runlength_Buffer(b, s)  		decode_runlength((b).buf, (b).vldsz, (s))
#define encode_runlength_Buffer(b)  		encode_runlength((b).buf, (b).vldsz)


// 
Buffer* get_Buffer_dim_tList(tList* lp);			// ꥹȤʬ򤷤ƥ(key)¤
Buffer* get_Buffer_dim_tList_value(tList* lp);		// ꥹȤʬ򤷤ƥХ塼(val)¤

Buffer* awk_Buffer_dim (Buffer  buf, char cc);		// ʸ awkʬ򤷤
Buffer* cawk_Buffer_dim(Buffer  buf, char cc);		// ʸ cawkʬ򤷤
Buffer  join_Buffer_dim(Buffer* dim, char* deli);	// Ǥ dli֤ƷҤ

void    del_Buffer_dim(Buffer** buf);				// 롥


// Extend tList
int		set_item_tList(tList* list, char* key, int no, char deli, int nm, char* value);
int		replace_item_tList(tList* list, char* key, int no, char deli, int nm, char* srcval, char* value);
int		set_item_tList_node(tList* list, char deli, int nm, char* value);
int		replace_item_tList_node(tList* list, char deli, int nm, char* srcval, char* value);


// General
tList*  get_dir_files(const char* dirn);




/**/
#endif




