/* vi: set tabstop=4 nocindent noautoindent: */

/*
եåǡ   gdata.c	v3.0   '02 8/1 (C) Fumi.Iseki

  إå
	  #include "gdata.h"

*/



#include "gdata.h"

int		ZeroBase = 0;
float   RZxy 	 = 1.0;		// 3D Ǥ x,y  z桡(zΥԥֳ)/(x,yΥԥֳ֡
int	 	ChkRZxy  = OFF; 	// RZxyꤵƤʤ ON, ꤵƤʤʤ OFF 




/**
void  free_CmnHead(CmnHead* hd)

	ǽ: ̥إåΥΰ롥cmnHead.kind  HEADER_ERRORˤʤ
		  init_CmnHead()񤷤Ƥ롥

	: hd  -- 붦̥إå

	: ʤ

*/
void  free_CmnHead(CmnHead* hd)
{
	if (hd!=NULL) {
		if (hd->buf!=NULL)   free(hd->buf);
		if (hd->grptr!=NULL) free(hd->grptr);
		init_CmnHead(hd);
	}
}




/**
void  init_CmnHead(CmnHead* hd)

	ǽ: ̥إåΥΰ롥cmnHead.kind  HEADER_ERRORˤʤ

	: hd  -- 붦̥إå

	: ʤ

*/
void  init_CmnHead(CmnHead* hd)
{
	if (hd!=NULL) {
		memset(hd, 0, sizeof(CmnHead));
		hd->kind = HEADER_ERROR;
	}
}




/**
BSGraph  make_BSGraph(int xs, int ys, int zs)

	ǽ: Byteñ㥰եåǡ(BSGraph)Υΰݤ롥
		  եåǡʬ 0ꥢ롥

	: xs   -- ݤ륰եåǡ xΥ
		  ys   -- ݤ륰եåǡ yΥ
		  zs   -- ݤ륰եåǡ zΥ
 
	͡BSGraphեåǡ¤ΡΰǤʤä
			,ΰؤΥݥ󥿤 NULLȤʤ롥
*/
BSGraph  make_BSGraph(int xs, int ys, int zs)
{
	int  i;
	BSGraph  vp;

	memset(&vp, 0, sizeof(BSGraph));
	if (xs==0 && ys==0) return vp;

	vp.xs = xs;
	vp.ys = ys;
	if (zs>0) vp.zs = zs;
	else	  vp.zs = 1;

	vp.gp = (sByte*)malloc(vp.xs*vp.ys*vp.zs*sizeof(sByte));
	if (vp.gp==NULL) {
		memset(&vp, 0, sizeof(BSGraph));
		vp.state = ERROR_GRAPH_MEMORY;
		return vp;
	}

	for (i=0; i<vp.xs*vp.ys*vp.zs; i++) vp.gp[i] = 0;

	return vp;
}




/**
WSGraph  make_WSGraph(int xs, int ys, int zs)

	ǽ: sWordñ㥰եåǡ(WSGraph)Υΰݤ롥
		  եåǡʬ 0ꥢ롥

	: xs   -- ݤ륰եåǡ xΥ
		  ys   -- ݤ륰եåǡ yΥ
		  zs   -- ݤ륰եåǡ zΥ
 
	͡WSGraphեåǡ¤ΡΰǤʤä
			,ΰؤΥݥ󥿤 NULLȤʤ롥
*/
WSGraph  make_WSGraph(int xs, int ys, int zs)
{
	int  i;
	WSGraph  vp;

	memset(&vp, 0, sizeof(WSGraph));
	if (xs==0 && ys==0) return vp;

	vp.xs = xs;
	vp.ys = ys;
	if (zs>0) vp.zs = zs;
	else	  vp.zs = 1;

	vp.gp = (sWord*)malloc(vp.xs*vp.ys*vp.zs*sizeof(sWord));
	if (vp.gp==NULL) {
		memset(&vp, 0, sizeof(WSGraph));
		vp.state = ERROR_GRAPH_MEMORY;
		return vp;
	}

	for (i=0; i<vp.xs*vp.ys*vp.zs; i++) vp.gp[i] = 0;

	return vp;
}




/**
FSGraph  make_FSGraph(int xs, int ys, int zs)

	ǽ: floatñ㥰եåǡ(FSGraph)Υΰݤ롥
		  եåǡʬ 0ꥢ롥

	: xs   -- ݤ륰եåǡ xΥ
		  ys   -- ݤ륰եåǡ yΥ
		  zs   -- ݤ륰եåǡ zΥ
 
	͡FSGraphեåǡ¤ΡΰǤʤä
			,ΰؤΥݥ󥿤 NULLȤʤ롥
*/
FSGraph  make_FSGraph(int xs, int ys, int zs)
{
	int  i;
	FSGraph  vp;

	memset(&vp, 0, sizeof(FSGraph));
	if (xs==0 && ys==0) return vp;

	vp.xs = xs;
	vp.ys = ys;
	if (zs>0) vp.zs = zs;
	else	  vp.zs = 1;

	vp.gp = (float*)malloc(vp.xs*vp.ys*vp.zs*sizeof(float));
	if (vp.gp==NULL) {
		memset(&vp, 0, sizeof(FSGraph));
		vp.state = ERROR_GRAPH_MEMORY;
		return vp;
	}

	for (i=0; i<vp.xs*vp.ys*vp.zs; i++) vp.gp[i] = 0.0;

	return vp;
}




/**
ISGraph  make_ISGraph(int xs, int ys, int zs)

	ǽ: intñ㥰եåǡ(ISGraph)Υΰݤ롥
		  եåǡʬ 0ꥢ롥

	: xs   -- ݤ륰եåǡ xΥ
		  ys   -- ݤ륰եåǡ yΥ
		  zs   -- ݤ륰եåǡ zΥ
 
	͡ISGraphեåǡ¤ΡΰǤʤä
			,ΰؤΥݥ󥿤 NULLȤʤ롥
*/
ISGraph  make_ISGraph(int xs, int ys, int zs)
{
	int  i;
	ISGraph  vp;

	memset(&vp, 0, sizeof(ISGraph));
	if (xs==0 && ys==0) return vp;

	vp.xs = xs;
	vp.ys = ys;
	if (zs>0) vp.zs = zs;
	else	  vp.zs = 1;

	vp.gp = (int*)malloc(vp.xs*vp.ys*vp.zs*sizeof(int));
	if (vp.gp==NULL) {
		memset(&vp, 0, sizeof(ISGraph));
		vp.state = ERROR_GRAPH_MEMORY;
		return vp;
	}

	for (i=0; i<vp.xs*vp.ys*vp.zs; i++) vp.gp[i] = 0;

	return vp;
}




/**
VSGraph  make_VSGraph(int xs, int ys, int zs)

	ǽ: vectorñ㥰եåǡ(VSGraph)Υΰݤ롥
		  եåǡʬ 0ꥢ롥

	: xs   -- ݤ륰եåǡ xΥ
		  ys   -- ݤ륰եåǡ yΥ
		  zs   -- ݤ륰եåǡ zΥ

	͡VSGraphեåǡ¤ΡΰǤʤä
			,ΰؤΥݥ󥿤 NULLȤʤ롥
*/
VSGraph  make_VSGraph(int xs, int ys, int zs)
{
	int  i;
	VSGraph  vp;

	memset(&vp, 0, sizeof(VSGraph));
	if (xs==0 && ys==0) return vp;

	vp.xs = xs;
	vp.ys = ys;
	if (zs>0) vp.zs = zs;
	else	  vp.zs = 1;

	vp.gp = (vector*)malloc(xs*ys*zs*sizeof(vector));
	if (vp.gp==NULL) {
		memset(&vp, 0, sizeof(VSGraph));
		vp.state = ERROR_GRAPH_MEMORY;
		return vp;
	}

	for (i=0; i<xs*ys*zs; i++) vp.gp[i] = set_vector(0.0, 0.0, 0.0);

	return vp;
}




/**
ISGraph  W2ISGraph(WSGraph vp)

	ǽ: sWordñ㥰եåǡ(WSGraph) intñ㥰եå
		  ǡ(ISGraph)Ѵ롥

	: vp   -- Ѵ sWordñ㥰եåǡ
 
	͡Ѵ줿 intñ㥰եåǡ(ISGraph)
*/
ISGraph  W2ISGraph(WSGraph vp)
{
	int  i;
	ISGraph  ix;

	ix.xs = vp.xs;
	ix.ys = vp.ys;
	ix.zs = vp.zs;
	ix.state = vp.state;

	ix.gp = (int*)malloc(ix.xs*ix.ys*ix.zs*sizeof(int));
	if (ix.gp==NULL) {
		memset(&ix, 0, sizeof(ISGraph));
		ix.state = ERROR_GRAPH_MEMORY;
		return ix;
	}

	for (i=0; i<ix.xs*ix.ys*ix.zs; i++) ix.gp[i] = (int)vp.gp[i];
	return ix;
}





/**
FSGraph  W2FSGraph(WSGraph vp)

	ǽ: sWordñ㥰եåǡ(WSGraph) floatñ㥰եå
		  ǡ(FSGraph)Ѵ롥

	: vp   -- Ѵ sWordñ㥰եåǡ
 
	͡Ѵ줿 floatñ㥰եåǡ(FSGraph)
*/
FSGraph  W2FSGraph(WSGraph vp)
{
	int  i;
	FSGraph  ix;

	ix.xs = vp.xs;
	ix.ys = vp.ys;
	ix.zs = vp.zs;
	ix.state = vp.state;

	ix.gp = (float*)malloc(ix.xs*ix.ys*ix.zs*sizeof(float));
	if (ix.gp==NULL) {
		memset(&ix, 0, sizeof(FSGraph));
		ix.state = ERROR_GRAPH_MEMORY;
		return ix;
	}

	for (i=0; i<ix.xs*ix.ys*ix.zs; i++) ix.gp[i]=(float)vp.gp[i];
	return ix;
}






/**
WSGraph  I2WSGraph(ISGraph vp)

	ǽ: intñ㥰եåǡ(ISGraph) sWordñ㥰եå
		  ǡ(WSGraph)Ѵ롥

	: vp   -- Ѵ intñ㥰եåǡ
 
	͡Ѵ줿 sWordñ㥰եåǡ(WSGraph)
*/
WSGraph  I2WSGraph(ISGraph vp)
{
	int  i;
	WSGraph  ix;

	ix.xs = vp.xs;
	ix.ys = vp.ys;
	ix.zs = vp.zs;
	ix.state = vp.state;

	ix.gp = (sWord*)malloc(ix.xs*ix.ys*ix.zs*sizeof(sWord));
	if (ix.gp==NULL) {
		memset(&ix, 0, sizeof(WSGraph));
		ix.state = ERROR_GRAPH_MEMORY;
		return ix;
	}

	for (i=0; i<ix.xs*ix.ys*ix.zs; i++) ix.gp[i] = (sWord)vp.gp[i];
	return ix;
}




/**
WSGraph  F2WSGraph(FSGraph vp)

	ǽ: floatñ㥰եåǡ(FSGraph) sWordñ㥰եå
		  ǡ(WSGraph)Ѵ롥

	: vp   -- Ѵ floatñ㥰եåǡ
 
	͡Ѵ줿 sWordñ㥰եåǡ(WSGraph)
*/
WSGraph  F2WSGraph(FSGraph vp)
{
	int  i;
	WSGraph  ix;

	ix.xs = vp.xs;
	ix.ys = vp.ys;
	ix.zs = vp.zs;
	ix.state = vp.state;

	ix.gp = (sWord*)malloc(ix.xs*ix.ys*ix.zs*sizeof(sWord));
	if (ix.gp==NULL) {
		memset(&ix, 0, sizeof(WSGraph));
		ix.state = ERROR_GRAPH_MEMORY;
		return ix;
	}

	for (i=0; i<ix.xs*ix.ys*ix.zs; i++) ix.gp[i] = (sWord)vp.gp[i];
	return ix;
}




/**
WSGraph  V2FSGraph(VSGraph vp)

	ǽ: vectorñ㥰եåǡ(VSGraph) floatñ㥰եå
		  ǡ(FSGraph)Ѵ롥

	: vp   -- Ѵ vectorñ㥰եåǡ

	͡Ѵ줿 floatñ㥰եåǡ(FSGraph)
*/
FSGraph  V2FSGraph(VSGraph vp)
{
	int  i;
	FSGraph  ix;

	ix = make_FSGraph(vp.xs, vp.ys, vp.zs);
	if (ix.gp==NULL) return ix;

	for (i=0; i<ix.xs*ix.ys*ix.zs; i++) ix.gp[i] = vp.gp[i].r;
	ix.state = vp.state;

	return ix;
}





/**
WSGraph  V2WSGraph(VSGraph vp)

	ǽ: vectorñ㥰եåǡ(VSGraph) sWordñ㥰եå
		  ǡ(WSGraph)Ѵ롥

	: vp   -- Ѵ vectorñ㥰եåǡ

	͡Ѵ줿 sWordñ㥰եåǡ(WSGraph)
*/
WSGraph  V2WSGraph(VSGraph vp)
{
	int  i;
	WSGraph  ix;

	ix = make_WSGraph(vp.xs, vp.ys, vp.zs);
	if (ix.gp==NULL) return ix;

	for (i=0; i<ix.xs*ix.ys*ix.zs; i++) ix.gp[i] = (sWord)vp.gp[i].r;
	ix.state = vp.state;

	return ix;
}





/**
void  init_RBound(RBound* rb)

	ǽ: ǡ¤Τ롥

	: *rb  -- 붭ǡϤʤ롥
 
	͡ʤ
*/
void  init_RBound(RBound* rb)
{
	rb->xmax = rb->ymax = rb->zmax = 0;
	rb->xmin = rb->ymin = rb->zmin = INTMAX;
	rb->misc = OFF;
}






/**
void   set_RZxy(float rzm)

	ǽ: zΤҤߤꤹ롥ǥեȤǤ 1.0ꤵƤ롥
		  ̵ˤˤ void unset_RZxy(void) Ѥ롥

	: rzm  -- Ҥߤ͡
 
	͡ʤ
*/
void   set_RZxy(float rzm)
{
	ChkRZxy = ON;
	RZxy = rzm;
	//fprintf(stderr,"set_RZxy: set RZxy to %f\n", rzm);
}




/**
int  chk_RZxy(void)   

	ǽ: zΤҤߤ꤬ꤵƤ뤫ɤå롥

	: ʤ
 
	͡ʤ
*/
int  chk_RZxy(void)   
{
	if (ChkRZxy==OFF) {
		DEBUG_MODE print_message("CHK_RZXY: WARNING: undefined RZxy!!!\n");
		//exit(1);
		return FALSE;
	}
	return TRUE;
}







