/**
եåǡѥإå   gdata.h   v3.0   '02/8/27
                               			(C) Fumi.Iseki

  ¸ط
      #include "gheader.h"
      #include "matrix.h"

*/






#ifndef _GDATA_H
#define _GDATA_H

#include "gheader.h"
#include "matrix.h"




////////////////////////////////////////////////////////////////////////////////////////////////
// եåǡι¤ (C)

/**
BSGRraph :Memory type (ǻѤ뷿
    int xs   : x. 4Byte.  
    int ys   : y. 4Byte.
    int zs   : z. 4Byte. 2Dξ 1.
	int state: 
    Byte* gp : եåǡؤΥݥ. xs*ys*zs*1Byte.

    ͭХȷ(1Byte)ץ륰եåǡ 
*/
typedef struct {
    int    xs;
    int    ys;
    int    zs;
	int    state;
    sByte* gp;
} BSGraph;



/**
WSGRraph :Memory type (ǻѤ뷿
    int xs   : x. 4Byte.  
    int ys   : y. 4Byte.
    int zs   : z. 4Byte. 2Dξ 1.
	int state: 
    sWord* gp: եåǡؤΥݥ. xs*ys*zs*2Byte.

    ͭɷ(2Byte)ץ륰եåǡ 
    ץǤβǡΥǥեȡ
*/
typedef struct {
    int    xs;
    int    ys;
    int    zs;
	int    state;
    sWord* gp;
} WSGraph;




/**
ISGRraph :Memory type (ǻѤ뷿
    int xs   : x. 4Byte.  
    int ys   : y. 4Byte.
    int zs   : z. 4Byte. 2Dξ 1.
	int state: 
    integer* gp : եåǡؤΥݥ. xs*ys*zs*4Byte.

    ץ륰եåǡ 
*/
typedef struct {
    int    xs;
    int    ys;
    int    zs;
	int    state;
    int*   gp;
} ISGraph;




/**
FSGRraph :Memory type (ǻѤ뷿
    int xs   : x. 4Byte.  
    int ys   : y. 4Byte.
    int zs   : z. 4Byte. 2Dξ 1.
	int state: 
    foat* gp : եåǡؤΥݥ. xs*ys*zs*sizeof(float)

    ¿ץ륰եåǡ 
*/
typedef struct {
    int    xs;
    int    ys;
    int    zs;
	int    state;
    float* gp;
} FSGraph;





/**
VSGRraph :Memory type (ǻѤ뷿
    int xs   : x. 4Byte.  
    int ys   : y. 4Byte.
    int zs   : z. 4Byte. 2Dξ 1.
	int state: 
    foat* gp : եåǡؤΥݥ. xs*ys*zs*sizeof(vector).

    ٥ȥ뷿ץ륰եåǡ 
*/
typedef struct {
    int    xs;
    int    ys;
    int    zs;
	int    state;
    vector *gp;
} VSGraph;





/**
¤  RBound 
    int xmin: xκǾ͡
    int xmax: xκ͡
    int ymin: yκǾ͡
    int ymax: yκ͡
    int zmin: zκǾ͡
    int zmax: zκ͡
    int misc: ¿Ūѡ

    եåǡ͡ʶ¸뷿 
*/
typedef struct {
    int xmin;
    int xmax;
    int ymin;
    int ymax;
    int zmin;
    int zmax;
    int misc;
} RBound;




extern  int 	ZeroBase;
extern  float   RZxy;
extern  int     ChkRZxy;



/**/

WSGraph I2WSGraph(ISGraph vp);
WSGraph F2WSGraph(FSGraph vp);
ISGraph W2ISGraph(WSGraph vp);
FSGraph W2FSGraph(WSGraph vp);
WSGraph V2WSGraph(VSGraph vp);
FSGraph V2FSGraph(VSGraph vp);

BSGraph make_BSGraph(int xs, int ys, int zs);
WSGraph make_WSGraph(int xs, int ys, int zs);
FSGraph make_FSGraph(int xs, int ys, int zs);
ISGraph make_ISGraph(int xs, int ys, int zs);
VSGraph make_VSGraph(int xs, int ys, int zs);


WSGraph zoom_WSGraph(WSGraph vp, int zm, int mode);
WSGraph grab_WSGraph(WSGraph vp, int x1, int y1, int x2, int y2);
void    copy_WSGraph(WSGraph src, WSGraph dst);

int     chk_RZxy(void);
void    set_RZxy(float rzm);
void    init_RBound(RBound* rb);
#define unset_RZxy()    {ChkRZxy=OFF;}

void	free_CmnHead(CmnHead* hd);      // ̥إåΥΰ
void	init_CmnHead(CmnHead* hd);

/**/



/**
ޥؿ

    free_Graph(WSGrapg* vp)              եåǡ vpΥХåե롥 
    Lx(WSGRaph vp, int i)                ǡ vp (i) Υǡ򻲾Ȥ롥
    Px(WSGRaph vp, int i, int j)         ǡ vp (i, j) Υǡ򻲾Ȥ롥
    Vx(WSGRaph vp, int i, int j, int k)  ǡ vp (i, j, k) Υǡ򻲾Ȥ롥
*/
#define  free_Graph(vp)    {if((vp)->gp)free((vp)->gp); (vp)->gp=NULL; (vp)->xs=(vp)->ys=(vp)->zs=(vp)->state=0;}
#define  free_WSGraph(vp)  {if((vp)->gp)free((vp)->gp); (vp)->gp=NULL; (vp)->xs=(vp)->ys=(vp)->zs=(vp)->state=0;}
#define  free_FSGraph(vp)  {if((vp)->gp)free((vp)->gp); (vp)->gp=NULL; (vp)->xs=(vp)->ys=(vp)->zs=(vp)->state=0;}
#define  free_ISGraph(vp)  {if((vp)->gp)free((vp)->gp); (vp)->gp=NULL; (vp)->xs=(vp)->ys=(vp)->zs=(vp)->state=0;}
#define  free_VSGraph(vp)  {if((vp)->gp)free((vp)->gp); (vp)->gp=NULL; (vp)->xs=(vp)->ys=(vp)->zs=(vp)->state=0;}

#define  Lx(vp, i)        ((vp).gp[(i)])
#define  Px(vp, i, j)     ((vp).gp[(i)+(vp).xs*(j)])
#define  Vx(vp, i, j, k)  ((vp).gp[(i)+(vp).xs*(j)+(vp).xs*(vp).ys*(k)])

#define  Lxt(vp, i)       ((vp).gp[((i)-1)])
#define  Pxt(vp, i, j)    ((vp).gp[((i)-1)+(vp).xs*((j)-1)])
#define  Vxt(vp, i, j, k) ((vp).gp[((i)-1)+(vp).xs*((j)-1)+(vp).xs*(vp).ys*((k)-1)])



#endif

