/**
եåǡإå   gheader.h   v3.0   '02/8/27
                               			(C) Fumi.Iseki

  ¸ط

*/






#ifndef _GRAPHIC_HEADER_H_
#define _GRAPHIC_HEADER_H_


#include "common.h"
#include "tools.h"

#include <stdlib.h>
#include <malloc.h>
#include <sys/stat.h>






///////////////////////////////////////////////////////////////////////////////////////
// CT(Moon) format إå
//			 
typedef struct {
	sWord  xsize;
	sWord  ysize;
	sWord  ctmin;
	sWord  ctmax;
	sWord  cutup; 
	sWord  cutdown;
	sWord  cutleft;
	sWord  cutright;
	sWord  anydata[23];
	sWord  img_flag;
} CTHead;




///////////////////////////////////////////////////////////////////////////////////////
// SUN RASTER File
// see...   man 5 rasterfile 
//
typedef struct {
    int  ras_magic;
    int  ras_width;
    int  ras_height;
    int  ras_depth;
    int  ras_length;
    int  ras_type;
    int  ras_maptype;
    int  ras_maplength;
} RasHead;



#define RAS_MAGIC       0x59a66a95
#define RAS_RLE         0x80
#define RT_OLD          0  
#define RT_STANDARD     1 
#define RT_BYTE_ENCODED 2 
#define RT_FORMAT_RGB   3
#define RMT_NONE        0
#define RMT_EQUAL_RGB   1
#define RMT_RAW         2




///////////////////////////////////////////////////////////////////////////////////////
// ̥إå
//
typedef struct {
	int	kind;				// Kind of Graphics Format		  
	int	xsize;				// Width of Graphics						
	int	ysize;				// Height of Graphics				  
	int	zsize;				// For 3D Data						 
	int	depth;				// Color Depth of Graphics	     (bit  unit)  
	unsigned int bsize;		// Fllowing buf size or Any Data (byte unit) 
	unsigned int lsize;		// Size of Graphics Data		 (byte unit) 
	uByte* buf;				// Ture Header buffer				  
	uByte* grptr;			// Pointer to Data					 
} CmnHead;





///////////////////////////////////////////////////////////////////////////////////////
/**
ΤǤեɤ߹Υإå

Common
	CmnHead  cmhd   : common header. 36Byte. 
	GraphicHeader : ǡͭΥإå
	Graphic  Data   : ǡ

	Ǥդβǡ¸βǡ˼̥إå(CmnHead)
	դ¸Ρ

-----------------------------------------------------------------------------------------------------
UN_KNOWN
	CmnHead  cmhd   : common header. 36Byte.ʾάġ
	Any Graphic	 : ǤդΥեåǡ
		[GraphicHeader] : ǡͭΥإå
		[Graphic  Data]   : ǡ

	Common HeaderϾάġʾάϡΥե
	եޥåȤϤǤʤΥեäơcmhd kindʳ̣ʤ
	η¸뤳Ȥ⡤إåŪ˰ȸʳä˰̣Ϥʤ


RAS_DATA
	CmnHead  cmhd : common header. 36Byte. ʾάġ
	RasHead  rshd : SunRasterΥإå32Byte. Ф int. 
	Graphic  Data : ǡ

	Common HeaderϾάġ
	Sun Rasterΰñʷ(Starndard)
	
	  			  
USERSET_DATA
	CmnHead  cmhd : common header. 36Byte. ʾάġ
	ANY HEADER	  : 桼Υإå 
	Graphic  Data : ǡ

	Common HeaderϾάġޤANY HEADER̵⤢롥
	إå򥪥ڥ졼ʥ桼ˤꤹηإåꤷơɤ߹ߡ񤭹ߤδؿ
	Ϥɬפ롥


CTե˴ؤƤ Gio.h 򸫤补


*/	
	


///////////////////////////////////////////////////////////////////////////////////////
// إå
// 0x0000 - 0x0080 
#define  UN_KNOWN			0  		// 0x0000	// ΤʤǡʥƥˤǤ
#define  MOON_DATA			1  		// 0x0001 
#define  DICOM_DATA			2  		// 0x0002	// DICOM Header
#define  RAS_DATA			4  		// 0x0004	// SUN RASTER  
#define  USERSET_DATA		8  		// 0x0008	// 桼Υǡʥإåξ硤Ѥ

// for CT Data
#define  CT_RGN_SL			16  	// 0x0010	// CT Region Slice DATA
#define  CT_DATA			32  	// 0x0020	// CT DATA (Moon) 
#define  CT_3DM		 		64  	// 0x0040	// 3D CT DATAʥޥ饤
#define  CT_3D_VOL			128		// 0x0080	// CT ܥ塼ǡ 	  
 

// 0x0100 - 0x4000 ѥ᡼ 
#define  HAS_DUMMY1			256  	// 0x0100
#define  HAS_DUMMY2 	  	512  	// 0x0200   
#define  HAS_BASE			1024  	// 0x0400   // 夲ͤ
#define  HAS_ZSPACE  	 	2048  	// 0x0800   
#define  HAS_RZXY		  	4096  	// 0x1000   // with RZxy data 
#define  HAS_RBOUND 	 	8192  	// 0x2000   // with RBound data 
#define  HAS_LENDIAN 		16384	// 0x4000   // ȥ륨ǥ

#define  HEADER_ERROR  		32768  	// 0x8000	// 顼 

#define  NUM_KDATA   		32767  	// 0x7fff	// Max Numver of Data Format



#define  RZXY_RATE    		10000	// RZxy եΥإåݤΨΨˡ 
#define  ZEROCT_BASE  		4096		



// GLib Υ顼
#define ERROR_GRAPH_HEADER  -1
#define ERROR_GRAPH_MEMORY  -2
#define ERROR_GRAPH_CANCEL  -3
#define ERROR_GRAPH_NODATA  -4
#define ERROR_GRAPH_NOFILE  -5
#define ERROR_GRAPH_OPFILE  -6
#define ERROR_GRAPH_RDFILE  -7
#define ERROR_GRAPH_WRFILE  -8
#define ERROR_GRAPH_FILESZ  -9
#define ERROR_GRAPH_IVDARG  -20
#define ERROR_GRAPH         -999



// DICOM
#define  DICOM_STUDY_GROUP  	0x0020
#define  DICOM_IMAGE_GROUP  	0x0028
#define  DICOM_PIXEL_GROUP		0x7fe0

#define  DICOM_PIXEL_ELEMENT  	0x0010
#define  DICOM_XSIZE_ELEMENT  	0x0011
#define  DICOM_YSIZE_ELEMENT  	0x0010
#define  DICOM_PXLSPC_ELEMENT  	0x0030
#define  DICOM_DEPTH_ELEMENT  	0x0100
#define  DICOM_GRYLV_ELEMENT  	0x0101

#define  DICOM_PIXCEL_VR		0x574f		// Not
#define  DICOM_STR_VR			0x5344		// Z
#define  DICOM_INT_VR			0x5355		// X, Y


#endif




