// vim: set tabstop=4 paste nocindent noautoindent ff=unix: 

/*
JPEG TOOL  			jpeg_tool.c	v0.9   '09/3/8 (C) Fumi.Iseki

	Using libjpeg

  	إå
	  	#include "jpeg_tool.h"

*/



#include "jpeg_tool.h"




/**
JPEGImage  read_jpeg_file(char* fname)

	ǽJPEGեɤ߹ǡJPEGImage¤ΤإǡǼ롥
	
	fname -- ɤ߹ե̾

	: JPEGImage ǡ
			.gp NULL ξ硥
				.state 	ERROR_GRAPH_OPFILE  ե륪ץ󥨥顼
				 	   	ERROR_GRAPH_HEADER  եJPEGեǤʤ
						ERROR_GRAPH_MEMORY  ꥨ顼

*/
JPEGImage  read_jpeg_file(char* fname)
{
	JPEGImage jp;
	int    xs, ys, col;
	FILE*  fp;

	struct jpeg_decompress_struct jdat;
	struct jpeg_error_mgr         jerr;


	memset(&jp, 0, sizeof(JPEGImage));

	jdat.err = jpeg_std_error(&jerr);
	jpeg_create_decompress(&jdat);

	// 顼ϥɥ
/*	jdat.client_data = "Client Data";
	jerr.error_exit  = jpeg_error_exit;
	jerr.output_message = print_message;
*/

	fp = fopen(fname, "rb");
	if (fp==NULL) {
		jp.state = ERROR_GRAPH_OPFILE;
		return jp;
	}
	jpeg_stdio_src(&jdat, fp);
	jpeg_read_header(&jdat, TRUE);
	jpeg_start_decompress(&jdat);

	xs  = jdat.output_width;
	ys  = jdat.output_height;
	col = jdat.output_components;
	if (xs<=0 || ys<=0 || col<=0) {
		jpeg_destroy_decompress(&jdat);
		fclose(fp);
		jp.state = ERROR_GRAPH_HEADER;
		return jp;
	}

	jp = make_JPEGImage(xs, ys, col);
	if (jp.gp==NULL) {
		jpeg_destroy_decompress(&jdat);
		fclose(fp);
		jp.state = ERROR_GRAPH_MEMORY;
		return jp;
	}
	

	int rmn = jdat.output_height;
	while(rmn>0) {
		jpeg_read_scanlines(&jdat, jp.img+jdat.output_scanline, rmn);
		rmn = jdat.output_height - jdat.output_scanline;
	}
	jpeg_finish_decompress (&jdat);
	jpeg_destroy_decompress(&jdat);

	fclose(fp);

	return jp;
}






/**
int  write_jpeg_file(char* fname, JPEGImage jp, int qulty)


	  fname -- ե̾
			jp    -- ¸ JPEGǡ
			qulty -- ¸Υƥ 0100  100ǹ

	͡ERROR_GRAPH_OPFILE  ե륪ץ󥨥顼
			ERROR_GRAPH_HEADER  եJPEGեǤʤ
			ERROR_GRAPH_MEMORY  ꥨ顼
			ERROR_GRAPH_NODATA 	jp ˥ǡ̵
			ERROR_GRAPH_IVDARH  ե̾ NULL, or ݡȳΥͥ(1 3Τߥݡ)
*/
int  write_jpeg_file(char* fname, JPEGImage jp, int qulty)
{
	FILE*  fp;
	struct jpeg_compress_struct jdat;
	struct jpeg_error_mgr       jerr;


	if (fname==NULL) return ERROR_GRAPH_IVDARG;
	if (jp.col!=1 && jp.col!=3) return ERROR_GRAPH_IVDARG;
	if (jp.gp==NULL || jp.img==NULL) return ERROR_GRAPH_NODATA;

	if (qulty>100)    qulty = 100;
	else if (qulty<0) qulty = 0;
	

	fp = fopen(fname, "wb");
	if (fp==NULL) {
		return ERROR_GRAPH_OPFILE;
	}

	jdat.err = jpeg_std_error(&jerr);
	jpeg_create_compress(&jdat);

	// 顼ϥɥ
/*	jdat.client_data = "Client Data";
	jerr.error_exit  = jpeg_error_exit;
	jerr.output_message = print_message;
*/
	jpeg_stdio_dest(&jdat, fp);

	jdat.image_width      = jp.xs;
	jdat.image_height     = jp.ys;
	jdat.input_components = jp.col;
	if (jp.col==1) jdat.in_color_space = JCS_GRAYSCALE;
	else           jdat.in_color_space = JCS_RGB;

	jpeg_set_quality (&jdat, qulty, TRUE);
	jpeg_set_defaults(&jdat);

	jpeg_start_compress (&jdat, TRUE);
	jpeg_write_scanlines(&jdat, jp.img, jp.ys);
	jpeg_finish_compress(&jdat);

	jpeg_destroy_compress(&jdat);
	fclose(fp);	

	return 0;
}








/**
WSGraph  JPEGImage2WSGraph(JPEGImage jp)

	ǽJPEGǡͥʬ򤷤ơWSGraph˳Ǽ롥

*/
WSGraph  JPEGImage2WSGraph(JPEGImage jp)
{
	WSGraph vp;
	int  i, j, k, yp, zp;

	memset(&vp, 0, sizeof(WSGraph));
	if (jp.gp==NULL || jp.img==NULL) {
		vp.state = ERROR_GRAPH_NODATA;
		return vp;
	}

	vp = make_WSGraph(jp.xs, jp.ys, jp.col);
	if (vp.gp==NULL) return vp;
	
	for (k=0; k<jp.col; k++) {
		zp = k*jp.xs*jp.ys;
		for (j=0; j<jp.ys; j++) {
			yp = zp + j*jp.xs;
			for (i=0; i<jp.xs; i++) {
				vp.gp[yp + i] = (sWord)(jp.img[j][i*jp.col + k]);	// ͥʬ
			}
		}
	}

	return vp;
}




/**
JPEGImage  WSGraph2JPEGImage(WSGraph vp)


*/
JPEGImage  WSGraph2JPEGImage(WSGraph vp)
{
	JPEGImage jp;
	int  i, j, k, yp, zp;

	memset(&jp, 0, sizeof(JPEGImage));
	if (vp.gp==NULL) {
		jp.state = ERROR_GRAPH_NODATA;
		return jp;
	}

	jp = make_JPEGImage(vp.xs, vp.ys, vp.zs);
	if (jp.gp==NULL || jp.img==NULL) return jp;

	for (k=0; k<vp.zs; k++) {
		zp = k*vp.xs*vp.ys;
		for (j=0; j<vp.ys; j++) {
			yp = zp + j*vp.xs;
			for (i=0; i<vp.xs; i++) {
				jp.img[j][i*vp.zs + k] = vp.gp[yp + i];
			}
		}
	}

	return jp;
}





















/**
JPEGImage  make_JPEGImage(int xs, int ys, int col)


*/
JPEGImage  make_JPEGImage(int xs, int ys, int col)
{
	int  j;
	JPEGImage jp;

	memset(&jp, 0, sizeof(JPEGImage));
	if (xs==0 || ys==0) {
		jp.state = ERROR_GRAPH_IVDARG;
		return jp;
	}
	if (col<1) col = 3;

	jp.img = (JSAMPARRAY)malloc(sizeof(JSAMPROW)*ys);
	if (jp.img==NULL) {
		jp.state = ERROR_GRAPH_MEMORY;
		return jp;
	}

	jp.gp  = (JSAMPLE*)malloc(sizeof(JSAMPLE)*col*xs*ys);
	if (jp.gp==NULL) {
		freeNull(jp.img);
		jp.state = ERROR_GRAPH_MEMORY;
		return jp;
	}
	
	for (j=0; j<ys; j++) {
		jp.img[j] = (JSAMPROW)&jp.gp[j*col*xs];
	}

	jp.xs  = xs;
	jp.ys  = ys;
	jp.col = col;

	return jp;
}




/**
void  free_JPEGImage(JPEGImage* jp)


*/
void  free_JPEGImage(JPEGImage* jp)
{
	if (jp==NULL) return;

	freeNull(jp->gp);
	freeNull(jp->img);
	
	jp->xs = jp->ys = jp->col = 0;
	return;
}



