/*
JPEG TOOL HEADER:  jpeg_tool.h v0.9   '09/3/8   (C) Fumi.Iseki
 

*/


#ifndef __JPEG_TOOL_H_
#define __JPEG_TOOL_H_


#include "xtools.h"
#include "gdata.h"

#include <jpeglib.h>



typedef struct {
    int    xs;
    int    ys;
    int    col;
	int	   state;
    JSAMPLE*   gp;
    JSAMPARRAY img;
} JPEGImage;




//////////////////////////////////////////////////////////////////////////////////////////

JPEGImage  read_jpeg_file (char* fname);
int  	   write_jpeg_file(char* fname, JPEGImage jp, int qulty);

WSGraph    JPEGImage2WSGraph(JPEGImage jp);
JPEGImage  WSGraph2JPEGImage(WSGraph vp);

JPEGImage  make_JPEGImage(int xs, int ys, int col);
void       free_JPEGImage(JPEGImage* jp);








#endif



