/* vi: set tabstop=4 nocindent paste : */


/**
ʰץǡ١饤֥ for Berkeley BD4:  bdb_tool.c  v2.0

  إå
	  #include "bdb_tool.h"

  饤֥
	  -ldb-4.2  for Berkeley DB4



  Berkeley DBΥޥ˥奢
		http://pybsddb.sourceforge.net/reftoc.html

*/




#include "bdb_tool.h"






/**
DB*  open_fdb(char* fname, unsigned int mode)
  
	ǽ: ǡ١Υץ
		  ǡ١ե fname򥪡ץ󤹤롥
		  ¸ߤʤϥե롥

	: fname -- ǡ١Υե̾(̾ĥҤϽ)

	: ǡ١եΥեǥץ
			ǡ١ե뤬¸ߤ,ˤ⼺Ԥ NULL ֤롥

*/
DB*  open_fdb(char* fname, unsigned int mode)
{
	DB* dp;

	if (fname==NULL) return NULL;

	int ret = db_create(&dp, NULL, 0);
	if (ret==0) {
		ret = dp->open(dp, NULL, fname, NULL, DB_HASH, (u_int32_t)mode, 0600);
	}

	if (ret!=0) {
		DEBUG_MODE {
			dp->err(dp, ret, "DB->open");
			print_message("dbname is %s\n", fname);
		}
		return NULL;
	}
	return dp;
}




/**
void  close_fdb(DB** dp)

	ǽǡ١Υǡƥեå夹롥

*/
void  close_fdb(DB** dp)
{
	if (dp==NULL || *dp==NULL) return;

	(*dp)->close((*dp), 0);
	*dp = NULL;
	return;
}




/**
int  check_fdb_file(char* fname)
  
	ǽ: ǡ١Υå
		  ǡ١ե fname¸ߤ뤫ɤå롥
		  ¸ߤʤϥե롥

	: fname -- ǡ١Υե̾(̾ĥҤϽ)

	: ǡ١ե뤬¸ߤ롥ޤϺˤ TRUE֤롥
			ǡ١ե뤬¸ߤ,ˤ⼺Ԥ FALSE֤롥

*/
int  check_fdb_file(char* fname)
{
	DB* dp = open_fdb(fname, DB_CREATE);

	if (dp==NULL)  return FALSE;
	close_fdb(&dp);
	return TRUE;
}




/**
int   set_fdb_data(DB* dp, Buffer id, Buffer dbdata)

	ǽ: ǥץȤäǡ١ؤϿ
		  ǡ١ǥץ dp ˥ id  dbdata Ͽ롥
		  ƱǴ˥ǡϿƤ dbdata֤롥
		  եΥץȥϹԤʤ

	: dp	 -- ǡ١ǥץ
		  id	 -- ǡ١Υ
		  dbdata -- ǡ١Ͽǡ

	: ǡϿϥǡĹ֤롥
			ϥǡΥʬʤ -1֤롥
			ǡϿ˼Ԥ 0֤롥

*/
int   set_fdb_data(DB* dp, Buffer id, Buffer dbdata)
{
	DBT  key, data;
	int  ret;
 
	memset(&key,  0, sizeof(DBT));
	memset(&data, 0, sizeof(DBT));

	key.data = id.buf;
	key.size = id.vldsz;
	if (key.size<=0) {
		key.size = strlen((char*)id.buf);
		if (key.size<=0) return -1;
	}

	data.data = dbdata.buf;
	data.size = dbdata.vldsz;
	if (data.size<=0) return -1;

	ret = dp->put(dp, NULL, &key, &data, 0);
	if (ret!=0) {
		DEBUG_MODE dp->err(dp, ret, "DB->put");
		return 0;
	}
	return  data.size;
}




/**
int   set_fdb_data_file(char* fname, Buffer id, Buffer dbdata)

	ǽ: ǡ١ؤϿ
		  ǡ١ե fname ˥ id  dbdata Ͽ롥
		  ƱǴ˥ǡϿƤ dbdata֤롥
		  եΥץȥԤ

	: fname  -- ǡ١Υե̾(̾ĥҤϽ)
		  id	 -- ǡ١Υ
		  dbdata -- ǡ١Ͽǡ

	: ǡϿϥǡĹ֤롥
			ǡ١եΥץ˼Ԥ硤ϥǡΥʬʤ -1֤롥
			ǡϿ˼Ԥ 0֤롥

*/
int   set_fdb_data_file(char* fname, Buffer id, Buffer dbdata)
{
	DBT  key, data;
	DB*  dp;
	int  ret;
 
	dp = open_fdb(fname, DB_CREATE);
	if (dp==NULL) return -1;

	memset(&key,  0, sizeof(DBT));
	memset(&data, 0, sizeof(DBT));

	key.data  = (char*)(id.buf);
	key.size = id.vldsz;
	if (key.size<=0) {
		key.size = strlen((char*)id.buf);
		if (key.size<=0) return -1;
	}

	data.data = (char*)dbdata.buf;
	data.size = dbdata.vldsz;
	if (data.size<=0) return -1;

	ret = dp->put(dp, NULL, &key, &data, 0);
	close_fdb(&dp);

	if (ret!=0) {
		DEBUG_MODE dp->err(dp, ret, "DB->put");
		return 0;
	}
	return  data.size;
}




/**
Buffer  get_fdb_data(DB* dp, Buffer id)

	ǽ: ǡ١ǡ
		  ǡ١ǥץ dp 饭 id ǥǡ롥
		   idʸǤʤФʤʤ
		  եΥץȥϹԤʤ

		  ˤ, ͤȤ BufferǡؤΥݥ󥿤֤
		  ɤ߼äǡηϥץޤİƤʤФʤʤ
		  ɤ߼äǡϻѤä free_Buffer()ؿˤ곫ʤФʤʤ

		  ǡμ˼Ԥ -2,γݤ˼Ԥ -3  state˳Ǽ֤롥
		  ԤϤξ, ѿ bufͤNULLˤʤä֤롥

	: dp	 -- ǡ١Υեǥץ
		  id	 -- ɤ߼ǡΥ

	:  ɤ߼äǡ(Bufferǡ)ؤΥݥ󥿤֤

	⡧data.data freeƤϤʤ

*/
Buffer  get_fdb_data(DB* dp, Buffer id)
{
	int  ret;
	DBT  key, data;
	Buffer dbdata;

	memset(&key,  0, sizeof(DBT));
	memset(&data, 0, sizeof(DBT));

	dbdata   = init_Buffer();
	key.data = (void*)id.buf;
	key.size = (u_int32_t)id.vldsz;
	if (key.size<=0) {
		key.size = strlen((char*)id.buf);
		if (key.size<=0) {
			dbdata.state = -2;
			return dbdata;
		}
	}

	ret = dp->get(dp, NULL, &key, &data, 0);
	if (ret!=0) {
		dbdata.state = -2;
		return  dbdata;
	}

	dbdata = make_Buffer(data.size+1);		// +1 is for string
	if (dbdata.buf==NULL) {
		dbdata.state = -3;
		return  dbdata;
	}
	memcpy(dbdata.buf, data.data, data.size);
	dbdata.vldsz = data.size;
	dbdata.buf[data.size] = '\0';			// for string

	return  dbdata;
}




/**
Buffer  get_fdb_data_file(char* fname, Buffer id)

	ǽ: ǡ١ǡ
		  ǡ١ե fname 饭 id ǥǡ롥
		   idʸǤʤФʤʤ
		  եΥץȥԤ

		  ˤ, ͤȤ BufferǡؤΥݥ󥿤֤
		  ɤ߼äǡηϥץޤİƤʤФʤʤ
		  ɤ߼äǡϻѤä free_Buffer()ؿˤ곫ʤФʤʤ

		  ǡ١ե fnameΥץ˼Ԥ Bufferѿ
		  ѿ state -1Ǽ֤롥ǡμ˼Ԥ
		   -2,γݤ˼Ԥ -3Ǽ֤롥
		  ԤϤξ,ѿbufͤNULLˤʤä֤롥

	: fname  -- ǡ١Υե̾(̾ĥҤϽ)
		  id	 -- ɤ߼ǡΥ

	:  ɤ߼äǡ(Bufferǡ)ؤΥݥ󥿤֤

	⡧data.data freeƤϤʤ

*/
Buffer  get_fdb_data_file(char* fname, Buffer id)
{
	int  ret;
	DBT  key, data;
	DB*  dp;
	Buffer dbdata;

	dbdata = init_Buffer();
	dp = open_fdb(fname, DB_RDONLY);
	if (dp==NULL) {
		dbdata.state = -1;
		return  dbdata;
	}

	memset(&key,  0, sizeof(DBT));
	memset(&data, 0, sizeof(DBT));

	key.data = (char*)(id.buf);
	key.size = id.vldsz;
	if (key.size<=0) {
		key.size = strlen((char*)id.buf);
		if (key.size<=0) {
			dbdata.state = -2;
			return dbdata;
		}
	}

	ret = dp->get(dp, NULL, &key, &data, 0);
	close_fdb(&dp);
	if (ret!=0) {
		dbdata.state = -2;
		return  dbdata;
	}

	dbdata = make_Buffer(data.size+1);		// +1 is for string
	if (dbdata.buf==NULL) {
		dbdata.state = -3;
		return  dbdata;
	}

	dbdata.vldsz = data.size;
	memcpy(dbdata.buf, data.data, data.size);
	dbdata.buf[data.size] = '\0';			// for string

	return  dbdata;
}




/**
int   del_fdb_data(DB* dp, Buffer id)

	ǽ: ǡ١κ
		  ǡ١ǥץ dp 饭 id Υǡ롥
		   idʸǤʤФʤʤ
		  եΥץȥϹԤʤ

	: dp	-- ǡ١ǥץ
		  id	-- ǡΥ

	: ǡκ TRUE֤롥
			ǡκ˼Ԥ FALSE֤롥

*/
int   del_fdb_data(DB* dp, Buffer id)
{
	DBT  key;
	int  ret;
 
	memset(&key, 0, sizeof(DBT));
	key.data = (char*)(id.buf);
	key.size = id.vldsz;
	if (key.size<=0) {
		key.size = strlen((char*)id.buf);
		if (key.size<=0) return FALSE;
	}
	ret = dp->del(dp, NULL, &key, 0);

	if (ret!=0) {
		DEBUG_MODE dp->err(dp, ret, "DB->del");
		return FALSE;
	}
	return  TRUE;
}




/**
int   del_fdb_data_file(char* fname, Buffer id)

	ǽ: ǡ١κ
		  ǡ١ե fname 饭 id Υǡ롥
		   idʸǤʤФʤʤ
		  եΥץȥԤ

	: fname -- ǡ١Υե̾(̾ĥҤϽ)
		  id	-- ǡΥ

	: ǡκ TRUE֤롥
			ǡκ˼Ԥ FALSE֤롥

*/
int   del_fdb_data_file(char* fname, Buffer id)
{
	DBT  key;
	DB*  dp;
	int  ret;
 
	dp = open_fdb(fname, 0);
	if (dp==NULL) return FALSE;

	memset(&key, 0, sizeof(DBT));
	key.data = (char*)(id.buf);
	key.size = id.vldsz;
	if (key.size<=0) {
		key.size = strlen((char*)id.buf);
		if (key.size<=0) return FALSE;
	}

	ret = dp->del(dp, NULL, &key, 0);
	close_fdb(&dp);

	if (ret!=0) {
		DEBUG_MODE dp->err(dp, ret, "DB->del");
		return FALSE;
	}
	return  TRUE;
}





/**
tList*  get_all_fdb_data(DB* dp)

	ǽ: ǡ١Τμ 

	: db -- ǡ١̻ҡ

*/
tList*  get_all_fdb_data(DB* dp)
{
	int  ret;
	DBT  key, data;
	DBC* crsp;

	tList* lt = NULL;
	tList* lp = NULL;
	Buffer id, dt;

	if (dp==NULL) return NULL;

	dp->cursor(dp, NULL, &crsp, 0);
	if (crsp==NULL) return NULL;
	
	memset(&key,  0, sizeof(DBT));
	memset(&data, 0, sizeof(DBT));

	ret = crsp->c_get(crsp, &key, &data, DB_NEXT);
	while (ret==0) {
		id = make_Buffer_bin(key.data,  key.size);
		dt = make_Buffer_bin(data.data, data.size);
		lt = add_tList_node_Buffer(lt, id, dt);
		if (lp==NULL) lp = lt;
		free_Buffer(&id);
		free_Buffer(&dt);

		ret = crsp->c_get(crsp, &key, &data, DB_NEXT);
	}

	crsp->c_close(crsp);

	return lp;
}





/**
tList*  get_all_fdb_data_file(char* fname)

	ǽ: ǡ١Τμ 

	: *fname -- ǡ١Υե̾

*/
tList*  get_all_fdb_data_file(char* fname)
{
	DB*    dp;
	tList* lp = NULL;

	if (fname==NULL) return NULL;

	dp = open_fdb(fname, DB_RDONLY);
	if (dp==NULL) return NULL;

	lp = get_all_fdb_data(dp);
	close_fdb(&dp);

	return lp;
}






