/**



	Υץ zlib ѤƤޤ

*/


#include "gz_tool.h"



/*
int  gz_encode_file(const char* ffn, const char* tfn)

	ǽե ffn 򰵽̤ gzip ե tfn ¸롥

	͡ɤ߹եΥ
*/
int  gz_encode_file(const char* ffn, const char* tfn)
{
	int  cc, sz;
	unsigned char buf[RECVBUFSZ];
	gzFile gf;
	FILE*  fp;

	fp = fopen(ffn, "rb");
	if (fp==NULL) return -1;

	gf = gzopen(tfn, "wb");
	if (gf==NULL) {
		fclose(fp);
		return -1;
	}

	memset(buf, 0, RECVBUFSZ);
	sz = cc = fread(buf, RECVBUFSZ, 1, fp);
	while(cc>0) {
		//gzread(gf, (voidp)buf, cc);
		gzwrite(gf, (voidp)buf, cc);
		memset(buf, 0, cc);
		cc = fread(buf, RECVBUFSZ, 1, fp);
		sz += cc;
	}

	gzclose(gf);	
	fclose(fp);

	return sz;
}




/**
int  gz_decode_file(const char* ffn, const char* tfn)

	ǽgzip ե ffn Ÿ ե tfn ¸롥

	͡񤭹եΥ
*/
int  gz_decode_file(const char* ffn, const char* tfn)
{
	int  cc, sz;
	unsigned char buf[RECVBUFSZ];
	gzFile gf;
	FILE*  fp;

	gf = gzopen(ffn, "rb");
	if (gf==NULL) return -1;

	fp = fopen(tfn, "wb");
	if (fp==NULL) {
		gzclose(gf);
		return -1;
	}

	memset(buf, 0, RECVBUFSZ);
	sz = cc = gzread(gf, (voidp)buf, RECVBUFSZ);
	while(cc>0) {
		fwrite(buf, cc, 1, fp);
		memset(buf, 0, cc);
		cc = gzread(gf, (voidp)buf, RECVBUFSZ);
		sz += cc;
	}

	gzclose(gf);	
	fclose(fp);

	return sz;
}




int  gz_decode_file_replace(const char* fn, const char* tempdir)
{
	int cc;
	char* tempfn;

	tempfn = temp_filename(tempdir, 16);
	cc = gz_decode_file(fn, tempfn);
	if (cc<=0) {
		free(tempfn);
		return cc;
	}

	unlink(fn);
	rename(tempfn, fn);
	freeNull(tempfn);

	return cc;
} 





////////////////////////////////////////////////////////////////////////////////////////////////

/*
int  gz_encode_file(FILE* fp, gzFile* gf)

	ǽե fp 򰵽̤ gzip ե *gf ¸롥

	͡ɤ߹եΥ
*/
int  gz_encode_fp(FILE* fp, gzFile* gf)
{
	int  cc, sz;
	unsigned char buf[RECVBUFSZ];

	if (*gf==NULL) return -1;

	memset(buf, 0, RECVBUFSZ);
	sz = cc = fread(buf, RECVBUFSZ, 1, fp);
	while(cc>0) {
		//gzread(*gf, (voidp)buf, cc);
		gzwrite(*gf, (voidp)buf, cc);
		memset(buf, 0, cc);
		cc = fread(buf, RECVBUFSZ, 1, fp);
		sz += cc;
	}

	return sz;
}




/**
int  gz_decode_fp(gzFile* gf, FILE* fp)

	ǽgzip ե gf Ÿ ե fp ¸롥

	͡񤭹եΥ
*/
int  gz_decode_fp(gzFile* gf, FILE* fp)
{
	int  cc, sz;
	unsigned char buf[RECVBUFSZ];

	if (*gf==NULL) return -1;

	memset(buf, 0, RECVBUFSZ);
	sz = cc = gzread(*gf, (voidp)buf, RECVBUFSZ);
	while(cc>0) {
		fwrite(buf, cc, 1, fp);
		memset(buf, 0, cc);
		cc = gzread(*gf, (voidp)buf, RECVBUFSZ);
		sz += cc;
	}

	return sz;
}





