
#include "http_tool.h"
#include "isnet.h"


/**
http_tool

	openssl饤̵֥꤬ƤѤǤ褦 https_tool ȤʬΥ


*/


////////////////////////////////////////////////////////////////////////////////////////////////////////
// Basic Funcsion.  
//


/**
int  send_http_header(int sofd, tList* pp, int mode)

	ǽإåꥹȤƤ HTTP̿롥
		  إå Content-Length ͤʤ

	sofd		³ؤΥå
		  pp   		إåǼꥹȤؤΥݥ󥿡
		  mode 		ON:  إåꥹ˥ƥĤΰФ롥
					OFF: إåꥹ˥ƥĤΰäƤʤ

	͡>=0		mode==OFF: ǡХȿmode==ON: 饳ƥĤΥХȿ
			<0		顼
			-1		ꥹȤؤΥݥ󥿤 NULL
*/
int  send_http_header(int sofd, tList* pp, int mode)
{
	int	   hs=0, sz=0;
	Buffer buf;

	if (pp==NULL) return -1;

	buf = restore_protocol_header(pp, ": ", mode);
	sz  = tcp_send_Buffer(sofd, &buf);
	if (mode==ON) sz = sz - hs;

	free_Buffer(&buf);
	return sz;
}




/**
int  send_http_Buffer(int sofd, tList* pl, Buffer* buf)

	ǽإåȥХåեƤ HTTP̿롥

	sofd		³ؤΥå
		  pl   		եΩäإåǼꥹȤؤΥݥ󥿡
		  buf		륳ƥĤǼ줿 BufferѿؤΥݥ󥿡

	͡>=0  	ǡ(Byte)
			-1		ꥹȤؤΥݥ󥿤 NULL
			-2		buf Υ顼
*/
int  send_http_Buffer(int sofd, tList* pl, Buffer* buf)
{
	int    sz;
	Buffer snd;
	tList* pp;

	if (pl==NULL) return -1;
	if (buf==NULL || buf->vldsz<0 || buf->buf==NULL) return -2;

	// Content-Length ν񤭴
	pp = pl;
	while(pp!=NULL) {
		if (!strcasecmp((const char*)(pp->ldat.key.buf), "Content-Length")) {
			copy_i2Buffer(buf->vldsz, &(pp->ldat.val));
			break;
		}
		pp = pp->next;
	}

	snd = restore_protocol_header(pl, ": ", OFF);
	cat_Buffer(buf, &snd);

	sz = tcp_send_Buffer(sofd, &snd);
	free_Buffer(&snd);

	return sz;
}






/**
int  send_http_file(int sofd, tList* pp, const char* fname)

	ǽإåȥեƤ HTTP̿롥

	sofd		³ؤΥå
		  pp   		եΩäإåǼꥹȤؤΥݥ󥿡
		  fname		ե̾إåΤ NULL

	͡>=0  	ǡ(Byte)
			-1		ꥹȤؤΥݥ󥿤 NULL
			-2		ݥ顼
*/
int  send_http_file(int sofd, tList* pl, const char* fname)
{
	int   sz = 0;
	FILE* fp = NULL;
	char num[20];
	tList* pp;
	unsigned char* html;
	Buffer  buf;


	if (pl==NULL) return -1;
	if (fname!=NULL) sz = file_size((char*)fname);
	if (sz<=0) sz = 0;
	snprintf(num, 18, "%d", sz);

	// Content-Length ν񤭴
	pp = pl;
	while(pp!=NULL) {
		if (!strcasecmp((const char*)(pp->ldat.key.buf), "Content-Length")) {
			copy_s2Buffer(num, &(pp->ldat.val));
			break;
		}
		pp = pp->next;
	}

	buf = restore_protocol_header(pl, ": ", OFF);


	if (fname!=NULL && sz!=0) fp = fopen(fname, "rb");
	if (fp!=NULL) {
		html = (unsigned char*)malloc(sz+1);
		if (html==NULL) {
			fclose(fp);
			free_Buffer(&buf);
			return -2;
		}

		memset(html, 0, sz+1);
		fread(html, sz, 1, fp); 
		fclose(fp);

		cat_b2Buffer(html, &buf, sz);
		free(html);
	}

	//tcp_send(sofd, (char*)html, sz);
	sz = tcp_send_Buffer(sofd, &buf);
	free_Buffer(&buf);

	return sz;
}







/**
int  recv_http_header(int sofd, tList** pl, int* len, FILE* fp, int* state)

	ǽHTTP̿ΥإåʬơꥹȤ˳Ǽ롥
		  NULLǤʤ fp ꤵ줿硤ƤΥǡե¸롥

	sofd		³ؤΥå
		  *pl		إå󤬳ǼꥹȤؤΥݥ
		  *len		إå "Content-Length" .  "Content-Length" ¸ߤʤ HTTP_HEADER_UNKNOWN_LEN (0̤)
					󥯷ʤ HTTP_HEADER_CHUNKED (0̤)
		  fp		ƤΥǡ¸뤿Υեݥ󥿡NULLξ¸ʤ
		  *state	ФȤ³֡³ʤ TRUEǤ FALSENULLꤷƤɤ

	͡0>		Хȿ
			0 		
			-1		顼
			-2		̵ sofdꤷ
*/
int  recv_http_header(int sofd, tList** pl, int* len, FILE* fp, int* state)
{
	int  cc, sz;
	Buffer mbuf;
	tList* lp;

	if (sofd<=0) return -2;
	if (len!=NULL)   *len = HTTP_HEADER_UNKNOWN_LEN;
	if (state!=NULL) *state = TRUE;

	mbuf = make_Buffer(RECVBUFSZ);

	sz  = 0;
	lp  = NULL;
	*pl = NULL;
	do {
		cc = tcp_recv_Buffer(sofd, &mbuf);
		if (cc>0) {
			if (fp!=NULL) fwrite(mbuf.buf, cc, 1, fp);
			lp = get_protocol_header_list_seq(lp, mbuf, ':', TRUE, TRUE);
			sz += cc;
		}
		else {
			if (state!=NULL) *state = FALSE;
			break;
		}

		*pl = find_tList_top(lp);
	} while(strncasecmp_tList(*pl, HDLIST_END_KEY, 0, 1)==NULL);

	free_Buffer(&mbuf);
	if (sz==0 && cc==0) return 0;       // 
	if (sz==0 && cc<0)  return -1;
	if (*pl==NULL) 		return -1;


	// ƥĤĹ롥
	if (len!=NULL) {
		Buffer hbuf;

		hbuf = search_protocol_header(*pl, HDLIST_FIRST_LINE_KEY, 1);
		if (hbuf.buf!=NULL) {
			if (!strncasecmp((char*)hbuf.buf, "GET ", 4)) {
				*len = 0;
			}
			free_Buffer(&hbuf);
		}

		if (*len==HTTP_HEADER_UNKNOWN_LEN) {
			hbuf = search_protocol_header(*pl, "Transfer-Encoding", 1);
			if (hbuf.buf!=NULL) {
				if (!strcasecmp((char*)hbuf.buf, "chunked")) {
					*len = HTTP_HEADER_CHUNKED;
				}
				free_Buffer(&hbuf);
			}
		}

		if (*len==HTTP_HEADER_UNKNOWN_LEN) {
			hbuf = search_protocol_header(*pl, "Content-Length", 1);
			if (hbuf.buf!=NULL) {
				*len = atoi((const char*)hbuf.buf);
				free_Buffer(&hbuf);
			}
		}
	}

	return sz;
}






/**
int  recv_http_content(int sofd, Buffer* buf, int len, int tm, FILE* fp, int* state)

	ǽHTTPå recv_http_header() Ǽإå˰³ơƥĤ롥
		  fp NULLǤʤСǡʥƥġˤϥեˤ¸롥

	sofd		³ؤΥå
		  buf		ƥĤ¸ѿǽˡrecv_http_header()Ǽƥʬ֤
		  len		إå "Content-Length" ͡ǡΥΥå˻Ѥ롥
		  tm		ॢÿ
		  fp		ƥĤ¸եǥץNULLʤ¸ʤ
		  *state	ФȤ³֡³ʤ TRUEǤ FALSENULLꤷƤɤ

	͡>=0  	ƥĤΥ(Byte)recv_http_header()Ǽƥʬޤࡥ
			<0		顼
*/
int  recv_http_content(int sofd, Buffer* buf, int len, int tm, FILE* fp, int* state)
{
	int    cc, sz;
	Buffer rcv;

	if (state!=NULL) *state = TRUE;
	sz = buf->vldsz;

	// ƥĤλĤ
	rcv = make_Buffer(RECVBUFSZ);
	while(sz<len) {
		if (!recv_wait(sofd, tm)) {
			if (state!=NULL) *state = FALSE;
			free_Buffer(&rcv);
			return RECV_TIMEOUTED;
		}

		cc = tcp_recv_Buffer(sofd, &rcv);
		if (cc>0) {
			if (fp!=NULL) fwrite(rcv.buf, cc, 1, fp);
			cat_Buffer(&rcv, buf);
			sz += cc;
		}
		else {
			if (state!=NULL) *state = FALSE;
			break;
		}
		memset(rcv.buf, 0, cc);
	}
	free_Buffer(&rcv);

	return sz;
}






/**
int  recv_http_chunked(int sofd, Buffer* buf, int tm, FILE* fp, int* state)

	ǽHTTPå recv_http_header() Ǽإå˰³ơChunk⡼ɤΥƥĥǡ롥
		  fp NULLǤʤСǡʥƥġˤϥեˤ¸롥

	sofd		³ؤΥå
		  buf		ƥĤ¸ѿǽˡrecv_http_header()Ǽƥʬ֤
		  tm		ॢÿ
		  fp		ƥĤ¸եǥץNULLʤ¸ʤ
		  *state	ФȤ³֡³ʤ TRUEǤ FALSENULLꤷƤɤ

	͡>=0  	ƥĤΥ(Byte)recv_http_header()Ǽƥʬޤࡥ
			<0		顼
*/
int  recv_http_chunked(int sofd, Buffer* buf, int tm, FILE* fp, int* state)
{
	int    cc, sz, tout;
	Buffer rcv;


	if (state!=NULL) *state = TRUE;
	sz = buf->vldsz;

	rcv = make_Buffer(RECVBUFSZ);
	while ((tout=recv_wait(sofd, tm))){
		cc = tcp_recv_Buffer(sofd, &rcv);
		if (cc>0) {
			if (fp!=NULL) fwrite(rcv.buf, cc, 1, fp);
			cat_Buffer(&rcv, buf);
			sz += cc;
		}
		else {
			if (state!=NULL) *state = FALSE;
			break;
		}
		memset(rcv.buf, 0, cc);
	}
	free_Buffer(&rcv);

	if (!tout) {
		if (state!=NULL) *state = FALSE;
		return RECV_TIMEOUTED;
	}

	return sz;
}






/**
int  recv_http_Buffer(int sofd, tList** pl, Buffer* buf, int tsecond, int* hdonly, int* state)

	ǽHTTPåơBufferѿ *buf¸롥gzipΥ󥳡ɽϹԤʤ
		  bufΥХåեΰͽݤƤ뤳ȡ

	sofd		³ؤΥå
		  *pl   	إåǼꥹȤؤΥݥ󥿡ɬפʤʤ NULLǤɤ
		  buf		ƥĤǼ BufferѿؤΥݥ󥿡
		  tsecond	ǽμޤǤΥॢ(s)
		  *hdonly   ǡإåΤߤξ TRUE, ƥĤ⤢ FALSENULLꤷƤɤ
		  *state	ФȤ³֡³ʤ TRUEǤ FALSENULLꤷƤɤ

	͡
			>=0  	ƥĤΥ(Byte)
			-1		顼
			-2		buf 顼
			RECV_TIMEOUTED	ॢȤ
*/
int  recv_http_Buffer(int sofd, tList** pl, Buffer* buf, int tsecond, int* hdonly, int* state)
{
	int	   cc=0, hs, len;
	Buffer cnt;
	int	   connect;
	tList* lp;


	if (buf==NULL || buf->buf==NULL) return -2;
	if (hdonly!=NULL) *hdonly = FALSE;

	// إåμ
	//hs = recv_http_header(sofd, pl, &len, NULL, &connect);
	hs = recv_http_header(sofd, &lp, &len, NULL, &connect);
	if (state!=NULL) *state = connect;
	if (hs<=0)  return hs;											// 顼
	if (len==0) { 													// إåΤ
		if (hdonly!=NULL) *hdonly = TRUE;
		return hs;
	}

	// إåʶƥĤμФ
	//cnt = search_protocol_header(*pl, HDLIST_CONTENTS_KEY, 1);
	cnt = search_protocol_header(lp, HDLIST_CONTENTS_KEY, 1);
	if (cnt.buf!=NULL) {
		cc = cnt.vldsz;
		hs = hs - cc;
		copy_Buffer(&cnt, buf);
		free_Buffer(&cnt);
	}

	if (pl!=NULL) *pl = lp;
	else del_tList(&lp);


	// ƥĤμ
	if (connect) {
		if (len>0) {
			cc = recv_http_content(sofd, buf, len, tsecond, NULL, &connect);
		}
		else {	//if (len==HTTP_HEADER_CHUNKED) {
			cc = recv_http_chunked(sofd, buf, tsecond, NULL, &connect);
		}
	}
	if (cc>0) cc = cc + hs;

	if (state!=NULL) *state = connect;
	return cc;
}






/**
int  recv_http_file(int sofd, tList** pl, const char* fname, const char* wdir, int tsecond, int* hdonly, int* state)

	ǽHTTPåơƥĤե¸롥Encoding gzipξŸ롥

	sofd		³ؤΥå
		  *pl   	إåǼꥹȤؤΥݥ󥿡
		  fname		¸ե̾
		wdir		ѥǥ쥯ȥꡥNULLξ /tmp ˤʤ롥
		  tsecond	ǽμޤǤΥॢ(s)
		  *hdonly   ǡإåΤߤξ TRUE, ƥĤ⤢ FALSENULLꤷƤɤ
		  *state	ФȤ³֡³ʤ TRUEǤ FALSENULLꤷƤɤ

	͡>=0  	եΥ(Byte)
			-1		顼
			RECV_TIMEOUTED	ॢȤ
*/
int  recv_http_file(int sofd, tList** pl, const char* fname, const char* wdir, int tsecond, int* hdonly, int* state)
{
	int	   cc=0, hs, len;
	Buffer buf, cnt;
	FILE*  fp = NULL;
	const char tmpd[] = "/tmp";
	int	  connect;


	if (hdonly!=NULL) *hdonly = FALSE;

	// إåμ
	hs = recv_http_header(sofd, pl, &len, NULL, &connect);
	if (state!=NULL) *state = connect;
	if (hs<=0)  return hs;											// 顼
	if (len==0) { 													// إåΤ
		if (hdonly!=NULL) *hdonly = TRUE;
		return hs;
	}

	// إåʶƥĤμФ
	buf = make_Buffer(RECVBUFSZ);
	cnt = search_protocol_header(*pl, HDLIST_CONTENTS_KEY, 1);
	if (cnt.buf!=NULL) {
		cc = cnt.vldsz;
		hs = hs - cc;
		copy_Buffer(&cnt, &buf);
		free_Buffer(&cnt);
	}


	// ƥĤμ
	if (connect) {
		if (len>0) {
			cc = recv_http_content(sofd, &buf, len, tsecond, NULL, &connect);
		}
		else {	//if (len==HTTP_HEADER_CHUNKED) {
			cc = recv_http_chunked(sofd, &buf, tsecond, NULL, &connect);
		}
	}


	if (cc>0) {
		// ƥĤե¸
		if (fname!=NULL) fp = fopen(fname, "wb");
		if (fp!=NULL) {
			fwrite(buf.buf, buf.vldsz, 1, fp);
			fclose(fp);
		}
		free_Buffer(&buf);


		// Encoding(gzip) 
		if (fname!=NULL) {
			buf = search_protocol_header(*pl, "Content-Encoding", 1);
			if (buf.buf!=NULL && !strncasecmp((const char*)buf.buf, "gzip", 4)) {
				#ifdef DISABLE_ZLIB 
					DEBUG_MODE print_message("RECV_HTTP_FILE: WARNING: Encoding is GZIP. But zlib is not installed!!\n");
				#else
					if (wdir==NULL) wdir = tmpd;
					cc = gz_decode_file_replace(fname, wdir);
				#endif
			}
			free_Buffer(&buf);
		}
		cc = cc + hs;
	}

	if (state!=NULL) *state = connect;
	return cc;
}







/**
    XML̿ǡե¸

	¸ǡ	
*/
int   save_http_xml(int cofd, tList** pl, tXML** xml, char** recvfn, const char* wdir, int timeout, int* state)
{
    int header;

    if (pl==NULL || recvfn==NULL) return 0;

    *pl = NULL;
    if (xml!=NULL) *xml = NULL;
    *recvfn = temp_filename(wdir, WORK_FILENAME_LEN);
   

    // ǡ
    int cc = recv_http_file(cofd, pl, *recvfn, wdir, timeout, &header, state);
    if (cc<0) return -1;

    if (header) {
        free(*recvfn);
        *recvfn = NULL;
    }
    else {
        if (xml!=NULL && cc>0) *xml = xml_parse_file(*recvfn);
    }
      
    return  cc;
}





////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tools
//

/*
void	set_host_header(tList* pl, const char* hname, unsigned short hport)

	ǽHTTPΥإå(pl) Host hname:hport ˽񤭴롥
		  Hostإå̵ϡǸɲá

*/
void	set_host_header(tList* pl, char* hname, unsigned short hport)
{
	Buffer buf;
	char   num[LEN_INT];
	
	if (pl==NULL) return;

	buf = make_Buffer(LBUF);
	snprintf(num, LEN_INT-1, "%d", hport);
	copy_s2Buffer(hname, &buf);
	cat_s2Buffer (":",   &buf);
	cat_s2Buffer (num,   &buf);

	set_protocol_header(pl, "Host", 1, (char*)buf.buf, ON);

	free_Buffer(&buf);
	return;
}






/**
int  decomp_url(Buffer url, Buffer* srvurl, Buffer* srvfqdn, unsigned short* sport, Buffer* srvdir)

	ǽurl URLʬ򤹤롥

	ʬ򤹤URLä Bufferѿɬפʤˤ NULL ǽ
		  ʬǤURLη
			protocol://www.xxx.yyy.zzz:80/AA/BB
			www.xxx.yyy.zzz:80/AA/BB

	͡url  https://AAA.BBB.CCC:80/xxx/yyy/zzz ξ
		srvurl  -- https://AAA.BBB.CCC:80   free
		srvfqdn -- AAA.BBB.CCC			  	free
		sport   -- 80
		srvdir  -- /xxx/yyy/zzz			 	free

		return: FALSE -- ʬ
				TRUE  -- ʬ
*/
int   decomp_url(Buffer url, Buffer* srvurl, Buffer* srvfqdn, unsigned short* sport, Buffer* srvdir)
{
	Buffer item1, item2, item3, item4, wrk;

	if (srvurl !=NULL) *srvurl  = init_Buffer();
	if (srvfqdn!=NULL) *srvfqdn = init_Buffer();
	if (srvdir !=NULL) *srvdir  = init_Buffer();
	if (sport  !=NULL) *sport   = 0;
	if (url.buf==NULL) return FALSE;

	item1 = init_Buffer();
	item2 = init_Buffer();
	item3 = init_Buffer();
	item4 = init_Buffer();
	 
	if (strstr((char*)url.buf, "//")!=NULL) {
		// http(s)://www.tuis.ac.jp:8100/..... 
		item1 = awk_Buffer(url, '/', 1);	// http(s):
		item2 = awk_Buffer(url, '/', 3);	// www.tuis.ac.jp:8100
	}
	else {
		// www.tuis.ac.jp:8100/..... 
		item2 = awk_Buffer(url, '/', 1);	// www.tuis.ac.jp:8100
	}

	if (item2.buf!=NULL) {
		item3 = awk_Buffer(item2, ':', 1);  // www.tuis.ac.jp
		if (item3.buf==NULL) {
			free_Buffer(&item1);
			free_Buffer(&item2);
			return FALSE;
		}
		item4 = awk_Buffer(item2, ':', 2);  // 8100
	}
	else {
		free_Buffer(&item1);
		return FALSE;
	}
	 

	if (item4.buf!=NULL && sport!=NULL) {
		*sport = (unsigned short)atoi((char*)item4.buf);
	}
	 
	wrk = make_Buffer(LBUF);
	if (item1.buf!=NULL) {
		copy_Buffer(&item1, &wrk);
		cat_s2Buffer("//",  &wrk);
	}
	cat_Buffer(&item2,  &wrk);

	if (item3.buf!=NULL) {
		if (srvfqdn!=NULL) *srvfqdn = item3;
		else free_Buffer(&item3);
	}
	 
	if (srvdir!=NULL) {
		*srvdir = make_Buffer_bystr((char*)(url.buf+strlen((char*)(wrk.buf))));
		if ((srvdir->buf)[0]=='\0') copy_s2Buffer("/", srvdir);
	}

	if (srvurl!=NULL) *srvurl = wrk;
	else free_Buffer(&wrk);


	free_Buffer(&item1);
	free_Buffer(&item2);
	free_Buffer(&item4);
	 
	return TRUE;
}										   







///////////////////////////////////////////////////////////////////////////////////////////////////
//
// HTTP Simple Proxy
//

/**
void  simple_web_proxy(int bofd, char* myip, int tmout)

	ǽʰWEBץWWW̿졼롥
		  ƤHTTPץȥ򥵥ݡȤƤǤϤʤ
		  ³ϤǤ¤ϰϤǤݻʤ

	bofd -- ֥饦Ȥ̿å
		  myip -- ʬIPɥ쥹
		  tmout - ॢ

	աƤӽФ¦ǥå bofd򥯥뤳ȡ
		  Ѥ̤ͳ̵¤ϡ֥ꥤפʤɤѤƤ
*/
void  simple_web_proxy(int bofd, char* myip, int tmout)
{
	int  	wofd = 0;
	int  	len, nd, cc, state;
	int  	btm, wtm, keep;
	char*	ipa;
	tList*	pl;

	unsigned short sport = 0;
	Buffer 	server, com;

	fd_set  mask;
	struct timeval timeout;


	//DEBUG_MODE print_message("[%d] SIMPLE_WEB_PROXY: Start Simple WEB Proxy.\n", (int)getpid());

	//init_rand();
	if (tmout<0) tmout = PROXY_TIMEOUT;
	btm = wtm = tmout;
	keep = TRUE;

	do {
		timeout.tv_sec  = btm*10;
		timeout.tv_usec = 0;
		FD_ZERO(&mask); 
		FD_SET(bofd, &mask);
		nd = select(bofd+1, &mask, NULL, NULL, &timeout);
	} while (nd<0);

	while (FD_ISSET(bofd, &mask) && keep) {
		cc = recv_http_header(bofd, &pl, &len, NULL, &state);
		if (cc<=0) break;
		if (pl==NULL) break;

		/*
		DEBUG_MODE {
			print_message("[%d] --- Web Proxy Request ---\n", getpid());
			print_tList(stderr, pl);
			print_message("\n");
		}*/

		com = http_proxy_header_anlys(pl, &server, &sport, &btm, &keep);
		if (btm==0) btm = tmout;
		else		btm = Min(btm, 60);

		wofd = 0;
		if (server.buf!=NULL && sport!=0) {
			ipa = get_ipaddr_byname((char*)server.buf);
			if (ipa!=NULL && !strcmp(ipa, myip)) {
				free_Buffer(&server);
				server = make_Buffer_bystr("127.0.0.1");
			}
			freeNull(ipa);

			wofd = tcp_client_socket((char*)server.buf, sport);
			free_Buffer(&server);
		}

		if (wofd<=0) {
			free_Buffer(&com);
			del_tList(&pl);
			break;
		}


		// for HTTPS
		if (com.buf!=NULL && !strcasecmp((char*)com.buf, "CONNECT")) {
			cc = tcp_send(bofd, "HTTP/1.1 200 Connection established.\r\nProxy-Connection: close\r\n\r\n", 0);
			cc = tcp_relay(bofd, wofd, 5);

			del_tList(&pl);
			free_Buffer(&com);
			break;
		}
		free_Buffer(&com);


		cc = send_http_header(wofd, pl, ON);
		if (cc<len && state) {
			Buffer buf = make_Buffer(RECVBUFSZ);
			cc = recv_http_content(bofd, &buf, len-cc, wtm, NULL, &state);
			if (cc<=0) {
				del_tList(&pl);
				break;
			}

			tcp_send_Buffer(wofd, &buf);
			free_Buffer(&buf);
		}
		del_tList(&pl);

		cc = www2browser_relay(bofd, wofd, btm, wtm, keep);
		if (cc<=0) break;

		do {
			timeout.tv_sec  = btm;
			timeout.tv_usec = 0;
			FD_ZERO(&mask); 
			FD_SET(bofd, &mask);
			nd = select(bofd+1, &mask, NULL, NULL, &timeout);
		} while (nd<0);
	}

	socket_close(wofd);

	return;
}






/**
Buffer  http_proxy_header_anlys(tList* pl, Buffer* server, unsigned short* sport, int* timeout, int* keep)

	ǽ֥饦ΥץѥꥯȤϤ롥

	pl      -- ϤإåäꥹȤؤΥݥ
		  server  -- ³̾ޤIPɥ쥹
		  sport   -- ³Υݡֹ椬롥
		  timeout -- ֥饦 Keep-Alive ͤ롥
		  keep    -- ³ݻ뤫ɤ롥(TRUE/FRALSE)

	֥͡饦Υޥ (GET, POST, CONNECT, ......)

*/
Buffer  http_proxy_header_anlys(tList* pl, Buffer* server, unsigned short* sport, int* timeout, int* keep)
{
	tList* 	frst;
	tList* 	lst;
	Buffer 	cmnd, url, ptcl;
	Buffer 	srvdir, bufport;


	cmnd     = init_Buffer();
	srvdir   = init_Buffer();
	*server  = init_Buffer();
	*sport   = 0;
	*timeout = 0;
	*keep	 = FALSE;


	frst = strncasecmp_tList(pl, HDLIST_FIRST_LINE_KEY, 0, 1);
	if (frst!=NULL) {
		cmnd = cawk_Buffer(frst->ldat.val, ' ', 1);
		url  = cawk_Buffer(frst->ldat.val, ' ', 2);
		ptcl = cawk_Buffer(frst->ldat.val, ' ', 3);
		decomp_url(url, NULL, server, sport, &srvdir);
	}
	else return cmnd;


	if (server->buf==NULL) {
		lst = strncasecmp_tList(pl, "Host", 0, 1);
		if (lst!=NULL) {
			*server = cawk_Buffer(lst->ldat.val, ':', 1);
			bufport = cawk_Buffer(lst->ldat.val, ':', 2);
			if (bufport.buf!=NULL) *sport = atoi((char*)bufport.buf);
			free_Buffer(&bufport);
		}
	}
	if (*sport==0) *sport = 80;


	lst = strncasecmp_tList(pl, "Keep-Alive", 0, 1);
	if (lst!=NULL) {
		if (lst->ldat.val.buf!=NULL) *timeout = atoi((char*)(lst->ldat.val.buf));
		del_tList_node(lst);
	}


	lst = strncasecmp_tList(pl, "Proxy-Connection", 0, 1);
	if (lst!=NULL) {
		if (!strcasecmp((char*)(lst->ldat.val.buf), "keep-alive")) *keep = TRUE;
		del_tList_node(lst);
	}


	free_Buffer(&(frst->ldat.val));
	copy_Buffer (&cmnd, &(frst->ldat.val));
	cat_s2Buffer(" ", &(frst->ldat.val));
	cat_Buffer  (&srvdir, &(frst->ldat.val));
	cat_s2Buffer(" ", &(frst->ldat.val));
	cat_Buffer  (&ptcl, &(frst->ldat.val));


	free_Buffer(&url);
	free_Buffer(&ptcl);
	free_Buffer(&srvdir);

	return cmnd;
}







/**
int  www2browser_relay(int bofd, int wofd, int btm, int wtm, int keep)

	ǽ: WWW -> Browser ̿졼롥

	bofd -- ֥饦¦Υå
		  wofd -- WWW¦Υå
		  btm  -- ֥饦ȤΥॢ
		  wtm  -- WWWФȤΥॢ
		  keep -- TRUE  ³ʲǽʸ¤˰ݻ
				  FALSE ³ݻʤ

	͡<0	-- 顼
			RECV_TIMEOUTED  ॢ
*/
int  www2browser_relay(int bofd, int wofd, int btm, int wtm, int keep)
{
	int	   len, cc, cx, sz, tout, state;
	Buffer buf;
	tList* pl;
	tList* lst;


	if (!recv_wait(wofd, wtm*10)) return RECV_TIMEOUTED;
	cc = recv_http_header(wofd, &pl, &len, NULL, &state);
	if (cc<=0) {
		if (pl!=NULL) del_tList(&pl);
		return cc;
	}
	if (pl==NULL) return -1;

	/*
	DEBUG_MODE {
		print_message("[%d] --- Web Proxy Response --\n", getpid());
		print_tList(stderr, pl);
		print_message("\n");
	}*/

	lst = strncasecmp_tList(pl, HDLIST_END_KEY, 0, 1);
	if (lst!=NULL && lst->prev!=NULL) {
		if (keep) {
			char   pxcn[48];
			snprintf(pxcn, 46, "keep-alive, timeout=%d", btm);
			add_tList_node_str(lst->prev, "Proxy-Connection", pxcn);
		}
		else {
			add_tList_node_str(lst->prev, "Proxy-Connection", "close");
		}
	}

	sz = cx = send_http_header(bofd, pl, ON);
	del_tList(&pl);

	//print_message("[%d] ==> %d/%d\n", getpid(), sz, len);

	if (len>0) {
		buf = make_Buffer(RECVBUFSZ);
		while(sz<len) {
			if (!recv_wait(wofd, wtm)) {
				free_Buffer(&buf);
				return RECV_TIMEOUTED;
			}
			cc = tcp_recv_Buffer(wofd, &buf);
			if (cc>0) {
				sz += cc;
				cx = tcp_send_Buffer(bofd, &buf);
				if (cx<=0) break;
			}
			else break;
			memset(buf.buf, 0, cc);
		}

		free_Buffer(&buf);
		if (cc<=0 || (cc>0&&cx<=0)) return 0;
	}

	else if (len<0) {	//if (sz>0 || len==HTTP_HEADER_CHUNKED) {
		buf = make_Buffer(RECVBUFSZ);
		while ((tout=recv_wait(wofd, 1))){
			cc = tcp_recv_Buffer(wofd, &buf);
			if (cc>0) {
				sz += cc;
				cx = tcp_send_Buffer(bofd, &buf);
				if (cx<=0) break;
			}
			else break;
			memset(buf.buf, 0, cc);
		}

		free_Buffer(&buf);
		if (!tout) return RECV_TIMEOUTED;
		//if (len==HTTP_HEADER_CHUNKED) return 0;		// chunked ⡼ɤǤϤǡ
		//if (cc<=0 || (cc>0&&cx<=0)) return 0;
		return 0;
	}

	return sz;
}








///////////////////////////////////////////////////////////////////////////////////////////////
//
// Alternative Tools
//

/**
int  tcp_relay(int sofd, int cofd, int tm)


	͡<0	-- 顼
				RECV_TIMEOUTED
*/
int  tcp_relay(int sofd, int cofd, int tm)
{
	int	 	num, nd, cx, cc=RECV_TIMEOUTED;
	Buffer  buf;
	fd_set  mask;
	struct timeval timeout;


	buf = make_Buffer(RECVBUFSZ);
	num = Max(sofd, cofd);

	do {
		timeout.tv_sec  = tm;
		timeout.tv_usec = 0;
		FD_ZERO(&mask); 
		FD_SET(sofd, &mask);
		FD_SET(cofd, &mask);
		nd = select(num+1, &mask, NULL, NULL, &timeout);
	} while (nd<0);

	while (FD_ISSET(cofd, &mask) || FD_ISSET(sofd, &mask)) {

		if (FD_ISSET(cofd, &mask)) {
			cc = tcp_recv_Buffer(cofd, &buf);
			if (cc>0) {
				cx = tcp_send_Buffer(sofd, &buf);
				if (cx<=0) {
					cc = cx;
					break;
				}
			}
			else break;
			memset(buf.buf, 0, cc);
		}

		if (FD_ISSET(sofd, &mask)) {
			cc = tcp_recv_Buffer(sofd, &buf);
			if (cc>0) {
				cx = tcp_send_Buffer(cofd, &buf);
				if (cx<=0) {
					cc = cx;
					break;
				}
			}
			else break;
			memset(buf.buf, 0, cc);
		}

		do {
			timeout.tv_sec  = tm;
			timeout.tv_usec = 0;
			FD_ZERO(&mask); 
			FD_SET(sofd, &mask);
			FD_SET(cofd, &mask);
			nd = select(num+1, &mask, NULL, NULL, &timeout);
		} while (nd<0);
	}

	free_Buffer(&buf);


	if (!FD_ISSET(cofd, &mask) && !FD_ISSET(sofd, &mask)) return RECV_TIMEOUTED;
	return cc;
}
 







////////////////////////////////////////////////////////////////////////////////////////////////////////
// Server Side Code  (Junk)
//

int  send_http_res_file(int sofd, char* fname, int mode)
{
    int   sz;
    FILE* fp;
    char  buf[LBUF];
    char* html;

    sz = file_size(fname);
    if (sz<=0) {
		sz = 0;
		mode = HTTP_CONNECTION_CLOSE;
    }

    tcp_send(sofd, "HTTP/1.1 200 OK\r\n", 0);
    tcp_send(sofd, "Accept-Ranges: bytes\r\n", 0);
    tcp_send(sofd, "Pragma: no-cache\r\n", 0);
    tcp_send(sofd, "Cache-Control: no-cache\r\n", 0);
    memset(buf, 0, LBUF);
    snprintf(buf, LBUF-2, "Content-Length: %d\r\n", sz);
    tcp_send(sofd, buf, 0);
    if (mode==HTTP_CONNECTION_CLOSE) tcp_send(sofd, "Connection: Close\r\n", 0);
    else {
    	tcp_send(sofd, "Keep-Alive: timeout=1800, max=100\r\n", 0);
    	tcp_send(sofd, "Connection: Keep-Alive\r\n", 0);
    }
    tcp_send(sofd, "\r\n", 0);


    if (sz!=0) fp = fopen(fname, "rb");
    else       fp = NULL;
    if (fp==NULL) return -1;

    html = (char*)malloc(sz);
    if (html==NULL) {
		fclose(fp);
		return -2;
    }

    fread(html, sz, 1, fp); 
    tcp_send(sofd, html, sz);
    fclose(fp);

    free(html);
    return sz;
}






void  send_http_passwd_req(int sofd)
{
    tcp_send(sofd, "HTTP/1.1 401 Authorization Required\r\n", 0);
    tcp_send(sofd, "WWW-Authenticate: Basic realm=\"TTS\"\r\n", 0);
    tcp_send(sofd, "Pragma: no-cache\r\n", 0);
    tcp_send(sofd, "Cache-Control: no-cache\r\n", 0);
    tcp_send(sofd, "Connection: Close\r\n", 0);
    tcp_send(sofd, "Content-Length: 0\r\n", 0);
    tcp_send(sofd, "Content-Type: text/html\r\n\r\n", 0);
	
	return;
}



