
#include "https_tool.h"




/**
int  send_https_header(int sofd, SSL* ssl, tList* pp, int mode)

	ǽإåꥹȤƤ HTTPS̿롥
		  إå Content-Length ͤʤ

	sofd		³ؤΥå
		ssl 		³ؤ SSLåȡSSL̿Ǥʤ NULL ꡥ
		  pp   		إåǼꥹȤؤΥݥ󥿡
		  mode 		ON:  إåꥹ˥ƥĤΰФ롥
					OFF: إåꥹ˥ƥĤΰäƤʤ

	͡>=0		mode==OFF: ǡХȿmode==ONξ硧ƥĤΥХȿ
			<0		顼
			-1		ꥹȤؤΥݥ󥿤 NULL
*/
int  send_https_header(int sofd, SSL* ssl, tList* pp, int mode)
{
	int	   hs=0, sz=0;
	Buffer buf;

	if (pp==NULL) return -1;

	buf = restore_protocol_header(pp, ": ", mode);
	sz  = ssl_tcp_send_Buffer(sofd, ssl, &buf);
	if (mode==ON) sz = sz - hs;

	free_Buffer(&buf);
	return sz;
}





/**
int  send_https_Buffer(int sofd, SSL* ssl, tList* pl, Buffer* buf)

	ǽإåȥХåեƤ HTTP̿롥

	sofd		³ؤΥå
		  ssl       ³ؤ SSLåȡSSL̿Ǥʤ NULL ꡥ
		  pl   		եΩäإåǼꥹȤؤΥݥ󥿡
		  buf		륳ƥĤǼ줿 BufferѿؤΥݥ󥿡

	͡>=0  	ǡ(Byte)
			-1		ꥹȤؤΥݥ󥿤 NULL
			-2		buf Υ顼
*/
int  send_https_Buffer(int sofd, SSL* ssl, tList* pl, Buffer* buf)
{
	int    sz;
	Buffer snd;
	tList* pp;

	if (pl==NULL) return -1;
	if (buf==NULL || buf->vldsz<0 || buf->buf==NULL) return -2;

	// Content-Length ν񤭴
	pp = pl;
	while(pp!=NULL) {
		if (!strcasecmp((const char*)(pp->ldat.key.buf), "Content-Length")) {
			copy_i2Buffer(buf->vldsz, &(pp->ldat.val));
			break;
		}
		pp = pp->next;
	}

	snd = restore_protocol_header(pl, ": ", OFF);
	cat_Buffer(buf, &snd);

	sz = ssl_tcp_send_Buffer(sofd, ssl, &snd);
	free_Buffer(&snd);

	return sz;
}






/**
int  send_https_file(int sofd, SSL* ssl, tList* pl, const char* fname)

	ǽإåȥեƤ HTTPS̿롥

	sofd		³ؤΥå
		ssl 		³ؤ SSLåȡSSL̿Ǥʤ NULL ꡥ
		  pp   		եΩäإåǼꥹȤؤΥݥ󥿡
		  fname		ե̾إåΤ NULL

	͡>=0  	ǡ(Byte)
			-1		ꥹȤؤΥݥ󥿤 NULL
			-2		ݥ顼
*/
int  send_https_file(int sofd, SSL* ssl, tList* pl, const char* fname)
{
	int   sz = 0;
	FILE* fp = NULL;
	char num[20];
	tList* pp;
	unsigned char* html;
	Buffer  buf;


	if (pl==NULL) return -1;
	if (fname!=NULL) sz = file_size((char*)fname);
	if (sz<=0) sz = 0;
	snprintf(num, 18, "%d", sz);

	// Content-Length ν񤭴
	pp = pl;
	while(pp!=NULL) {
		if (!strcasecmp((const char*)(pp->ldat.key.buf), "Content-Length")) {
			copy_s2Buffer(num, &(pp->ldat.val));
			break;
		}
		pp = pp->next;
	}

	buf = restore_protocol_header(pl, ": ", OFF);


	if (fname!=NULL && sz!=0) fp = fopen(fname, "rb");
	if (fp!=NULL) {
		html = (unsigned char*)malloc(sz+1);
		if (html==NULL) {
			fclose(fp);
			free_Buffer(&buf);
			return -2;
		}

		memset(html, 0, sz+1);
		fread(html, sz, 1, fp); 
		fclose(fp);

		cat_b2Buffer(html, &buf, sz);
		free(html);
	}

	//ssl_tcp_send(sofd, ssl, (char*)html, sz);
	sz = ssl_tcp_send_Buffer(sofd, ssl, &buf);
	free_Buffer(&buf);

	return sz;
}





/**
int  recv_https_header(int sofd, SSL* ssl, tList** pl, int* len, FILE* fp, int* state)

	ǽHTTPS̿ΥإåʬơꥹȤ˳Ǽ롥
		  NULLǤʤ fp ꤵ줿硤ƤΥǡե¸롥

	sofd		³ؤΥå
		ssl 		³ؤ SSLåȡSSL̿Ǥʤ NULL ꡥ
		  *pl		إå󤬳ǼꥹȤؤΥݥ
		  *len		إå "Content-Length" .  "Content-Length" ¸ߤʤ HTTP_HEADER_UNKNOWN_LEN (0̤)
					󥯷ʤ HTTP_HEADER_CHUNKED (0̤)
		  fp		ƤΥǡ¸뤿Υեݥ󥿡NULLξ¸ʤ
		  *state	ФȤ³֡³ʤ TRUEǤ FALSENULLꤷƤɤ

	͡0>		Хȿ
			0 		
			-1		顼
			-2		̵ sofdꤷ
*/
int  recv_https_header(int sofd, SSL* ssl, tList** pl, int* len, FILE* fp, int* state)
{
	int  cc, sz;
	Buffer mbuf;
	tList* lp;

	if (sofd<=0) return -2;
	if (len!=NULL)   *len = HTTP_HEADER_UNKNOWN_LEN;
	if (state!=NULL) *state = TRUE;

	mbuf = make_Buffer(RECVBUFSZ);

	sz  = 0;
	lp  = NULL;
	*pl = NULL;
	do {
		cc = ssl_tcp_recv_Buffer(sofd, ssl, &mbuf);
		if (cc>0) {
			if (fp!=NULL) fwrite(mbuf.buf, cc, 1, fp);
			lp = get_protocol_header_list_seq(lp, mbuf, ':', TRUE, TRUE);
			sz += cc;
		}
		else {
			if (state!=NULL) *state = FALSE;
			break;
		}

		*pl = find_tList_top(lp);
	} while(strncasecmp_tList(*pl, HDLIST_END_KEY, 0, 1)==NULL);

	free_Buffer(&mbuf);
	if (sz==0 && cc==0) return 0;       // 
	if (sz==0 && cc<0)  return -1;
	if (*pl==NULL) 		return -1;


	// ƥĤĹ롥
	if (len!=NULL) {
		Buffer hbuf;

		hbuf = search_protocol_header(*pl, HDLIST_FIRST_LINE_KEY, 1);
		if (hbuf.buf!=NULL) {
			if (!strncasecmp((char*)hbuf.buf, "GET ", 4)) {
				*len = 0;
			}
			free_Buffer(&hbuf);
		}

		if (*len==HTTP_HEADER_UNKNOWN_LEN) {
			hbuf = search_protocol_header(*pl, "Transfer-Encoding", 1);
			if (hbuf.buf!=NULL) {
				if (!strcasecmp((char*)hbuf.buf, "chunked")) {
					*len = HTTP_HEADER_CHUNKED;
				}
				free_Buffer(&hbuf);
			}
		}

		if (*len==HTTP_HEADER_UNKNOWN_LEN) {
			hbuf = search_protocol_header(*pl, "Content-Length", 1);
			if (hbuf.buf!=NULL) {
				*len = atoi((const char*)hbuf.buf);
				free_Buffer(&hbuf);
			}
		}
	}

	return sz;
}






/**
int  recv_https_content(int sofd, SSL* ssl, Buffer* buf, int len, int tm, FILE* fp, int* state)

	ǽHTTPSå recv_https_header() Ǽإå˰³ơƥĤ롥
		  fp NULLǤʤСǡʥƥġˤϥեˤ¸롥

	sofd		³ؤΥå
		ssl 		³ؤ SSLåȡSSL̿Ǥʤ NULL ꡥ
		  buf		ƥĤ¸ѿǽˡrecv_https_header()Ǽƥʬ֤
		  len		إå "Content-Length" ͡ǡΥΥå˻Ѥ롥
		  tm		ॢÿ
		  fp		ƥĤ¸եǥץNULLʤ¸ʤ
		  *state	ФȤ³֡³ʤ TRUEǤ FALSENULLꤷƤɤ

	͡>=0  	ƥĤΥ(Byte)recv_https_header()Ǽƥʬޤࡥ
			<0		顼
*/
int  recv_https_content(int sofd, SSL* ssl, Buffer* buf, int len, int tm, FILE* fp, int* state)
{
	int    cc, sz;
	Buffer rcv;

	if (state!=NULL) *state = TRUE;
	sz = buf->vldsz;

	// ƥĤλĤ
	rcv = make_Buffer(RECVBUFSZ);
	while(sz<len) {
		if (!recv_wait(sofd, tm)) {
			if (state!=NULL) *state = FALSE;
			free_Buffer(&rcv);
			return RECV_TIMEOUTED;
		}

		cc = ssl_tcp_recv_Buffer(sofd, ssl, &rcv);
		if (cc>0) {
			if (fp!=NULL) fwrite(rcv.buf, cc, 1, fp);
			cat_Buffer(&rcv, buf);
			sz += cc;
		}
		else {
			if (state!=NULL) *state = FALSE;
			break;
		}
		memset(rcv.buf, 0, cc);
	}
	free_Buffer(&rcv);

	return sz;
}






/**
int  recv_https_chunked(int sofd, SSL* ssl, Buffer* buf, int tm, FILE* fp, int* state)

	ǽHTTPå recv_https_header() Ǽإå˰³ơChunk⡼ɤΥƥĥǡ롥
		  fp NULLǤʤСǡʥƥġˤϥեˤ¸롥

	sofd		³ؤΥå
		ssl 		³ؤ SSLåȡSSL̿Ǥʤ NULL ꡥ
		  buf		ƥĤ¸ѿǽˡrecv_https_header()Ǽƥʬ֤
		  tm		ॢÿ
		  fp		ƥĤ¸եǥץNULLʤ¸ʤ
		  *state	ФȤ³֡³ʤ TRUEǤ FALSENULLꤷƤɤ

	͡>=0  	ƥĤΥ(Byte)recv_https_header()Ǽƥʬޤࡥ
			<0		顼
*/
int  recv_https_chunked(int sofd, SSL* ssl, Buffer* buf, int tm, FILE* fp, int* state)
{
	int    cc, sz, tout;
	Buffer rcv;


	if (state!=NULL) *state = TRUE;
	sz = buf->vldsz;

	rcv = make_Buffer(RECVBUFSZ);
	while ((tout=recv_wait(sofd, tm))) {
		cc = ssl_tcp_recv_Buffer(sofd, ssl, &rcv);
		if (cc>0) {
			if (fp!=NULL) fwrite(rcv.buf, cc, 1, fp);
			cat_Buffer(&rcv, buf);
			sz += cc;
		}
		else {
			if (state!=NULL) *state = FALSE;
			break;
		}
		memset(rcv.buf, 0, cc);
	}
	free_Buffer(&rcv);

	if (!tout) {
		if (state!=NULL) *state = FALSE;
		return RECV_TIMEOUTED;
	}

	return sz;
}






/**
int  recv_https_Buffer(int sofd, SSL* ssl, tList** pl, Buffer* buf, int tsecond, int* hdonly, int* state)

    ǽHTTPSåơBufferѿ *buf¸롥gzipΥ󥳡ɽϹԤʤ
          bufΥХåեΰͽݤƤ뤳ȡ

	sofd		³ؤΥå
		  ssl       ³ؤ SSLåȡSSL̿Ǥʤ NULL ꡥ
		  *pl   	إåǼꥹȤؤΥݥ󥿡ɬפʤʤ NULLǤɤ
   		  buf		ƥĤǼ BufferѿؤΥݥ󥿡 
		  tsecond	ǽμޤǤΥॢ(s)
		  *hdonly   ǡإåΤߤξ TRUE, ƥĤ⤢ FALSENULLꤷƤɤ
		  *state	ФȤ³֡³ʤ TRUEǤ FALSENULLꤷƤɤ

	͡
			>=0  	ƥĤΥ(Byte)
			-1		顼
			-2  	buf 顼
			RECV_TIMEOUTED	ॢȤ
*/
int  recv_https_Buffer(int sofd, SSL* ssl, tList** pl, Buffer* buf, int tsecond, int* hdonly, int* state)
{
	int	   cc=0, hs, len;
	Buffer cnt;
	int	   connect;
	tList* lp;

	
	if (buf==NULL || buf->buf==NULL) return -2;
	if (hdonly!=NULL) *hdonly = FALSE;

	// إåμ
	//hs = recv_https_header(sofd, ssl, pl, &len, NULL, &connect);
	hs = recv_https_header(sofd, ssl, &lp, &len, NULL, &connect);
	if (state!=NULL) *state = connect;
	if (hs<=0)  return hs;											// 顼
	if (len==0) { 													// إåΤ
		if (hdonly!=NULL) *hdonly = TRUE;
		return hs;
	}


	// إåʶƥĤμФ
	//cnt = search_protocol_header(*pl, HDLIST_CONTENTS_KEY, 1);
	cnt = search_protocol_header(lp, HDLIST_CONTENTS_KEY, 1);
	if (cnt.buf!=NULL) {
		cc = cnt.vldsz;
		hs = hs - cc;
		copy_Buffer(&cnt, buf);
		free_Buffer(&cnt);
	}

	if (pl!=NULL) *pl = lp;
	else del_tList(&lp);


	// ƥĤμ
	if (connect) {
		if (len>0) {
			cc = recv_https_content(sofd, ssl, buf, len, tsecond, NULL, &connect);
		}
		else {	//if (len==HTTP_HEADER_CHUNKED) {
			cc = recv_https_chunked(sofd, ssl, buf, tsecond, NULL, &connect);
		}
	}
	if (cc>0) cc = cc + hs;

	if (state!=NULL) *state = connect;
	return cc;
}







/**
int  recv_https_file(int sofd, SSL* ssl, tList** pl, const char* fname, const char* wdir, int tsecond, int* hdonly, int* state)

	ǽHTTPSåơƥĤե¸롥Encoding gzipξŸ롥

	sofd		³ؤΥå
		ssl 		³ؤ SSLåȡSSL̿Ǥʤ NULL ꡥ
		  *pl   	إåǼꥹȤؤΥݥ󥿡
		  fname		¸ե̾
		wdir		ѥǥ쥯ȥꡥNULLξ /tmp ˤʤ롥
		  tsecond	ǽμޤǤΥॢ(s)
		  *hdonly   ǡإåΤߤξ TRUE, ƥĤ⤢ FALSENULLꤷƤɤ
		  *state	ФȤ³֡³ʤ TRUEǤ FALSENULLꤷƤɤ

	͡>=0  	եΥ(Byte)
			-1		顼
			RECV_TIMEOUTED	ॢȤ
*/
int  recv_https_file(int sofd, SSL* ssl, tList** pl, const char* fname, const char* wdir, int tsecond, int* hdonly, int* state)
{
	int	   cc=0, hs, len;
	Buffer buf, cnt;
	FILE*  fp = NULL;
	const char tmpd[] = "/tmp";
	int   connect;
	

	if (hdonly!=NULL) *hdonly = FALSE;

	// إåμ
	hs = recv_https_header(sofd, ssl, pl, &len, NULL, &connect);
	if (state!=NULL) *state = connect;
	if (hs<=0)  return hs;											// 顼
	if (len==0) { 													// إåΤ
		if (hdonly!=NULL) *hdonly = TRUE;
		return hs;
	}


	// إåʶƥĤμФ
	buf = make_Buffer(RECVBUFSZ);
	cnt = search_protocol_header(*pl, HDLIST_CONTENTS_KEY, 1);
	if (cnt.buf!=NULL) {
		cc = cnt.vldsz;
		hs = hs - cc;
		copy_Buffer(&cnt, &buf);
		free_Buffer(&cnt);
	}


	// ƥĤμ
	if (connect) {
		if (len>0) {
			cc = recv_https_content(sofd, ssl, &buf, len, tsecond, NULL, &connect);
		}
		else {	//if (len==HTTP_HEADER_CHUNKED) {
			cc = recv_https_chunked(sofd, ssl, &buf, tsecond, NULL, &connect);
		}
	}


	if (cc>0) {
		// ƥĤե¸
		if (fname!=NULL) fp = fopen(fname, "wb");
		if (fp!=NULL) {
			fwrite(buf.buf, buf.vldsz, 1, fp);
			fclose(fp);
		}
		free_Buffer(&buf);


		// Encoding(gzip) 
		if (fname!=NULL) {
			buf = search_protocol_header(*pl, "Content-Encoding", 1);
			if (buf.buf!=NULL && !strncasecmp((const char*)buf.buf, "gzip", 4)) {
				#ifdef DISABLE_ZLIB
					DEBUG_MODE print_message("RECV_HTTPS_FILE: WARNING: Encoding is GZIP. But zlib is not installed!!\n");
				#else
					if (wdir==NULL) wdir = tmpd;
					cc = gz_decode_file_replace(fname, wdir);
				#endif
			}
			free_Buffer(&buf);
		}
		cc = cc + hs;
	}

	if (state!=NULL) *state = connect;
	return cc;
}






/**
    XML̿ǡե¸

	¸ǡ	
*/
int   save_https_xml(int cofd, SSL* ssl, tList** pl, tXML** xml, char** recvfn, const char* wdir, int timeout, int* state)
{
    int header;

    if (pl==NULL || recvfn==NULL) return 0;

    *pl = NULL;
    if (xml!=NULL) *xml = NULL;
    *recvfn = temp_filename(wdir, WORK_FILENAME_LEN);
   

    // ǡ
    int cc = recv_https_file(cofd, ssl,  pl, *recvfn, wdir, timeout, &header, state);
    if (cc<0) return -1;

    if (header) {
        free(*recvfn);
        *recvfn = NULL;
    }
    else {
        if (xml!=NULL && cc>0) *xml = xml_parse_file(*recvfn);
    }
      
    return  cc;
}



