/* vi: set tabstop=4 nocindent noautoindent: */

/**  
	IP Address Tool
		
				by Fumi Iseki '05 09/21
*/



#include "ipaddr_tool.h"




/**
tList*  read_ipaddr_file(char* fn)

	ǽե뤫 IPɥ쥹ɤ߹ǡ[IPɥ쥹]/[ͥåȥޥ]η
		  ѴơꥹȤ˳Ǽ롥FQDNIPɥ쥹Ѵ
		  FQDNǤʤɥᥤ̾ʸ / ʸ̵뤷ʸΤޤޥꥹȤ˳Ǽ롥

		  ǡɤ߼˼νԤʤ롥
			ζ,CR,LFϺ
			Ԥ̵뤵롥
			# ǻϤޤ롤ޤ (ʣ)# ǻϤޤԤ̵뤵롥

	fn  -- ե̾

	͡ꥹȤؤΥݥ
*/
tList*  read_ipaddr_file(char* fn)
{
	tList* lp;
	tList* lt;

	lp = read_tList_file(fn, 1);
	if (lp==NULL) return NULL;

	lt = to_ipaddress_list(lp);
	del_all_tList(&lp);

	return lt;
}





/**
tList*  read_ipaddr_fp(FILE* fp)

	ǽե뤫 IPɥ쥹ɤ߹ǡ[IPɥ쥹]/[ͥåȥޥ]η
		  ѴơꥹȤ˳Ǽ롥FQDNIPɥ쥹Ѵ
		  FQDNǤʤɥᥤ̾ʸ / ʸ̵뤷ʸΤޤޥꥹȤ˳Ǽ롥

		  ǡɤ߼˼νԤʤ롥
			ζ,CR,LFϺ
			Ԥ̵뤵롥
			# ǻϤޤ롤ޤ (ʣ)# ǻϤޤԤ̵뤵롥

	fp  -- եݥ

	͡ꥹȤؤΥݥ
*/
tList*  read_ipaddr_fp(FILE* fp)
{
	tList* lp;
	tList* lt;

	lp = read_tList_fp(fp, 1);
	if (lp==NULL) return NULL;

	lt = to_ipaddress_list(lp);
	del_all_tList(&lp);

	return lt;
}




/**
tList*  to_ipaddress_list(tList* lp)

	ǽꥹ IPɥ쥹 [IPɥ쥹]/[ͥåȥޥ]η
		  ѴơꥹȤ˳Ǽ롥FQDNIPɥ쥹Ѵ
		  Ѵ to_address_num8() ѡCIDERб
		  FQDNǤʤɥᥤ̾ʸ / ʸ̵뤷ʸΤޤ
		  ꥹȤ˳Ǽ롥
		   is_host_in_list()ʤɤ®˹Ԥʤ

	Ѵʥեʤɤɤ߹ޤޡˤΥǡäꥹ

	͡Ѵƿꥹȡ

*/
tList*  to_ipaddress_list(tList* lp)
{
	unsigned char* num;
	char*          addr;
	tList* ls = NULL;
	tList* lt = NULL;

	if (lp==NULL) return NULL;
	if (lp->ldat.key.buf==NULL) return NULL;

	while (lp!=NULL) {
		if (lp->ldat.key.buf!=NULL && strlen((const char*)lp->ldat.key.buf)>0) {
			if ((lp->ldat.key.buf)[0]!='#') {
				num = to_address_num8((char*)lp->ldat.key.buf, 1);
				if (num!=NULL) {
					addr = to_address_char8(num);
					free(num);
					if (addr!=NULL) {
						ls = add_tList_node_str(ls, addr, NULL);
						free(addr);
					}	//  addr==NULL Ȥʤϥ­Τ
				}
				else {
					addr = awk((char*)lp->ldat.key.buf, '/', 1);
					if (addr!=NULL) {
						int i = 0;
						while(addr[i]!='\0' && addr[i]!=',' && addr[i]!=' ') i++;
						addr[i] = '\0';
						ls = add_tList_node_str(ls, addr, NULL);
						free(addr);
					}
				}
				if (lt==NULL) lt = ls;
			}
		}
		lp = lp->next;
	}
	
	return lt;
}






/**
int  is_host_in_list(tList* lp, unsigned char* num, char* hname)

	ǽꥹlp ˳ǼƤ ۥȾ num, hname Ʊͥåȥ°뤫
		ɤå롥num  hname Ϥɤ餫ꤵƤнʬǤ롥
		  褺lpΥFQDNˤ hname Ӥ롥Ĥޤꡤɥᥤ̾ΰ
		   hnameӤʸסˡ
		ˡlpΥɥᥤ̾ǤʤIPɥ쥹ξˤ num Ӥ롥
	
	lp    -- åIPɥ쥹ʸˤγǼƤꥹȡ
		  num   -- ӤIPɥ쥹1byte unsigned 4Byte
			       8Byte(addr/mask)Ǥư뤬ͥåȥޥ̵뤹롥
		  hname -- Ӥۥ̾ʸˡ̾ numհ줿Ρ

	͡FALSE -- ꥹƱͥåȥ°륨ȥ¸ߤʤ
			TRUE  -- ꥹƱͥåȥ°륨ȥ꤬¸ߤ롥
*/
int  is_host_in_list(tList* lp, unsigned char* num, char* hname)
{
	unsigned char* addr;

	if (lp==NULL) return FALSE;
	if (lp->ldat.key.buf==NULL) return FALSE;
	if (hname==NULL && num==NULL) return FALSE;

	while (lp!=NULL) {
		if (lp->ldat.key.buf!=NULL && strlen((const char*)lp->ldat.key.buf)>0) {
			addr = to_address_num8((char*)lp->ldat.key.buf, 0);
			if (addr==NULL && hname!=NULL) {
				if (!strnrvscmp((const char*)lp->ldat.key.buf, hname, strlen((const char*)lp->ldat.key.buf))) return TRUE;
			}
			else if(addr!=NULL && num!=NULL) {
				if (is_same_network_num(addr, num, &(addr[4]))) return TRUE;
			}
		}
		lp = lp->next;
	}
	
	return FALSE;
}







/**
int  is_ipaddr_num_in_list(tList* lp, unsigned char* num)

	ǽꥹlp ˳ǼƤ ۥȾ num Ʊͥåȥ°뤫
		ɤå롥
		  ꥹȤΥFQDNǤäƤåǽ
	
	lp  -- åIPɥ쥹ʸˤγǼƤꥹȡ
		  num -- ӤIPɥ쥹1byte unsigned 4Byte
			     8Byte(addr/mask)Ǥư뤬ͥåȥޥ̵뤹롥

	͡FALSE -- ꥹƱͥåȥ°륨ȥ¸ߤʤ
			TRUE  -- ꥹƱͥåȥ°륨ȥ꤬¸ߤ롥

*/
int  is_ipaddr_num_in_list(tList* lp, unsigned char* num)
{
	unsigned char* addr;

	if (lp==NULL || num==NULL) return FALSE;
	if (lp->ldat.key.buf==NULL) return FALSE;

	while (lp!=NULL) {
		if (lp->ldat.key.buf!=NULL && strlen((const char*)lp->ldat.key.buf)>0) {
			addr = to_address_num8((char*)lp->ldat.key.buf, 1);
			if (addr!=NULL) {
				if (is_same_network_num(num, addr, &(addr[4]))) return TRUE;
			}
		}
		lp = lp->next;
	}
	
	return FALSE;
}






/**
void  print_address_in_list(FILE* fp, tList* lp)

	ǽꥹΥɥᥤ̾ޤIPɥ쥹ɽ롥
		  FQDNIPɥ쥹Ѵɽ롥

	ɥᥤ̾ޤIPɥ쥹򥭡˳ǼꥹȤؤΥݥ

*/
void  print_address_in_list(FILE* fp, tList* lp)
{
	unsigned char* addr;

	while (lp!=NULL) {
		if (lp->ldat.key.buf!=NULL && strlen((const char*)lp->ldat.key.buf)>0) {
			addr = to_address_num8((char*)lp->ldat.key.buf, 1);
			if (addr!=NULL) {	
				fprintf(fp, "[%d.%d.%d.%d/%d.%d.%d.%d]\n", addr[0],addr[1],addr[2],addr[3],addr[4],addr[5],addr[6],addr[7]);
			}
			else { 		// 餯ɥᥤ̾
				fprintf(fp, "[%s]\n", lp->ldat.key.buf);
			}
		}
		lp = lp->next;
	}
	return;
}





