/* vi:set tabstop=4 paste noautoindent: */


/**
JunkBox_Libѥ饤֥  isnet.c

  ISNET	ץȥ¸ؿ

  إå 
	  #include "isnet.h"

	make_Buffer() γݥåʤ
*/



#include "isnet.h"



Buffer*  Base64_DHspki   = NULL;
Buffer*  Base64_RSAspki  = NULL;

Buffer*  User_ID	 = NULL;
Buffer*  User_Passwd = NULL;
Buffer*  User_Salt	 = NULL;

int 	 No_Chlng = FALSE;	// 󥸥Ѥʤ (¦ξ֤ɽ)




/////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// ¦ǤΥޥɼ
//

/** 
Buffer  get_command(Buffer msg)

	ǽ: Buffer (̿)饳ޥФ
		  ʸʸѴ롥

	: msg  -- ̿Ǽ Bufferԥɤʤ

	: ޥǼ Buffer

	: ̿ comannd_operand_comment (_ʣζ) η򤷤Ƥ롥
		commentΤ϶ޤǤɤ
*/
Buffer  get_command(Buffer msg)
{
	unsigned int i;
	Buffer com;

	com = cawk_Buffer(msg, ' ', 1);
	if (com.buf==NULL) {
		com = make_Buffer(1);
		return com;
	}

	for (i=0; i<strlen((const char*)com.buf); i++) {
		if (com.buf[i]>='a' && com.buf[i]<='z') com.buf[i] += - 'a' + 'A';	
	}
	return com;
}





/** 
Buffer  get_operand(Buffer msg)

	ǽ: Buffer̿ˤ饪ڥФ
		  ʸʸѴ롥

	: msg  -- ̿Ǽ Bufferԥɤʤ

	: ڥǼ Buffer

	: ̿ comannd_operand_comment (_ʣζ) η򤷤Ƥ롥
		commentΤ϶ޤǤɤ
*/
Buffer  get_operand(Buffer msg)
{
	Buffer opr;

	opr = cawk_Buffer(msg, ' ', 2);
	if (opr.buf==NULL) opr = make_Buffer(1);

	return opr;
}





/** 
Buffer  get_comment(Buffer msg)

	ǽ: Buffer̿ˤ饳Фޤࡥ

	: msg  -- ̿Ǽ Bufferԥɤʤ

	: Ǽ Buffer

	: ̿ comannd_operand_comment (_ʣζ) η򤷤Ƥ롥
		commentΤ϶ޤǤɤ
*/
Buffer  get_comment(Buffer msg)
{
	int i, j, pos, cnt;
	char*  buf;
	Buffer com;

	buf = (char*)msg.buf;
	for(i=0, j=0; j<2; j++) {
		while (buf[i]!='\0' && buf[i]!=' ') i++;
		while (buf[i]!='\0' && buf[i]==' ') i++;
	}

	pos = i;
	while (buf[i]!='\0') i++;
	cnt = i - pos;
	com = make_Buffer(cnt+1);

	if (com.buf==NULL) com = make_Buffer(1);
	else {
		for (i=0; i<cnt; i++) com.buf[i] = buf[pos+i];
		com.vldsz = cnt;
	}

	return com;
}





/**
int 	command_USERID(Buffer operand, Buffer comment, int sock)

	USERID 桼ID 
		󥸥ɤ׵ᤷʤ硤ѥɤή
		ǽΤǡɬŹ沽뤳ȡ
	ǽUSERID ޥɤ롥


	operand  -- ޥɤΥڥ
		comment  -- ޥɤΥ
		sock     -- 饤ȤؤΥå

	͡0  	   
			0ʳ顼ֹ

	顼ֹ桧120
*/
int 	command_USERID(Buffer operand, Buffer comment, int sock)
{
	int   cc;
	char* pass  = NULL;
	char* salt1 = NULL;
	char* salt2 = NULL;
	Buffer  buf;

	pass = get_passwd((char*)operand.buf);
	if (pass==NULL) {
		print_message("USER [%s]\n", operand.buf);
		cc = tcp_send_crypt_mesg(sock, "ERR 121 passwd get error.\r\n", NULL);
		return 121;
	}

	if (User_ID!=NULL)     del_Buffer(&User_ID);
	if (User_Passwd!=NULL) del_Buffer(&User_Passwd);
	if (User_Salt!=NULL)   del_Buffer(&User_Salt);
 	User_ID      = new_Buffer();
	User_Passwd  = new_Buffer();
	User_Salt    = new_Buffer();
	*User_ID     = dup_Buffer(operand);
	*User_Passwd = make_Buffer_bystr(pass);


	// MD5
	if (strlen((const char*)pass)==LEN_MD5PASS) {
		*User_Salt = make_Buffer(LEN_MD5SALT*2+5);
		salt1 = cut_str(pass, 0, LEN_MD5SALT-1);
		salt2 = randstr(LEN_MD5SALT-4);
		copy_s2Buffer(salt1, 	User_Salt);
		cat_s2Buffer("\r\n$1$", User_Salt);
		cat_s2Buffer(salt2, 	User_Salt);
		cat_s2Buffer("$", 		User_Salt);
	}

	// DES
	else if (strlen((const char*)pass)==LEN_DESPASS) {
		*User_Salt = make_Buffer(LEN_DESSALT*2+5);
		salt1 = cut_str(pass, 0, LEN_DESSALT-1);
		salt2 = randstr(LEN_DESSALT);
		copy_s2Buffer(salt1,  User_Salt);
		cat_s2Buffer ("\r\n", User_Salt);
		cat_s2Buffer (salt2,  User_Salt);

/*		*User_Salt = make_Buffer(LEN_DESSALT+LEN_MD5SALT+5);
		salt1 = cut_str(pass, 0, LEN_DESSALT-1);
		salt2 = randstr(LEN_MD5SALT-4);
		copy_s2Buffer(salt1,  User_Salt);
		cat_s2Buffer("\r\n$1$", User_Salt);
		cat_s2Buffer(salt2, 	User_Salt);
		cat_s2Buffer("$", 		User_Salt);
*/
	}

	freeNull(pass);
	freeNull(salt1);
	freeNull(salt2);

	if (User_Salt->buf!=NULL) {
		buf = make_Buffer(LBUF);
		cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
		copy_Buffer(User_Salt,  &buf);
		cat_s2Buffer("\r\nEND\r\n", &buf);
		if (No_Chlng==FALSE) cc = tcp_send_crypt_sBuffer(sock, &buf, NULL);
		free_Buffer(&buf);
	}
	else {
		cc = tcp_send_crypt_mesg(sock, "ERR 129 USERID error.\r\n", NULL);
		return 129;
	}

	return 0;
}




/**
int	  command_PASSWD(Buffer operand, Buffer comment, int sock)

	ǽPASSWD ޥɤ롥

	operand  -- ޥɤΥڥ
		comment  -- ޥɤΥ
		sock     -- 饤ȤؤΥå

	͡0  	   
			0ʳ顼ֹ

	顼ֹ桧130

*/
int	  command_PASSWD(Buffer operand, Buffer comment, int sock)
{
	int   cc;
	char* npass = NULL;
	char* opass = NULL;
	char* salt  = NULL;
	
	if (User_Passwd==NULL) {
		cc = tcp_send_crypt_mesg(sock, "ERR 131 system has not a your password.\r\n", NULL);
		return 131;
	}

	if      (strlen((const char*)User_Passwd->buf)==LEN_MD5PASS) opass = (char*)&(User_Passwd->buf[LEN_MD5SALT]);
	else if (strlen((const char*)User_Passwd->buf)==LEN_DESPASS) opass = (char*)&(User_Passwd->buf[LEN_DESSALT]);


	if (No_Chlng==FALSE) {	// Use Challenge Keys
		salt = get_line((char*)User_Salt->buf, 2);
		if (salt!=NULL && opass!=NULL) {
			npass = (char*)crypt((const char*)opass, (const char*)salt);
			if      (strlen((const char*)npass)==LEN_MD5PASS) npass = &(npass[LEN_MD5SALT]);
			else if (strlen((const char*)npass)==LEN_DESPASS) npass = &(npass[LEN_DESSALT]);
			else npass = NULL;
		}
		if (npass!=NULL) {
			if (!strcmp((const char*)operand.buf, (const char*)npass)) {
				cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
				return 0;
			}
		}
	}
	else {					// Not Use Challenge Keys
		salt = get_line((char*)User_Salt->buf, 1);
		if (salt!=NULL && operand.buf!=NULL) {
			npass = (char*)crypt((const char*)operand.buf, (const char*)salt);
			if      (strlen((const char*)npass)==LEN_MD5PASS) npass = &(npass[LEN_MD5SALT]);
			else if (strlen((const char*)npass)==LEN_DESPASS) npass = &(npass[LEN_DESSALT]);
			else npass = NULL;
		}
		if (npass!=NULL) {
			if (!strcmp((const char*)opass, (const char*)npass)) {
				cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
				return 0;
			}
		}
	}

	cc = tcp_send_crypt_mesg(sock, "ERR 139 PASSWD error.\r\n", NULL);
	return 139;
}





/**
int	  command_HELLO(Buffer operand, Buffer comment, int sock)

	ǽHELLO ޥɤ롥

	operand  -- ޥɤΥڥ
		comment  -- ޥɤΥ
		sock     -- 饤ȤؤΥå

	͡0  	   
			0ʳ顼ֹ

	顼ֹ桧100

*/
int	  command_HELLO(Buffer operand, Buffer comment, int sock)
{
	int  cc;
	cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
	return cc;
}







/**
int   command_BYE(Buffer operand, Buffer comment, int sock)

	ǽBYE ޥɤ롥

	operand  -- ޥɤΥڥ
		comment  -- ޥɤΥ
		sock     -- 饤ȤؤΥå

	͡0  	   
			0ʳ顼ֹ

	顼ֹ桧110
*/
int   command_BYE(Buffer operand, Buffer comment, int sock)
{
	int  cc;
	cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
	clear_CRYPT_parameter();
	return cc;
}




/**
int    command_KEYEX(Buffer operand, Buffer comment, int sock)

	ǽKEYEX ޥɤ롥
          ѥɡʵڤӤ¾ξˤθˡꤹ롥
		  ڥɤ˸ŹΥ르ꥺबꤵ줿Ȥž륵¦ SPKI ϳ
׻ѤߤǤʤФʤʤʼ˥ޥɵưˡ
		  򴹥르ꥺλθ塤KEYEX SKPI ˽ȡδؿ϶ͭ롥
	줿ͭ ǥեȶͭȤʤ롥
		  	see also  get_CRYPT_SharedKey(), exchange_CRYPT_SharedKey() in ssl_tool.c
	
	operand  -- "DH"   ѥɾŹ沽뤿ΡŹ沽θ򴹥르ꥺȤ 
                             Diffie-Hellman ꤹ롥Ф³ơʤSPKIȤ Diffie-Hellnan 
                              SPKI(Base64_DHspki) 򥯥饤Ȥž롥

					  "RSA"	 򴹥르ꥺ RSA ꤷФSPKIȤ RSA SPKI(Base64_RSAspki)
							 򥯥饤Ȥž롥¿ʬ ssl_tool.c ǤޤƤʤ

					  "SPKI" 饤Ȥϡ³ƼʤSPKI򥵡Фž롥ФϤꡤ
 ľ˻ꤵ줿򴹤Υ르ꥺ˽äơͭ롥

                      "CHLNG"   ѥɤθ򴹤˥󥸥Ѥ롥ǥեȡ

                      "NOCHLNG" ѥɤθ򴹤˥󥸥Ѥʤξɬ
                                르ꥺꤷưŹ沽򴹤̿Ź沽ʤФʤʤ

		comment  -- ޥɤΥ
		sock     -- 饤ȤؤΥå


	͡0  	   
			0ʳ顼ֹ

	顼ֹ桧160

*/
int    command_KEYEX(Buffer operand, Buffer comment, int sock)
{
	int    cc;
	static int keyex;
	Buffer buf;


	if (!strcmp("DH", (const char*)operand.buf)) {
	    if (Base64_DHspki!=NULL) {
			keyex = SSL_DH;
			cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);

			buf = make_Buffer(LBUF);
			copy_Buffer(Base64_DHspki,  &buf);
			cat_s2Buffer("\r\nEND\r\n", &buf);
			cc = tcp_send_crypt_sBuffer(sock, &buf, NULL);
			free_Buffer(&buf);
	    }
	    else {
			cc = tcp_send_crypt_mesg(sock, "ERR 161 KEYEX DH Error.\r\n", NULL);
			return 161;
	    }
	}


	else if (!strcmp("RSA", (const char*)operand.buf)) {
	    if (Base64_RSAspki!=NULL) {
			keyex = SSL_RSA;

			cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
			buf = make_Buffer(LBUF);
			copy_Buffer(Base64_RSAspki, &buf);
			cat_s2Buffer("\r\nEND\r\n", &buf);
			cc = tcp_send_crypt_sBuffer(sock, &buf, NULL);
			free_Buffer(&buf);
	    }
	    else {
			cc = tcp_send_crypt_mesg(sock, "ERR 162 KEYEX RSA Error.\r\n", NULL);
			return 162;
	    }
	}


	else if (!strcmp("SPKI", (const char*)operand.buf)) {
		Buffer dkey;

		cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
		buf = make_Buffer(LBUF);
		cc = tcp_recv_sBuffer(sock, &buf, 20);
		dkey = get_plain_sBuffer(buf, NULL);
		free_Buffer(&buf);
		chomp_Buffer(&dkey);
		buf = decode_base64_Buffer(dkey);
		free_Buffer(&dkey);

		if (gen_CRYPT_SharedKey(keyex, buf)) {
			cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
		}
		else {
			cc = tcp_send_crypt_mesg(sock, "ERR 163 cannot generate Shared KEY.\r\n", NULL);
			return 163;
		}
		free_Buffer(&buf);
	}


	else if (!strcmp("CHLNG", (const char*)operand.buf)) {
		No_Chlng = FALSE;
		cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
	}


	else if (!strcmp("NOCHLNG", (const char*)operand.buf)) {
		No_Chlng = TRUE;
		cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
	}


	else {
	    cc = tcp_send_crypt_mesg(sock, "ERR 169 Unkown KEYEX operand.\n\r", NULL);
		return 169;
	}

	return 0;
}





/**
int   command_CRYPT(Buffer operand, Buffer comment, int sock)

	ǽCRYPT ޥɤ롥
		  Ź沽ˡѤϡδؿνλOKľ夫鿷ˡѤ롥

	operand  -- ޥɤΥڥ
		comment  -- ޥɤΥ
		sock     -- 饤ȤؤΥå

	͡0  	   
			0ʳ顼ֹ

	顼ֹ桧170
*/
int   command_CRYPT(Buffer operand, Buffer comment, int sock)
{
	int   cc;

	if (!has_CRYPT_SharedKey()) {
		cc = tcp_send_crypt_mesg(sock, "ERR 171 No Shared Key.\r\n", NULL);
		return 171;
	}

	if (!strcmp("AES128CBC", (const char*)operand.buf)) {			// AES 128bit CBC
		cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
		init_EVPAPI_Buffer(SSL_AES128CBC);
	}
	else if (!strcmp("3DES3CBC", (const char*)operand.buf)) {		// 3DES 3key CBC
		cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
		init_EVPAPI_Buffer(SSL_3DES3CBC);
	}
	else if (!strcmp("RESET", (const char*)operand.buf)) {			// RESET: Ź沽
		cc = tcp_send_crypt_mesg(sock, "OK\r\n", NULL);
		free_EVPAPI_Buffer();
	}
	else {
		cc = tcp_send_crypt_mesg(sock, "ERR 179 Unkown CRYPT operand.\r\n", NULL);
		return 179;
	}

	return 0;
}






/////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// 饤¦ǤΥޥ
//

/**
int  send_command_recv_ans(int sock, char* command, int tm)

	ǽ: Ф˥ޥɡ\r\nưŪźաˤꡤ"OK"  "ERR" Ԥġ

	: sock	    ФΥåȡ
		  command   Ф륳ޥɡ
		  tm		ॢȻ֡ñ̡

	:  0 ｪλ"OK" 
			 1ʾ  顼ֹ"ERR"ˡ
			-1  ̿顼
			-2  ޥɤ NULL
			-3  "OK", "ERR" ʳΤΤ
*/
int  send_command_recv_ans(int sock, char* command, int tm)
{
	int	 cc, nn;
	Buffer  ret, ans, buf, eno;
	
	if (command==NULL) return -2;

	buf = make_Buffer(LNAME);
	copy_s2Buffer(command, &buf);
	cat_s2Buffer("\r\n", &buf);
	cc = tcp_send_crypt_sBuffer(sock, &buf, NULL);
	free_Buffer(&buf);

	ret = make_Buffer(LNAME);
	cc = tcp_recv_sBuffer(sock, &ret, tm);	
	if (cc<=0) {
		free_Buffer(&ret);
		return -1;
	}
	buf = get_plain_sBuffer(ret, NULL);
	chomp_Buffer(&buf);
	ans = get_command(buf);

	if	    (!strcmp("OK",  (const char*)ans.buf)) nn = 0;
	else if (!strcmp("ERR", (const char*)ans.buf)) {
		eno = get_operand(buf);
		nn  = atoi((const char*)eno.buf);
		free_Buffer(&eno);
		DEBUG_MODE print_message("SEND_COMMAND_RECV_ANS: error = %d\n", nn);
	}
	else nn = -3;

	free_Buffer(&ret);
	free_Buffer(&buf);
	free_Buffer(&ans);

	return nn;
}




/** 
Buffer  recv_mesg_until_end(int sock, int tm)

	ǽ: Ź沽ǡξ "END" ޤǡå
	ХåեɲäʴʰץХåե󥰵ǽˡ
		  Ź沽ǡξϡԥ(\r\n)ޤǼ롥

		  Ź沽бꡥCRYPT_Algprism<>0 λCRYPT_SharedKey ǰŹ沽沽
		Ԥʤ롥Źˡinit_EVPAPI_Buffer() 롥 

	: sock	    ФΥåȡ
		  tm		ॢȻ֡ñ̡

	:  ǡ"END"ޤࡥŹξ沽롥

*/
Buffer  recv_mesg_until_end(int sock, int tm)
{
	int	cc;
	Buffer ret, buf, dec;
	
	ret = make_Buffer(LBUF);
	buf = make_Buffer(RECVBUFSZ);

	do {
		cc = tcp_recv_sBuffer(sock, &buf, tm);
		if (cc>0) {
			cat_Buffer(&buf, &ret);
			clear_Buffer(&buf);
			if (CRYPT_Algorism) {
				if (!strnrvscmp("\r\n", (const char*)ret.buf, 2)) break; 
			}
			else {
				if (!strnrvscmp("\r\nEND\r\n", (const char*)ret.buf, 7) ||
					!strnrvscmp("\nEND\n", (const char*)ret.buf, 5)) break;
			}
		}
	} while(cc>0);

	dec = get_plain_sBuffer(ret, NULL);
	free_Buffer(&buf);
	free_Buffer(&ret);
	return dec;
}		






/**
Buffer  send_algor_recv_spki(int sock, char* algor, int tm)

	ǽФظŹ楢르ꥺ algorѤ뤳ȤΤФ SPKI
		  餦
		  Ź沽бꡥCRYPT_Algprism!=0 λCRYPT_SharedKey ǰŹ沽沽
		Ԥʤ롥Źˡinit_EVPAPI_Buffer() 롥 


	sock  -- ФؤΥå
		algor -- ѥ르ꥺࡥߥݡȤƤΤ "DH" Τߡ
		tm    -- ॢ

	͡Ф X.509 SPKI (DER)
*/
Buffer  send_algor_recv_spki(int sock, char* algor, int tm)
{
	int	cc;
	Buffer com, ret, buf;

	ret = init_Buffer();								// 
	if (algor==NULL) return ret;

	com = make_Buffer_bystr((void*)"KEYEX ");
	cat_s2Buffer(algor, &com);
	cc = send_command_recv_ans(sock, (char*)com.buf, tm);
	free_Buffer(&com);
	if (cc!=0) { ret.state = cc; return ret; }

	ret = recv_mesg_until_end(sock, tm);				// Ф
	buf = get_line_Buffer(ret, 1);						// SPKI(BASE64)
	free_Buffer(&ret);
	ret = decode_base64_Buffer(buf);					// ǥɤ롥
	free_Buffer(&buf);

	return ret;
}





/**
int  send_spki_recv_ans(int sock, Buffer mkey, int tm)

	ǽФؼʬ SPKI(DER)ơԤġ
		  Ź沽бꡥCRYPT_Algprism!=0 λCRYPT_SharedKey ǰŹ沽沽
		Ԥʤ롥Źˡinit_EVPAPI_Buffer() 롥 

	sock  -- ФؤΥå
		  mkey  -- ʬ SPKI (DER)
		tm    -- ॢ

	͡0      -- ｪλ	
			0ʳ  -- ФΥ顼ֹ
*/
int  send_spki_recv_ans(int sock, Buffer mkey, int tm)
{
	int	cc;
	Buffer enc;

	cc = send_command_recv_ans(sock, "KEYEX SPKI", tm);
	if (cc!=0) return cc;

	enc = encode_base64_Buffer(mkey);				// ʬθ򥨥󥳡
	cc = send_command_recv_ans(sock, (char*)enc.buf, tm);
	free_Buffer(&enc);

	return cc;
}








/////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// 饤¦Ǥǧڽ
//

/** 
int  check_auth(Buffer ahost, int aport, Buffer userid, Buffer passwd, int keyex, int cryptm, char* cfn, int cont)

	ǽ: ǧڥФ³ǧڤԤʤ
		  keyex, cryptm ξꤷƤˤϰŹ沽̿Ԥʤ롥
		  Ź沽̿Ԥʤ cfn NULL̵ϡФγǧԤʤ

	: ahost	 	ǧڥۥȤ̾
		  aport	 	ǧڥۥȤΥݡֹ桥
		  userid	桼ID	
		  passwd	ѥ
		  chmode    󥸥򴹥⡼ɡOFF:󥸥򴹤ʤON:󥸥򴹤롥
					Ź沽̿ԤʤϡŪ˥󥸥򴹤(ONˤʤ)
		  keyex		򴹥르ꥺ
		cryptm	ͭŹ楢르ꥺ
		  cfn		ǧڥۥȤθ¸줿ե롥ǧڥۥȸѡNULLξϸڤʤ
		  cont 		Źաޤϥгǧ˼Ԥ˽³뤫ɤ
					TRUE:³롥FALSE:顼֤

	:  1   ｪλ
			 2   桼ǧڼ(桼¸ߤ뤬ѥɤפʤ)
			 3   桼ǧڼ(桼¸ߤʤ)
			 0   ǧڥФꤵƤʤޤϤ¾Υ顼
			-1   ǧڥФȤ³顼
			-2   ǧڥФȤ̿ϥ顼 ǧڥФǤʤ  
			-3   Źե顼ʥǧڤޤ
			-4   󥸥ե顼
*/
int  check_auth(Buffer ahost, int aport, Buffer userid, Buffer passwd, int chmode, int keyex, int cryptm, char* cfn, int cont)
{
	int    cryptf, sock, cc, tm = 10;
	Buffer ipaddr, buf, salt;
	char*  pass;
	char*  chip;

	if (ahost.buf==NULL) return 0;

	// ǧڥФ³ 
	sock = tcp_client_socket((char*)ahost.buf, aport);
	if (sock<0) {
	   	debug_message("CHECK_AUTH: auth server open error.\n");
		return  -1;
	}
	debug_message("CHECK_AUTH: auth server opened.\n");


    // ̿
    cc = send_command_recv_ans(sock, "HELLO", tm);
	if (cc!=0) {
		socket_close(sock);
		return -2;
	}


	// Ź
	cryptf = FALSE;
	if (keyex!=0 && cryptm!=0) {
		cryptf = TRUE;
   		chip   = get_ipaddr_byname((char*)ahost.buf);
   		ipaddr = make_Buffer_bystr(chip);
		freeNull(chip);
		cc  = start_CRYPT_transfer(sock, keyex, cryptm, ipaddr, cfn, tm);
		free_Buffer(&ipaddr);
		if (cc && !cont) {
			clear_CRYPT_parameter();
			socket_close(sock);
			return -3;
		}
		// ʸŹ沽̿
	}


	// 󥸥
	if (cryptf==FALSE) chmode = ON;

	if (chmode==OFF) {
    	cc = send_command_recv_ans(sock, "KEYEX NOCHLNG", tm);
		if (cc!=0) {
			if (cc==169) {		// Unkown KEYEX operand. Support for old version.
				chmode = ON;
			}
			else {
				socket_close(sock);
				return -4;
			}
		}
	}


	/////////////////////////////////////////
	// 桼ID롥 
	buf = make_Buffer(LBUF);
	copy_s2Buffer("USERID ", &buf);
	cat_Buffer(&userid, &buf);
	cc = send_command_recv_ans(sock, (char*)buf.buf, tm);
	if (cc!=0) {
		free_Buffer(&buf);
		if (cryptf) clear_CRYPT_parameter();
		socket_close(sock);
		return 3;
	}

	// SALT롥 
	if (chmode==ON) {
		salt = recv_mesg_until_end(sock, tm);
		//DEBUG_MODE print_escape("SALT = [%s]\n", (char*)salt.buf);
	}
	clear_Buffer(&buf);


   	// ѥɤ׻롥 
	copy_s2Buffer("PASSWD ", &buf);
	if (chmode==ON) {
		pass = x2crypt((char*)passwd.buf, (char*)salt.buf);
		cat_s2Buffer(pass, &buf);
		freeNull(pass);
	}
	else {
		cat_s2Buffer((char*)passwd.buf, &buf);
	}
	cc = send_command_recv_ans(sock, (char*)buf.buf, tm);
	free_Buffer(&buf);

	if (cc) {
		if (cryptf) clear_CRYPT_parameter();
		socket_close(sock);
		return 2;
	}


	// Ź沽̿λ
	if (cryptf) cc = stop_CRYPT_transfer(sock, tm);

    cc = send_command_recv_ans(sock, "BYE", tm);

	socket_close(sock);
	debug_message("CHECK_AUTH: auth server normally closed.\n");

	return  1;
}
/**/






/////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//	饤¦ǤΰŹ泫ϡλ
//

/**
int   start_CRYPT_transfer(int sock, int keyex, int cryptm, Buffer ipaddr, char* cfn, int tm)

	ǽ¦ȰŹ沽̿ԤΥͥԤ
		  ͥ硤δؿλ夫Ź沽̿Ϥޤ롥

	: sock	 	ǧڥۥȤؤΥåȡ
		  keyex	 	򴹥르ꥺʸߤνꡤSSL_DH Τߡˡ
		  cryptm	̸ŹΥ르ꥺ	
		  ipaddr	ǧڥۥȤIPɥ쥹ǧڥۥȸѡ
		  cfn		ǧڥۥȤθ¸줿ե롥ǧڥۥȸѡNULLξϸڤʤ
		  tm		ॢ

	͡ 0  ʸ塤Ź沽ˤ̿Ԥ
			-1  ǧڥۥȤθڥ顼
			-2  ΤʤŹ楢르ꥺ
			-3  Τʤ̸Ź楢르ꥺ

*/
int   start_CRYPT_transfer(int sock, int keyex, int cryptm, Buffer ipaddr, char* cfn, int tm)
{
	int    cc;
	Buffer spki, mpki;

	if (cfn!=NULL && ipaddr.buf!=NULL) {
    	if (!check_server_spki(ipaddr, spki, cfn)) return -1;
    }

	if      (keyex==SSL_DH)  spki = send_algor_recv_spki(sock, "DH", tm);
	else if (keyex==SSL_RSA) spki = send_algor_recv_spki(sock, "RSA", tm);
	else return -2;

	/*
	DEBUG_MODE {
		Buffer enc;
		enc = encode_base64_Buffer(spki);
		print_message("SERVER SPKI = [%s]\n", enc.buf);
		free_Buffer(&enc);
	}*/
    mpki = get_DHspki_fs(spki);
	gen_CRYPT_SharedKey(keyex, spki);

    cc = send_spki_recv_ans(sock, mpki, tm);

    if (cryptm==SSL_AES128CBC) {
		cc = send_command_recv_ans(sock, "CRYPT AES128CBC", tm);
    	init_EVPAPI_Buffer(SSL_AES128CBC);
	}
    else if (cryptm==SSL_3DES3CBC) {
  		cc = send_command_recv_ans(sock, "CRYPT 3DES3CBC", tm);
    	init_EVPAPI_Buffer(SSL_3DES3CBC);
	}
	else {
		free_Buffer(&spki);
		free_Buffer(&mpki);
		//stop_CRYPT_transfer();
		clear_CRYPT_parameter();
		return -3;
	}

	free_Buffer(&spki);
	free_Buffer(&mpki);
	return 0;
}





/**
int  stop_CRYPT_transfer(int sock, int tm)

	ǽ饤¦ǤΰŹ沽̿λ
		  Ф˰ŹѽλʬѤλ롥

	sock  -- ФؤΥå

	:  0 ｪλ"OK" 
			 1ʾ  顼ֹ"ERR"ˡ
			-1  ̿顼
			-2  ޥɤ NULL
			-3  "OK", "ERR" ʳΤΤ
*/
int  stop_CRYPT_transfer(int sock, int tm)
{
	int cc;

    cc = send_command_recv_ans(sock, "CRYPT RESET", tm);
	if (!cc) clear_CRYPT_parameter();
	return cc;
}




