/* vi: set tabstop=4 nocindent noautoindent: */

/**
	Protocol
					by Fumi Iseki 2005 10/10
								  2009 2/5
*/



#include "protocol.h"




//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Protocol Header
//

/**
tList*  get_protocol_header_list(Buffer buf, char deli, int fstline, int rcntnt)

	ǽbuf ץȥإåkey'deli' data ηˤʬ򤷤ƥꥹȤ˳Ǽ롥'deli'϶ʸ
		  fstline TRUEξ硤إåΰܤ HDLIST_FIRST_LINE_KEY ΥĤƥꥹȤ˳Ǽ롥

		  ޤδؿϥХåե󥰤ʤɤϹԤʤΤǡإå˥ƥĤκǽʬʶǽ롥
		  rcntnt TRUEξϡHDLIST_CONTENTS_KEY 򥭡ˤƥƥĤꥹȤ˳Ǽ롥FALSEξ̵롥
		  ƥĤΥ礭缡ɤ߹ޤ硤HDLIST_CONTENTS_KEYΡɤʣ롥

		  إåͤʣԤˤʤ硤إå HDLIST_CONTINUE ȤơΥΡɤ˳Ǽ롥

	buf	  -- إåǼѿ
		  deli	  -- إåθФ(Key)ȤζʸHTTP SMTPǤ ':'
		  fstline -- ܤ̰ˤ뤫 ܤ key'deli' data ηǤʤץȥ, ex) HTTP, SIP
		  rcntnt  -- ƥĤɤफ

	͡إåǼꥹȤؤΥݥ󥿡

*/
tList*  get_protocol_header_list(Buffer buf, char deli, int fstline, int rcntnt)
{
	tList* lp;

	if (buf.buf==NULL) return NULL;

	lp = get_protocol_header_list_seq(NULL, buf, deli, fstline, rcntnt);
	if (lp!=NULL) lp = find_tList_top(lp);

	return lp;
}





/**
Buffer  restore_protocol_header(tList* list, char* deli, int mode)

	ǽ
		ꥹ list¸줿ǡإåǡ롥
		mode==ON ʤ listʶǤ륳ƥĤƤä֤
		
		get_protocol_header_list() εա

*/
Buffer  restore_protocol_header(tList* list, char* deli, int mode)
{
	Buffer buf;

	buf = init_Buffer();
	if (list==NULL) return buf;

	buf = make_Buffer(RECVBUFSZ);

	while(list!=NULL) {
		if (!strcmp((const char*)(list->ldat.key.buf), HDLIST_FIRST_LINE_KEY)) {
			copy_Buffer(&(list->ldat.val), &buf);
			cat_s2Buffer("\r\n", &buf);
		}
		else if (!strcmp((const char*)(list->ldat.key.buf), HDLIST_CONTINUE)) {
			buf.buf[buf.vldsz] = TAB;
			buf.vldsz++;
			cat_Buffer(&(list->ldat.val), &buf);
			cat_s2Buffer("\r\n", &buf);
		}
		else if (!strcmp((const char*)(list->ldat.key.buf), HDLIST_END_KEY)) break;
		else {
			cat_Buffer(&(list->ldat.key), &buf);
			cat_s2Buffer(deli, &buf);
			cat_Buffer(&(list->ldat.val), &buf);
			cat_s2Buffer("\r\n", &buf);
		}

		list = list->next;
	}
	cat_s2Buffer("\r\n", &buf);


	if (mode==ON) {
		int nn = 1;
		tList* pl = strncmp_tList(list, HDLIST_CONTENTS_KEY, 0, nn);
		while (pl!=NULL && pl->ldat.val.buf!=NULL) {
			cat_Buffer(&(pl->ldat.val), &buf);
			pl = strncmp_tList(list, HDLIST_CONTENTS_KEY, 0, ++nn);
		}
	}

	return buf;
}





/**
Buffer  restore_protocol_contents(tList* list)

	ǽ
		ꥹ list¸줿ǡ饳ƥĤ롥

*/
Buffer  restore_protocol_contents(tList* list)
{
	Buffer buf;
	tList* lp;
	int nn = 1;

	buf = make_Buffer(BUFSZ);

	lp = strncmp_tList(list, HDLIST_CONTENTS_KEY, 0, nn);
	while (lp!=NULL && lp->ldat.val.buf!=NULL) {
		cat_Buffer(&(lp->ldat.val), &buf);
		lp = strncmp_tList(list, HDLIST_CONTENTS_KEY, 0, ++nn);
	}

	return buf;
}





/**
void	set_protocol_contents(tList* list, Buffer contents)

	աץȥ˰¸ΤǡƥĥκƷ׻ϹԤʤ


*/
void	set_protocol_contents(tList* list, Buffer contents)
{
	while (list!=NULL) {
		if (list->ldat.key.buf!=NULL && !strcmp((char*)list->ldat.key.buf, HDLIST_CONTENTS_KEY)) {
			free_Buffer(&list->ldat.val);
			list->ldat.val = dup_Buffer(contents);

			while (is_header_continue(list)) del_tList_node(list->next);								
			break;
		}

		list = list->next;
	}

	return;
}






/**
tList*  get_protocol_header_list_seq(tList* lp, Buffer buf, char deli, int fstline, int rcntnt)

	ǽbuf ץȥإåkey'deli' data ηˤʬ򤷤ƥꥹȤ˳Ǽ롥'deli'϶ʸ
		󥷥˿ƤӽФȤǽ
		  lp==NULL Ǿ֡ŪѿˤꥻåȤΤǡǽ lp NULLˤ뤳ȡ

		  fstline TRUEξ硤إåΰܤ HDLIST_FIRST_LINE_KEY ΥĤƥꥹȤ˳Ǽ롥

		  ޤδؿϥХåե󥰤ʤɤϹԤʤΤǡإå˥ƥĤκǽʬʶǽ롥
		  rcntnt TRUEξϡHDLIST_CONTENTS_KEY 򥭡ˤƥƥĤꥹȤ˳Ǽ롥FALSEξ̵롥
		  ƥĤΥ礭缡ɤ߹ޤ硤HDLIST_CONTENTS_KEYΡɤʣ롥

		  إåͤʣԤˤʤ硤إå HDLIST_CONTINUE ȤơΥΡɤ˳Ǽ롥

		  lp!=NULL ޤ fstlineFALSE ξϰܤνϹԤʤ

	lp	  -- إåǼꥹȤؤΥݥ󥿡
					 NULLξϥꥹȤ롥NULLǤʤϤΥꥹȤ˥إåɲä롥
		  buf	 -- إåǼѿ
		  deli	-- إåθФ(Key)ȤζʸHTTP SMTPǤ ':'
		  fstline -- ܤ̰ˤ뤫 ܤ key'deli' data ηǤʤץȥ, ex) HTTP, SIP
		  rcntnt  -- ƥĤɤफ

	ֺ͡Ǹ˺ꥹȥΡɤؤΥݥ󥿡
			ꥹȤΥȥåפˤ find_tList_top(tList* pp) Ѥ롥

	ѿin_contents ƥǤ뤳Ȥɽ
		  crlfCount    CR,LFο

*/
tList*  get_protocol_header_list_seq(tList* lp, Buffer buf, char deli, int fstline, int rcntnt)
{
	static int crlfCount  = 0;
	static int inContents = FALSE;
	int	i=0, n=0, size;
	Buffer key, data;


	if (buf.buf==NULL) return NULL;

	size = buf.vldsz;
	data = make_Buffer(size+1);
	key  = make_Buffer(LBUF);

	if (lp==NULL) {
		crlfCount  = 0;
		inContents = FALSE;
	}


	// FIRST LINE 
	if (fstline && lp==NULL) {
		while(buf.buf[i]!=0x0a && buf.buf[i]!='\0' && i<size && n<size) {
			data.buf[n++] = buf.buf[i++];
		}
		if (data.buf[n-1]==0x0d) {
			i--;
			n--;
		}

		data.buf[n] = '\0';
		data.vldsz  = n;
		copy_s2Buffer(HDLIST_FIRST_LINE_KEY, &key);
		lp = add_tList_node_Buffer(NULL, key, data);

		if (buf.buf[i]=='\0' || i==size) {
			free_Buffer(&key);
			free_Buffer(&data);
			return lp;
		}
		clear_Buffer(&key);
		clear_Buffer(&data);
	}


	// HEADER
	while(buf.buf[i]!='\0' && i<size && !inContents) {
		// Check Previous Line's CR & LF
		if (i+1<size && buf.buf[i]==0x0d && buf.buf[i+1]==0x0a) {
			i = i + 2;
			if (crlfCount==1) {			// for previous called function
				copy_s2Buffer(HDLIST_END_KEY, &key);
				lp = add_tList_node_Buffer(lp, key, data);
				crlfCount  = 0;
				inContents = TRUE;
				break;	
			}
			else crlfCount = 1;
		}
		else if (buf.buf[i]==0x0a) {
			i = i + 1;
			if (crlfCount==1) {			// for previous called function
				copy_s2Buffer(HDLIST_END_KEY, &key);
				lp = add_tList_node_Buffer(lp, key, data);
				crlfCount  = 0;
				inContents = TRUE;
				break;	
			}
			else crlfCount = 1;
		}

		// 
		if (i+1<size && buf.buf[i]==0x0d && buf.buf[i+1]==0x0a) {
			i = i + 2;
			if (crlfCount==1) {
				copy_s2Buffer(HDLIST_END_KEY, &key);
				lp = add_tList_node_Buffer(lp, key, data);
				crlfCount  = 0;
				inContents = TRUE;
				break;	
			}
		}
		else if (i<size && buf.buf[i]==0x0a) {
			i = i + 1;
			if (crlfCount==1) {
				copy_s2Buffer(HDLIST_END_KEY, &key);
				lp = add_tList_node_Buffer(lp, key, data);
				crlfCount  = 0;
				inContents = TRUE;
				break;	
			}
		}

		if (buf.buf[i]=='\0' || i==size) break;


		// HEADER KEY
		n = 0;
		if (buf.buf[i]==TAB || buf.buf[i]==' ') {
			copy_s2Buffer(HDLIST_CONTINUE, &key);
		}
		else {
			while(buf.buf[i]!=deli && buf.buf[i]!='\0' && i<size && n<LBUF) {
				key.buf[n++] = buf.buf[i++];
			}
			key.buf[n] = '\0';
			key.vldsz  = n;
		}
		while ((buf.buf[i]==deli ||buf.buf[i]==' '||buf.buf[i]==TAB) && i<size) i++;


		// HEADER VALUE
		n = 0;
		while(buf.buf[i]!=0x0a && buf.buf[i]!='\0' && i<size && n<size) {
			data.buf[n++] = buf.buf[i++];
		}
		if (data.buf[n-1]==0x0d) {
			i--;
			n--;
		}
		data.buf[n] = '\0';
		data.vldsz  = n;

		lp = add_tList_node_Buffer(lp, key, data);

		crlfCount = 0;
		clear_Buffer(&key);
		clear_Buffer(&data);
	}
	

	// CONTENTS (Text or Binary)
	if (rcntnt && i<size && inContents) {
		crlfCount = 0;
		clear_Buffer(&key);
		clear_Buffer(&data);
		copy_s2Buffer(HDLIST_CONTENTS_KEY, &key);

		n = 0;
		while(i<size && n<size) {
	   		data.buf[n++] = buf.buf[i++];
		}
		data.vldsz = n;

		lp = add_tList_node_Buffer(lp, key, data);
	}
	
	free_Buffer(&key);
	free_Buffer(&data);

	return lp;
}





/**
tList*  get_protocol_header_list_file(char* fname, char deli, int fstline, int rcntnt)

	ǽե fname إåɤ߹ʬ򤷡ꥹȤ˳Ǽ֤

	fname   -- ɤ߹ե̾
		  deli	-- إåθФ(Key)ȤζʸHTTP SMTPǤ ':'
		  fstline -- ܤ̰ˤ뤫 ܤ key'deli' data ηǤʤץȥ, ex) HTTP, SIP
					 'deli'϶ʸ
		  rcntnt  -- ƥĤɤफ

	͡إåǼꥹȤؤΥݥ󥿡

*/
tList*  get_protocol_header_list_file(char* fname, char deli, int fstline, int rcntnt)
{
	Buffer buf;
	tList* lp;

	if (fname==NULL) return NULL;

	buf = read_Buffer_file(fname);
	lp  = get_protocol_header_list(buf, deli, fstline, rcntnt);

	return lp;
}





//////////////////////////////////////////////////////////////////////////////////////////////////
// Search

/**
Buffer  search_protocol_header(tList* list, char* key, int no) 

	ǽإåꥹȤ椫 noܤ keyΡɤõФ͡ldat.val.bufˤΥԡ֤
		  ͤʣԤϤϡ\r\n ƹԤ礹롥
		  Ǥ keyĹ˹碌롥ޤ, keyϥ󥻥󥷥ƥ֡

	list -- оݤΥإåǼꥹ
		  key  -- إå̡
		  no   -- Ʊإå̤ΥΡɤʣ硤ܤΥΡɤꤹ롥롥

	͡
			free
*/
Buffer  search_protocol_header(tList* list, char* key, int no) 
{
	tList* pp;
	Buffer buf;

	buf = init_Buffer();
	if (list==NULL || key==NULL) return buf;
	
	pp = strncasecmp_tList(list, key, 0, no);		// 
	if (pp!=NULL) {
		buf = dup_Buffer(pp->ldat.val);

		while (is_header_continue(pp)) {
			cat_s2Buffer("\r\n", &buf);
			pp = pp->next;
			cat_Buffer(&(pp->ldat.val), &buf);
		}
	}
	
	return buf;
}





/**
Buffer  search_protocol_header_item(tList* list, char* key, int no, char deli, int nm) 

	ǽkey 򥭡ˤ noܤΥΡɤͤǡdeliڤˤ nmܤιܡʸˤ֤

	list -- оݤΥإåǼꥹ
		  key  -- إå̡
		  no   -- Ʊإå̤ʣ硤ܤΥΡɤꤹ롥롥
		  deli -- Ρ͡ʸˤζڤʸ
		nm   -- deli ڤʸȤƲܤιܤ 1롥

	͡
		 ꤷܡʸˤΥԡ

*/
Buffer  search_protocol_header_item(tList* list, char* key, int no, char deli, int nm) 
{
	Buffer buf, itm;

	buf = search_protocol_header(list, key, no);
	if (buf.buf==NULL) return buf;
	
	itm = cawk_Buffer(buf, deli, nm);
	free_Buffer(&buf);

	return itm;
}





/**
Buffer  search_protocol_header_value(tList* list, char* key, char* data, int no) 

	ǽإåꥹȤ椫 noܤ keyΡɤõФdataǻϤޤΡɤ͡ldat.val.bufˤΥԡ֤
		  key, dataϥ󥻥󥷥ƥ֡data ʣԤ˷³Ƥϡ³ƤԤñȤιԤȤƸ롥

	list -- оݤΥإåǼꥹ
		  key  -- إå̡
	data -- إåͤκǽʸNULL ʤƤȰס
		  no   -- Ʊإå̤ΥΡɤʣ硤ܤΥΡɤꤹ롥롥
	
	͡פΡɤΥΡͤΥԡ

*/
Buffer  search_protocol_header_value(tList* list, char* key, char* data, int no) 
{
	Buffer buf;
	char*  str;
	int	   len, nm;

	buf = init_Buffer();
	if (list==NULL || key==NULL) return buf;

	if (data==NULL) {
		buf = search_protocol_header(list, key, no);
		return buf;
	}

	buf = init_Buffer();
	len = strlen(data); 
	
	nm = 0;
	while (list!=NULL) {
		if (list->ldat.key.buf!=NULL && !strcasecmp((char*)list->ldat.key.buf, key)) {
			str = (char*)list->ldat.val.buf;

			if (str!=NULL && !strncasecmp(str, data, len)) {
				nm++;
				if (no==nm) {
					buf = make_Buffer_bystr(str);
					return buf;
				}
			}

			while (is_header_continue(list)) {
				list = list->next;
				str  = (char*)list->ldat.val.buf;
				if (str!=NULL && !strncasecmp(str, data, len)) {
					nm++;
					if (no==nm) {
						buf = make_Buffer_bystr(str);
						return buf;
					}
				}
			}
		}

		list = list->next;
	}

	return buf;
}





/**
Buffer  search_protocol_header_partvalue(tList* list, char* key, char* data, int no) 

	ǽإåꥹȤ椫 noܤ keyΡɤõФdataʸޤΡɤ͡ldat.val.bufˤΥԡ֤
		  key, dataϥ󥻥󥷥ƥ֡data ʣԤ˷³Ƥϡ³ƤԤñȤιԤȤƸ롥

	list -- оݤΥإåǼꥹ
		  key  -- إå̡
	data -- إåͤκǽʸNULL ʤƤȰס
		  no   -- Ʊإå̤ΥΡɤʣ硤ܤΥΡɤꤹ롥롥

	͡פΡɤΥΡͤΥԡ
*/
Buffer  search_protocol_header_partvalue(tList* list, char* key, char* data, int no) 
{
	Buffer buf;
	char*  str;
	int	   len, nm;

	buf = init_Buffer();
	if (list==NULL || key==NULL) return buf;

	if (data==NULL) {
		buf = search_protocol_header(list, key, no);
		return buf;
	}

	buf = init_Buffer();
	len = strlen(data); 
	
	nm = 0;
	while (list!=NULL) {
		if (list->ldat.key.buf!=NULL && !strcasecmp((char*)list->ldat.key.buf, key)) {
			str = (char*)list->ldat.val.buf;

			if (str!=NULL && strstrcase(str, data)) {
				nm++;
				if (no==nm) {
					buf = make_Buffer_bystr(str);
					return buf;
				}
			}

			while (is_header_continue(list)) {
				list = list->next;
				str  = (char*)list->ldat.val.buf;
				if (str!=NULL && strstrcase(str, data)) {
					nm++;
					if (no==nm) {
						buf = make_Buffer_bystr(str);
						return buf;
					}
				}
			}
		}

		list = list->next;
	}

	return buf;
}








//////////////////////////////////////////////////////////////////////////////////////////////////
// Set

/*
int 	set_protocol_header(tList* list, char* key, char* value, int no, int add_mode)

	ǽꥹ(lt) noܤ keyΥΡͤ valueꤹ롥
		  no  0ʲξϡƤ keyΡɤͤФ꤬Ԥ롥
		  keyΡɤ¸ߤ mode==ON ξϡꥹȤκǸʥƥĤˤɲä롥

		  set_value_tList() Ȥΰ㤤ϡɲûɲäλΤߡ(in Lib/tlist.c)

	
		list   -- оݤΥꥹ
		key	   -- ԤΡɤΥ
		value  -- ꤵʸ
		no	   -- ܤΥΡɤФԤ1롥
				  0ʲξkeyפ뤹٤ƤΥΡɤФԤ
		add_mod - ͤON ĻꤷΡɤ̵硤ΡɥꥹȤκǸʤƥĤˤɲä롥

   ͡
		ꤵ줿Ρɤοꤵ줿Ρɤ¸ߤʤϡɲä줿0
		ξϥ顼

*/
int 	set_protocol_header(tList* list, char* key, int no, char* value, int add_mode)
{
	int cn = set_value_tList(list, key, no, value, OFF);

	// Not Found
	if (add_mode==ON && cn==0) {
		tList* pm = strncmp_tList(list, HDLIST_END_KEY, 0, 1);
		if (pm!=NULL && pm->prev!=NULL) {
			add_tList_node_str(pm->prev, key, value);
		}
		else {
			add_tList_node_str(list, key, value);
		}
	}

	return cn;
}





/**
int 	replace_protocol_header(tList* list, char* key, char* srcval, char* value, int no)

	ǽꥹ(lt) noܤ keyΡɤͤ srcvalʬ value ֤롥
		  no  0ʲξϡƤ keyΡɤͤФ֤Ԥ롥

		  replace_valute_tList() Ʊؿ (in Lib/tlist.c)

	
		list   -- оݤΥꥹ
		key	   -- ֤ԤΡɤΥ
		srcval -- ֤оݤʸ
		value  -- ֤Ԥʸ
		no	   -- ܤιܤ֤뤫1롥0ʲξkeyפƤιܤ֤

	͡
		ѹ줿Ρɤοꤵ줿Ρɤ¸ߤʤϡɲä줿0
		ξϥ顼

	#define replace_protocol_header(l, k, s, d, n)	replace_value_tList((l), (k), (s), (d), (n))
*/





/**
int		set_protocol_header_item(tList* list, char* key, int no, char deli, int nm, char* value)

	ǽkey 򥭡ˤ noܤΥΡɤͤǡdeliڤˤ nmܤιܡʸˤ
		value ꤹ롥

	list -- оݤΥإåǼꥹ
		  key  -- إå̡
		  no   -- Ʊإå̤ʣ硤ܤΥΡɤꤹ롥롥
				  no 0ʲξ keyפƤΥΡɤФԤ
		  deli -- Ρ͡ʸˤζڤʸ
		nm   -- deli ڤʸȤƲܤιܤ 1롥
		  value - ꤹʸ

	͡ԤäΡɿ

int		set_protocol_header_item(tList* list, char* key, int no, char deli, int nm, char* value)
*/





/**
int		replace_protocol_header_item(tList* list, char* key, int no, char deli, int nm, char* srcval, char* value)

	ǽkey 򥭡ˤ noܤΥΡɤͤǡdeliڤˤ nmܤιܡʸˤ
		srcvalʬ value֤롥

	list  -- оݤΥإåǼꥹ
		  key   -- إå̡
		  no	-- Ʊإå̤ʣ硤ܤΥΡɤꤹ롥롥
				   no 0ʲξ keyפƤΥΡɤФԤ
		  deli  -- Ρ͡ʸˤζڤʸ
		nm	-- deli ڤʸȤƲܤιܤ 1롥
		  srcval - ֤оݤʸNULLʤꤷܤʸ
		  value  - ֤ʸ

	֤͡ԤäΡɿ

int		replace_protocol_header_item(tList* list, char* key, int no, char deli, int nm, char* srcval, char* value)
*/





/**
int search_crlfcrlf(char* mesg) 

	ǽʸζԤõԥɤ 0x0d, 0x0a ޤ 0x0a

	͡ԸμιԤƬΰ
			-1 ξ϶̵

*/
int  search_crlfcrlf(char* mesg) 
{
	int cr = 0;		// dummy
	int lf = 0;
	int i;

	if (mesg==NULL)	return -2;
	if (mesg[0]==0x0a) return 1;
	if (mesg[0]==0x0d && mesg[1]==0x0a) return 2;

	i = 0;
	while(mesg[i]!='\0') {
		if	  (mesg[i]==0x0d) cr++;
		else if (mesg[i]==0x0a) lf++;
		else {
			cr = lf = 0;
		}

		if (lf==2) return i+1;
		i++;
	}
	return -1;
}




/**
int  is_header_continue(tList* pp)

	ǽpp ؤƤإåͤΥꥹȤ³Ƥ뤫ɤȽꤹ롥
		  ץȥǤϡإåͤʣԤϤ롥

*/
int  is_header_continue(tList* pp)
{
	if (pp==NULL || pp->next==NULL || pp->next->ldat.key.buf==NULL)	return FALSE;
	if (!strcmp((const char*)pp->next->ldat.key.buf, HDLIST_CONTINUE)) return TRUE;
	return FALSE;
}







