/* vi: set tabstop=4 nocindent noautoindent: */

/** 
	SMTP TOOL
				by Fumi Iseki '05 12/25
*/



#include "smtp_tool.h"
#include "mime_tool.h"






/**
char*  get_smtp_rcpt(char* mesg)

	ǽmesg  RCPT TO: ޥɤ򸡺Υ᡼륢ɥ쥹֤

*/
char*  get_smtp_rcpt(char* mesg)
{
	char* pp;
	char* pt;
	char* pc;
	char* pa = NULL;

	pp = awk(mesg, ':', 1);
	pc = pack_char(pp, ' ');
	freeNull(pp);
	if (pc==NULL) return NULL;

	if (!strcasecmp("RCPT TO", pc)) {
		pp = (char*)malloc(strlen((const char*)mesg)+1);
		pt = strstr(mesg, ":");
		if (pp==NULL || pt==NULL) {
			freeNull(pc);
			freeNull(pp);
			return NULL;
		}
		memset(pp, 0, strlen((const char*)mesg)+1);
		memcpy(pp, pt, strlen((const char*)pt));

		pa = get_smtp_mailbox(pp);
		freeNull(pp);
	}

	freeNull(pc);
	return pa;
}
	





/**
char*   get_smtp_mailbox(char* mesg)

	ǽ<forward-path>  <mailbox> ֤see RFC821
		  RFC821 <mailbox> Ȥϡ̾Υ᡼륢ɥ쥹Τȡ

		  ʸõ(':' || '<' || ' ')  !(' ' && '>' && CR && LF) Ф
*/
char*   get_smtp_mailbox(char* mesg)
{
	int i, j, k, l;
	char* mb;

	i = strlen((const char*)mesg);
	mb = (char*)malloc(i+1);
	if (mb==NULL) return NULL;
	memset(mb, 0, i+1);

	i--;
	while(i>=0) {
		if (mesg[i]!=' ' && mesg[i]!='>' && mesg[i]!=CR && mesg[i]!=LF) break;	
		i--;
	}
	l = i;

	while(i>=0) {
		if (mesg[i]==':' || mesg[i]=='<' || mesg[i]==' ') break;	
		i--;
	}
	k = i + 1;

	for (i=k, j=0; i<=l; i++) mb[j++] = mesg[i];

	return mb;
}



	
/**
int   is_smtp_onecommand(char* mesg, char* com)

	ǽDATA, RSETʤɤζ̵ʤΥޥɤ̤롥

*/
int   is_smtp_onecommand(char* mesg, char* com)
{
	int   ret = FALSE;
	char* pp;
	char* pc;

	pp = pack_char(mesg, ' ');
	pc = awk(pp, ' ', 1);
	freeNull(pp);
	if (pc==NULL) return FALSE;

	if (!strncasecmp(com, pc, strlen((const char*)com))) ret = TRUE;

	freeNull(pc);
	return ret;
}
	




/**
int  smtp_check_dot(char* mesg) 

	ǽ᡼ν "\r\n.\r\n" õ
	
	͡\r\n.\r\n 򸫤Ĥ TRUE, ̵ä FALSE

*/
int  smtp_check_dot(char* mesg) 
{
	static int preDot = OFF;
	char* p = mesg;

	if (preDot==ON) {								// ʸƬ ".\r\n" õ
		if (!strncmp(".\r\n", mesg, 3)) {
			preDot  = OFF;
			return TRUE;
		}
		preDot = OFF;
	}

	while(*p!='\0') {
		if (!strncmp("\r\n", p, 2)) {				// ʸ "\r\n" õ	
			if (p[2]=='\0') {						// ʸ "\r\n" õ
				preDot = ON;
				return FALSE;
			}
			else if (!strncmp("\r\n.\r\n", p, 5)) { // ʸ "\r\n.\r\n" õ
				preDot = OFF;
				return TRUE;
			}
		}
		p++;
	}

	return FALSE;
}










