/* vi: set tabstop=4 nocindent noautoindent: */

/**
SSLŹѥ饤֥  ssl_tool.c

إå
	  #include "ssl_tool.h"

饤֥
	  -L/usr/local/ssl/lib -lcrypto 


---------------------------------------------------------------
Υץ openSSL ѤƤޤ
This product includes software developed by the OpenSSL Project
for use in the OpenSSL Toolkit. (http://www.openssl.org/)

*/



#include "ssl_tool.h"





Buffer*  CRYPT_SharedKey = NULL;
const EVP_CIPHER* CRYPT_Type = NULL;
DH*	  DHkey = NULL;

int	  KEYEX_Algorism = 0;
int	  CRYPT_Algorism = 0;





///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

/**
int	gen_CRYPT_SharedKey(int keyex, Buffer spki)

	ǽ򴹥르ꥺ keyex ǡͭ׻롥
			ʬSPKI̩Ϸ׻ѤߤǤʤФʤʤ
		  줿ͭ Buffer* CRYPT_SharedKey ˳Ǽ롥

	keyex
		SSL_SH: Diffie-Hellman ξϡDH* DHkey̩DH_generate_key()ʤޤ 
				gen_DHspki(), get_DHspki_fs(), get_DHspki_ff()Ǥɤˤˤ׻ʤޤ
				ɡˤ졤DH* DHkey ˳ǼƤʤФʤʤ
		RSA: 	RSAξ,,,,,,,,,,,,


	keyex  -- 򴹥르ꥺࡥߥݡȤƤΤ SSL_DH Τߡ
			spki	--  SPKI  		

	͡TRUE	
			FALSE  
*/
int	gen_CRYPT_SharedKey(int keyex, Buffer spki)
{
	if (spki.buf==NULL) return FALSE;

	KEYEX_Algorism = keyex;
	if (CRYPT_SharedKey!=NULL) del_Buffer(&CRYPT_SharedKey);
	CRYPT_SharedKey = new_Buffer();

	if	  (KEYEX_Algorism==SSL_DH)  *CRYPT_SharedKey = get_DHsharedkey(spki); // ̩
	else if (KEYEX_Algorism==SSL_RSA) *CRYPT_SharedKey = dup_Buffer(spki);		// ̤
	else {
		KEYEX_Algorism  = 0;
			del_Buffer(&CRYPT_SharedKey);
			CRYPT_SharedKey = NULL;
		return FALSE;
	}

//	dump_Buffer(*CRYPT_SharedKey);
	return TRUE;
}




/**
int	has_CRYPT_SharedKey()

	ǽǥեȶͭ CRYPT_SharedKey äƤ뤫ɤ롥

	͡TRUE	äƤ롥
			FALSE  äƤʤ
*/
int	has_CRYPT_SharedKey()
{
	if (CRYPT_SharedKey==NULL)	  return FALSE;
	if (CRYPT_SharedKey->buf==NULL) return FALSE;
	return  TRUE;
}





/**
void	clear_CRYPT_parameter()

	ǽŹѥѥ᡼롥

*/
void	clear_CRYPT_parameter()
{
	free_EVPAPI_Buffer();
	del_Buffer(&CRYPT_SharedKey);
	CRYPT_SharedKey = NULL;
	CRYPT_Algorism  = 0;
	KEYEX_Algorism  = 0;
}










///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

/**
žǡʥƥȡ˷

	̾žǡ  			[ǡ][\r][\n]
	̾žǡʣԡˡ	[ǡ][\r][\n][ǡ][\r][\n]...[\r][\n][END][\r][\n]
	Ź沽žǡ		[Ź沽ǡ][\r][\n] ʰԡ
									|梪[ǡ][\r][\n]....[\r][\n][END][\r][\n]

	˥ǡžȤ\r\n ΥǡκǸˤĤΤŹ沽줿ǡκǸ
		ˤĤΤ褯դʤȤʤ
*/


/**
int	tcp_send_crypt_mesg	(int sock, char*	mesg, Buffer* key)
int	tcp_send_crypt_sBuffer(int sock, Buffer* mesg, Buffer* key)

	ǽŹ沽бžؿŹ沽ǡκǸˤɬ \r\n Ĥǡ
		κǸ \r\n ϥ桼Ǥղä̾ϤĤˡ
		CRYPT_Algorism  0 ǤʤˤϰŹ沽(+\r\n)롥

		  tcp_send_crypt_mesgln(), tcp_send_crypt_sBufferln() ϺǸβԥɤ
		갷𤹤ΤʤɤʤȻפˡ tcp_send_mesgln(),
		  tcp_send_sBufferln()ȤϻȤۤʤ뤳ȤˤʤΤդɬס

	sock  -- å
		mesg  -- žǡ
		key	-- Ź渰ؤΥݥ󥿡NULLξϥǥեȸCRYPT_SharedKeyˤȤ	

	͡0ʾ塡žǡ
0̤̿顼

	㡧 tcp_send_crypt_mesg(sock, "OK\r\n");

*/
int	tcp_send_crypt_mesg(int sock, char* mesg, Buffer* key)
{
	int	cc;
	Buffer buf, enc;

	if (mesg==NULL) return -1;
	//DEBUG_MODE print_escape(" SEND -> [%s]\n", mesg);

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		buf = make_Buffer_bystr(mesg);
		enc = encode_EVPAPI_Buffer(buf, *key);
		free_Buffer(&buf);
		buf = encode_base64_Buffer(enc);
		free_Buffer(&enc);
		//DEBUG_MODE print_escape("CSEND -> [%s]\n", (char*)buf.buf);
		cc = tcp_send_sBufferln(sock, &buf);
		free_Buffer(&buf);
	}
	else {
		cc = tcp_send_mesg(sock, mesg);
	}

	return cc;
}





int	tcp_send_crypt_sBuffer(int sock, Buffer* mesg, Buffer* key)
{
	int	cc;
	Buffer buf, enc;

	if (mesg==NULL) return -1;
	//DEBUG_MODE print_escape(" SEND -> [%s]\n", (char*)mesg->buf);

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		enc = encode_EVPAPI_Buffer(*mesg, *key);
		buf = encode_base64_Buffer(enc);
		free_Buffer(&enc);
		//DEBUG_MODE print_escape("CSEND -> [%s]\n", (char*)buf.buf);
		cc = tcp_send_sBufferln(sock, &buf);
		free_Buffer(&buf);
	}
	else {
		cc = tcp_send_sBuffer(sock, mesg);
	}

	return cc;
}






/**
Buffer  get_plain_message(char*  mesg, Buffer* key)
Buffer  get_plain_sBuffer(Buffer mesg, Buffer* key)
Buffer  get_crypt_message(char*  mesg, Buffer* key)
Buffer  get_crypt_sBuffer(Buffer mesg, Buffer* key)

	ǽŹ桤沽ؿŹ沽˲ä Base64沽Ԥʤ
			get_plain_	Base64ǥ  沽
			get_crypt_	Ź沽  Base64沽
		  CRYPT_Algorism  0 ξѴԤʤʤ

	mesg  -- Ѵå
		key	-- Ź渰ؤΥݥ󥿡NULLξϥǥեȸCRYPT_SharedKeyˤȤ	

	͡Ѵ줿å	
*/
Buffer  get_plain_message(char* mesg, Buffer* key)
{
	Buffer  buf, dec;

	buf = make_Buffer_bystr(mesg);
	//DEBUG_MODE print_escape(" MESG -> [%s]\n", mesg);

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		dec = decode_base64_Buffer(buf);
		free_Buffer(&buf);
		buf = decode_EVPAPI_Buffer(dec, *key);
		free_Buffer(&dec);
		//DEBUG_MODE print_escape("DMESG -> [%s]\n", (char*)buf.buf);
	}
	return buf;
}





Buffer  get_plain_sBuffer(Buffer mesg, Buffer* key)
{
	Buffer buf, dec;

	buf = dup_Buffer(mesg);
	//DEBUG_MODE print_escape(" MESG -> [%s]\n", (char*)mesg.buf);

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		dec = decode_base64_Buffer(buf);
		free_Buffer(&buf);
		buf = decode_EVPAPI_Buffer(dec, *key);
		free_Buffer(&dec);
		//DEBUG_MODE print_escape("DMESG -> [%s]\n", (char*)buf.buf);
	}
	return buf;
}




Buffer  get_crypt_message(char* mesg, Buffer* key)
{
	Buffer  buf, enc;

	buf = make_Buffer_bystr(mesg);

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		enc = encode_EVPAPI_Buffer(buf, *key);
		free_Buffer(&buf);
		buf = encode_base64_Buffer(enc);
		free_Buffer(&enc);
	}
	return buf;
}




Buffer  get_crypt_sBuffer(Buffer mesg, Buffer* key)
{
	Buffer  buf, enc;

	buf = dup_Buffer(mesg);

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		enc = encode_EVPAPI_Buffer(buf, *key);
		free_Buffer(&buf);
		buf = encode_base64_Buffer(enc);
		free_Buffer(&enc);
	}
	return buf;
}





///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Client's Side Check 
//

/**
int	check_server_spki(char* filename, Buffer ipaddr, Buffer spki)

	ǽ: Ф SPKI򡤰¸Ƥ SPKIӤơФ򸡺롥
		  եSPKI̵ϡΥФȤơIPɥ쥹SPKI¸롥	
		  饤¦ǥФǧ˻Ѥ롥

	: 	filename -- ¸Ƥե
			ipaddr	-- ФIPɥ쥹ʸ󷿡㡧192.168.1.1
			spki	 -- ФSPKI(DER)

	: TRUE	ФSPKIϰ¸SPKI˰פޤϿΥС
			FALSE  ФSPKIϰ¸SPKI˰פʤ
 */
int	check_server_spki(Buffer ipaddr, Buffer spki, char* filename)
{
	Buffer  buf;
	FILE*	fp;

	buf = init_Buffer();

	fp = fopen(filename, "rb");
	if (fp!=NULL) {
		buf = read_spki_with_ipaddr(ipaddr, fp);
		fclose(fp);
		if (buf.buf!=NULL) {
			if (bincmp_Buffer(buf, spki)) {
				free_Buffer(&buf);
				return FALSE;
			}
		}
	}

	if (buf.buf==NULL) {
		fp = file_chmod_open(filename, "a", S_IRUSR | S_IWUSR);
		save_spki_with_ipaddr(ipaddr, spki, fp);
		fclose(fp);
	}

	return TRUE;
}





/**
int	save_spki_with_ipaddr(Buffer ipa, Buffer pki, FILE* fp)

	ǽФθX.509 SubjectPublicKeyInfoˤ̻identȶ˥ե¸롥
		  ̻Ҥˤ̾ IPɥ쥹Ѥ롥
		  ̻ҡν¸롥˥ե뤬¸ߤ
		ǡϥեκǸɲä롥
		  ̻ҤIPɥ쥹Ѥ뤳Ȥˤꡤ饤¦ǤΥǧڤ˻Ѥ롥

	ident -- ̻ҡ̾ϥФIPɥ쥹
		  pki 	-- ¸븰DERˡ
		  mode	-- FBRTL_BASE64	BASE64Ѵ¸롥

	: TRUE	
			FALSE  ԡ
*/
int	save_spki_with_ipaddr(Buffer ipa, Buffer pki, FILE* fp)
{	
	unsigned int  md;

	if (fp==NULL) return FALSE;

	md = FBRTL_IPADDRESS | FBRTL_STRING;
	if (!save_taggedBuffer(ipa, fp, md, FALSE)) return FALSE;

	md = FBRTL_SPKI | FBRTL_ORIGINAL;
	if (!save_taggedBuffer(pki, fp, md, FALSE)) return FALSE;

	return  TRUE;
}






/**
Buffer  read_spki_with_ipaddr(Buffer ipa, FILE* fp)

	ǽIPɥ쥹 ipaĥФθX.509 SubjectPublicKeyInfoˤե뤫ɤ߹ࡥ

	ipa  -- IPɥ쥹
		fp	-- IPɥ쥹

	͡IPɥ쥹 ipaθ(DER)
*/
Buffer  read_spki_with_ipaddr(Buffer ipa, FILE* fp)
{
	unsigned int md;
	Buffer	ips, pki;

	pki = init_Buffer();
	if (ipa.buf==NULL) return pki;

	md  = FBRTL_IPADDRESS | FBRTL_STRING;
	ips = read_taggedBuffer(fp, &md);
	while (!feof(fp) && strcmp_Buffer(ipa, ips)) {
		ips = read_taggedBuffer(fp, &md);
	}
		
	if (!strcmp_Buffer(ipa, ips)) {
		md  = FBRTL_SPKI | FBRTL_ORIGINAL;	
		pki = read_taggedBuffer(fp, &md);
	}
	free_Buffer(&ips);

	return pki;
}







///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// EVP API
//

/**
int	init_EVPAPI_Buffer(int type)

	ǽ̸ŹΥ르ꥺꤹ롥
		  ٤ˡƱˡʣΰŹ沽֥ȤϻǤʤ
		򥯥ꥢˤ free_EVPAPI_Buffer()Ѥ롥

	type  --  Ź沽֥ȡʰŹ沽ˡ

	: TRUE	
			FALSE  ԡ

	Ź沽֥Ȥμʰˡ
		AES:	  EVP_aes_#_X()  # 128, 192, 256  X ecb, cbc, cfb, ofb  㡧EVP_aes_128_cbc()
		Blowfish: EVP_bf_X()	 X ecb, cbc, cfb, ofb
		DES:	  EVP_des_X()	X ecb, cbc, cfb, ofb
		3DES:	 EVP_des_ede(),  EVP_des_ede_X()	 X cbc, cfb, ofb
				  EVP_des_ede3(), EVP_des_ede3_X()	X cbc, cfb, ofb
		RC4:	  EVP_rc4(), EVP_rc4_40()
*/
int	init_EVPAPI_Buffer(int type)
{
	if (type==SSL_AES128CBC) {
		CRYPT_Type	 = EVP_aes_128_cbc();
		CRYPT_Algorism = SSL_AES128CBC;
	}
	else if (type==SSL_3DES3CBC) {
		CRYPT_Type	 = EVP_des_ede3_cbc();
		CRYPT_Algorism = SSL_3DES3CBC;
	}
	else {
		CRYPT_Type	 = NULL;
		CRYPT_Algorism = 0;
		return FALSE;
	}

	return TRUE;
}




/**
void	free_EVPAPI_Buffer()

	ǽŹ沽ѥ᡼򥯥ꥢ롥

*/
void	free_EVPAPI_Buffer()
{
	CRYPT_Type	 = NULL;
	CRYPT_Algorism = 0;
}





/**
Buffer  decode_EVPAPI_Buffer(Buffer buf, Buffer shkey)

	ǽinit_EVPAPI_Buffer() ˤäƻꤵ줿ˡˤ Źʸbuf椹롥

	buf  -- 椹Źǡ

	͡ʸʿʸ
*/
Buffer  decode_EVPAPI_Buffer(Buffer buf, Buffer shkey)
{
	int		sz, ss;
	Buffer dec;
	EVP_CIPHER_CTX* ctx;
	unsigned char*  iv;

	dec = init_Buffer();
	if (CRYPT_SharedKey==NULL || CRYPT_Type==NULL) return dec;

	iv  = (unsigned char*)&(shkey.buf[shkey.vldsz - SSL_IV_SIZE]);

	ctx = (EVP_CIPHER_CTX*)malloc(sizeof(EVP_CIPHER_CTX));
	EVP_CIPHER_CTX_init(ctx);
	//EVP_DecryptInit_ex(ctx, CRYPT_Type, NULL, shkey.buf, NULL);
	EVP_DecryptInit_ex(ctx, CRYPT_Type, NULL, shkey.buf, iv);

	dec = make_Buffer(buf.vldsz + EVP_CIPHER_CTX_block_size(ctx) + 1);
	if (dec.buf==NULL) return dec;

	EVP_DecryptUpdate(ctx, dec.buf, &sz, buf.buf, buf.vldsz);
	EVP_DecryptFinal_ex(ctx, &(dec.buf[sz]), &ss);
	dec.vldsz = sz + ss;
	dec.buf[dec.vldsz] = '\0';

	EVP_CIPHER_CTX_cleanup(ctx);
	free(ctx);
	return dec;
}





/**
Buffer  encode_EVPAPI_Buffer(Buffer buf, Buffer shkey)

	ǽinit_EVPAPI_Buffer() ˤäƻꤵ줿ˡˤ buf Ź沽롥
		   CRYPT_SharedKey Ȥ
		  Ź沽 SSL_ENC_BLCKSZ ByteˡŹ沽ʥ֥åŹ

	buf  -- Ź沽ǡ

	͡Źʸ
*/
Buffer  encode_EVPAPI_Buffer(Buffer buf, Buffer shkey)
{
	int		i, len, ss=0, sz;
	Buffer enc;
	EVP_CIPHER_CTX* ctx;
	unsigned char*  iv;

	enc = init_Buffer();
	if (CRYPT_SharedKey==NULL || CRYPT_Type==NULL) return enc;

	iv  = (unsigned char*)&(shkey.buf[shkey.vldsz - SSL_IV_SIZE]);

	ctx = (EVP_CIPHER_CTX*)malloc(sizeof(EVP_CIPHER_CTX));
	EVP_CIPHER_CTX_init(ctx);
	//EVP_EncryptInit_ex(ctx, CRYPT_Type, NULL, shkey.buf, NULL);
	EVP_EncryptInit_ex(ctx, CRYPT_Type, NULL, shkey.buf, iv);

	len = buf.vldsz;
	enc = make_Buffer(len + EVP_CIPHER_CTX_block_size(ctx));
	if (enc.buf==NULL) return enc;

	for (i=0; i<len/SSL_ENC_BLCKSZ; i++) {
		EVP_EncryptUpdate(ctx, &(enc.buf[ss]), &sz, &(buf.buf[i*SSL_ENC_BLCKSZ]), SSL_ENC_BLCKSZ);
		ss += sz;
	}
	if (len%SSL_ENC_BLCKSZ!=0) {
		EVP_EncryptUpdate(ctx, &(enc.buf[ss]), &sz, &(buf.buf[i*SSL_ENC_BLCKSZ]), len%SSL_ENC_BLCKSZ);
		ss += sz;
	}
	EVP_EncryptFinal_ex(ctx, &(enc.buf[ss]), &sz);
	enc.vldsz = ss + sz;

	EVP_CIPHER_CTX_cleanup(ctx);
	free(ctx);
	return  enc;
}






///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  Diffie-Hellman ˡ
//

/**
int	save_DHspki_with_private(Buffer pki, FILE* fp)

	ǽDiffie-Hellman θX.509 SubjectPublicKeyInfopkiȥץ饤١ȸ
		  (ѿDHkey)ե¸롥󡤥ץ饤١ȸν
	񤭹ޤ롥˥ե뤬¸ߤ硤ƤϾ񤭤롥

	pki -- ¸븰DERˡ
		  fp  -- եݥ 

	͡TRUE  
			FALSE ԡեƤݾڤʤ
*/
int	save_DHspki_with_private(Buffer pki, FILE* fp)
{	
	unsigned int  md;
	Buffer pv;

	if (fp==NULL) return FALSE;

	md = FBRTL_SPKI | FBRTL_ORIGINAL;
	if (!save_taggedBuffer(pki, fp, md, FALSE)) return FALSE;

	pv = get_DHprivatekey(DHkey);
	if (pv.buf==NULL) return FALSE;
	md = FBRTL_PRIV_KEY | FBRTL_ORIGINAL;
	if (!save_taggedBuffer(pv,  fp, md, FALSE)) return FALSE;
	free_Buffer(&pv);

	return  TRUE;
}





/**
Buffer  read_DHspki_with_private(FILE* fp)

	ǽDiffie-Hellman θX.509 SubjectPublicKeyInfoˤȥץ饤ڡȸ
ե뤫ɤ߹ࡥ

	fp  -- եݥ 

	͡ɤ߹
*/
Buffer  read_DHspki_with_private(FILE* fp)
{
	int  n, code;
	DH*  dh=NULL;
	unsigned int  md;
	Buffer	pp, pv, pk, gk, yk;

	pp = init_Buffer();
	if (fp==NULL) return pp;

	md = FBRTL_SPKI | FBRTL_ORIGINAL;
	pp = read_taggedBuffer(fp, &md);
	if (pp.buf==NULL) return pp;

	dh = DH_new();
	if (dh==NULL) {
		free_Buffer(&pp);
		return pp;
	}
	
	pk = get_DHPkey(pp);
	gk = get_DHGkey(pp);
	yk = get_DHYkey(pp);
	dh->p	= BN_bin2bn((const unsigned char*)(pk.buf), pk.vldsz, NULL);
	dh->g	= BN_bin2bn((const unsigned char*)(gk.buf), gk.vldsz, NULL);
	dh->pub_key = BN_bin2bn((const unsigned char*)(yk.buf), yk.vldsz, NULL);
	free_Buffer(&pk);
	free_Buffer(&gk);
	free_Buffer(&yk);

	// Υå
	n = DH_check(dh, &code);
	if (n!=1 || code!=0) {
		DH_free(dh);
		free_Buffer(&pp);
		return pp;
	}

	// Private KEY ɤ߹
	md = FBRTL_PRIV_KEY | FBRTL_ORIGINAL;
	pv = read_taggedBuffer(fp, &md);
	if (pv.buf==NULL) return pp;

	dh->priv_key = BN_bin2bn((const unsigned char*)(pv.buf), pv.vldsz, NULL);
	free_Buffer(&pv);

	DHkey = dh;
	return  pp;
}






/**
Buffer  get_DHspki_ff(char* filename, int ks)

	ǽ: ե뤫 Diffie-Hellman θɤ߹ࡥʲξˤksΥθ
		  򿷤ե¸Ƥ֤
				1. ե뤬¸ߤʤɤ߹ʤ
				2. ե˥ץ饤١ȸ¸Ƥʤ
				3. եθĹ ksû
		  ѿ DH* DHkey DHθѥ᡼롥

	: 	filename -- ¸Ƥե
			ks	-- θĹ(Bit)

	: DERθ
 */
Buffer  get_DHspki_ff(char* filename, int ks)
{
	Buffer  pki;
	FILE*	fp;

	pki = init_Buffer();
	if (filename==NULL) return pki;

	if (file_exist(filename)) {
		debug_message("Load DH public key. ");
		fp = fopen(filename, "rb");
		pki = read_DHspki_with_private(fp);
		fclose(fp);
		debug_message("... done.\n");
		if (pki.buf!=NULL) {
			if (DH_size(DHkey)<(ks+7)/8 || DHkey->priv_key==NULL) free_Buffer(&pki);
		}
	}

	if (pki.buf==NULL) {
		debug_message("Generate DH public key. ");
		pki = gen_DHspki(ks);
		debug_message("... done.\n");

		fp = file_chmod_open(filename, "w", S_IRUSR | S_IWUSR);
		if (fp!=NULL) {
			save_DHspki_with_private(pki, fp);
			fclose(fp);
		}
	}

	/*
	DEBUG_MODE {
		Buffer enc;
		enc = encode_base64_Buffer(pki);
		debug_message("SPKI = [%s]\n", enc.buf);
		free_Buffer(&enc);
	}*/
	return pki;
}








/**
Buffer  gen_DHspki(int ks)

	ǽ: Diffie-Hellman θ,δʾX.509 SubjectPublicKeyInfo
		  DER֤
		  ѿ DH* DHkey DHθѥ᡼롥

	: ks  -- Ĺ(Bit)512 1024ꡥ

	: DERθ
 */
Buffer  gen_DHspki(int ks)
{
	int	   sz, n, code;
	Buffer px, pp, pk;

	pk = init_Buffer();

	//if (!RAND_load_file("/dev/random", 1024)) return pk;
	debug_message("Load /dev/urandom.");
	if (!RAND_load_file("/dev/urandom", 1024)) return pk;

	do {
		debug_message("Generate parameters.");
		DHkey = DH_generate_parameters(ks, DH_GENERATOR_2, NULL, NULL);
		n = DH_check(DHkey, &code);
	} while (n!=1 || code!=0);

	debug_message("Generate key.");
	DH_generate_key(DHkey);

	debug_message("Check key size.");
	sz = i2d_DHparams(DHkey, NULL);			 	// ѥ᥿Υ򸡺 
	pp = px = make_Buffer(sz);				  	// ѥ᥿ 
	if (pp.buf==NULL) {
		DH_free(DHkey);
		return pk;
	}
	pp.vldsz = i2d_DHparams(DHkey, &(px.buf));  // ѥ᥿(P,G) DERءpp.buf˳Ǽ 
												// px.buf˲롥

//	sz = DH_size(DHkey);
	sz = BN_num_bytes(DHkey->pub_key);
	px = make_Buffer(sz);
	if (px.buf==NULL) {
		DH_free(DHkey);
		free_Buffer(&pp);
		return pk;
	}

//	for (i=0; i<sz; i++) px.buf[i] = ((unsigned char*)(DHkey->pub_key->d))[sz-i-1];
	px.vldsz = BN_bn2bin(DHkey->pub_key, px.buf);

	pk = join_DHpubkey(pp, px);					// pp -> DHѥ᥿(P,G),  px-> Y

	free_Buffer(&pp);
	free_Buffer(&px);

	return pk;
}






/**
Buffer  gen_DHspki_fs(Buffer pki)

	ǽ: ФθξX.509 SubjectPublicKeyInfo, DERˤ P,G
		  ʬθX.509 SPKI, DERˤФ
		  ѿ DH* DHkey DHθѥ᡼롥

	: pki -- θDER

	: ʬθξX.509 SubjectPublicKeyInfo, DER
 */
Buffer  gen_DHspki_fs(Buffer pki)
{
	int	   sz, n, code;
	Buffer px, pp, pk;
	Buffer pkey, gkey;

	pk= init_Buffer();
	DHkey = DH_new();
	if (DHkey==NULL) return pk;

	pkey = get_DHPkey(pki);
	gkey = get_DHGkey(pki);
	if (pkey.buf==NULL || gkey.buf==NULL) {
		DH_free(DHkey);
		return pk;
	}
	DHkey->p = BN_bin2bn((const unsigned char*)(pkey.buf), pkey.vldsz, NULL);
	DHkey->g = BN_bin2bn((const unsigned char*)(gkey.buf), gkey.vldsz, NULL);
	free_Buffer(&pkey);
	free_Buffer(&gkey);

	n = DH_check(DHkey, &code);
	if (n!=1 || code!=0) {
		DH_free(DHkey);
		return pk;
	}
	DH_generate_key(DHkey);

	sz = i2d_DHparams(DHkey, NULL);			 		// ѥ᥿Υ򸡺 
	pp = px = make_Buffer(sz);				  		// ѥ᥿ 
	if (pp.buf==NULL) {
		DH_free(DHkey);
		return pk;
	}
	pp.vldsz = i2d_DHparams(DHkey, &(px.buf));  	// ѥ᥿(P,G) DERءpp.buf˳Ǽ 
													// px.buf˲롥
	sz = BN_num_bytes(DHkey->pub_key);
	px = make_Buffer(sz);
	if (px.buf==NULL) {
		DH_free(DHkey);
		free_Buffer(&pp);
		return px;
	}
	px.vldsz = BN_bn2bin(DHkey->pub_key, px.buf);	// (Y) DER 

	pk = join_DHpubkey(pp, px);						// pp -> DHѥ᥿(P,G),  px-> Y

	free_Buffer(&pp);
	free_Buffer(&px);

	return pk;
}





/**
Buffer get_DHsharedkey(Buffer dec)

	ǽ: θξX.509 SubjectPublicKeyInfo, DERˤDHkeyʼʬθ
		  򸵤˶̤Ф
		  ѿ DH* DHkey ѡ DHkey ˤ DH_generate_key(DHkey)gen_DHspki() ޤ 
		  gen_DHspki_fs()ǤġˤˤäƤΥѥ᡼P,G,Y,̩ˤꤵƤʤФʤʤ 

	ykey  -- θ

	̸͡ʥХʥ

	͡man -M /usr/local/ssl/man bn
*/
Buffer get_DHsharedkey(Buffer dec)
{
	Buffer  ykey, skey;
	
	skey = init_Buffer();
	ykey = get_DHYkey(dec);
	if (ykey.buf==NULL) return skey;
	skey = get_DHsharedkey_fY(ykey);
	
	free_Buffer(&ykey);
	return skey;
}







/**
Buffer get_DHsharedkey_fY(Buffer ykey)

	ǽ: ΡDiffie-Hellman ΡYDHkeyʼʬθˤ򸵤˶̸Ф
		  ѿ DHkey ѡ DHkey ˤ DH_generate_key()gen_DHspki() ޤ 
		  gen_DHspki_fs()ǤġˤˤäƤΥѥ᡼P,G,Y,̩ˤꤵ
		  ʤФʤʤ 

	ykey  --  Yʸ

	̸͡ʥХʥ

	͡man -M /usr/local/ssl/man bn
*/
Buffer get_DHsharedkey_fY(Buffer ykey)
{
	int sz, n;
	Buffer  buf;
	BIGNUM* yk;

	yk = BN_bin2bn((const unsigned char*)(ykey.buf), ykey.vldsz, NULL);
	sz = DH_size(DHkey);

	buf = make_Buffer(sz);
	n	= DH_compute_key((unsigned char*)buf.buf, yk, DHkey);
	buf.vldsz = sz;

	BN_free(yk);
	return buf;
}





/**
Buffer	get_DHYkey(Buffer param)

	ǽ: X.509 SubjectPublicKeyInfo DER顤Diffie-Hellman YФ 

	: param  -- X.509 SubjectPublicKeyInfo DER

	͡YʥХʥ

	͡ [SEQ	[SEQ	[OBJ  Algor]
						 [SEQ  [INT  P-key]
								[INT  G-key]
								[INT  P-keysize - 1]
						 ]
					]
					[BIT  Seed(0x00)  [INT  Y-key]]
			]  
*/
Buffer	get_DHYkey(Buffer param)
{
	int	 i, lp, sz=0;
	Buffer  pp;
	pp = init_Buffer();

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;
	sz = sz + lp;

	sz = skip_DERtag(param, ASN1_BIT, sz, &lp);
	if (sz<0) return pp;
	sz++;						// for Seed(0x00)

	sz = skip_DERtag(param, ASN1_INT, sz, &lp);
	if (sz<0) return pp;

	pp = make_Buffer(lp);
	if (pp.buf==NULL) return pp;
	for (i=0; i<lp; i++) pp.buf[i] = param.buf[sz+i];
	pp.vldsz = lp;
	return pp;
}

	



/**
Buffer	get_DHPkey(Buffer param)

	ǽ: X.509 SubjectPublicKeyInfo DER顤Diffie-Hellman PФ 

	: param  -- X.509 SubjectPublicKeyInfo DER

	͡PʥХʥ

	͡ [SEQ	[SEQ	[OBJ  Algor]
						 [SEQ  [INT  P-key]
								[INT  G-key]
								[INT  P-keysize - 1]
						 ]
					]
					[BIT  Seed(0x00)  [INT  Y-key]]
			]  
*/
Buffer	get_DHPkey(Buffer param)
{
	int	 i, lp, sz=0;
	Buffer  pp;
	pp = init_Buffer();

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_OBJ, sz, &lp);
	if (sz<0) return pp;
	sz = sz + lp;

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_INT, sz, &lp);
	if (sz<0) return pp;

	pp = make_Buffer(lp);
	if (pp.buf==NULL) return pp;
	for (i=0; i<lp; i++) pp.buf[i] = param.buf[sz+i];
	pp.vldsz = lp;
	return pp;
}



	

/**
Buffer	get_DHGkey(Buffer param)

	ǽ: X.509 SubjectPublicKeyInfo DER顤Diffie-Hellman GФ 
		  ̤ 2  5

	: param  -- X.509 SubjectPublicKeyInfo DER
 
	͡GʥХʥ

	͡ [SEQ	[SEQ	[OBJ  Algor]
						 [SEQ  [INT  P-key]
								[INT  G-key]
								[INT  P-keysize - 1]
						 ]
					]
					[BIT  Seed(0x00)  [INT  Y-key]]
			]  
*/
Buffer	get_DHGkey(Buffer param)
{
	int	 i, lp, sz=0;
	Buffer  pp;
	pp = init_Buffer();

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_OBJ, sz, &lp);
	if (sz<0) return pp;
	sz = sz + lp;

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_INT, sz, &lp);
	if (sz<0) return pp;
	sz = sz + lp;

	sz = skip_DERtag(param, ASN1_INT, sz, &lp);
	if (sz<0) return pp;

	pp = make_Buffer(lp);
	if (pp.buf==NULL) return pp;
	for (i=0; i<lp; i++) pp.buf[i] = param.buf[sz+i];
	pp.vldsz = lp;
	return pp;
}

	



/**
Buffer	get_DHalgor(Buffer param)

	ǽ: X.509 SubjectPublicKeyInfo DER顤르ꥺ(Algor)Ф 

	: param  -- X.509 SubjectPublicKeyInfo DER
 
	͡르ꥺʥХʥ

	͡ [SEQ	[SEQ	[OBJ  Algor]
						 [SEQ  [INT  P-key]
								[INT  G-key]
								[INT  P-keysize - 1]
						 ]
					]
					[BIT  Seed(0x00)  [INT  Y-key]]
			]  
*/
Buffer	get_DHalgor(Buffer param)
{
	int	 i, lp, sz=0;
	Buffer  pp;
	pp = init_Buffer();

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_OBJ, sz, &lp);
	if (sz<0) return pp;

	pp = make_Buffer(lp);
	if (pp.buf==NULL) return pp;
	for (i=0; i<lp; i++) pp.buf[i] = param.buf[sz+i];
	pp.vldsz = lp;
	return pp;
}

	



/**
Buffer  get_DHprivatekey(DH* dh)

	ǽ: DH dh ץ饤١ȸФ֤

	: dh  -- DH
 
	͡ץ饤١ȸ
 */
Buffer  get_DHprivatekey(DH* dh)
{
	int	sz;
	Buffer pv;

	sz = BN_num_bytes(dh->priv_key);
	pv = make_Buffer(sz);
	if (pv.buf==NULL) return pv;
	pv.vldsz = BN_bn2bin(dh->priv_key, pv.buf);

	return pv;
}






/**
Buffer	join_DHpubkey(Buffer param, Buffer key)

	ǽ: Diffie-Hellman θ򴹤Τ X.509 SubjectPublicKeyInfo 롥
		  DHѥ᥿(P+G)DH(Y)DER礷,ʸDERĤ롥

	: param  -- DHѥ᡼(P,G)i2d_DHparams()ˤ DER
		  key	 -- DH(Y) DER

	: DERθ  [[Algor + [P + G + PKeySize]] + [BIT [Y]]]
		 
	͡
		param Υǡ
			[SEQ  [INT  P-key]
				  [INT  G-key]
			]
		Ǥ롥 Y-key 顡Υǡ롥

			[SEQ	[SEQ  [OBJ  Algor]
						 [SEQ  [INT  P-key]
								[INT  G-key]
								[INT  P-keysize - 1]
						 ]
					]
					[BIT(̤bit̵)  [INT  Y-key]]
			]  


	:	DHΥ르ꥺ {0x06,0x07,0x2a,0x86,0x48,0xce,0x3e,0x02,0x01}
		  ȻפΤ, RSAΥ르ꥺư褦

*/
Buffer	join_DHpubkey(Buffer param, Buffer key)
{
//	unsigned char dh_algor[]={0x06,0x07,0x2a,0x86,0x48,0xce,0x3e,0x02,0x01};
	unsigned char dh_algor[]={0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x03,0x01}; 
											//  RSA르ꥺࡩ 
	int	 ls, lp, la, sz;
	Buffer  px, pp, pm;

	// [P + G]  pp 
	pp = init_Buffer();
	sz = skip_DERtag(param, ASN1_SEQ, 0, &lp);
	if (sz<0) return pp;
	pp.buf	= param.buf	+ sz;
	pp.bufsz = param.bufsz - sz;
	pp.vldsz = param.vldsz - sz;

	// []  pm 
	px = int2DER(key.vldsz*8-1);
	pm = toDER(px, ASN1_INT);
	ls = pm.vldsz;
	free_Buffer(&px);		 

	// pp[P + G] + pm[]  pm 
	px = make_Buffer(lp+ls); 
	memcpy(px.buf,	pp.buf, lp);
	memcpy(px.buf+lp, pm.buf, ls);  
	px.vldsz = lp + ls;
	free_Buffer(&pm);			  // pp freeƤϤʤ 
	pm = toDER(px, ASN1_SEQ); 
	ls = pm.vldsz;
	free_Buffer(&px);

	// dh_algor[르ꥺ] + pm[P + G + ]  px 
	la = sizeof(dh_algor); 
	pp = make_Buffer(ls+la); 
	memcpy(pp.buf,  dh_algor, la);
	memcpy(pp.buf+la, pm.buf, ls);
	pp.vldsz = ls + la;
	free_Buffer(&pm);		 
	px = toDER(pp, ASN1_SEQ);
	ls = px.vldsz;
	free_Buffer(&pp);  

	// px[르ꥺ + P + G + ] + pp[Y]  pm 
	pm = toDER(key, ASN1_INT);
	pp = toDER(pm,  ASN1_BIT);
	lp = pp.vldsz;
	free_Buffer(&pm); 
	pm = make_Buffer(ls+lp);
	memcpy(pm.buf,	px.buf, ls);
	memcpy(pm.buf+ls, pp.buf, lp);
	pm.vldsz = ls + lp;
	free_Buffer(&px);
	free_Buffer(&pp);  

	pp = toDER(pm, ASN1_SEQ);
	free_Buffer(&pm);
	return pp;
}







///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// ASN.1 DER
//

/**
int  skip_DERtag(Buffer param, char tag, int ls, int* lp) 

	ǽ: ֥param ls ΰ֤[(tag)][ͤĹ]
		  åפơ[]ΰ(return)ȤΥͤĹ *lp ֤

	param -- ֥
		tag	-- ߤΥʳǧΤ˻
		  ls	-- ֥Ǥ	 
		  lp	-- ؿλˡΥΥͤĹǼ롥ͤϻꤷʤ

	͡return  -- ΥΥͤƬ֡
			lp	  -- ؿλˡΥΥͤĹǼ롥

	͡							ls
		  [֥] = .....[(tag)][ͤĹ(*lp)][][].......
									  							  return
		  []Ȥơ[֥]ޤ⤢ʳع¤
*/
int  skip_DERtag(Buffer param, unsigned char tag, int ls, int* lp) 
{
	int i, sz=-1;

	if ((unsigned char)param.buf[ls]==tag) {
		if ((unsigned char)param.buf[ls+1]>=0x80) {
			sz = (int)param.buf[ls+1] - 128;
			*lp = 0;
			for (i=ls+2; i<ls+sz+2; i++) {
				*lp *= 256;
				*lp += (unsigned char)param.buf[i];
			}	
		}
		else {
			sz = 0;
			*lp = (int)param.buf[ls+1];
		}
		//if ((unsigned char)param.buf[ls]==ASN1_BIT) sz++;
		sz = ls + sz + 2;
	}

	return sz;
}







/**
Buffer  toDER(Buffer pt, char tag)

	ǽ: ǡ DERѴ롥
		  ߤ ASN1_INT, ASN1_SEQ, ASN1_BIT Τߤ򥵥ݡȡ

	: tag  -- ǡΥASN1_INT, ASN1_SEQ, ASN1_BIT 򥵥ݡȡ
				  ǥեư  ANS1_SEQ

	: DERѴ줿ǡ

*/
Buffer  toDER(Buffer pt, char tag)
{
	int  sz, len, pp;
	unsigned char  cnt=0;
	Buffer	buf;

	len = get_DER_length(pt, tag);  
	buf = make_Buffer(len);
	sz = pt.vldsz;
	pp = len - sz;
	memcpy(buf.buf+pp, pt.buf, sz);

	pp--;
	if (tag==ASN1_INT) {
			if (pt.buf[0]>=0x80) {
			sz++;
			buf.buf[pp--] = 0x00;
		}
	}
	else if (tag==ASN1_BIT) {
		sz++;
		buf.buf[pp--] = 0x00;
	}

	buf.buf[0] = tag;
	if (sz>=128) {
		cnt++;
		while (sz>=256) {
			buf.buf[pp--] = sz % 256;
				sz >>= 8;
			cnt++;
		}
		buf.buf[pp] = (unsigned char)sz;
		buf.buf[1]  = 0x80 + cnt;
	}
	else {
		buf.buf[1] = (unsigned char)sz;
	}

	buf.vldsz = len;
	return buf;
}





/**
Buffer  int2DER(int n)

	ǽ:  DERΥХʥѴ롥,INTդʤ

	: n  -- Ѵ

	: DERΥХʥ
	
	Х: δؿǤ,intϰϤοͤʤ

*/
Buffer  int2DER(int n)
{
	int  ii, div, cnt;
	Buffer str;

	cnt = 1;
	div = n;
	while(div>=256) {
		div >>= 8;
		cnt++;
	}

	str = make_Buffer(cnt);
	ii = cnt - 1;

	while(n>=256) {
		str.buf[ii--] = (unsigned char)(n % 256);
		n >>= 8;
	}
	str.buf[0] = (unsigned char)n;
	str.vldsz  = cnt;

	return str;
}





/**
int  get_DER_length(Buffer pt, char tag)

	ǽ: ǡDERѴĹ׻롥
 
	: pt	-- ׻оݤΥǡ
		  tag  -- ǡΥASN1_INT, ASN1_SEQ, ASN1_BIT 򥵥ݡȡ
				  ǥեư ANS1_SEQ

	: ǡDERѴĹ顼ξ 0

*/
int  get_DER_length(Buffer pt, char tag)
{
	int  sz, div, cnt=0;

	sz = pt.vldsz;
	if (tag==ASN1_INT) {
			if (pt.buf[0]>=0x80) sz++;
	}
	else if (tag==ASN1_BIT) sz++;	

	div = sz;
	if (div>=128) cnt++;
	while (div>=256) {
			div >>= 8;
		cnt++;
	}
	sz = sz + cnt + 2;
	return sz;
}
	
	





///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// SSL/TLS
//
// 		Reference: 	http://h71000.www7.hp.com/doc/83final/BA554_90007/ch04s03.html
//					http://x68000.q-e-d.net/~68user/net/
//

/**
SSL/TLS ؿ  

	δؿǤϡSSL_CTX*  SSL* ѿϰабƤ
		Ψϰפʤ롥

*/



/**
void  ssl_init()

	ǽSSL/TLS νԤΩäơνԤäƤɤ

*/
void  ssl_init()
{
	SSL_library_init();
	SSL_load_error_strings();
}




/**
SSL*  ssl_client_connect(int sock)

	ǽSSL/TLSΥȥ꡼åȤȴϢդ롥
		ˤSSL򤷤٤륵СˤSSL/TLS̿ǽˤʤ롥

	sock SSL̿Ԥå
		  ca   ǧڶɤμʾ PEM
		  mode оΥåԤ
			   ON  Ԥǧڥ顼ξ NULL ֤
			   OFF ǤϹԤʤca  NULLξ϶Ū OFFˤʤ롥

	͡SSLѥȥ꡼ؤΥݥ󥿡
			顼ξ NULL֤롥
			//ξ ERR_print_errors_fp(stderr); ľΥ顼ƤΤ뤳ȤǤ롥

	աδؿˤäƼ SSL* ѿϡɬ ssl_close() ǥ뤳ȡ
SSL_shutdown(), SSL_free() Ѥ SSL_CTX* ѿǤʤΤǡ꡼򵯤

*/
SSL*  ssl_client_socket(int sock, char* ca, int mode)
{
	int      ret;
	SSL*  	 ssl;
	SSL_CTX* ssl_ctx;
	SSL_METHOD* meth;


	meth = SSLv23_client_method();
	ssl_ctx = SSL_CTX_new(meth);
	if (ssl_ctx==NULL) return NULL;

	ssl = SSL_new(ssl_ctx);
	if (ssl==NULL) {
		//DEBUG_MODE ERR_print_errors_fp(stderr);
		SSL_CTX_free(ssl_ctx);
		return NULL;
	}


	// ǧڶɥǡɤ߹PEMǡ
	if (ca!=NULL) SSL_CTX_load_verify_locations(ssl_ctx, ca, NULL);
	else mode = OFF;

	ret = SSL_set_fd(ssl, sock);
	if (ret!=1) {
		//DEBUG_MODE ERR_print_errors_fp(stderr);
		ssl_close(ssl);
		return NULL;
	}

	// Ф³
	ret = SSL_connect(ssl);
	if (ret!=1) {
		//DEBUG_MODE ERR_print_errors_fp(stderr);
		ssl_close(ssl);
		return NULL;
	}

	// оΥå
	if (mode==ON) {
		long lrt = SSL_get_verify_result(ssl);
		if (lrt!=X509_V_OK) {
			//DEBUG_MODE ERR_print_errors_fp(stderr);
			ssl_close(ssl);
			return NULL;
		}
	}

	return ssl;
}





/**
SSL*  ssl_server_socket(int sock, char* crt_fn, char* key_fn)

	ǽSSL/TLSΥTCPȥ꡼åȤȴϢդ롥
		  Ωä TCP³Ω֤ʤФʤʤ

	sock    SSL̿Ԥåȡsock  accept() ͤѤ롥
		  crt_fn  оΥե̾PEM
		  key_fn  Ф̩Υե̾PEM

	͡SSLѥȥ꡼ؤΥݥ󥿡
			顼ξ NULL֤롥

	աδؿˤäƼ SSL* ѿϡɬ ssl_close() ǥ뤳ȡ
SSL_shutdown(), SSL_free() Ѥ SSL_CTX* ѿǤʤΤǡ꡼򵯤

*/
SSL*  ssl_server_socket(int sock, char* crt_fn, char* key_fn)
{
	int  ret;
	SSL*  	 ssl;
	SSL_CTX* ssl_ctx;
	SSL_METHOD* meth;


	//SSL_library_init();
	//SSL_load_error_strings();

	meth = SSLv23_server_method();
	ssl_ctx = SSL_CTX_new(meth);
	if (ssl_ctx==NULL) return NULL;


	// о̩ɤ߹
	if (crt_fn!=NULL && key_fn!=NULL) {
		ret = SSL_CTX_use_certificate_file(ssl_ctx, crt_fn, SSL_FILETYPE_PEM);
		if (ret!=1) {
			//DEBUG_MODE ERR_print_errors_fp(stderr);
			SSL_CTX_free(ssl_ctx);
			return NULL;
		}
		ret = SSL_CTX_use_PrivateKey_file(ssl_ctx, key_fn, SSL_FILETYPE_PEM);
		if (ret!=1) {
			//DEBUG_MODE ERR_print_errors_fp(stderr);
			SSL_CTX_free(ssl_ctx);
			return NULL;
		}
		SSL_CTX_set_verify(ssl_ctx, SSL_VERIFY_PEER, NULL);
		SSL_CTX_set_verify_depth(ssl_ctx, 1);
	}


	ssl = SSL_new(ssl_ctx);
	if (ssl==NULL) {
		//DEBUG_MODE ERR_print_errors_fp(stderr);
		SSL_CTX_free(ssl_ctx);
		return NULL;
	}

	ret = SSL_set_fd(ssl, sock);
	if (ret!=1) {
		//DEBUG_MODE ERR_print_errors_fp(stderr);
		ssl_close(ssl);
		return NULL;
	}

	return ssl;
}





/**				
void  ssl_close(SSL* ssl)
				  
	ǽSSLȥ꡼򥯥Ѥѿ롥
		 
		  
		ssl	 SSLѥȥ꡼
			
	͡ʤ	 
*/
void  ssl_close(SSL* ssl)
{
	if (ssl!=NULL) {
		SSL_CTX* p = ssl->ctx;
		SSL_shutdown(ssl);
		SSL_free(ssl);
		if (p!=NULL) SSL_CTX_free(p);
	}
}





/**
tList*  ssl_get_cert_info(SSL* ssl)

	ǽSSLȥ꡼फξ롥Ωä ³ connect ƤʤȤʤ
		 
		  
		ssl	 SSLѥȥ꡼
			
	͡SSLξǼꥹȤؤΥݥ󥿡
			Ǥϡcipher, version, subject, issuer, before, after	 

*/
tList*  ssl_get_cert_info(SSL* ssl)
{
	tList* lt;
	tList* lp;
	char* pp;
	char  buf[LBUF];
	X509* x509;
	BIO*  bio;


	pp = (char*)SSL_get_cipher(ssl);
	lt = lp = add_tList_node_str(NULL, "cipher", pp);

	pp = SSL_get_cipher_version(ssl);
	lp = add_tList_node_str(lp, "version", pp);


	x509 = SSL_get_peer_certificate(ssl); 
	if (x509==NULL) return lt;

	bio = BIO_new(BIO_s_mem());
	if (bio==NULL) {
		X509_free(x509);
		return lt;
	}

	X509_NAME_print_ex(bio, X509_get_subject_name(x509), 0, XN_FLAG_RFC2253);
	BIO_gets(bio, buf, LBUF);
	lp = add_tList_node_str(lp, "subject", buf);

	X509_NAME_print_ex(bio, X509_get_issuer_name(x509), 0, XN_FLAG_RFC2253);
	BIO_gets(bio, buf, LBUF);
	lp = add_tList_node_str(lp, "issuer", buf);

	ASN1_TIME_print(bio, X509_get_notBefore(x509));
	BIO_gets(bio, buf, LBUF);
	lp = add_tList_node_str(lp, "before", buf);

	ASN1_TIME_print(bio, X509_get_notAfter(x509));
	BIO_gets(bio, buf, LBUF);
	lp = add_tList_node_str(lp, "after", buf);

	BIO_free(bio);
	X509_free(x509);

	return lt;
}







/////////////////////////////////////////////////////////////////
// SSL communications

/**				
int  ssl_recv(SSL* ssl, char* rmsg, int size)
					
	ǽ: SSL_read()åԥ󥰤ؿSSLͳǥǡ롥
					
	: ssl	 SSLѥȥ꡼
		  rmsg	 ѥǡХåե
		  size	 ǡХåեΥ
					
	: ˹ԤФΥХȿ
			Ԥ-1֤
			0 ξ

	see also tcp_recv() in Lib
*/  
int  ssl_recv(SSL* ssl, char* rmsg, int size)
{
	int cc;

	memset(rmsg, 0, size);
	cc = SSL_read(ssl, rmsg, size-1);
	 
	return cc;
}




/**				
int  ssl_send(SSL* ssl, char* smsg, int size)
					
	ǽ: SSL_write()åԥ󥰤ؿSSLͳǥǡ롥
		  ǡ(smsg)Υ size0ʲꤷϡsmsgʸ
		  Ǥȸʤ,ưŪ˷׻롥
					
	: ssl	 SSLѥȥ꡼
		  smsg	 ǡ
		  size	 ǡsmsgˤΥ 0ʲξ
				 smsgʸǤȤߤʤ
					
	: ϤХȿ
			Ԥˤ-1֤롥

	see also tcp_send() in Lib
*/
int  ssl_send(SSL* ssl, char* smsg, int size)
{
	int cc;

	if (size<=0) size = strlen(smsg);
	cc = SSL_write(ssl, smsg, size);
	
	return cc;
}




/**				
int  ssl_recv_mesg(int sock, SSL* ssl, char* mesg, int sz, int tm)
				  
	ǽSSLͳǥå(ʸ)롥Хʥġ
		  ॢȤ꤬ǽॢȤ 0ꤷ, recv_wait()
		  ؿƤӽФɤ߹߲ǽǡʤФ˥ॢ
		  Ȥʤ (RECV_TIMEOUTED֤)
		 
	:		 
		 sock	 åȵһ
		 ssl	 SSLѥȥ꡼
		 mesg	 ѥǡХåե
		 sz		 ǡХåեΥ
		 tm		 ॢȻ֡ñ̡
			
	:	  
		 1ʾ	Хȿ
		 0		餯¦å򥯥
		 -1		顼
		 RECV_TIMEOUTED		ॢȡ

	see also tcp_recv_mesg() in Lib
*/		
int  ssl_recv_mesg(int sock, SSL* ssl, char* mesg, int sz, int tm)
{
	int  cc;
				 
	if (recv_wait(sock, tm)) {
		cc = ssl_recv(ssl, mesg, sz);
		if (cc<=0) debug_message("SSL_RECV_MESG: Session Closed.\n");
	}
	else {
		debug_message("SSL_RECV_MESG: Time Out.\n");
		return RECV_TIMEOUTED;
	}		
	return cc;
}




/**				
int  ssl_send_mesg(SSL* ssl, char* mesg)
				  
	ǽSSLͳǥå(ʸ)롥
		 
			
		ssl	  SSLѥȥ꡼
		mesg  ѥå
			
	͡	 
		 ϤХȿ
		 Ԥˤ-1֤롥
					
	ǤϼΤϥޥǤ롥
	  #define  ssl_send_mesg(s, m)  ssl_send((s), (m), 0)
*/





/**				
int  ssl_send_mesgln(SSL* ssl, char* mesg)
				  
	ǽSSLå(ʸ)˲(\r\n)դä롥
		 
		  
		ssl	 	SSLѥȥ꡼
	  	mesg	ѥå
			
	͡	 
	  	Ϥʸ(ޤ)
	  	Ԥˤ-1֤롥
*/			 
int  ssl_send_mesgln(SSL* ssl, char* mesg)
{  
	int	cc, sz;
	char* buf;
	
	sz = strlen(mesg)+3;	// for CR+LF+0x00 
	buf = (char*)malloc(sz);
	if (buf==NULL) return -1;
	
	strncpy(buf, mesg, sz);
	strncat(buf, "\r\n", 2);
	cc = ssl_send(ssl, buf, strlen(buf));
	
	free(buf);
	return cc;
}




/**
int  ssl_recv_mstream(int sock, SSL* ssl, char* mesg, int sz, mstream* sb, int tm)

	ǽSSL/TSLͳǥå(ʸ)롥åϥåȥ꡼
		Хåե˰öХåե󥰤졤δؿˤԤɤ߽Ф롥mesgˤϺ
		sz-1ʸǼ롥⤷ХåեΰԤΥǡ sz-1礭
		Ϥ߽ФʬϼΤƤ롥
		  mesg˳ǼβԥɤϺ졤ˤɬ \0 롥
		  ॢȤ꤬ǽǥॢȤ 0ꤷ, ƤӽФ
		  ɤ߹߲ǽǡʤФ˥ॢȤȤʤ (RECV_TIMEOUTED ֤)
		  åȥ꡼ΥХåեݤƤʤϡǽ˸ƤӽФ줿
		ݤ롥öδؿѤơǡХåե󥰤顤åȤ
		  ޤǡɤ߼ˤɬƱȥ꡼ѤƤδؿƤӽФФ
		  Фʤʤ̵ϼǡݾڤʤ

	
	 	sock 	åȵһ
	 	ssl 	SSLѥȥ꡼
	  	mesg	ѥǡХåեͽώʬʥΰݤƤ
	  	sz	 	ǡХåեΥ
		sb	    ȥ꡼Хåեʥ󥰥ХåեΥȥ꡼Хåե
				ХåեݤƤʤСưŪ˳ݤ롥
	  	tm	 	ॢȻ֡ñ̡

	͡
	  	1ʾ	mesg˳ǼåΥХȿ
	  	0  		餯¦å򥯥
	  	-1 		顼
		-2  	 NULLΥǡ롥
		-3  	åХåե̵Τǳݤ褦Ȥݤ˼Ԥ
		-4  	åХåե˥ǡ¸ߤϤͳˤ˼Ԥ
		-5  	åХåեΥǡĹmesgĹ礭Ϥ߽ФʬϼΤƤ줿
	  	RECV_TIMEOUTED  	ॢȡ
*/
int  ssl_recv_mstream(int sock, SSL* ssl, char* mesg, int sz, mstream* sb, int tm)
{
	int  cc;
	unsigned char* pp;

	if (mesg==NULL || sb==NULL) return -2;
	memset(mesg, 0, sz);

	if (sb->buf==NULL) {
		*sb = make_mstream(RECVBUFSZ);
		if (sb->buf==NULL) return -3;
	}

	while (sb->datano==0) {
		cc = ssl_recv_mesg(sock, ssl, mesg, sz, tm);
		if (cc<=0) return cc;
		put_mstream(sb, (unsigned char*)mesg);
		memset(mesg, 0, sz);
	}

	pp = get_mstream(sb);
	if (pp==NULL) return -4;
	if (strlen((const char*)pp)>=(unsigned int)sz) {
		memcpy(mesg, pp, sz-1);
		free(pp);
		return -5;
	}
	memcpy(mesg, pp, strlen((const char*)pp));

	free(pp);
	return strlen(mesg);
}






/////////////////////////////////////////////////////////////////
// SSL with Buffer

/**
int  ssl_recv_Buffer(SSL* ssl, Buffer* str)

	ǽ: SSLͳǥǡ롥Хåե󥰤ʤ

	: ssl	 SSLѥȥ꡼
		  *str	 ѥǡХåեͽݤƤ

	: ˹ԤФΥХȿ
			Ԥ-1֤
			0 ξ
*/
int  ssl_recv_Buffer(SSL* ssl, Buffer* str)
{
	int cc;

	memset(str->buf, 0, str->bufsz);
	str->vldsz = 0;

	cc = SSL_read(ssl, str->buf, str->bufsz-1);
	if (cc>=0) str->vldsz = cc;

	return cc;
}






/**
int  ssl_send_Buffer(SSL* ssl, Buffer* str)

	ǽ: SSLͳǥǡ롥

	: ssl	 SSLѥȥ꡼
		  str	 ѥǡХåե

	: ϤХȿ
			Ԥˤ-1֤(send())

*/
int  ssl_send_Buffer(SSL* ssl, Buffer* str)
{
	int cc;

	if (str->vldsz<0) str->vldsz = strlen((const char*)str->buf);
	cc = SSL_write(ssl, str->buf, str->vldsz);
	return cc;
}






/**
int  ssl_recv_sBuffer(int sock, SSL* ssl, Buffer* str, int tm)

	ǽ: SSLͳʸǡ롥
		  ॢȤ꤬ǽॢȤ 0ꤷ, recv_wait()
		  ؿƤӽФɤ߹߲ǽǡʤФ˥ॢ
		  Ȥʤ (RECV_TIMEOUTED֤)

	: sock	 åȵһ
		  ssl	 SSLѥȥ꡼
		  *str	 ѥǡХåեͽݤƤ
		  tm	 ॢȻ֡ñ̡

	: 1ʾ	Хȿ
			0	  	餯¦å򥯥
			-1	  	顼
			RECV_TIMEOUTED	  	ॢȡ
*/
int  ssl_recv_sBuffer(int sock, SSL* ssl, Buffer* str, int tm)
{
	int cc;

	str->vldsz = 0;
	cc = ssl_recv_mesg(sock, ssl, (char*)str->buf, str->bufsz, tm);
	if (cc>=0) str->vldsz = cc;

	return cc;
}





/**
int  ssl_send_sBuffer(SSL* ssl, Buffer* str)

	ǽ: SSLͳʸǡ롥

	: ssl	 SSLѥȥ꡼
		  str	 ѥǡХåե

	: ϤХȿ
			Ԥˤ-1֤(send())

*/
int  ssl_send_sBuffer(SSL* ssl, Buffer* str)
{
	int cc;

	cc = SSL_write(ssl, str->buf, strlen((const char*)str->buf));
	return cc;
}






/**
int  ssl_send_sBufferln(SSL* ssl, Buffer* str)

	ǽ: SSLå(ʸ)˲(\r\n)դä롥

	: ssl	 SSLѥȥ꡼
		  mesg	 ѥåХåե

	: Ϥʸ(ޤ)
			Ԥˤ-1֤(send())
*/
int  ssl_send_sBufferln(SSL* ssl, Buffer* str)
{
	int	cc;
	Buffer buf;

	buf = dup_Buffer(*str);
	cat_s2Buffer("\r\n", &buf);
	cc = SSL_write(ssl, buf.buf, strlen((const char*)buf.buf));
	free_Buffer(&buf);

	return cc;
}





/**
int  ssl_recv_mstreamBuffer(int sock, SSL* ssl, Buffer* mesg, mstream* sb, int tm)

	ǽSSLͳǥå(ʸ)롥åϥåȥ꡼
		˰öХåե󥰤졤δؿˤԤɤ߽Ф롥
		  mesg˳ǼβԥɤϺ졤ˤɬ \0 롥
		  ॢȤ꤬ǽǥॢȤ 0ꤷ, ƤӽФ
		  ɤ߹߲ǽǡʤФ˥ॢȤȤʤ (RECV_TIMEOUTED ֤)
		  åȥ꡼ΥХåեݤƤʤϡǽ˸ƤӽФ줿
		ݤ롥öδؿѤơǡХåե󥰤顤åȤ
		  ޤǡɤ߼ˤɬƱȥ꡼ѤƤδؿƤӽФФ
		  Фʤʤ̵ϼǡݾڤʤ

	
		sock	åȵһ
		ssl	 	SSLѥȥ꡼
		mesg 	ѥǡХåեХåեݤɬפϤʤ
		sb	  	åХåեʥ󥰷Υȥ꡼Хåե
				ХåեݤƤʤСưŪ˳ݤ롥
		tm	  	ॢȻ֡ñ̡

	͡
		1ʾ	mesg˳ǼåΥХȿ
		0  		餯¦å򥯥
		-1  	顼
		-2  	 NULLΥǡ롥
		-3  	åХåե̵Τǳݤ褦Ȥݤ˼Ԥ
		-4  	åХåե˥ǡ¸ߤϤͳˤ˼Ԥ
		RECV_TIMEOUTED  	ॢȡ
*/
int  ssl_recv_mstreamBuffer(int sock, SSL* ssl, Buffer* mesg, mstream* sb, int tm)
{
	int	cc;
	unsigned char* pp;

	if (mesg==NULL || sb==NULL) return -2;
	*mesg = make_Buffer(LBUF);

	if (sb->buf==NULL) {
		*sb = make_mstream(RECVBUFSZ);
		if (sb->buf==NULL) return -3;
	}

	while (sb->datano==0) {
		cc = ssl_recv_sBuffer(sock, ssl, mesg, tm);
		if (cc<=0) {
			free_Buffer(mesg);
			return cc;
		}
		put_mstream(sb, mesg->buf);
		clear_Buffer(mesg);
	}

	pp = get_mstream(sb);
	if (pp==NULL) return -4;
	copy_s2Buffer((char*)pp, mesg);
	free(pp);

	return mesg->vldsz;
}







/**
int  ssl_recv_linesBuffer(int sock, SSL* ssl, Buffer* mesg, int tm)

	ǽSSLͳǥå(ʸ)롥ʣʬ\nǽ뤳ȤݾڤˤΥǡ
		  ФȤΤǤʰץХåեǽդ餵˰ʬΥǡФˤϡ
		  get_line() ʤɤѤ롥
		  ޤͥåȥľܰԤŤļФˤϡtcp_recv_mstreamBuffer() Ȥۤɤ

	: sock	 	åȵһ
		  ssl	    SSLѥȥ꡼
		  *mesg		ѥǡХåեͽݤƤ
		  tm	  	ॢȻ֡ñ̡

	: 1ʾ	줿Хȿ
			0		餯¦å򥯥
			-1		顼
			-2	    buf NULL
			RECV_TIMEOUTED	  	ॢȡ

	ХǡɬLFǽ뤳Ȥݾ㤵ƤˤѤǤʤ
		  ĤޤŪˤϡֻȤʤ

*/
int  ssl_recv_linesBuffer(int sock, SSL* ssl, Buffer* mesg, int tm)
{
	int	cc;
	Buffer msg, buf;

	if (mesg==NULL) return -2;
	buf = make_Buffer(LBUF);

	cc = ssl_recv_sBuffer(sock, ssl, &buf, tm);
	while (cc>0) {
		cat_Buffer(&buf, &msg);
		if (buf.buf[cc-1]==LF) break;
		clear_Buffer(&buf);
		cc = ssl_recv_sBuffer(sock, ssl, &buf, tm);
	}
	free_Buffer(&buf);
		
	if (cc<=0) {
		free_Buffer(mesg);
		return cc;
	}

	return mesg->vldsz;
}






/////////////////////////////////////////////////////////////////
// SSL abd TCP compati communications

/**				
int  ssl_tcp_recv(int sock, SSL* ssl, char* rmsg, int size)
					
	ǽ: ssl NULLǤʤSSLǼԤNULLʤ̾ΥåȤǼԤ
					
	: ssl	 SSLѥȥ꡼
		  rmsg	 ѥǡХåե
		  size	 ǡХåեΥ
					
	: ˹ԤФΥХȿ
			Ԥ-1֤
			0 ξ

	see also tcp_recv() in Lib
*/  
int  ssl_tcp_recv(int sock, SSL* ssl, char* rmsg, int size)
{
	int cc;

	memset(rmsg, 0, size);
	
	if (ssl!=NULL) cc = SSL_read(ssl, rmsg, size-1);
	else           cc = recv(sock, rmsg, size, 0);
	 
	return cc;
}




/**				
int  ssl_tcp_send(int sock, SSL* ssl, char* smsg, int size)
					
	ǽ: ssl NULLǤʤSSLԤNULLʤ̾ΥåȤԤ
		  ǡ(smsg)Υ size0ʲꤷϡsmsgʸ
		  Ǥȸʤ,ưŪ˷׻롥
					
	: ssl	 SSLѥȥ꡼
		  smsg	 ǡ
		  size	 ǡsmsgˤΥ 0ʲξ
				 smsgʸǤȤߤʤ
					
	: ϤХȿ
			Ԥˤ-1֤롥

	see also tcp_send() in Lib
*/
int  ssl_tcp_send(int sock, SSL* ssl, char* smsg, int size)
{
	int cc;

	if (size<=0) size = strlen(smsg);

	if (ssl!=NULL) cc = SSL_write(ssl, smsg, size);
	else           cc = send(sock, smsg, size, 0);
	
	return cc;
}




/**				
int  ssl_tcp_recv_mesg(int sock, SSL* ssl, char* mesg, int sz, int tm)
				  
	ǽsslNULLǤʤСSSLͳǥå(ʸ)롥sslNULLʤ
̾ΥåȤǼ롥Хʥġ
		  ॢȤ꤬ǽॢȤ 0ꤷ, recv_wait()
		  ؿƤӽФɤ߹߲ǽǡʤФ˥ॢ
		  Ȥʤ (RECV_TIMEOUTED֤)
		 
	:		 
		 sock	 åȵһ
		 ssl	 SSLѥȥ꡼
		 mesg	 ѥǡХåե
		 sz		 ǡХåեΥ
		 tm	 	 ॢȻ֡ñ̡
			
	:	  
		 1ʾ	Хȿ
		 0		餯¦å򥯥
		 -1		顼
		 RECV_TIMEOUTED		ॢȡ

	see also tcp_recv_mesg() in Lib
*/		
int  ssl_tcp_recv_mesg(int sock, SSL* ssl, char* mesg, int sz, int tm)
{
	int  cc;
				 
	if (recv_wait(sock, tm)) {
		cc = ssl_tcp_recv(sock, ssl, mesg, sz);
		if (cc<=0) debug_message("SSL_RECV_MESG: Session Closed.\n");
	}
	else {
		debug_message("SSL_RECV_MESG: Time Out.\n");
		return RECV_TIMEOUTED;
	}		
	return cc;
}




/**				
int  ssl_tcp_send_mesg(int sock, SSL* ssl, char* mesg)
				  
	ǽSSLͳǥå(ʸ)롥
		 
			
		 ssl	 SSLѥȥ꡼
		 mesg	 ѥå
			
	͡	 
		 ϤХȿ
		 Ԥˤ-1֤롥
					
	ǤϼΤϥޥǤ롥
	  #define  ssl_tcp_send_mesg(s, l, m)  ssl_tcp_send((s), (l), (m), 0)
*/





/**				
int  ssl_tcp_send_mesgln(int sock, SSL* ssl, char* mesg)
				  
	ǽSSL or TCPå(ʸ)˲(\r\n)դä롥
		 
		  
		ssl	    SSLѥȥ꡼
	  	mesg	ѥå
			
	͡	 
	  	Ϥʸ(ޤ)
	  	Ԥˤ-1֤롥
*/			 
int  ssl_tcp_send_mesgln(int sock, SSL* ssl, char* mesg)
{  
	int	cc, sz;
	char* buf;
	
	sz = strlen(mesg)+3;	// for CR+LF+0x00 
	buf = (char*)malloc(sz);
	if (buf==NULL) return -1;
	
	strncpy(buf, mesg, sz);
	strncat(buf, "\r\n", 2);
	cc = ssl_tcp_send(sock, ssl, buf, strlen(buf));
	
	free(buf);
	return cc;
}




/**
int  ssl_tcp_recv_mstream(int sock, SSL* ssl, char* mesg, int sz, mstream* sb, int tm)

	ǽSSL/TSL/TCPͳǥå(ʸ)롥åϥåȥ꡼
		Хåե˰öХåե󥰤졤δؿˤԤɤ߽Ф롥mesgˤϺ
		sz-1ʸǼ롥⤷ХåեΰԤΥǡ sz-1礭
		Ϥ߽ФʬϼΤƤ롥
		  mesg˳ǼβԥɤϺ졤ˤɬ \0 롥
		  ॢȤ꤬ǽǥॢȤ 0ꤷ, ƤӽФ
		  ɤ߹߲ǽǡʤФ˥ॢȤȤʤ (RECV_TIMEOUTED ֤)
		  åȥ꡼ΥХåեݤƤʤϡǽ˸ƤӽФ줿
		ݤ롥öδؿѤơǡХåե󥰤顤åȤ
		  ޤǡɤ߼ˤɬƱȥ꡼ѤƤδؿƤӽФФ
		  Фʤʤ̵ϼǡݾڤʤ

	
	 	sock 	åȵһ
	 	ssl 	SSLѥȥ꡼
	  	mesg	ѥǡХåեͽώʬʥΰݤƤ
	  	sz	 	ǡХåեΥ
		sb	    ȥ꡼Хåեʥ󥰥ХåեΥȥ꡼Хåե
				ХåեݤƤʤСưŪ˳ݤ롥
	  	tm	 	ॢȻ֡ñ̡

	͡
	  	1ʾ	mesg˳ǼåΥХȿ
	  	0  		餯¦å򥯥
	  	-1  	顼
		-2  	 NULLΥǡ롥
		-3  	åХåե̵Τǳݤ褦Ȥݤ˼Ԥ
		-4  	åХåե˥ǡ¸ߤϤͳˤ˼Ԥ
		-5  	åХåեΥǡĹmesgĹ礭Ϥ߽ФʬϼΤƤ줿
	  	RECV_TIMEOUTED  	ॢȡ
*/
int  ssl_tcp_recv_mstream(int sock, SSL* ssl, char* mesg, int sz, mstream* sb, int tm)
{
	int  cc;
	unsigned char* pp;

	if (mesg==NULL || sb==NULL) return -2;
	memset(mesg, 0, sz);

	if (sb->buf==NULL) {
		*sb = make_mstream(RECVBUFSZ);
		if (sb->buf==NULL) return -3;
	}

	while (sb->datano==0) {
		cc = ssl_tcp_recv_mesg(sock, ssl, mesg, sz, tm);
		if (cc<=0) return cc;
		put_mstream(sb, (unsigned char*)mesg);
		memset(mesg, 0, sz);
	}

	pp = get_mstream(sb);
	if (pp==NULL) return -4;
	if (strlen((const char*)pp)>=(unsigned int)sz) {
		memcpy(mesg, pp, sz-1);
		free(pp);
		return -5;
	}
	memcpy(mesg, pp, strlen((const char*)pp));

	free(pp);
	return strlen(mesg);
}






/////////////////////////////////////////////////////////////////
// SSL with Buffer

/**
int  ssl_tcp_recv_Buffer(int sock, SSL* ssl, Buffer* str)

	ǽ: SSL or TCPͳǥǡ롥Хåե󥰤ʤ

	: ssl	 SSLѥȥ꡼
		  *str	 ѥǡХåեͽݤƤ

	: ˹ԤФΥХȿ
			Ԥ-1֤
			0 ξ
*/
int  ssl_tcp_recv_Buffer(int sock, SSL* ssl, Buffer* str)
{
	int cc;

	memset(str->buf, 0, str->bufsz);
	str->vldsz = 0;

	if (ssl!=NULL) cc = SSL_read(ssl, str->buf, str->bufsz-1);
	else           cc = recv(sock, str->buf, str->bufsz, 0);

	if (cc>=0) str->vldsz = cc;

	return cc;
}






/**
int  ssl_tcp_send_Buffer(int sock, SSL* ssl, Buffer* str)

	ǽ: SSL or TCPͳǥǡ롥

	: ssl	 SSLѥȥ꡼
		  str	 ѥǡХåե

	: ϤХȿ
			Ԥˤ-1֤(send())

*/
int  ssl_tcp_send_Buffer(int sock, SSL* ssl, Buffer* str)
{
	int cc;

	if (str->vldsz<0) str->vldsz = strlen((const char*)str->buf);

	if (ssl!=NULL) cc = SSL_write(ssl, str->buf, str->vldsz);
	else           cc = send(sock, str->buf, str->vldsz, 0);

	return cc;
}






/**
int  ssl_tcp_recv_sBuffer(int sock, SSL* ssl, Buffer* str, int tm)

	ǽ: SSL or TCPͳʸǡ롥
		  ॢȤ꤬ǽॢȤ 0ꤷ, recv_wait()
		  ؿƤӽФɤ߹߲ǽǡʤФ˥ॢ
		  Ȥʤ (RECV_TIMEOUTED֤)

	: sock	 åȵһ
		  ssl	 SSLѥȥ꡼
		  *str	 ѥǡХåեͽݤƤ
		  tm	 ॢȻ֡ñ̡

	: 1ʾ Хȿ
			0	 餯¦å򥯥
			-1	  顼
			RECV_TIMEOUTED	  ॢȡ
*/
int  ssl_tcp_recv_sBuffer(int sock, SSL* ssl, Buffer* str, int tm)
{
	int cc;

	str->vldsz = 0;
	cc = ssl_tcp_recv_mesg(sock, ssl, (char*)str->buf, str->bufsz, tm);
	if (cc>=0) str->vldsz = cc;

	return cc;
}





/**
int  ssl_tcp_send_sBuffer(int sock, SSL* ssl, Buffer* str)

	ǽ: SSL or TCPͳʸǡ롥

	: ssl	 SSLѥȥ꡼
		  str	 ѥǡХåե

	: ϤХȿ
			Ԥˤ-1֤(send())

*/
int  ssl_tcp_send_sBuffer(int sock, SSL* ssl, Buffer* str)
{
	int cc;

	if (ssl!=NULL) cc = SSL_write(ssl, str->buf, strlen((const char*)str->buf));
	else           cc = send(sock, str->buf, strlen((const char*)str->buf), 0);

	return cc;
}






/**
int  ssl_tcp_send_sBufferln(int sock, SSL* ssl, Buffer* str)

	ǽ: SSL or TCPå(ʸ)˲(\r\n)դä롥

	: ssl	 SSLѥȥ꡼
		  mesg	 ѥåХåե

	: Ϥʸ(ޤ)
			Ԥˤ-1֤(send())
*/
int  ssl_tcp_send_sBufferln(int sock, SSL* ssl, Buffer* str)
{
	int	cc;
	Buffer buf;

	buf = dup_Buffer(*str);
	cat_s2Buffer("\r\n", &buf);

	if (ssl!=NULL) cc = SSL_write(ssl, buf.buf, strlen((const char*)buf.buf));
	else           cc = send(sock, buf.buf, strlen((const char*)buf.buf), 0);

	free_Buffer(&buf);

	return cc;
}





/**
int  ssl_tcp_recv_mstreamBuffer(int sock, SSL* ssl, Buffer* mesg, mstream* sb, int tm)

	ǽSSL or TCPͳǥå(ʸ)롥åϥåȥ꡼
		˰öХåե󥰤졤δؿˤԤɤ߽Ф롥
		  mesg˳ǼβԥɤϺ졤ˤɬ \0 롥
		  ॢȤ꤬ǽǥॢȤ 0ꤷ, ƤӽФ
		  ɤ߹߲ǽǡʤФ˥ॢȤȤʤ (RECV_TIMEOUTED ֤)
		  åȥ꡼ΥХåեݤƤʤϡǽ˸ƤӽФ줿
		ݤ롥öδؿѤơǡХåե󥰤顤åȤ
		  ޤǡɤ߼ˤɬƱȥ꡼ѤƤδؿƤӽФФ
		  Фʤʤ̵ϼǡݾڤʤ

	
		sock	åȵһ
		ssl	 	SSLѥȥ꡼
		buf	 	ѥǡХåեХåեݤɬפϤʤ
		sb	  	åХåեʥ󥰷Υȥ꡼Хåե
				ХåեݤƤʤСưŪ˳ݤ롥
		tm	  	ॢȻ֡ñ̡

	͡
		1ʾ	mesg˳ǼåΥХȿ
		0  		餯¦å򥯥
		-1  	顼
		-2  	 NULLΥǡ롥
		-3  	åХåե̵Τǳݤ褦Ȥݤ˼Ԥ
		-4  	åХåե˥ǡ¸ߤϤͳˤ˼Ԥ
		RECV_TIMEOUTED  	ॢȡ
*/
int  ssl_tcp_recv_mstreamBuffer(int sock, SSL* ssl, Buffer* mesg, mstream* sb, int tm)
{
	int	cc;
	unsigned char* pp;

	if (mesg==NULL || sb==NULL) return -2;
	*mesg = make_Buffer(LBUF);

	if (sb->buf==NULL) {
		*sb = make_mstream(RECVBUFSZ);
		if (sb->buf==NULL) return -3;
	}

	while (sb->datano==0) {
		cc = ssl_tcp_recv_sBuffer(sock, ssl, mesg, tm);
		if (cc<=0) {
			free_Buffer(mesg);
			return cc;
		}
		put_mstream(sb, mesg->buf);
		clear_Buffer(mesg);
	}

	pp = get_mstream(sb);
	if (pp==NULL) return -4;
	copy_s2Buffer((char*)pp, mesg);
	free(pp);

	return mesg->vldsz;
}







/**
int  ssl_tcp_recv_linesBuffer(int sock, SSL* ssl, Buffer* mesg, int tm)

	ǽSSL or TCPͳǥå(ʸ)롥ʣʬ\nǽ뤳ȤݾڤˤΥǡ
		  ФȤΤǤʰץХåեǽդ餵˰ʬΥǡФˤϡ
		  get_line() ʤɤѤ롥
		  ޤͥåȥľܰԤŤļФˤϡtcp_recv_mstreamBuffer() Ȥۤɤ

	: sock	 	åȵһ
		  ssl	 	SSLѥȥ꡼
		  *mesg		ѥǡХåեͽݤƤ
		  tm	  	ॢȻ֡ñ̡

	: 1ʾ	줿Хȿ
			0		餯¦å򥯥
			-1		顼
			-2	  	buf NULL
			RECV_TIMEOUTED	  	ॢȡ

	ХǡɬLFǽ뤳Ȥݾ㤵ƤˤѤǤʤ
		  ĤޤŪˤϡֻȤʤ

*/
int  ssl_tcp_recv_linesBuffer(int sock, SSL* ssl, Buffer* mesg, int tm)
{
	int	cc;
	Buffer msg, buf;

	if (mesg==NULL) return -3;
	buf = make_Buffer(LBUF);

	cc = ssl_tcp_recv_sBuffer(sock, ssl, &buf, tm);
	while (cc>0) {
		cat_Buffer(&buf, &msg);
		if (buf.buf[cc-1]==LF) break;
		clear_Buffer(&buf);
		cc = ssl_tcp_recv_sBuffer(sock, ssl, &buf, tm);
	}
	free_Buffer(&buf);
		
	if (cc<=0) {
		free_Buffer(mesg);
		return cc;
	}

	return mesg->vldsz;
}






