<?php
//
// by Fumi.Iseki  2007/03/24
//                2012/04/12
//                2013/04/20
//                2013/09/21
//

$jbxl_tools_ver = 2013092100;


//
if (defined('JBXL_TOOLS_VER') or defined('_JBXL_TOOLS')) {
	if (defined('JBXL_TOOLS_VER')) {
		if (JBXL_TOOLS_VER < $jbxl_tools_ver) {
			print_error('JBXL_TOOLS: old version is used. '.JBXL_TOOLS_VER.' < '.$jbxl_tools_ver);
		}
	}
}
else {

define('JBXL_TOOLS_VER', $jbxl_tools_ver);



/****************************************************************
 * Function List

 function  jbxl_isNumeric($str, $nullok=false)
 function  jbxl_isAlphabetNumeric($str, $nullok=false)
 function  jbxl_isAlphabetNumericSpecial($str, $nullok=false)
 function  jbxl_isGUID($uuid, $nullok=false)
 
 function  jbxl_split_key_value($str)

 function  jbxl_make_random_hash()
 function  jbxl_make_random_guid()
 
 function  jbxl_j2k_to_tga($file, $iscopy=true)
 function  jbxl_get_j2k_to_tga_command() 			// need j2k_to_image (OpenJpeg)
 function  jbxl_get_image_size_convert_command($xsize, $ysize)

 function  jbxl_find_command_path($command)


 function  jbxl_to_subnetformats($strips)
 function  jbxl_match_ipaddr($ip, $ipaddr_subnets)
 function  jbxl_randstr($len=8, $lowcase=false)

 function  jbxl_get_ipresolv_url($ip)

 ****************************************************************/





function  jbxl_isNumeric($str, $nullok=false)
{
	if ($str!='0' and $str==null) return $nullok;
	if (!preg_match('/^[0-9\.]+$/', $str)) return false;

	return true;
}



function  jbxl_isAlphabetNumeric($str, $nullok=false)
{
	if ($str!='0' and $str==null) return $nullok;
	if (!preg_match('/^\w+$/', $str)) return false;
	return true;
}



function  jbxl_isAlphabetNumericSpecial($str, $nullok=false)
{
	if ($str!='0' and $str==null) return $nullok;
	if (!preg_match('/^[_a-zA-Z0-9 &@%#\-\.]+$/', $str)) return false;
	return true;
}



function  jbxl_isGUID($uuid, $nullok=false)
{
	if ($uuid==null) return $nullok;
	if (!preg_match('/^[0-9A-Fa-f]{8,8}-[0-9A-Fa-f]{4,4}-[0-9A-Fa-f]{4,4}-[0-9A-Fa-f]{4,4}-[0-9A-Fa-f]{12,12}$/', $uuid)) return false;
	return true;
}



function  jbxl_make_random_hash()
{
 	$ret = sprintf('%04x%04x%04x%04x%04x%04x%04x%04x',mt_rand(0,0xffff),mt_rand(0,0xffff),mt_rand(0,0xffff),mt_rand(0,0xffff),
 													  mt_rand(0,0xffff),mt_rand(0,0xffff),mt_rand(0,0xffff),mt_rand(0,0xffff));
	return $ret;
}



function  jbxl_make_random_guid()
{
	$uuid = sprintf( '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
					  mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ),
					  mt_rand( 0, 0x0fff ) | 0x4000,
					  mt_rand( 0, 0x3fff ) | 0x8000,   
		   			  mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ) );
	return $uuid;
}
 



///////////////////////////////////////////////////////////////////////////////////////////////////
//
// String Tools
//

// parse {"key1":"value1","key2":{"key3":"value3"}}
//
//    	--> [key1] => value1
//    		[key2] => Array
//        		(
//            		[key3] => value3
//        		)
//

function  jbxl_split_key_value($str)
{
	$info = array();
	$str  = trim($str);

	if (substr($str, 0, 1)=='{' and substr($str, -1)=='}') {
		$str = substr($str, 1, -1);
		$inbrkt = 0;
		$inquot = false;
		$inkkko = false;
		$isakey = true;
		$key    = "";
		$val    = "";

		for ($i=0; $i<strlen($str); $i++) {
			$cc = substr($str, $i, 1);

			if ($inbrkt==0 and !$inquot and ($cc=='"' or $cc=='\'')) {
				$inquot = true;
			}
			else if ($inbrkt==0 and $inquot and ($cc=='"' or $cc=='\'')) {
				$inquot = false;
			}
			else if ($inbrkt==0 and $isakey  and !$inquot and !$inkkko and $cc==':') {
				$isakey = false;
			}		
			else if ($inbrkt==0 and !$isakey and !$inquot and !$inkkko and $cc==',') {
				if (substr($val, 0, 1)=='{' and substr($val, -1)=='}') {
					$info[$key] = split_key_value($val);
				}
				else $info[$key] = $val;

				$isakey = true;
				$key    = "";
				$val    = "";
			}
			else {
				if      ($cc=='{') $inbrkt++;
				else if ($cc=='}') $inbrkt--;
				else {
					if      ($inbrkt==0 and !$inkkko and $cc=='[') $inkkko = true;
					else if ($inbrkt==0 and $inkkko  and $cc==']') $inkkko = false;
				}

				if ($isakey) $key .= $cc;	
				else         $val .= $cc;
			}
		}

		//
		if ($key!="") {
			if (substr($val, 0, 1)=='{' and substr($val, -1)=='}') {
				$info[$key] = split_key_value($val);
			}
			else $info[$key] = $val;
		}
	}

	return $info;
}




///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Image
//

//
// Convert Image from JPEG2000 to TGA
//		file -> file.tga
// 
function  jbxl_j2k_to_tga($file, $iscopy=true)
{
	if (!file_exists($file)) return false;

	$com_totga = get_j2k_to_tga_command();
	if ($com_totga=='') return false;

	if ($iscopy) $ret = copy  ($file, $file.'.j2k');
	else 		 $ret = rename($file, $file.'.j2k');
	if (!$ret) return false;

	exec("$com_totga -i $file.j2k -o $file.tga 1>/dev/null 2>&1");
	unlink($file.'.j2k');

	return true;
}



function  jbxl_get_j2k_to_tga_command()
{
	$command = find_command_path('j2k_to_image');
	return $command;
}




//
// Image Size Convert Command String
//
function  jbxl_get_image_size_convert_command($xsize, $ysize)
{
	if (!isNumeric($xsize) or !isNumeric($ysize)) return '';

	$command = find_command_path('convert');
	if ($command=='') return '';

	$prog = $command.' - -geometry '.$xsize.'x'.$ysize.'! -';
	return $prog;
}




function  jbxl_find_command_path($command)
{
	$path = '';
	if (file_exists('/usr/local/bin/'.$command))	  $path = '/usr/local/bin/';
	else if (file_exists('/usr/bin/'.$command))		  $path = '/usr/bin/';
	else if (file_exists('/usr/X11R6/bin/'.$command)) $path = '/usr/X11R6/bin/';
	else if (file_exists('/bin/'.$command))			  $path = '/bin/';
	else return '';

	return $path.$command;
}




//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// IPv4 Address
//

//
// IPアドレスを "," または半角空白で区切って記述した文字列から，有効なIPアドレス
// とサブネットを8bitずつ取り出す．CIDER対応
//
// 入力例：" 0.2.1.1/2 222.222.111.222/255., 123.31.6.000 202.26.156.2/20, 202.26.144.0/255.255.255.0   , "
//  
// 戻り値：
//     $return[index]['ipaddr'][0〜3の数]  8bit区切りの IPアドレス
//     $return[index]['subnet'][0〜3の数]  8bit区切りの netmaskアドレス
//
function  jbxl_to_subnetformats($strips)
{
	$return = array();

	$tmpips = preg_split("/[ ,]/ ", $strips);
	foreach($tmpips as $value) {
		if (!empty($value)) $ipfmts[] = $value;
	}
	if (empty($ipfmts)) return $return;

	unset($tempips);
	// omission of subnetmask
	foreach($ipfmts as $ipfmt) {
		$tempips = explode('/', $ipfmt);
		if (empty($tempips[0])) continue;
		if (empty($tempips[1])) {
			$ips = explode('.', $tempips[0]);
			$tempips[1] = '';
			for ($i=0; $i<4; $i++) {
				if (empty($ips[$i])) $tempips[1].= '0';
				else                 $tempips[1].= '255';
				if ($i!=3) $tempips[1].= '.';
			}
			unset($ips);
		}
		$ipaddr_subnets[] = $tempips;
	}
	if (empty($ipaddr_subnets)) return $return;

	//
	$index = 0;
	foreach($ipaddr_subnets as $ipaddr_subnet) {
		$ips = explode('.', $ipaddr_subnet[0]);
		$sub = explode('.', $ipaddr_subnet[1]);

		if (count($sub)==1 and $sub[0]<=32) { 	// CIDER -> SubnetMask
			$cider = $sub[0];
			$nbyte = (int)($cider/8);
			$nbit  = $cider - $nbyte*8;
			for ($i=0; $i<$nbyte; $i++) {
				$sub[$i] = 255;
			}
			if ($nbyte!=4) {
				$nsub = 0;
				$base = 128;
				for ($i=0; $i<$nbit; $i++) {
					$nsub += $base;
					$base = $base/2;
				}	
				$sub[$nbyte] = $nsub;
			}
		}
		
		for ($i=0; $i<4; $i++) {
			if (!empty($ips[$i])) $return[$index]['ipaddr'][$i] = (int)$ips[$i]; 
			else                  $return[$index]['ipaddr'][$i] = (int)0;
			if (!empty($sub[$i])) $return[$index]['subnet'][$i] = (int)$sub[$i]; 
			else                  $return[$index]['subnet'][$i] = (int)0;
		}
		$index++;
	}

	return $return;
}




//
// $ip が $ipaddr_subnetsの中に含まれるか検査する．
// $ipaddr_subnets は jbxl_to_subnetformats()が出力したものを使用すること．
// $ip の内容の形式はチェックしない．これは呼び出し側の責任．
//
function  jbxl_match_ipaddr($ip, array $ipaddr_subnets)
{
	$ipa = explode('.', $ip);
	if (empty($ipa)) return false;

	for ($i=1; $i<4; $i++) {
		if (empty($ipa[$i])) $ipa[$i] = 0;
	}

	foreach($ipaddr_subnets as $ipaddr_subnet) {
		$ips = $ipaddr_subnet['ipaddr'];
		$sub = $ipaddr_subnet['subnet'];

		$match_f = true;
		for ($i=0; $i<4; $i++) {
			$check1 = $ipa[$i] & $sub[$i];
			$check2 = $ips[$i] & $sub[$i];
			if ($check1 != $check2) {
				$match_f = false;
				break;
			}
		}

		if ($match_f) {
			//print_r($ips);
			//print_r($sub);
			return true;
		}
	}
	return false;
}




$JBXLBaseChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";



function  jbxl_randstr($len=8, $lowcase=false)
{
	global $JBXLBaseChar;

	if ($lowcase) $rndmax = 25;
	else		  $rndmax = strlen($JBXLBaseChar) - 1;

    $return  = "";
    for($i=0; $i<$len; $i++) {
        $return .= $JBXLBaseChar{mt_rand(0, $rndmax)};
	}
    return $return;
}




function  jbxl_get_ipresolv_url($ip, $region='APNIC')
{
	if (!preg_match('/(^\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/', $ip, $match)) return '';

	if ($match[1]>255 or $match[2]>255 or $match[3]>255 or $match[4]>255) return '';
	if ($match[1]=='127' or  $match[1]=='10') return '';
	if ($match[1]=='172' and $match[2]>='16' and $match[2]<='31') return '';
	if ($match[1]=='192' and $match[2]=='168') return '';

	if ($region=='JPNIC') {
		$url = 'http://whois.nic.ad.jp/cgi-bin/whois_gw?type=NET&key='.$ip;	// JPNIC
	}
	else {
		$url = 'http://wq.apnic.net/apnic-bin/whois.pl?searchtext='.$ip;	// APNIC
	}

	return $url;
}





} 		// !defined('JBXL_TOOLS_VER')
