<?php
///////////////////////////////////////////////////////////////////////////////
//	clpresenceAction.class.php
//
//	OpenSimのDBを更新する．
//
//		v2.0
//		OpenSim
//			passwordSaltが''の場合はランダムに生成して，passwordHashもそれに合わせる．
//
//
//                                   Created by Fumi.Iseki
//

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/AbstructAction.class.php');
require_once(CMS_MODULE_PATH.'/class/xoopensimClPresenceForm.class.php');



class  clpresenceAction extends Abstruct_Action
{
	var $action_url;
	var	$cleared = false;



	function  clpresenceAction($controller) 
	{
		$this->mActionForm = & new Xoopensim_ClPresenceForm();
		if (!$this->mActionForm->isAdmin) {
			$controller->executeRedirect(CMS_MODULE_URL, 2, _AM_XPNSM_ACCESS_FORBIDDEN);
		}

		$this->action_url = CMS_MODULE_URL.'/admin/index.php?action=clpresence';
	}



	function  execute()
	{
		if (xoops_getenv('REQUEST_METHOD')=='POST') {
			$this->mActionForm->prepare();
			$this->mActionForm->fetch();
			$this->mActionForm->validate();

			if (!$this->mActionForm->hasError()) {
				$quest = $this->mActionForm->get('quest');
				if ($quest=='yes') {
					$ret = opensim_check_db();
					if (!$ret['grid_status']) {
						$this->mActionForm->addErrorMessage(_MD_XPNSM_DB_CONNECT_ERROR);
						return;
					}
					opensim_clear_login_table();
					$this->cleared = true;
				}
			}
		}
	}



	function  executeView($render) 
	{
		$root = & XCube_Root::getSingleton();
		$grid_name  = $root->mContext->mModuleConfig['grid_name'];
		$admin_menu = $root->mContext->mModule->getAdminMenu();

		$render->setTemplateName(CMS_MODULE_PATH.'/templates/xoopensim_clpresence.html');

		$render->setAttribute('admin_menu', $admin_menu);
		$render->setAttribute('grid_name',	$grid_name);
		$render->setAttribute('cleared',    $this->cleared);
		$render->setAttribute('action_url', $this->action_url);
		$render->setAttribute('actionForm', $this->mActionForm);
	}
}

?>
