<?php

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/xoopensimActionForm.class.php');


class Xoopensim_EditeventForm extends Xoopensim_ActionForm
{
	var $isAdmin = false;
	var $uid   = 0;
	var $uname = '';


	function Xoopensim_EditeventForm()
	{
		parent::Xoopensim_ActionForm();

		$root = & XCube_Root::getSingleton();
		if (is_object($root->mContext->mXoopsUser)) {
			$this->uid   = $root->mContext->mXoopsUser->get('uid');
			$this->uname = $root->mContext->mXoopsUser->get('uname');
		}
		$this->isAdmin 	 = isXoopensimAdmin($root);
	}



	function getTokenName()
	{
		return 'module.xoopensim.EditeventAction.TOKEN';
	}



	function prepare()
	{
		$this->mFormProperties['uid']  			= & new XCube_IntProperty('uid');
		$this->mFormProperties['event_id']  	= & new XCube_IntProperty('event_id');
		$this->mFormProperties['event_name']   	= & new XCube_StringProperty('event_name');
		$this->mFormProperties['event_desc']	= & new XCube_TextProperty('event_desc');
		$this->mFormProperties['event_day']  	= & new XCube_IntProperty('event_day');
		$this->mFormProperties['event_month']  	= & new XCube_IntProperty('event_month');
		$this->mFormProperties['event_year']  	= & new XCube_IntProperty('event_year');
		$this->mFormProperties['event_hour']  	= & new XCube_IntProperty('event_hour');
		$this->mFormProperties['event_minute'] 	= & new XCube_IntProperty('event_minute');
		$this->mFormProperties['duration'] 		= & new XCube_IntProperty('duration');
		$this->mFormProperties['category'] 		= & new XCube_IntProperty('category');
		$this->mFormProperties['cover_charge'] 	= & new XCube_IntProperty('cover_charge');
		$this->mFormProperties['cover_amount'] 	= & new XCube_IntProperty('cover_amount');
		$this->mFormProperties['parcel_name'] 	= & new XCube_StringProperty('parcel_name');
		$this->mFormProperties['check_mature'] 	= & new XCube_IntProperty('check_mature');
		$this->mFormProperties['creator_name'] 	= & new XCube_StringProperty('creator_name');
		$this->mFormProperties['owner_name'] 	= & new XCube_StringProperty('owner_name');
		$this->mFormProperties['action_submit']	= & new XCube_StringProperty('action_submit');
		$this->mFormProperties['submit_delete']	= & new XCube_StringProperty('submit_delete');

		$this->mFieldProperties['event_name'] 	= & new XCube_FieldProperty($this);
        $this->mFieldProperties['event_name']->setDependsByArray(array('required'));
		$this->mFieldProperties['event_name']->addMessage('required', _MD_XPNSM_EVENT_NAME_REQUIRED);

		$this->mFieldProperties['event_desc'] 	= & new XCube_FieldProperty($this);
        $this->mFieldProperties['event_desc']->setDependsByArray(array('required'));
		$this->mFieldProperties['event_desc']->addMessage('required', _MD_XPNSM_EVENT_DESC_REQUIRED);

		$this->mFieldProperties['creator_name'] = & new XCube_FieldProperty($this);
        $this->mFieldProperties['creator_name']->setDependsByArray(array('required'));
		$this->mFieldProperties['creator_name']->addMessage('required', _MD_XPNSM_EVENT_CREATOR_REQUIRED);

		$this->mFieldProperties['owner_name'] 	= & new XCube_FieldProperty($this);
        //$this->mFieldProperties['owner_name']->setDependsByArray(array('required'));
		//$this->mFieldProperties['owner_name']->addMessage('required', _MD_XPNSM_EVENT_OWNER_REQUIRED);

		$this->mFieldProperties['uid'] 			= & new XCube_FieldProperty($this);
		$this->mFieldProperties['event_id'] 	= & new XCube_FieldProperty($this);
		$this->mFieldProperties['event_year'] 	= & new XCube_FieldProperty($this);
		$this->mFieldProperties['event_month'] 	= & new XCube_FieldProperty($this);
		$this->mFieldProperties['event_day'] 	= & new XCube_FieldProperty($this);
		$this->mFieldProperties['event_hour'] 	= & new XCube_FieldProperty($this);
		$this->mFieldProperties['event_minute'] = & new XCube_FieldProperty($this);
		$this->mFieldProperties['duration'] 	= & new XCube_FieldProperty($this);
		$this->mFieldProperties['category'] 	= & new XCube_FieldProperty($this);
		$this->mFieldProperties['cover_charge'] = & new XCube_FieldProperty($this);
		$this->mFieldProperties['cover_amount'] = & new XCube_FieldProperty($this);
		$this->mFieldProperties['parcel_name'] 	= & new XCube_FieldProperty($this);
		$this->mFieldProperties['check_mature'] = & new XCube_FieldProperty($this);
		$this->mFieldProperties['action_submit']= & new XCube_FieldProperty($this);
		$this->mFieldProperties['submit_delete']= & new XCube_FieldProperty($this);
	}



	function load()
	{
	}



	function validateCover_amount()
	{
		$val = $this->get('cover_amount');

		if ($val==null) {
			$this->set('cover_amount', 0);
		}
	}



	function validateCheck_mature()
	{
		$val = $this->get('check_mature');
	
		if ($val==null) {
			$this->set('check_mature', 0);
			return;
		}

		if (OPENSIM_PG_ONLY and $val==1) {
			$this->addErrorMessage(_MD_XPNSM_PG_ONLY_ERROR);
		}
	}



	function validateEvent_day()
	{
		$year   = $this->get('event_year');
		$month  = $this->get('event_month');
		$day    = $this->get('event_day');
		$hour   = $this->get('event_hour');
		$minute = $this->get('event_minute');
		$event  = mktime($hour, $minute, 0, $month, $day, $year);
		$tm		= time();

		if ($event<$tm) {
			$ftr = date(DATE_FORMAT, $event);
			$this->addErrorMessage(_MD_XPNSM_INVALID_DATE_ERROR." ($ftr < "._MD_XPNSM_TIME_NOW.")");
		}
	}



	function validateParcel_name()
	{
		$val = $this->get('parcel_name');
	
		if ($val==null) {
			$this->set('parcel_name', '0/0/0|00000000-0000-0000-0000-000000000000');
		}
	}



	function validateOwner_name()
	{
		$err_flag   = false;

		$owner_data = $this->get('owner_name');
		$owner      = explode('|', $owner_data);
		$owner_uuid = $owner[0];
		$owner_name = $owner[1];

		if (!isGuid($owner_uuid)) {
			//$owner_uuid = htmlspecialchars($owner_uuid);
			//$this->addErrorMessage(_MD_XPNSM_INVALID_OWNER_UUID." ($owner_uuid)");
			//$owner_uuid = '00000000-0000-0000-0000-000000000000';
			$err_flag   = true;
		}

		if (!isAlphabetNumericSpecial($owner_name)) {
			//$owner_name = htmlspecialchars($owner_name);
			//$this->addErrorMessage(_MD_XPNSM_INVALID_OWNER_NAME." ($owner_name)");
			$err_flag   = true;
		}

		if ($err_flag) {
			//$owner_data = join('|', $owner_uuid, $owner_uname);
			//$this->set('owner_name', $owner_data);
			$owner_data = $this->get('creator_name');
			$this->set('owner_name', $owner_data);
		}
	}



	function validateCreator_name()
	{
		$err_flag   = false;

		$creator_data = $this->get('creator_name');
		$creator      = explode('|', $creator_data);
		$creator_uuid = $creator[0];
		$creator_name = $creator[1];

		if (!isGuid($creator_uuid)) {
			$creator_uuid = htmlspecialchars($creator_uuid);
			$this->addErrorMessage(_MD_XPNSM_INVALID_OWNER_UUID." ($creator_uuid)");
			$creator_uuid = '00000000-0000-0000-0000-000000000000';
			$err_flag   = true;
		}

		if (!isAlphabetNumericSpecial($creator_name)) {
			$creator_name = htmlspecialchars($creator_name);
			$this->addErrorMessage(_MD_XPNSM_INVALID_OWNER_NAME." ($creator_name)");
			$err_flag   = true;
		}

		if ($err_flag) {
			$creator_data = join('|', $creator_uuid, $creator_uname);
			$this->set('creator_name', $creator_data);
		}
	}

}

?>
