<?php


require_once(CMS_MODULE_PATH.'/class/xoopensimActionForm.class.php');



class Xoopensim_LastnamesForm extends Xoopensim_ActionForm
{
	var $isAdmin;
	var $dbhandler;
	var $lastNames = array();


	function Xoopensim_LastnamesForm()
	{
		parent::Xoopensim_ActionForm();

		$root = & XCube_Root::getSingleton();
		$this->isAdmin = isXoopensimAdmin($root);

		// LastNames   
		$this->dbhandler = & xoops_getmodulehandler('lastnamesdb');
		$criteria   = & new CriteriaCompo();
		$criteria->addSort('lastname');
		$modobj = & $this->dbhandler->getObjects($criteria);
		foreach ($modobj as $mod) {
			$this->lastNames[$mod->get('lastname')] = $mod->get('state');
		}
	}



	function getTokenName()
	{
		return 'module.xoopensim.LastnamesAction.TOKEN';
	}



	function prepare()
	{
		$this->mFormProperties ['submit_add']    = & new XCube_StringProperty('submit_add');
		$this->mFormProperties ['submit_left']   = & new XCube_StringProperty('submit_left');
		$this->mFormProperties ['submit_right']  = & new XCube_StringProperty('submit_right');
		$this->mFormProperties ['submit_delete'] = & new XCube_StringProperty('submit_delete');
		$this->mFormProperties ['select_left']   = & new XCube_StringProperty('select_left');
		$this->mFormProperties ['select_right']  = & new XCube_StringProperty('select_right');
		$this->mFormProperties ['addname'] 		 = & new XCube_StringProperty('addname');

		$this->mFieldProperties['addname'] = & new XCube_FieldProperty($this);
		$this->mFieldProperties['addname']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['addname']->addMessage('maxlength', _MD_XPNSM_LASTNAME_MAXLENGTH, '24');
		$this->mFieldProperties['addname']->addVar('maxlength', '24');

		$this->mFieldProperties['submit_add']    = & new XCube_FieldProperty($this);
		$this->mFieldProperties['submit_left']   = & new XCube_FieldProperty($this);
		$this->mFieldProperties['submit_right']  = & new XCube_FieldProperty($this);
		$this->mFieldProperties['submit_delete'] = & new XCube_FieldProperty($this);
		$this->mFieldProperties['select_left'] 	 = & new XCube_FieldProperty($this);
		$this->mFieldProperties['select_right']  = & new XCube_FieldProperty($this);
	}



	function  validateAddname()
	{
		$str = $this->get('addname');
		if ($str=='') return;

		$ret = isAlphabetNumeric($str);
		if (!$ret) {
			$this->addErrorMessage(_MD_XPNSM_ALPHABET_NUMERIC.' ('._MD_XPNSM_LASTNAME.')');
			$this->set('addname', htmlspecialchars($str));
		}

		if ($str!='') {
			foreach($this->lastNames as $lname) {
				if ($lname==$str) {
					$this->addErrorMessage(_MD_XPNSM_INVALID_LASTNAME.': '.htmlspecialchars($str));
					$this->set('addname', htmlspecialchars($str));
					break;
				}
			}
		}
		return;
	}

}

?>
