<?php

require_once(realpath(dirname(__FILE__).'/../../../mainfile.php'));
require_once(realpath(dirname(__FILE__).'/../include/env_interface.php'));


$root = & XCube_Root::getSingleton();
if ($root->mContext->mUser->isInRole('Site.GuestUser')) {
    exit('<h4>guest user is not allowed to access this page!!</h4>');
}

$uuid  = $root->mContext->mRequest->getRequest('uuid');
if (!isGUID($uuid)) exit('<h4>bad asset uuid!! ('.htmlspecialchars($uuid).')</h4>');
$xsize = $root->mContext->mRequest->getRequest('xsize');
if (!isNumeric($xsize, true)) exit('<h4>bad xsize!! ('.htmlspecialchars($xsize).')</h4>');
$ysize = $root->mContext->mRequest->getRequest('ysize');
if (!isNumeric($ysize, true)) exit('<h4>bad ysize!! ('.htmlspecialchars($ysize).')</h4>');

$prog  = env_get_config('image_processor_jp2');
//$path  = env_get_config('image_processor_path');
$cache = CMS_MODULE_PATH.'/helper/texture_cache';

$ret = opensim_display_texture_data($uuid, $prog, $xsize, $ysize, $cache, true);
if (!$ret) exit();
 
?>
