<?php

require_once(realpath(dirname(__FILE__).'/../../../mainfile.php'));
require_once(realpath(dirname(__FILE__).'/../include/env_interface.php'));


$world_map_url = CMS_MODULE_URL.'/helper/world_map.php';
$allow_zoom = true;


$root = & XCube_Root::getSingleton();

$grid_name = $root->mContext->mModuleConfig['grid_name'];
$mapstartX = $root->mContext->mModuleConfig['map_start_x'];
$mapstartY = $root->mContext->mModuleConfig['map_start_y'];

$centerX = $root->mContext->mRequest->getRequest('ctX');
$centerY = $root->mContext->mRequest->getRequest('ctY');
if ($centerX!='' and !preg_match('/^[0-9.]+$/', $centerX)) $centerX = '';
if ($centerY!='' and !preg_match('/^[0-9.]+$/', $centerY)) $centerY = '';
if ($centerX=='') $centerX = $mapstartX;
if ($centerY=='') $centerY = $mapstartY;

$size = $root->mContext->mModuleConfig['map_size'];
$tsize = $root->mContext->mRequest->getRequest('size');
if ($tsize!='' and $allow_zoom and preg_match('/^[0-9]+$/', $tsize)) {
    if ($tsize==16 or $tsize==32 or $tsize==64 or $tsize==128 or $tsize==256 or $tsize==512) {
       	$size = $tsize;
    }
}


ob_start();
require(CMS_MODULE_PATH.'/include/map_script.php');
$map_script = ob_get_contents();
ob_end_clean();
 

$xoopsTpl->assign('grid_name',  	$grid_name);
$xoopsTpl->assign('allow_zoom', 	$allow_zoom);
$xoopsTpl->assign('map_script', 	$map_script);
$xoopsTpl->assign('mapstartX',  	$mapstartX);
$xoopsTpl->assign('mapstartY',  	$mapstartY);
$xoopsTpl->assign('centerX',  		$centerX);
$xoopsTpl->assign('centerY',  		$centerY);
$xoopsTpl->assign('pluszoom',   	$pluszoom);
$xoopsTpl->assign('minuszoom',  	$minuszoom);
$xoopsTpl->assign('module_url', 	CMS_MODULE_URL);
$xoopsTpl->assign('world_map_url',	$world_map_url);

$xoopsTpl->display('db:xoopensim_map.html');

?>
