<?php
/****************************************************************
 *	xoopensim.func.php by Fumi.Iseki for XoopenSim
 *
 *
 ****************************************************************/


/****************************************************************
 * Functions

 // Tools
 function  isXoopensimAdmin(&$root=null)

 // DB
 function  xoopensim_get_update_time($fullname_table)
 function  xoopensim_get_user_email($uuid)
 function  xoopensim_get_user($uuid)

 // Avatars
 function  xoopensim_get_avatars($uid=0)
 function  xoopensim_get_avatars_num($uid=0)

 // Users Table
 function  xoopensim_get_userstable()
 function  xoopensim_insert_userstable($user, $force=false)
 function  xoopensim_update_userstable($user, $force=false)
 function  xoopensim_delete_userstable($user, $force=false)

 // Group
 function  xoopensim_delete_groupdb($uuid, $delallgrp=false)
 function  xoopensim_delete_groupdb_by_uuid($uuid)
 function  xoopensim_delete_groupdb_by_gpid($gpid)

 // Profile
 function  xoopensim_get_profile($uuid)
 function  xoopensim_set_profiles_from_users($profs, $ovwrite=true)
 function  xoopensim_delete_profiles($uuid)

 // Events
 function  xoopensim_get_events($uid=0, $start=0, $limit=25, $pg_only=false, $tm=0)
 function  xoopensim_get_events_num($uid=0, $pg_only=false, $tm=0)
 function  xoopensim_get_event($eventid)
 function  xoopensim_set_event($event)

 // Login Screen
 function  xoopensim_get_loginscreen_alert()
 function  xoopensim_set_loginscreen_alert($alert)

 // Bann Avatar
 function  xoopensim_activate_avatar($uuid)
 function  xoopensim_inactivate_avatar($uuid)
 function  xoopensim_delete_banneddb($uuid)

 // Synchro DB
 function  xoopensim_synchro_opensimdb($timecheck=true, $force=true)

 ***************************************************************/


if (!defined('CMS_MODULE_PATH')) exit();

require_once(CMS_MODULE_PATH.'/include/env_interface.php');

require_once(CMS_MODULE_PATH.'/include/tools.func.php');
require_once(CMS_MODULE_PATH.'/include/mysql.func.php');
require_once(CMS_MODULE_PATH.'/include/opensim.mysql.php');
require_once(CMS_MODULE_PATH.'/include/xoops.func.php');


//
$root = & XCube_Root::getSingleton();
$pg_only = $root->mContext->mModuleConfig['pg_only'];




//
// for XoopenSim
//

////////////////////////////////////////////////////////////////////////////////
//
// NOT Well Worked in Block
//
function  isXoopensimAdmin(&$root=null)
{
	if ($root==null) $root = & XCube_Root::getSingleton();
	
	// Guest is not Admin
	if ($root->mContext->mUser->isInRole('Site.GuestUser')) return false;
	if ($root->mContext->mUser->isInRole('Module.'.CMS_DIR_NAME.'.Admin')) return true;

	return false;
}





////////////////////////////////////////////////////////////////////////////////
//
// DB
//
//

function  xoopensim_get_update_time($fullname_table)
{
	if ($fullname_table=="") return 0;

	$db = new DB(CMS_DB_HOST, CMS_DB_NAME, CMS_DB_USER, CMS_DB_PASS);
	$update = $db->get_update_time($fullname_table);

	return $update;
}



function  xoopensim_get_user_email($uuid)
{
	if (!isGUID($uuid)) return null;

	$user = xoopensim_get_user($uuid);
	if ($user==null) return null;

	$email = get_userinfo_by_id($user['uid'], 'email');
	return $email;
}



function  xoopensim_get_user($uuid)
{
	if (!isGUID($uuid)) return null;

	$handler = & xoops_getmodulehandler('usersdb');
	$modobj  = & $handler->get($uuid);
	
	$user = array();
	if ($modobj!=null) {
		$user = $modobj->gets();
	}

	return $user;
}




////////////////////////////////////////////////////////////////////////////////
//
// Avatars
//
//
function  xoopensim_get_avatars($uid=0)
{
	$handler  = & xoops_getmodulehandler('usersdb');
	$criteria = & new CriteriaCompo();
	if ($uid>0) $criteria->add(new Criteria('uid', $uid));
	$modobj = & $handler->getObjects($criteria);
	
	$avatars = array();
	foreach ($modobj as $mod) {
		$uuid = $mod->getVar('UUID');
		$avatars[$uuid] = $mod->gets();
		$avatars[$uuid]['fullname'] = $avatars[$uuid]['firstname']." ".$avatars[$uuid]['lastname'];
	}
	return $avatars;
}



//
// 一人のユーザが何人のアバターを管理しているか
//
function  xoopensim_get_avatars_num($uid=0)
{
	$handler = & xoops_getmodulehandler('usersdb');
	$criteria = & new CriteriaCompo();
	if ($uid>0) $criteria->add(new Criteria('uid', $uid));
	$avatars_num = $handler->getCount($criteria);
	
	return $avatars_num;
}





////////////////////////////////////////////////////////////////////////////////
//
// Users Table DB
//
//

function  xoopensim_get_userstable()
{
	// XoopenSim DBを配列に変換
	$handler = & xoops_getmodulehandler('usersdb');
	$modobj  = & $handler->getObjects();

	$xoops_users = array();
	foreach ($modobj as $userobj) {
		$xoops_uuid = $userobj->getVar('UUID');
		$xoops_users[$xoops_uuid] = $userobj->gets();
	}

	return $xoops_users;
}



//   UUID, firstname, lastname, uid, state, time, hmregion are setted in $user[]
//			hmregion is UUID or name of region
function  xoopensim_insert_userstable($user, $force=false)
{
	$handler = & xoops_getmodulehandler('usersdb');
	$insobj = & $handler->create();
	if ($insobj==null) return false;

	$insobj->assignVar('UUID', 		$user['UUID']);
	$insobj->assignVar('firstname', $user['firstname']);
	$insobj->assignVar('lastname', 	$user['lastname']);

	if ($user['uid']!='') 	$insobj->assignVar('uid', $user['uid']);
	else				 	$insobj->assignVar('uid', 0);

	if ($user['state']!='')	$insobj->assignVar('state', (int)$user['state']);
	else					$insobj->assignVar('state', (int)AVATAR_STATE_SYNCDB);

	if ($user['time']!='')	$insobj->assignVar('time', $user['time']);
	else 					$insobj->assignVar('time', time());

	if (isGUID($user['hmregion'])) {
		$regionName = opensim_get_region_name($user['hmregion']);
		if ($regionName!='')$insobj->assignVar('hmregion', $regionName);
		else			   	$insobj->assignVar('hmregion', $user['hmregion']);
	}
	else {
		if ($user['hmregion']==null) {
			$insobj->assignVar('hmregion', '');
		}
		else {
			$insobj->assignVar('hmregion', $user['hmregion']);
		}
	}

	$ret = $handler->insert($insobj, $force);
	return $ret;
}



//
// update (Xoops's) uid, hmregion, state, time of users (Xoops DB).
//
function  xoopensim_update_userstable($user, $force=false)
{
	$handler = & xoops_getmodulehandler('usersdb');
	$updobj = & $handler->get($user['UUID']);
	if ($updobj==null) return false;

	if ($user['uid']!='') 	$updobj->assignVar('uid',   $user['uid']);
	if ($user['state']!='') $updobj->assignVar('state', (int)$user['state']);

	if ($user['time']!='')  $updobj->assignVar('time', $user['time']);
	else 					$updobj->assignVar('time', time());

	if (isGUID($user['hmregion'])) {
		$regionName = opensim_get_region_name($user['hmregion']);
		if ($regionName!='')$updobj->assignVar('hmregion', $regionName);
		else			   	$updobj->assignVar('hmregion', $user['hmregion']);
	}
	else if ($user['hmregion']!='') {
		$updobj->assignVar('hmregion', $user['hmregion']);
	}

	$ret = $handler->insert($updobj, $force);
	return $ret;
}



function  xoopensim_delete_userstable($user, $force=false)
{
	if (!isGUID($user['UUID'])) return false;
	if (!((int)$user['state']&AVATAR_STATE_INACTIVE)) return false;		// active

	$handler = & xoops_getmodulehandler('usersdb');
	$delobj = & $handler->get($user['UUID']);
	if ($delobj==null) return false;
	$ret = $handler->delete($delobj, $force);

	return $ret;
}




///////////////////////////////////////////////////////////////////////////////////////
//
// Group DB
//

function  xoopensim_delete_groupdb($uuid, $delallgrp=false)
{
	$ret = xoopensim_delete_groupdb_by_uuid($uuid);
	if (!$ret) return false;

	if ($delallgrp) {
		$criteria = new Criteria('FounderID', $uuid);
		$groupHandler = & xoops_getmodulehandler('grouplistdb');
		$groupobjs = & $groupHandler->getObjects($criteria);
		if ($groupobjs==null) return false;

		foreach($groupobjs as $groupdata) {
			$ret = xoopensim_delete_groupdb_by_gpid($groupdata->get('GroupID'));
			if (!$ret) return false;
		}
	}

	return true;
}



function  xoopensim_delete_groupdb_by_uuid($uuid)
{
	$groupHandler = & xoops_getmodulehandler('groupactivedb');
	$groupdata = $groupHandler->get($uuid);
	if ($groupdata!=null) $groupHandler->delete($groupdata);

	$criteria = new Criteria('AgentID', $uuid);
	$groupHandler = & xoops_getmodulehandler('groupinvitedb');
	$groupHandler->deleteAll($criteria);

	$criteria = new Criteria('AgentID', $uuid);
	$groupHandler = & xoops_getmodulehandler('groupmembershipdb');
	$groupHandler->deleteAll($criteria);

	$criteria = new Criteria('AgentID', $uuid);
	$groupHandler = & xoops_getmodulehandler('grouprolemembershipdb');
	$groupHandler->deleteAll($criteria);

	return true;
}



function  xoopensim_delete_groupdb_by_gpid($gpid)
{
	$criteria = new Criteria('ActiveGroupID', $gpid);
	$groupHandler = & xoops_getmodulehandler('groupactivedb');
	$groupHandler->deleteAll($criteria);

	$criteria = new Criteria('GroupID', $gpid);
	$groupHandler = & xoops_getmodulehandler('groupinvitedb');
	$groupHandler->deleteAll($criteria);

	$criteria = new Criteria('GroupID', $gpid);
	$groupHandler = & xoops_getmodulehandler('groupmembershipdb');
	$groupHandler->deleteAll($criteria);

	$criteria = new Criteria('GroupID', $gpid);
	$groupHandler = & xoops_getmodulehandler('groupnoticedb');
	$groupHandler->deleteAll($criteria);

	$criteria = new Criteria('GroupID', $gpid);
	$groupHandler = & xoops_getmodulehandler('grouproledb');
	$groupHandler->deleteAll($criteria);

	$criteria = new Criteria('GroupID', $gpid);
	$groupHandler = & xoops_getmodulehandler('grouprolemembershipdb');
	$groupHandler->deleteAll($criteria);

	$groupHandler = & xoops_getmodulehandler('grouplistdb');
	$groupdata  = $groupHandler->get($gpid);
	if ($groupdata!=null) $groupHandler->delete($groupdata);

	return true;
}



///////////////////////////////////////////////////////////////////////////////////////
//
// Profile
//

function  xoopensim_get_profile($uuid)
{
	$prof = array();

	$handler = & xoops_getmodulehandler('profuserprofiledb');
	if ($handler==null) return $prof;

	$prfobj = $handler->get($uuid);
	if ($prfobj!=null) {
		$prof['UUID']			= $prfobj->get('useruuid');
		$prof['Partnar']		= $prfobj->get('profilePartner');
		$prof['Image']		  	= $prfobj->get('profileImage');
		$prof['AboutText']	  	= $prfobj->get('profileAboutText');
		$prof['AllowPublish']   = $prfobj->get('profileAllowPublish');
		$prof['MaturePublish']  = $prfobj->get('profileMaturePublish');
		$prof['URL']			= $prfobj->get('profileURL');
		$prof['WantToMask']	 	= $prfobj->get('profileWantToMask');
		$prof['WantToText']	 	= $prfobj->get('profileWantToText');
		$prof['SkillsMask']	 	= $prfobj->get('profileSkillsMask');
		$prof['SkillsText']	 	= $prfobj->get('profileSkillsText');
		$prof['LanguagesText']  = $prfobj->get('profileLanguagesText');
		$prof['FirstImage']	 	= $prfobj->get('profileFirstImage');
		$prof['FirstAboutText'] = $prfobj->get('profileFirstText');
	}

	return $prof;
}




// called from updatedbAction.class.php
function  xoopensim_set_profiles_from_users($profs, $ovwrite=true)
{
	$handler = & xoops_getmodulehandler('profuserprofiledb');
	if ($handler==null) return false;

	foreach($profs as $prof) {
		if ($prof['UUID']!='') {
			$prfobj = $handler->get($prof['UUID']);

			if ($ovwrite or $prfobj==null) {
				if ($prfobj==null) $prfobj = & $handler->create();
				if ($prfobj!=null) {
					$prfobj->assignVar('useruuid', 	$prof['UUID']);
					if ($prof['Partnar']!='')		$prfobj->assignVar('profilePartnar',   		$prof['Partnar']);
					if ($prof['Image']!='')			$prfobj->assignVar('profileImage', 	  		$prof['Image']);
					if ($prof['AboutText']!='')		$prfobj->assignVar('profileAboutText',   	$prof['AboutText']);
					//if ($prof['AllowPublish']!='')	$prfobj->assignVar('profileAllowPublish',	$prof['AllowPublish']);
					//if ($prof['MaturePublish']!='')	$prfobj->assignVar('profileMaturePublish',	$prof['MaturePublish']);
					//if ($prof['URL']!='')			$prfobj->assignVar('profileURL',			$prof['URL']);
					if ($prof['WantToMask']!='')	$prfobj->assignVar('profileWantToMask',  	$prof['WantToMask']);
					if ($prof['SkillsMask']!='')	$prfobj->assignVar('profileSkillsMask',  	$prof['SkillsMask']);
					//if ($prof['WantToText']!='')	$prfobj->assignVar('profileWantToText',  	$prof['WantToText']);
					//if ($prof['SkillsText']!='')	$prfobj->assignVar('profileSkillsText',  	$prof['SkillsText']);
					//if ($prof['LanguagesText']!='') $prfobj->assignVar('profileLanguagesText',	$prof['LanguagesText']);
					if ($prof['FirstAboutText']!='')$prfobj->assignVar('profileFirstText',   	$prof['FirstAboutText']);
					if ($prof['FirstImage']!='')	$prfobj->assignVar('profileFirstImage',  	$prof['FirstImage']);
					$handler->insert($prfobj);
				}
			}
		}
	}


	$handler = & xoops_getmodulehandler('profusersettingsdb');
	if ($handler==null) return false;

	foreach($profs as $prof) {
		if ($prof['UUID']!='') {
			$prfobj = $handler->get($prof['UUID']);

			if ($ovwrite or $prfobj==null) {
				if ($prfobj==null) $prfobj = & $handler->create();
				if ($prfobj!=null) {
					$prfobj->assignVar('useruuid', 	$prof['UUID']);
					//if ($prof['ImviaEmail']!='')	$prfobj->assignVar('imviaemail',$prof['ImviaEmail']);
					//if ($prof['Visible']!='')		$prfobj->assignVar('visible',	$prof['Visible']);
					if ($prof['Email']!='')			$prfobj->assignVar('email',		$prof['Email']);
					$handler->insert($prfobj);
				}
			}
		}
	}

	return true;
}




function  xoopensim_delete_profiles($uuid)
{
	$criteria = new Criteria('useruuid', $uuid);
	$handler = & xoops_getmodulehandler('profuserprofiledb');
	$handler->deleteAll($criteria);

	$criteria = new Criteria('useruuid', $uuid);
	$handler = & xoops_getmodulehandler('profusersettingsdb');
	$handler->deleteAll($criteria);

	$criteria = new Criteria('useruuid', $uuid);
	$handler = & xoops_getmodulehandler('profusernotesdb');
	$handler->deleteAll($criteria);

	$criteria = new Criteria('creatoruuid', $uuid);
	$handler = & xoops_getmodulehandler('profuserpicksdb');
	$handler->deleteAll($criteria);

	$criteria = new Criteria('creatoruuid', $uuid);
	$handler = & xoops_getmodulehandler('profclassifiedsdb');
	$handler->deleteAll($criteria);

	return;
}




///////////////////////////////////////////////////////////////////////////////////////
//
// Events
//

function  xoopensim_get_events($uid=0, $start=0, $limit=25, $pg_only=false, $tm=0)
{
	$events = array();
	if ($tm==0) $tm = time();

	$handler  = & xoops_getmodulehandler('searcheventsdb');
	$criteria = & new CriteriaCompo();
	$criteria->add(new Criteria('dateUTC',$tm, '>'));
	if ($pg_only) $criteria->add(new Criteria('eventflags', '0'));
	if ($uid>0)   $criteria->add(new Criteria('uid', $uid));
	$criteria->setSort('dateUTC');
	if ($start!='') $criteria->setStart($start);
	if ($limit!='') $criteria->setLimit($limit);

	$rets = $handler->getObjects($criteria);
	
	if ($rets!=null) {  
		$num = 0;
		foreach ($rets as $event) {
			$events[$num]['uid'] 	 	 = $event->getVar('uid');
			$events[$num]['owneruuid'] 	 = $event->getVar('owneruuid');
			$events[$num]['name'] 		 = $event->getVar('name');
			$events[$num]['eventid'] 	 = $event->getVar('eventid');
			$events[$num]['creatoruuid'] = $event->getVar('creatoruuid');
			$events[$num]['category'] 	 = $event->getVar('category');
			$events[$num]['description'] = $event->getVar('description');
			$events[$num]['dateUTC'] 	 = $event->getVar('dateUTC');
			$events[$num]['duration'] 	 = $event->getVar('duration');
			$events[$num]['covercharge'] = $event->getVar('covercharge');
			$events[$num]['coveramount'] = $event->getVar('coveramount');
			$events[$num]['simname'] 	 = $event->getVar('simname');
			$events[$num]['globalPos'] 	 = $event->getVar('globalPos');
			$events[$num]['eventflags']  = $event->getVar('eventflags');
			$num++;
		}				  
	}

	return $events;
}



function  xoopensim_get_events_num($uid=0, $pg_only=false, $tm=0)
{
	if ($tm==0) $tm = time();

	$handler  = & xoops_getmodulehandler('searcheventsdb');
	$criteria = & new CriteriaCompo();
	$criteria->add(new Criteria('dateUTC', $tm, '>'));
	if ($pg_only) $criteria->add(new Criteria('eventflags', '0'));
	if ($uid>0)   $criteria->add(new Criteria('uid', $uid));
	$events_num = $handler->getCount($criteria);
	
	return $events_num;
}



function  xoopensim_get_event($eventid)
{
	$handler = & xoops_getmodulehandler('searcheventsdb');
	$event   = $handler->get($eventid);
	
	$ret = array();
	if ($event!=null) { 
		$ret['uid'] 		= $event->getVar('uid');
		$ret['owneruuid'] 	= $event->getVar('owneruuid');
		$ret['name'] 		= $event->getVar('name');
		$ret['eventid'] 	= $event->getVar('eventid');
		$ret['creatoruuid'] = $event->getVar('creatoruuid');
		$ret['category'] 	= $event->getVar('category');
		$ret['description'] = $event->getVar('description');
		$ret['dateUTC'] 	= $event->getVar('dateUTC');
		$ret['duration'] 	= $event->getVar('duration');
		$ret['covercharge'] = $event->getVar('covercharge');
		$ret['coveramount'] = $event->getVar('coveramount');
		$ret['simname'] 	= $event->getVar('simname');
		$ret['globalPos'] 	= $event->getVar('globalPos');
		$ret['eventflags']  = $event->getVar('eventflags');
	}

	return $ret;
}



function  xoopensim_set_event($event)
{
	$handler = & xoops_getmodulehandler('searcheventsdb');

	$dbobj = null;
	if (isNumeric($event['eventid'])) {
		$dbobj = & $handler->get($event['eventid']);
	}
	if (!is_object($dbobj)) {
		$dbobj = & $handler->create();
		$dbobj->setNew();
	}
	if (!is_object($dbobj)) return false;

	$dbobj->assignVar('uid', 		 $event['uid']);
	$dbobj->assignVar('owneruuid', 	 $event['owneruuid']);
	$dbobj->assignVar('name', 		 $event['name']);
	$dbobj->assignVar('creatoruuid', $event['creatoruuid']);
	$dbobj->assignVar('category', 	 $event['category']);
	$dbobj->assignVar('description', $event['description']);
	$dbobj->assignVar('dateUTC', 	 $event['dateUTC']);
	$dbobj->assignVar('duration', 	 $event['duration']);
	$dbobj->assignVar('covercharge', $event['covercharge']);
	$dbobj->assignVar('coveramount', $event['coveramount']);
	$dbobj->assignVar('simname', 	 $event['simname']);
	$dbobj->assignVar('globalPos',	 $event['globalPos']);
	$dbobj->assignVar('eventflags',  $event['eventflags']);

	$ret = $handler->insert($dbobj);
	return $ret;
}





///////////////////////////////////////////////////////////////////////////////////////
//
// Login Screen
//

function  xoopensim_get_loginscreen_alert()
{
	$handler = & xoops_getmodulehandler('loginscreendb');
	$modobjs = & $handler->getObjects();

	$ret = array();   

	if ($modobjs!=null) {
		foreach ($modobjs as $alert) {
			if ($alert->getVar('id')!=null) break;
		}
		if ($alert!=null and $alert->getVar('id')!=null) {
			$ret['id']			= $alert->getVar('id');
			$ret['title']		= $alert->getVar('title');
			$ret['information'] = $alert->getVar('information');
			$ret['borderColor'] = $alert->getVar('borderColor');
			$ret['timestamp']   = $alert->getVar('timestamp');
		}
	}
   
	return $ret;
}



function  xoopensim_set_loginscreen_alert($alert)
{
	$obj->title	   = '';
	$obj->information = '';
	$obj->borderColor = 'white';

	if ($alert['title']!=null)		 $obj->title 	   = $alert['title'];
	if ($alert['information']!=null) $obj->information = $alert['information'];
	if ($alert['borderColor']!=null) $obj->borderColor = $alert['borderColor'];

	$getobj = xoopensim_get_loginscreen_alert();

	$handler = & xoops_getmodulehandler('loginscreendb');
	$insobj  = & $handler->create();
	if ($insobj==null) return false;	

	if ($getobj!=null and $getobj['id']!=null) {
		$insobj->assignVar('id', $getobj['id']);
		$insobj->unsetNew();
	}
	$insobj->assignVar('title', 	  $obj->title);
	$insobj->assignVar('information', $obj->information);
	$insobj->assignVar('borderColor', $obj->borderColor);
	$insobj->assignVar('timestamp',   time());

	$ret = $handler->insert($insobj);

	return $ret;
}





///////////////////////////////////////////////////////////////////////////////////////
//
// Bann List
//

// Active/Inactive Avatar
function  xoopensim_activate_avatar($uuid)
{
	$handler = & xoops_getmodulehandler('banneddb');
	$banobj = $handler->get($uuid);
	if ($banobj==null) return false;
	$passwdhash = $banobj->get('agentinfo');

	$ret = opensim_set_password($uuid, $passwdhash);
	if (!$ret) return false;

	$handler->delete($banobj);
	return true;
}



function  xoopensim_inactivate_avatar($uuid)
{
	$passwd = opensim_get_password($uuid);
	if ($passwd==null) return false;

	$passwdhash = $passwd['passwordHash'];
	if ($passwdhash==null) return false;

	$handler = & xoops_getmodulehandler('banneddb');
	$insobj = & $handler->create();
	if ($insobj==null) return false;

	$insobj->assignVar('UUID', $uuid);
	$insobj->assignVar('agentinfo', $passwdhash);
	$insobj->assignVar('time', time());
   	$handler->insert($insobj);

	$ret = opensim_set_password($uuid, 'invalid_password');
	if (!$ret) xoopensim_delete_banneddb($uuid);

	return $ret;
}



function  xoopensim_delete_banneddb($uuid)
{
	$bandbHandler = & xoops_getmodulehandler('banneddb');
	$banobj = $bandbHandler->get($uuid);
	if ($banobj==null) return false;

	$bandbHandler->delete($banobj);
	return true;
}




///////////////////////////////////////////////////////////////////////////////////////
//
// Synchro DB
//

function  xoopensim_synchro_opensimdb($timecheck=true, $force=true)
{
	if ($timecheck) {
		$opensim_up = opensim_users_update_time();
		$xoops_up   = xoopensim_get_update_time(XPNSM_DB_PREFIX.'users');
		if ($xoops_up>$opensim_up) return;
	}


	$opensim_users = opensim_get_avatars_infos(); 	// OpenSim DB
	$xoops_users   = xoopensim_get_userstable(); 	// XoopenSim DB

	// OpenSimに対応データが無い場合は XoopenSim のデータを消す．
	foreach ($xoops_users as $xoops_user) {
		$xoops_uuid = $xoops_user['UUID'];
		if (!array_key_exists($xoops_uuid, $opensim_users)) {
			$xoops_user['state'] = (int)$xoops_user['state'] | AVATAR_STATE_INACTIVE;
			xoopensim_delete_userstable($xoops_user, $force);
		}
	}

	// OpenSimにデータがある場合は，XoopenSimのデータを OpenSimにあわせる．
	foreach ($opensim_users as $opensim_user) {
		$opensim_user['time']  = time();
		if (array_key_exists($opensim_user['UUID'], $xoops_users)) {
			$opensim_user['uid']   = $xoops_users[$opensim_user['UUID']]['uid']; 
			$opensim_user['state'] = $xoops_users[$opensim_user['UUID']]['state']|AVATAR_STATE_SYNCDB;
			xoopensim_update_userstable($opensim_user, $force);
		}
		else {
			$opensim_user['uid']   = 0;
			$opensim_user['state'] = AVATAR_STATE_SYNCDB;
			xoopensim_insert_userstable($opensim_user, $force);
		}
	}

	// Asset and Inventory URL
/*	$context = & XCube_Root::getSingleton()->mContext;
	$userInventoryURI = $context->mModuleConfig['inventory_uri'];
	$userAssetURI	 = $context->mModuleConfig['asset_uri'];

	$DbLink = & opensim_new_db();
	foreach ($opensim_users as $opensim_user) {
		$uuid = $opensim_user['UUID'];
			if ($userInventoryURI!=null and $userInventoryURI!='') {
			$DbLink->query('UPDATE users SET userInventoryURI='$userInventoryURI' WHERE UUID='$uuid'');
		}
		if ($userAssetURI!=null and $userAssetURI!='') {
		$DbLink->query('UPDATE users SET userAssetURI='$userAssetURI'		 WHERE UUID='$uuid'');
			}
	}
	$DbLink->close();
	*/
}


?>
