<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/AbstructAction.class.php');
require_once(CMS_MODULE_PATH.'/class/xoopensimDeleventForm.class.php');



class  del_eventAction extends Abstruct_Action
{
	var $mController;
	var $mActionForm;

	var $isAdmin    = false;
	var $action_url = '';
	var $return_url = '';
	var $userid	    = 0;		// owner of this process
	var $uid		= 0;		// creator of event

	var $event_id	= 0;
	var $handler 	= null;
	var $eventobj	= null;
	var $deleted 	= false;




	function  del_eventAction($controller) 
	{
		$this->mController = $controller;

		$root = & XCube_Root::getSingleton();
		if ($root->mContext->mUser->isInRole('Site.GuestUser')) {
			$controller->executeRedirect(CMS_MODULE_URL, 2, _MD_XPNSM_ACCESS_FORBIDDEN);
		}

		$this->mActionForm 	= & new Xoopensim_DeleventForm();
		$this->isAdmin	   	= $this->mActionForm->isAdmin;
		$this->userid 	   	= $this->mActionForm->uid;

		$this->action_url  	= CMS_MODULE_URL.'/?action=del_event';
		$this->return_url  	= CMS_MODULE_URL.'/?action=events';

		// GET eventid
		$this->event_id = $root->mContext->mRequest->getRequest('eventid');
		if (!isNumeric($this->event_id)) {
			$controller->executeRedirect($this->return_url, 3, _MD_XPNSM_BAD_EVENT_ID);
		}

		$this->handler	= & xoops_getmodulehandler('searcheventsdb');
		$this->eventobj = & $this->handler->get($this->event_id);
		if ($this->eventobj==null) {
			$controller->executeRedirect($this->return_url, 3, _MD_XPNSM_NOT_EXIST_EVENT);
		}
		$this->uid = $this->eventobj->get('uid');

		if (!$this->isAdmin and $this->userid!=$this->uid) {
			$controller->executeRedirect($this->return_url, 3, _MD_XPNSM_ACCESS_FORBIDDEN);
		}
	}



	function  execute()
	{
		// Form
		$this->mActionForm->prepare();
		if (xoops_getenv('REQUEST_METHOD')=='POST') {
			$this->mActionForm->fetch();
			$this->mActionForm->validate();
		}
		$this->mActionForm->load();

		if (xoops_getenv('REQUEST_METHOD')=='POST' and  !$this->mActionForm->hasError()) {
			$del = $this->mActionForm->get('submit_delete');
			if ($del!='') {
				// delete event
				$this->deleted = $this->handler->delete($this->eventobj);
				if (!$this->deleted) $this->mActionForm->addErrorMessage(_MD_XPNSM_XOOPS_UPDATE_ERROR);
			}
			else {
				$this->mController->executeRedirect($this->return_url, 2, _MD_XPNSM_EVENT_DLT_CNCLD_TTL);
			}
		}
	}



	function  executeView($render) 
	{
		global $Categories;

		$render->setTemplateName('xoopensim_del_event.html');

		$grid_name = $this->mController->mRoot->mContext->mModuleConfig['grid_name'];
		$showPostForm = !$this->deleted or $this->mActionForm->hasError();

		$render->setAttribute('grid_name',		$grid_name);
		$render->setAttribute('actionForm', 	$this->mActionForm);
		$render->setAttribute('showPostForm',	$showPostForm);

		$render->setAttribute('return_action', 	'events');
		$render->setAttribute('action_url', 	$this->action_url);
		$render->setAttribute('return_url', 	$this->return_url);
		$render->setAttribute('deleted',		$this->deleted);
		$render->setAttribute('isAdmin',		$this->isAdmin);

		$render->setAttribute('event_id', 		$this->event_id);
		$render->setAttribute('use_utc_time', 	USE_UTC_TIME);


		$event['name'] 		= $this->eventobj->get('name');
		$event['date'] 		= date(DATE_FORMAT, $this->eventobj->get('dateUTC'));
		$event['category'] 	= $Categories[$this->eventobj->get('category')];
		$owner_name = opensim_get_avatar_name($this->eventobj->get('owneruuid'));
		$event['ownername']	= $owner_name['fullname'];
		$creator_name = opensim_get_avatar_name($this->eventobj->get('creatoruuid'));
		$event['creatorname'] = $creator_name['fullname'];

		$render->setAttribute('event', 			$event);
	}

}

?>
