<?php
//////////////////////////////////////////////////////////////////////////////////////////////
// loginscreenAction.class.php
//
//										created by Fumi.Iseki
//

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once(CMS_MODULE_PATH.'/class/AbstructAction.class.php');
require_once(CMS_MODULE_PATH.'/class/xoopensimLoginscreenForm.class.php');
require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');



class  loginscreenAction extends Abstruct_Action
{
	var $mController;
	var $action_url	= '';

	var $isAdmin = false;
	var $userid	 = 0;

	var $preview = false;
	var $updated = false;
	var $colors	 = array(0=>'white', 1=>'green', 2=>'yellow', 3=>'red');

	var $lgnscrn_ckey   = 0;
	var $lgnscrn_title  = '';
	var $lgnscrn_color  = '';
	var $lgnscrn_altbox = '';


	function  loginscreenAction($controller) 
	{
		$this->mController = $controller;

		$root = & XCube_Root::getSingleton();
		if ($root->mContext->mUser->isInRole('Site.GuestUser')) {
			$controller->executeRedirect(CMS_MODULE_URL, 2, _AM_XPNSM_ACCESS_FORBIDDEN);
		}

		$this->mActionForm = & new Xoopensim_LoginscreenForm();
		$this->userid  = $this->mActionForm->uid;
		$this->isAdmin = $this->mActionForm->isAdmin;

		if (!$this->mActionForm->isAdmin) {
			$controller->executeRedirect(CMS_MODULE_URL, 2, _AM_XPNSM_ACCESS_FORBIDDEN);
		}

		$this->action_url = CMS_MODULE_URL.'/admin/?action=loginscreen';
	}



	function  execute()
	{
		// Form	
		$this->mActionForm->prepare();
		if (xoops_getenv('REQUEST_METHOD')=='POST') {
			$this->mActionForm->fetch();
			$this->mActionForm->validate();
		}
		$this->mActionForm->load();

		if (xoops_getenv('REQUEST_METHOD')=='POST' and  !$this->mActionForm->hasError()) {
			$cancel	 = $this->mActionForm->get('submit_cancel');
			$preview = $this->mActionForm->get('submit_preview');
			$update  = $this->mActionForm->get('submit_update');

 			if ($cancel!='') $this->mController->executeRedirect($this->action_url, 0, '');

			$this->lgnscrn_title  = $this->mActionForm->get('lgnscrn_title');
			$this->lgnscrn_color  = $this->mActionForm->get('lgnscrn_color');
			$this->lgnscrn_ckey   = $this->mActionForm->get('lgnscrn_ckey');
			$this->lgnscrn_altbox = $this->mActionForm->get('lgnscrn_altbox');

			if ($preview!='') {
				$this->preview = true;
				$this->updated = true;
				$this->lgnscrn_color = $this->colors[$this->lgnscrn_ckey];
			}

			else if ($update!='') {
				$ret = opensim_check_db();
				if (!$ret['grid_status']) {
					$this->hasError = true;
					$this->errorMsg[] = get_string('modlos_db_connect_error', 'block_modlos');
					return false;
				}
			   
				$alert['title']		  = $this->lgnscrn_title;
				$alert['borderColor'] = $this->lgnscrn_color;
				$alert['information'] = $this->lgnscrn_altbox;
		   
				$ret = xoopensim_set_loginscreen_alert($alert);
				if ($ret) {
					$this->updated = true;
				}
				else {
					$this->hasError = true;
					$this->errorMsg[] = "DB Update Error!! (modlos_set_loginscreen_alert)";
				}
			}
		}

		// GET
		else {
			$alert = xoopensim_get_loginscreen_alert();
			if ($alert!=null and is_array($alert)) {
				$this->lgnscrn_title  = $alert['title'];
				$this->lgnscrn_color  = $alert['borderColor'];
				$this->lgnscrn_altbox = $alert['information'];

				foreach($this->colors as $ckey => $color) {
					if ($this->lgnscrn_color==$color) {
						$this->lgnscrn_ckey = $ckey;
						break;
					}
				}
				$this->preview = true;
			}
		}
	}



	function  executeView($render) 
	{
		$root = & XCube_Root::getSingleton();
		$grid_name  = $root->mContext->mModuleConfig['grid_name'];
		$admin_menu = $root->mContext->mModule->getAdminMenu();

		$render->setTemplateName('xoopensim_loginscreen.html');

		$render->setAttribute('grid_name', 		$grid_name);
		$render->setAttribute('admin_menu',		$admin_menu);
		$render->setAttribute('action_url', 	$this->action_url);
		$render->setAttribute('actionForm', 	$this->mActionForm);

		$render->setAttribute('updated',		$this->updated);
		$render->setAttribute('preview', 		$this->preview);
		$render->setAttribute('action_url', 	$this->action_url);
		$render->setAttribute('colors', 		$this->colors);

		$render->setAttribute('lgnscrn_title', 	$this->lgnscrn_title);
		$render->setAttribute('lgnscrn_ckey', 	$this->lgnscrn_ckey);
		$render->setAttribute('lgnscrn_color', 	$this->lgnscrn_color);
		$render->setAttribute('lgnscrn_altbox',	$this->lgnscrn_altbox);

		$render->setAttribute('BOX_TITLE',		$this->lgnscrn_title);
		$render->setAttribute('BOX_COLOR',		$this->lgnscrn_color);
		$render->setAttribute('BOX_INFOTEXT',	$this->lgnscrn_altbox);
		$render->setAttribute('color_box',		$this->lgnscrn_color);
	}

}


?>
