<?php

require_once(realpath(dirname(__FILE__).'/../../../mainfile.php'));
require_once(realpath(dirname(__FILE__).'/../include/env_interface.php'));


$owner  = ' - ';
$state  = 0;
$userid = 0;

$root = & XCube_Root::getSingleton();

if ($root->mContext->mUser->isInRole('Site.GuestUser')) {
	exit('<h4>guest user is not allowed to access this page!!</h4>');
}

$agent = $root->mContext->mRequest->getRequest('agent');
if (!preg_match('/^[0-9a-fA-F-]+$/', $agent)) exit('<h4>bad agent uuid!!</h4>');
$grid_name = $root->mContext->mModuleConfig['grid_name'];
$userinfo  = $root->mContext->mModuleConfig['userinfo_link'];
$isAdmin   = isXoopensimAdmin($root);

if ($agent) {
	// OpenSim DB
	$profileText  = '';
	$profileImage = '';
	$firstText	  = '';
	$firstImage   = '';
	$partner	  = '';

	$avinfo = opensim_get_avatar_info($agent);
	if ($avinfo!=null) {
		$UUID			= $avinfo['UUID'];
		$firstN			= $avinfo['firstname'];
		$lastN			= $avinfo['lastname'];
		$created		= $avinfo['created'];
		$lastlogin		= $avinfo['lastlogin'];
		$regionUUID		= $avinfo['regionUUID'];
		$regionName		= $avinfo['regionName'];
		$serverIP		= $avinfo['serverIP'];
		$serverHttpPort	= $avinfo['serverHttpPort'];
		$serverURI		= $avinfo['serverURI'];

		$profileText	= $avinfo['profileText'];
		$profileImage   = $avinfo['profileImage'];
		$firstText		= $avinfo['firstText'];
		$firstImage		= $avinfo['firstImage'];
		$partner		= $avinfo['partner'];

		$online 	 	= opensim_get_avatar_online($UUID);
		$agentOnline 	= $online['online'];
		$crrntRegion 	= $online['region_id'];
		//$crrntRegion 	= $online['region_name'];
	}


	// auto synchro
	xoopensim_synchro_opensimdb(true);

	// Xoops DB
	$usersdbHandler = & xoops_getmodulehandler('usersdb');
	$avatardata = & $usersdbHandler->get($agent);

	// auto synchro
	if ($avatardata==null) {
		xoopensim_synchro_opensimdb(true, false);
		$avatardata = & $usersdbHandler->get($agent);
	}

	if ($avatardata!=null) {
		$userid = $avatardata->get('uid');
		if ($userid!='0') $owner = get_username_by_id($userid);
		$state = (int)$avatardata->get('state');
	}


	$prof = xoopensim_get_profile($agent);
	if ($prof!=null) {
		if ($prof['Partnar']!='')		 $partner	   = $prof['Partnar'];
		if ($prof['AboutText']!='')		 $profileText  = $prof['AboutText'];
		if ($prof['FirstAboutText']!='') $firstText	   = $prof['FirstAboutText'];

		if ($prof['Image']!=''		and $prof['Image']!='00000000-0000-0000-0000-000000000000')		 $profileImage = $prof['Image'];
		if ($prof['FirstImage']!='' and $prof['FirstImage']!='00000000-0000-0000-0000-000000000000') $firstImage   = $prof['FirstImage'];

		//$prof['AllowPublish']
		//$prof['MaturePublish']
		//$prof['URL']
		//$prof['WantToMask']
		//$prof['SkillsMask']
		//$prof['WantToText']
		//$prof['SkillsText']
		//$prof['LanguagesText']
	}


	if ($created=='0' or $created==null or $created=='' or $created=='0') {
		$born = ' - ';
	}
	else {
		$born = date(DATE_FORMAT, $created);
	}
	if ($lastlogin==null or $lastlogin=='' or $lastlogin=='0') {
		$lastin = ' - ';
	}
	else {
		$lastin = date(DATE_FORMAT, $lastlogin);
	}
}


$server = '';
if ($serverURI!='') {
	$dec = explode(':', $serverURI);
	if (!strncasecmp($dec[0], 'http', 4)) $server = $dec[0].':'.$dec[1];
}
if ($server=='') {
	$server = 'http://'.$serverIP;
}
$server = $server.':'.$serverHttpPort;
$guid = str_replace('-', '', $UUID);


$xoopsTpl->assign('grid_name',   $grid_name);
$xoopsTpl->assign('userinfo',	 $userinfo);
$xoopsTpl->assign('regionName',  $regionName);
$xoopsTpl->assign('regionUUID',  $regionUUID);
$xoopsTpl->assign('crrntRegion', $crrntRegion);
$xoopsTpl->assign('firstN',		 $firstN);
$xoopsTpl->assign('lastN',		 $lastN);
$xoopsTpl->assign('UUID',		 $UUID);
$xoopsTpl->assign('born',		 $born);
$xoopsTpl->assign('lastin',		 $lastin);
$xoopsTpl->assign('owner',		 $owner);
$xoopsTpl->assign('userid',		 $userid);
$xoopsTpl->assign('state',		 $state);
$xoopsTpl->assign('agentOnline', $agentOnline);
$xoopsTpl->assign('profileText', $profileText);
$xoopsTpl->assign('profileImage',$profileImage);
$xoopsTpl->assign('server',		 $server);
$xoopsTpl->assign('guid',		 $guid);
$xoopsTpl->assign('isAdmin',	 $isAdmin);
$xoopsTpl->assign('module_url',  CMS_MODULE_URL);
$xoopsTpl->assign('texture_url', CMS_MODULE_URL.'/helper/get_texture.php?uuid=');

$xoopsTpl->display('db:xoopensim_agent.html');

?>
