<?php
//
// Configration file for Xoops Cube
//												by Fumi.Iseki
//
//

require_once(realpath(dirname(__FILE__).'/../../../mainfile.php'));

if (!defined('CMS_DIR_NAME'))	 define('CMS_DIR_NAME',	basename(dirname(dirname(__FILE__))));
if (!defined('CMS_MODULE_URL'))  define('CMS_MODULE_URL',  XOOPS_MODULE_URL. '/'.CMS_DIR_NAME);
if (!defined('CMS_MODULE_PATH')) define('CMS_MODULE_PATH', XOOPS_MODULE_PATH.'/'.CMS_DIR_NAME);

if (!defined('ENV_HELPER_URL'))  define('ENV_HELPER_URL',  XOOPS_MODULE_URL. '/'.CMS_DIR_NAME.'/helper');
if (!defined('ENV_HELPER_PATH')) define('ENV_HELPER_PATH', XOOPS_MODULE_PATH.'/'.CMS_DIR_NAME.'/helper');

$config_handler =& xoops_gethandler('config');
$module_config  =& $config_handler->getConfigsByDirname(CMS_DIR_NAME);


//
$GLOBALS['xmlrpc_internalencoding'] = 'UTF-8';



//////////////////////////////////////////////////////////////////////////////////
//
// for OpenSim
//

// for OpenSim DB
define('OPENSIM_DB_HOST',		$module_config['sql_server_name']);
define('OPENSIM_DB_NAME',		$module_config['sql_db_name']);
define('OPENSIM_DB_USER',		$module_config['sql_db_user']);
define('OPENSIM_DB_PASS',		$module_config['sql_db_pass']);

define('USE_CURRENCY_SERVER',   $module_config['use_currency_server']);
define('CURRENCY_SCRIPT_KEY',	$module_config['currency_script_key']);
define('USER_SERVER_URI',		$module_config['user_server_uri']);




//////////////////////////////////////////////////////////////////////////////////
//
// Xoops Cube 
//

// for CMS/LMS DB
define('CMS_DB_HOST',			XOOPS_DB_HOST);
define('CMS_DB_NAME',			XOOPS_DB_NAME);
define('CMS_DB_USER',			XOOPS_DB_USER);
define('CMS_DB_PASS',			XOOPS_DB_PASS);


//
define('SYSURL',				XOOPS_URL);
define('OPENSIM_PG_ONLY',		$module_config['pg_only']);
define('DATE_FORMAT',			$module_config['date_format']);
define('USE_UTC_TIME',			$module_config['use_utc_time']);

if (USE_UTC_TIME) date_default_timezone_set('UTC');


// XOOPS DB PREFIX
define('XPNSM_DB_PREFIX',		XOOPS_DB_PREFIX.'_'.CMS_DIR_NAME.'_');



//////////////////////////////////////////////////////////////////////////////////
//
// External NSL Modules
//

// Currency DB for helpers.php
if (USE_CURRENCY_SERVER) {
	define('CURRENCY_DB_HOST',			OPENSIM_DB_HOST);
	define('CURRENCY_DB_NAME',			OPENSIM_DB_NAME);
	define('CURRENCY_DB_USER',			OPENSIM_DB_USER);
	define('CURRENCY_DB_PASS',			OPENSIM_DB_PASS);
	define('CURRENCY_MONEY_TBL',	 	'balances');
	define('CURRENCY_TRANSACTION_TBL', 	'transactions');
}
else {
	define('CURRENCY_DB_HOST',			CMS_DB_HOST);
	define('CURRENCY_DB_NAME',			CMS_DB_NAME);
	define('CURRENCY_DB_USER',			CMS_DB_USER);
	define('CURRENCY_DB_PASS',			CMS_DB_PASS);
	define('CURRENCY_MONEY_TBL',	 	XPNSM_DB_PREFIX.'economy_transactions');
	define('CURRENCY_TRANSACTION_TBL', 	XPNSM_DB_PREFIX.'economy_transactions');
}


// Offline Message
define('OFFLINE_DB_HOST',				CMS_DB_HOST);
define('OFFLINE_DB_NAME',				CMS_DB_NAME);
define('OFFLINE_DB_USER',				CMS_DB_USER);
define('OFFLINE_DB_PASS',				CMS_DB_PASS);
define('OFFLINE_MESSAGE_TBL', 			XPNSM_DB_PREFIX.'offline_message');


// MuteList 
define('MUTE_DB_HOST',  				CMS_DB_HOST);
define('MUTE_DB_NAME',  				CMS_DB_NAME);
define('MUTE_DB_USER',  				CMS_DB_USER);
define('MUTE_DB_PASS',  				CMS_DB_PASS);
define('MUTE_LIST_TBL', 				XPNSM_DB_PREFIX.'mute_list');



//////////////////////////////////////////////////////////////////////////////////
//
// External other Modules
//

// XML Group.  see also xmlgroups_config.php 
define('XMLGROUP_ACTIVE_TBL', 			XPNSM_DB_PREFIX.'group_active');
define('XMLGROUP_LIST_TBL',				XPNSM_DB_PREFIX.'group_list');
define('XMLGROUP_INVITE_TBL',			XPNSM_DB_PREFIX.'group_invite');
define('XMLGROUP_MEMBERSHIP_TBL',   	XPNSM_DB_PREFIX.'group_membership');
define('XMLGROUP_NOTICE_TBL',			XPNSM_DB_PREFIX.'group_notice');
define('XMLGROUP_ROLE_MEMBER_TBL', 		XPNSM_DB_PREFIX.'group_rolemembership');
define('XMLGROUP_ROLE_TBL',  			XPNSM_DB_PREFIX.'group_role');

define('XMLGROUP_RKEY',					$module_config['groupdb_read_key']);
define('XMLGROUP_WKEY',					$module_config['groupdb_write_key']);


// Avatar Profile. see also profile_config.php
define('PROFILE_CLASSIFIEDS_TBL',  		XPNSM_DB_PREFIX.'prof_classifieds');
define('PROFILE_USERNOTES_TBL',  		XPNSM_DB_PREFIX.'prof_usernotes');
define('PROFILE_USERPICKS_TBL',  		XPNSM_DB_PREFIX.'prof_userpicks');
define('PROFILE_USERPROFILE_TBL',  		XPNSM_DB_PREFIX.'prof_userprofile');
define('PROFILE_USERSETTINGS_TBL',		XPNSM_DB_PREFIX.'prof_usersettings');


// Search the In World. see also search_config.php 
define('SEARCH_ALLPARCELS_TBL',	 		XPNSM_DB_PREFIX.'search_allparcels');
define('SEARCH_EVENTS_TBL',		 		XPNSM_DB_PREFIX.'search_events');
define('SEARCH_HOSTSREGISTER_TBL',  	XPNSM_DB_PREFIX.'search_hostsregister');
define('SEARCH_OBJECTS_TBL',			XPNSM_DB_PREFIX.'search_objects');
define('SEARCH_PARCELS_TBL',			XPNSM_DB_PREFIX.'search_parcels');
define('SEARCH_PARCELSALES_TBL',		XPNSM_DB_PREFIX.'search_parcelsales');
define('SEARCH_POPULARPLACES_TBL',  	XPNSM_DB_PREFIX.'search_popularplaces');
define('SEARCH_REGIONS_TBL',			XPNSM_DB_PREFIX.'search_regions');
define('SEARCH_CLASSIFIEDS_TBL',		PROFILE_CLASSIFIEDS_TBL);



//////////////////////////////////////////////////////////////////////////////////
//
// for Avatar State for CMS/LMS
//
define('AVATAR_STATE_NOSTATE',		'0');		// 0x00
define('AVATAR_STATE_SYNCDB',  		'1');		// 0x01
define('AVATAR_STATE_INACTIVE',		'4');		// 0x04

define('AVATAR_STATE_NOSYNCDB',		'254');		// 0xfe
define('AVATAR_STATE_ACTIVE',  		'251');		// 0xfb

// Editable
define('AVATAR_NOT_EDITABLE',		'0');
define('AVATAR_EDITABLE',	 		'1');
define('AVATAR_OWNER_EDITABLE',		'2');

// Lastname
define('AVATAR_LASTN_INACTIVE', 	'0');
define('AVATAR_LASTN_ACTIVE',   	'1');



//
if (!defined('ENV_READED_CONFIG')) define('ENV_READED_CONFIG', 'YES');
?>
