<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/AbstructAction.class.php');
require_once(CMS_MODULE_PATH.'/class/xoopensimEditeventForm.class.php');



class  edit_eventAction extends Abstruct_Action
{
	var $mController;
	var $mActionForm;

	var $parcels  = array();
	var $owners   = array();
	var $creators = array();

	var $isAdmin = false;
	var $isGuest = true;
	var $userid	 = 0;			// owner id of this process
	var $uid	 = 0;			// first creator of this event

	var $action_url  = '';
	var $delete_url  = '';
	var $language	 = 'english';

	var $event_id 	  = 0;
	var $global_pos	  = '';
	var $region_uuid  = '';
	var $event_name	  = '';
	var $category	  = 0;
	var $event_desc	  = '';
	var $duration	  = 0;
	var $cover_charge = 0;
	var $cover_amount = 0;
	var $check_mature = 0;
	var $event_owner  = '';
	var $owner_uuid	  = '';
	var $event_creator= '';
	var $creator_uuid = '';
	var $event_saved  = false;

	var $event_day;
	var $event_month;
	var $event_year;
	var $event_hour;
	var $event_minute;

	var $saved_event_name	= '';
	var $saved_global_pos	= '';
	var $saved_region_name	= '';
	var $saved_category		= 0;
	var $saved_cover_amount = 0;
	var $saved_event_type   = '';
	var $saved_event_date	= '';
	var $saved_event_owner	= '';
	var $saved_event_creator= '';



	function  edit_eventAction($controller) 
	{
		$this->mController = $controller;
		$root = & XCube_Root::getSingleton();

		$this->isGuest = $root->mContext->mUser->isInRole('Site.GuestUser');
		if ($this->isGuest) {
			$controller->executeRedirect(CMS_MODULE_URL, 2, _MD_XPNSM_ACCESS_FORBIDDEN);
		}

		$this->mActionForm = & new Xoopensim_EditeventForm();

		$this->isAdmin 	 = $this->mActionForm->isAdmin;
		$this->userid  	 = $this->mActionForm->uid;
		$this->language	 = $root->mLanguageManager->mLanguageName;

		// GET eventid
		$this->event_id	 = $root->mContext->mRequest->getRequest('eventid');
		if ($this->event_id==null) $this->event_id = 0;

		$this->action_url = CMS_MODULE_URL.'/?action=edit_event';
		$this->delete_url = CMS_MODULE_URL.'/?action=del_event&eventid=';
	}



	function  execute()
	{
		// Form
		$this->mActionForm->prepare();
		if (xoops_getenv('REQUEST_METHOD')=='POST') {
			$this->mActionForm->fetch();
			$this->mActionForm->validate();
		}
		$this->mActionForm->load();


		// List of Parcels
		$modHandler = & xoops_getmodulehandler('searchparcelsdb');
		$modobj = & $modHandler->getObjects();
		$i = 0;
		foreach ($modobj as $mod) {
			//$this->parcels[$i]['uuid'] 		= $mod->get('parcelUUID');
			$this->parcels[$i]['name'] 			= $mod->get('parcelname');
			$this->parcels[$i]['regionUUID'] 	= $mod->get('regionUUID');
			$this->parcels[$i]['landingpoint'] 	= $mod->get('landingpoint');
			$i++;
		}

		// List of Owners
		$this->owners = xoopensim_get_avatars();

		//List of Creators
		$this->creators = xoopensim_get_avatars($this->userid);
		if ($this->creators==null) {
			$this->mController->executeRedirect(CMS_MODULE_URL, 3, _MD_XPNSM_SHOULD_HAVE_AVATAR);
		}
		foreach ($this->creators as $creator) {
			$this->event_owner = $creator['fullname'];
			break;
		}


		// POST Submit
		$event = array();
		if (xoops_getenv('REQUEST_METHOD')=='POST') {
			$this->uid		= $this->mActionForm->get('uid');
			$this->event_id	= $this->mActionForm->get('event_id');

			$del = $this->mActionForm->get('submit_delete');
			if ($del!='') {
				$this->mController->executeForward($this->delete_url.$this->event_id);
				exit('<h4>delete page open error!!</h4>');
			}

			$parcel 	  		= explode('|', $this->mActionForm->get('parcel_name'));
			$this->global_pos 	= $parcel[0];
			$this->region_uuid 	= $parcel[1];

			$owner 	  			= explode('|', $this->mActionForm->get('owner_name'));
			$this->owner_uuid	= $owner[0];
			$this->event_owner	= $owner[1];

			$creator 			= explode('|', $this->mActionForm->get('creator_name'));
			$this->creator_uuid = $creator[0];
			$this->event_creator= $creator[1];

			$this->event_year	= $this->mActionForm->get('event_year');
			$this->event_month  = $this->mActionForm->get('event_month');
			$this->event_day	= $this->mActionForm->get('event_day');
			$this->event_hour	= $this->mActionForm->get('event_hour');
			$this->event_minute = $this->mActionForm->get('event_minute');
			
			$this->event_name	= $this->mActionForm->get('event_name');
			$this->event_desc	= $this->mActionForm->get('event_desc');
			$this->category		= $this->mActionForm->get('category');
			$this->duration	  	= $this->mActionForm->get('duration');
			$this->cover_charge = $this->mActionForm->get('cover_charge');
			$this->cover_amount = $this->mActionForm->get('cover_amount');
			$this->check_mature = $this->mActionForm->get('check_mature');

			if ($this->cover_charge==0) $this->cover_amount = 0; 

			if (!$this->mActionForm->hasError()) {
				$event_date = mktime($this->event_hour, $this->event_minute, 0, $this->event_month, $this->event_day, $this->event_year); 
				$event['uid']		  = $this->uid;
				$event['eventid']	  = $this->event_id;
				$event['owneruuid']	  = $this->owner_uuid;
				$event['name']		  = $this->event_name;
				$event['creatoruuid'] = $this->creator_uuid;
				$event['category']	  = $this->category;
				$event['description'] = $this->event_desc;
				$event['duration']	  = $this->duration;
				$event['covercharge'] = $this->cover_charge;
				$event['coveramount'] = $this->cover_amount;
				$event['dateUTC'] 	  = $event_date;
				$event['simname']	  = $this->region_uuid;
				$event['globalPos']	  = $this->global_pos;
				$event['eventflags']  = $this->check_mature;

				// save to DB
				$this->event_saved = xoopensim_set_event($event);

				// Event is saved
				if ($this->event_saved) {
					$this->saved_event_name	  = $this->event_name;
					$this->saved_category	  = $this->category;
					$this->saved_duration	  = $this->duration;
					$this->saved_cover_amount = $this->cover_amount;
					$this->saved_cover_charge = $this->cover_charge;
					$this->saved_global_pos   = $this->global_pos;
					$this->saved_event_date   = date(DATE_FORMAT, $event_date);
					$this->saved_event_owner  = $this->event_owner;
					$this->saved_event_creator= $this->event_creator;

					$this->saved_region_name  = opensim_get_region_name($this->region_uuid);
					if ($this->saved_region_name=="") $this->saved_region_name = _MD_XPNSM_UNKNOWN_REGION;

					if ($this->check_mature) {
		 				$this->saved_event_type = "title='Mature Event' src=./images/events/blue_star.gif";
					}
					else {
						$this->saved_event_type = "title='PG Event' src=./images/events/pink_star.gif";
					}

					// clear valiable
					$this->event_name	= '';
					$this->event_desc	= '';
					$this->category		= 0;
					$this->duration	  	= 0;
					$this->cover_charge = 0;
					$this->cover_amount = 0;
					$this->check_mature = 0;
					$this->global_pos 	= 0;
					$this->region_uuid 	= '';
					$this->event_owner	= '';
					$this->owner_uuid	= '';
					$this->event_creator= '';
					$this->creator_uuid	= '';
					$this->event_id		= 0;

					foreach ($this->creators as $creator) {
						$this->event_owner = $creator['fullname'];
						break;
					}

					$date = getdate();
					$this->event_year   = $date['year'];
					$this->event_month  = $date['mon'];
					$this->event_day	= $date['mday'];
					$this->event_hour   = $date['hours'];
					$this->event_minute = ((int)($date['minutes']/15))*15;
				}

				else {
					$this->mActionForm->addErrorMessage(_MD_XPNSM_XOOPS_UPDATE_ERROR);
				}
			}
		}

		// GET
		else {
			$date = getdate();
			$this->uid = $this->userid;

			if (isNumeric($this->event_id) and $this->event_id>0) {
				$event = xoopensim_get_event($this->event_id);

				if ($event!=null and ($event['uid']==$this->userid or $this->isAdmin)) {
					$this->uid			= $event['uid'];
					$this->event_name	= $event['name'];
					$this->owner_uuid	= $event['owneruuid'];
					$this->event_desc	= $event['description'];
					$this->creator_uuid	= $event['creatoruuid'];
					$this->category		= $event['category'];
					$this->duration	  	= $event['duration'];
					$this->cover_charge = $event['covercharge'];
					$this->cover_amount = $event['coveramount'];
					$this->check_mature = $event['eventflags'];
					$this->global_pos 	= $event['globalPos'];
					$this->region_uuid 	= $event['simname'];

					$owner_name = opensim_get_avatar_name($this->owner_uuid);
					$this->event_owner = $owner_name['fullname'];
					$creator_name = opensim_get_avatar_name($this->creator_uuid);
					$this->event_creator = $creator_name['fullname'];

					$date = getdate($event['dateUTC']);
				}
			}

			$this->event_year   = $date['year'];
			$this->event_month  = $date['mon'];
			$this->event_day	= $date['mday'];
			$this->event_hour   = $date['hours'];
			$this->event_minute = ((int)($date['minutes']/15))*15;
		}
	}



	function  executeView($render) 
	{
		global $Categories;

		$render->setTemplateName('xoopensim_edit_event.html');
		$grid_name = $this->mController->mRoot->mContext->mModuleConfig['grid_name'];

		$render->setAttribute('grid_name',		$grid_name);
		$render->setAttribute('action_url', 	$this->action_url);
		$render->setAttribute('isAdmin',		$this->isAdmin);
		$render->setAttribute('actionForm', 	$this->mActionForm);
		$render->setAttribute('pg_only',		OPENSIM_PG_ONLY);
		$render->setAttribute('parcels',		$this->parcels);
		$render->setAttribute('owners',			$this->owners);
		$render->setAttribute('creators',		$this->creators);
		$render->setAttribute('uid',			$this->uid);

		$render->setAttribute('event_id',		$this->event_id);
		$render->setAttribute('event_name',		$this->event_name);
		$render->setAttribute('event_desc',		$this->event_desc);
		$render->setAttribute('category',		$this->category);
		$render->setAttribute('duration',		$this->duration);
		$render->setAttribute('cover_charge',	$this->cover_charge);
		$render->setAttribute('cover_amount',	$this->cover_amount);
		$render->setAttribute('check_mature',	$this->check_mature);
		$render->setAttribute('global_pos',		$this->global_pos);
		$render->setAttribute('region_uuid',	$this->region_uuid);
		$render->setAttribute('use_utc_time',	USE_UTC_TIME);
		$render->setAttribute('Categories',		$Categories);

		$render->setAttribute('event_year',		$this->event_year);
		$render->setAttribute('event_month',	$this->event_month);
		$render->setAttribute('event_day',		$this->event_day);
		$render->setAttribute('event_hour',		$this->event_hour);
		$render->setAttribute('event_minute',	$this->event_minute);
		$render->setAttribute('event_owner',	$this->event_owner);
		$render->setAttribute('event_creator',	$this->event_creator);
		$render->setAttribute('event_saved',	$this->event_saved);

		$render->setAttribute('saved_event_name',	$this->saved_event_name);
		$render->setAttribute('saved_global_pos',	$this->saved_global_pos);
		$render->setAttribute('saved_region_name',	$this->saved_region_name);
		$render->setAttribute('saved_category',		$this->saved_category);
		$render->setAttribute('saved_cover_amount', $this->saved_cover_amount);
		$render->setAttribute('saved_event_type',	$this->saved_event_type);
		$render->setAttribute('saved_event_date',	$this->saved_event_date);
		$render->setAttribute('saved_event_owner',	$this->saved_event_owner);
		$render->setAttribute('saved_event_creator',$this->saved_event_creator);


		$date_file = CMS_MODULE_PATH.'/language/'.$this->language.'/xoopensim_events_date.html';
		if (!file_exists($date_file)) {
			$date_file = CMS_MODULE_PATH.'/language/english/xoopensim_events_date.html';
		}
		$render->setAttribute('date_file', 	$date_file);
	}


}

?>
